/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.DomainModel;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.Debug;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class DomainModels
extends CmsObservable
implements Observer {
    private static INetElement[] ElementArrayTemplate = new INetElement[0];
    private static String PROP_DOMAIN = "domain";
    private Network netModel;
    private HashMap nodeMap = new HashMap();
    private HashMap domMap = new HashMap();
    public Debug db = new DmsDebug("DomainModels");

    public DomainModels(Network network) {
        this.discover(network);
    }

    private synchronized void discover(Network network) {
        this.netModel = network;
        network.addObserver(this);
        INetElement[] iNetElementArray = (INetElement[])network.getElements().toArray();
        for (INetElement iNetElement : network.getElements()) {
            NodeModel nodeModel = (NodeModel)iNetElement.getNodeModel();
            nodeModel.addObserver(this);
            this.setNewMembership(this.getNodeDomain(nodeModel), nodeModel);
        }
    }

    private synchronized void setMembership(NodeModel nodeModel) {
        String string;
        String string2 = this.getNodeDomain(nodeModel);
        if (this.nodeMap.containsKey(nodeModel) && !(string = (String)this.nodeMap.get(nodeModel)).equals(string2)) {
            this.nodeMap.remove(nodeModel);
            DomainModel domainModel = (DomainModel)((Object)this.domMap.get(string));
            if (domainModel != null) {
                domainModel.remove(nodeModel);
                if (domainModel.size() == 0) {
                    this.domMap.remove(string);
                    domainModel.dispose();
                }
            }
        }
        this.setNewMembership(string2, nodeModel);
    }

    private synchronized void setNewMembership(String string, NodeModel nodeModel) {
        this.nodeMap.put(nodeModel, string);
        if (this.domMap.containsKey(string)) {
            DomainModel domainModel = (DomainModel)((Object)this.domMap.get(string));
            if (domainModel != null) {
                domainModel.add(nodeModel);
            }
        } else {
            this.createNewDM(string, nodeModel);
        }
    }

    private void createNewDM(String string, NodeModel nodeModel) {
        DomainModel domainModel = new DomainModel(string);
        this.domMap.put(string, domainModel);
        if (this.db.on) {
            this.db.println("createNewDM: domain=" + string);
        }
        this.setChanged();
        this.notifyObservers((Object)domainModel);
        domainModel.add(nodeModel);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Received an update from:" + observable + " arg=" + object);
        }
        NodeModel nodeModel = null;
        if (object instanceof INetElement) {
            nodeModel = (NodeModel)((INetElement)object).getNodeModel();
        } else if (observable instanceof NodeModel) {
            nodeModel = (NodeModel)((Object)observable);
        }
        if (nodeModel != null) {
            this.setMembership(nodeModel);
        }
    }

    public synchronized DomainModel[] getDomainModels() {
        return this.domMap.values().toArray(new DomainModel[0]);
    }

    private String getNodeDomain(NodeModel nodeModel) {
        try {
            String string = nodeModel.getProperty(PROP_DOMAIN);
            if (this.db.on) {
                this.db.println("getNodeDomain: node=" + nodeModel.getName() + " domain=" + string.replace('_', ' '));
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void dispose() {
        block3: {
            try {
                this.netModel.deleteObserver(this);
                Object[] objectArray = this.nodeMap.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((NodeModel)objectArray[i]).deleteObserver(this);
                }
                this.db.dispose();
            }
            catch (Exception exception) {
                if (!this.db.on) break block3;
                Debug.printStackTrace((Throwable)exception);
            }
        }
    }

    public class DmsDebug
    extends Debug {
        DmsDebug(String string) {
            super(string);
        }

        public final synchronized void domains() {
            String[] stringArray = DomainModels.this.domMap.keySet().toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                DomainModel domainModel = (DomainModel)((Object)DomainModels.this.domMap.get(stringArray[i]));
                if (domainModel == null) continue;
                this.println("domain=" + domainModel.getName());
                NodeModel[] nodeModelArray = domainModel.getModelList();
                for (int j = 0; j < nodeModelArray.length; ++j) {
                    this.println("    node=" + nodeModelArray[j].getName());
                }
            }
        }
    }
}

