/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IChassisModelUpdate;
import cerent.cms.model.IChassisModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.topo.NetElement;
import cerent.cms.ui.ExplorerController;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExplorerTreeNode
extends DefaultMutableTreeNode
implements Observer {
    private String name;
    private NetElement ne;
    private int state;
    private Color color;
    private ImageIcon icon;
    private SDebug db;
    public String tooltip = null;

    public ExplorerTreeNode(NetElement netElement, int n, Color color, SDebug sDebug) {
        this.ne = netElement;
        this.name = ExplorerController.instance().getProxyStatus(this.getNe()) + netElement.getName();
        this.state = n;
        this.color = color;
        this.icon = ExplorerController.instance().stateToIcon(netElement, this.getState());
        this.tooltip = ExplorerController.instance().getToolTip(netElement);
        this.db = new SDebug((KDebug)sDebug, "ExplorerTreeNode " + this.name);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public NetElement getNe() {
        return this.ne;
    }

    public int getState() {
        return this.state;
    }

    public String getName() {
        return ExplorerController.instance().getProxyStatus(this.getNe()) + this.name;
    }

    public void setName(String string) {
        this.name = ExplorerController.instance().getProxyStatus(this.getNe()) + string;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setIcon() {
        this.icon = ExplorerController.instance().stateToIcon(this.ne, this.getState());
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isLeaf() {
        return !this.getNe().isInited();
    }

    @Override
    public void update(Observable observable, Object object) {
        block9: {
            try {
                final ExplorerController explorerController = ExplorerController.instance();
                final ExplorerTreeNode explorerTreeNode = this;
                final NetElement netElement = this.ne;
                if (observable instanceof IChassisModels) {
                    int n = ((IChassisModelUpdate)object).getUpdateType();
                    final int n2 = ((IChassisModelUpdate)object).getShelfId();
                    final IEntityModel iEntityModel = ((IChassisModels)observable).getEntityByShelfId(n2);
                    if (n == 2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                explorerController.addShelf(explorerTreeNode, iEntityModel, n2);
                            }
                        });
                    }
                }
                if (object == ModelUpdateType.ADDED && observable instanceof IEntityModel) {
                    final IEntityModel iEntityModel = (IEntityModel)observable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            explorerController.addCard(iEntityModel, explorerTreeNode);
                        }
                    });
                }
                if (observable instanceof NetElement || object instanceof IAlarmStatus) {
                    if (object == ModelUpdateType.DELETED) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                explorerController.deleteNode(netElement, explorerTreeNode);
                            }
                        });
                    } else if (object == ModelUpdateType.CHANGED || object instanceof IAlarmStatus) {
                        this.db.fine("node is changed" + this.ne.getName());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                explorerController.checkConnection(netElement, explorerTreeNode);
                                explorerController.changeNodeName(netElement, explorerTreeNode);
                                ExplorerTreeNode.this.tooltip = explorerController.getToolTip(ExplorerTreeNode.this.ne);
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

