/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.WrongPathType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OchncHelper {
    private static final SDebug db = new SDebug("OchncHelper");
    private static final int WRK_LINE_IDX = 0;
    private static final int PRT_LINE_IDX = 1;
    private static final int REV_LINE_IN_IDX = 0;
    private static final int REV_LINE_OUT_IDX = 1;

    public static List<IEntityModel> getInOutLinePorts(int n, IEntityModel iEntityModel) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            INodeOpticsTopologyModel iNodeOpticsTopologyModel = iEntityModel.getNodeModel().getINodeOpticsTopologyModel();
            try {
                arrayList.addAll(iNodeOpticsTopologyModel.getOchncAllLineOutPorts(iEntityModel.getEntityIndex(), n));
                arrayList.addAll(iNodeOpticsTopologyModel.getOchncAllLineInPorts(iEntityModel.getEntityIndex(), n));
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            IEntityModel iEntityModel2 = OchncHelper.getOutLinePort(0, n, iEntityModel);
            if (iEntityModel2 != null) {
                arrayList.add(iEntityModel2);
            }
            if ((iEntityModel2 = OchncHelper.getInLinePort(0, n, iEntityModel)) != null) {
                arrayList.add(iEntityModel2);
            }
        }
        return arrayList;
    }

    public static List<IEntityModel> getOutLinePorts(int n, IEntityModel iEntityModel) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            try {
                return iEntityModel.getNodeModel().getINodeOpticsTopologyModel().getOchncAllLineOutPorts(iEntityModel.getEntityIndex(), n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            IEntityModel iEntityModel2 = OchncHelper.getOutLinePort(0, n, iEntityModel);
            if (iEntityModel2 != null) {
                arrayList.add(iEntityModel2);
            }
        }
        return arrayList;
    }

    public static IEntityModel getWorkingOutLinePort(int n, IEntityModel iEntityModel) {
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            try {
                List list = iEntityModel.getNodeModel().getINodeOpticsTopologyModel().getOchncWorkingLineOutPorts(iEntityModel.getEntityIndex(), n);
                if (list.size() == 1) {
                    return (IEntityModel)list.get(0);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return OchncHelper.getOutLinePort(0, n, iEntityModel);
    }

    public static IEntityModel getProtectedOutLinePort(int n, IEntityModel iEntityModel) {
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            try {
                List list = iEntityModel.getNodeModel().getINodeOpticsTopologyModel().getOchncProtectedLineOutPorts(iEntityModel.getEntityIndex(), n);
                if (list.size() == 1) {
                    return (IEntityModel)list.get(0);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return OchncHelper.getOutLinePort(1, n, iEntityModel);
    }

    private static IEntityModel getOutLinePort(int n, int n2, IEntityModel iEntityModel) {
        try {
            int n3;
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            int[] nArray = OchncHelper.getOutPoints(n2, iEntityModel, iNodeModel);
            if (db.on()) {
                db.println("Found " + nArray.length + " outpoints for channel " + n2 + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    db.println(n3 + ": 0x" + Integer.toHexString(nArray[n3]));
                }
            }
            if (OchPortsHelper.isAddPort(iEntityModel)) {
                return OchncHelper.entModelFromIndex(iNodeModel, nArray[n]);
            }
            n3 = nArray[n];
            int n4 = iEntityModel.getEntityIndex();
            int[] nArray2 = OchncHelper.getOchncLineReverseEntitiesPair(iNodeModel, n2, n3, n4);
            if (db.on()) {
                db.println("Found " + nArray2.length + " reverse pairs for 0x" + Integer.toHexString(n3) + ", 0x" + Integer.toHexString(n4));
                for (int i = 0; i < nArray2.length; ++i) {
                    db.println(i + ": 0x" + Integer.toHexString(nArray2[i]));
                }
            }
            return OchncHelper.entModelFromIndex(iNodeModel, nArray2[1]);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public static List<IEntityModel> getInLinePorts(int n, IEntityModel iEntityModel) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            try {
                return iEntityModel.getNodeModel().getINodeOpticsTopologyModel().getOchncAllLineInPorts(iEntityModel.getEntityIndex(), n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            IEntityModel iEntityModel2 = OchncHelper.getInLinePort(0, n, iEntityModel);
            if (iEntityModel2 != null) {
                arrayList.add(iEntityModel2);
            }
        }
        return arrayList;
    }

    public static IEntityModel getWorkingInLinePort(int n, IEntityModel iEntityModel) {
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            try {
                List list = iEntityModel.getNodeModel().getINodeOpticsTopologyModel().getOchncWorkingLineInPorts(iEntityModel.getEntityIndex(), n);
                if (list.size() == 1) {
                    return (IEntityModel)list.get(0);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return OchncHelper.getInLinePort(0, n, iEntityModel);
    }

    public static IEntityModel getProtectedInLinePort(int n, IEntityModel iEntityModel) {
        if (iEntityModel.getNodeModel().provides(Feature.COLOR_DIR_LESS)) {
            try {
                List list = iEntityModel.getNodeModel().getINodeOpticsTopologyModel().getOchncProtectedLineInPorts(iEntityModel.getEntityIndex(), n);
                if (list.size() == 1) {
                    return (IEntityModel)list.get(0);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return OchncHelper.getInLinePort(1, n, iEntityModel);
    }

    private static IEntityModel getInLinePort(int n, int n2, IEntityModel iEntityModel) {
        block8: {
            try {
                int n3;
                INodeModel iNodeModel = iEntityModel.getNodeModel();
                int[] nArray = OchncHelper.getOutPoints(n2, iEntityModel, iNodeModel);
                if (db.on()) {
                    db.println("Found " + nArray.length + " outpoints for channel " + n2 + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        db.println(n3 + ": 0x" + Integer.toHexString(nArray[n3]));
                    }
                }
                if (n < nArray.length) {
                    if (!OchPortsHelper.isAddPort(iEntityModel)) {
                        return OchncHelper.entModelFromIndex(iNodeModel, nArray[n]);
                    }
                    n3 = iEntityModel.getEntityIndex();
                    int n4 = nArray[n];
                    int[] nArray2 = OchncHelper.getOchncLineReverseEntitiesPair(iNodeModel, n2, n3, n4);
                    if (db.on()) {
                        db.println("Found " + nArray2.length + " reverse pairs for 0x" + Integer.toHexString(n3) + ", 0x" + Integer.toHexString(n4));
                        for (int i = 0; i < nArray2.length; ++i) {
                            db.println(i + ": 0x" + Integer.toHexString(nArray2[i]));
                        }
                    }
                    return OchncHelper.entModelFromIndex(iNodeModel, nArray2[0]);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private static int[] getOchncLineReverseEntitiesPair(INodeModel iNodeModel, int n, int n2, int n3) throws AlreadyInUse, NoSuchEquipment, WrongPathType {
        if (iNodeModel.provides(Feature.PASSIVE_UNITS)) {
            return iNodeModel.getINodeOpticsTopologyModel().getOchncLineReverseEntitiesPair(n, n2, n3);
        }
        return iNodeModel.getINodeOpticsTopologyModel().getOchncLineReverseEntitiesPair(n2, n3);
    }

    private static IEntityModel getLineReverseEntitiesPair(int n, IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        try {
            int n2;
            int n3;
            int[] nArray = OchncHelper.getOutPoints(n, iEntityModel, iNodeModel);
            if (db.on()) {
                db.println("Found " + nArray.length + " outpoints for channel " + n + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    db.println(n3 + ": 0x" + Integer.toHexString(nArray[n3]));
                }
            }
            if (nArray.length == 0) {
                if (db.on()) {
                    db.println("No reverse found for channel " + n + ", port 0x" + Integer.toHexString(iEntityModel.getEntityIndex()));
                }
                return null;
            }
            if (OchPortsHelper.isPortTypeRx(iEntityModel)) {
                n3 = iEntityModel.getEntityIndex();
                n2 = nArray[0];
            } else {
                n3 = nArray[0];
                n2 = iEntityModel.getEntityIndex();
            }
            int[] nArray2 = OchncHelper.getOchncLineReverseEntitiesPair(iNodeModel, n, n3, n2);
            if (db.on()) {
                db.println("Found " + nArray2.length + " reverse pairs for 0x" + Integer.toHexString(n3) + ", 0x" + Integer.toHexString(n2));
                for (int i = 0; i < nArray2.length; ++i) {
                    db.println(i + ": 0x" + Integer.toHexString(nArray2[i]));
                }
            }
            IEntityModel iEntityModel2 = null;
            iEntityModel2 = OchPortsHelper.isPortTypeRx(iEntityModel) ? OchncHelper.entModelFromIndex(iNodeModel, nArray2[1]) : OchncHelper.entModelFromIndex(iNodeModel, nArray2[0]);
            if (db.on()) {
                db.println("Reverse channel for port " + iEntityModel + " is " + iEntityModel2);
            }
            return iEntityModel2;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public static IEntityModel getReversePort(int n, IEntityModel iEntityModel) {
        List<IEntityModel> list = OchncHelper.getReversePorts(n, iEntityModel);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<IEntityModel> getReversePorts(int n, IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        if (iNodeModel.provides(Feature.COLOR_DIR_LESS)) {
            try {
                int[] nArray = iNodeModel.getINodeOpticsTopologyModel().getOchncReversePorts(n, iEntityModel.getEntityIndex());
                return OchncHelper.entModelFromIndex(iNodeModel, nArray);
            }
            catch (Exception exception) {
                if (!db.on()) return linkedList;
                SDebug.printStackTrace((Throwable)exception);
                return linkedList;
            }
        } else {
            linkedList.add(OchncHelper.getLineReverseEntitiesPair(n, iEntityModel));
        }
        return linkedList;
    }

    public static boolean isAvailableForOchncSource(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        boolean bl;
        boolean bl2 = circuitCreatInfo.dir() == 1;
        List<IEntityModel> list = OchncHelper.getAddPortsForOchnc(iNodeModel, circuitCreatInfo);
        if (!bl2) {
            bl = list.size() > 0;
        } else {
            List<IEntityModel> list2 = OchncHelper.getDropPortsForOchnc(iNodeModel, circuitCreatInfo);
            boolean bl3 = bl = list.size() > 0 && list2.size() > 0;
        }
        if (db.on()) {
            db.println("isAvailableForOchncSource(" + iNodeModel + ") :" + bl);
        }
        return bl;
    }

    public static boolean isAvailableForOchncDrop(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        boolean bl;
        boolean bl2 = circuitCreatInfo.dir() == 1;
        List<IEntityModel> list = OchncHelper.getDropPortsForOchnc(iNodeModel, circuitCreatInfo);
        if (!bl2) {
            bl = list.size() > 0;
        } else {
            List<IEntityModel> list2 = OchncHelper.getAddPortsForOchnc(iNodeModel, circuitCreatInfo);
            boolean bl3 = bl = list2.size() > 0 && list.size() > 0;
        }
        if (db.on()) {
            db.println("isAvailableForOchncDrop(" + iNodeModel + ") :" + bl);
        }
        return bl;
    }

    private static List<IEntityModel> getAddDropPortsForOchnc(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, int n) {
        int n2;
        int[] nArray;
        block10: {
            nArray = new int[]{};
            n2 = circuitCreatInfo.cktOptChannel();
            boolean bl = circuitCreatInfo.singleNodeOchnc();
            boolean bl2 = circuitCreatInfo.isProtected();
            try {
                if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchnc(n2, n, bl, bl2);
                } else if (iNodeModel.provides(Feature.OCHNC_DCN_CIRCUIT)) {
                    if (!bl2) {
                        nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchnc(n2, n, bl);
                    }
                } else if (!bl && !bl2) {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchnc(n2, n);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                db.println("Cannot get available entities for OCHNC: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(Integer.toHexString(nArray[i]));
            }
            db.println("Node " + iNodeModel + " - " + (n == 0 ? "ADD" : "DROP") + " entities for " + n2 + ": [" + stringBuffer + "]");
        }
        return OchncHelper.entModelFromIndex(iNodeModel, nArray);
    }

    public static List<IEntityModel> getAddPortsForOchnc(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        return OchncHelper.getAddDropPortsForOchnc(iNodeModel, circuitCreatInfo, 0);
    }

    public static List<IEntityModel> getDropPortsForOchnc(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        return OchncHelper.getAddDropPortsForOchnc(iNodeModel, circuitCreatInfo, 1);
    }

    public static List<IEntityModel> getDropPortsForOchncDcn(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, IEntityModel iEntityModel, boolean bl) {
        boolean bl2;
        int n;
        int[] nArray;
        block5: {
            nArray = new int[]{};
            n = circuitCreatInfo.cktOptChannel();
            bl2 = circuitCreatInfo.isProtected();
            try {
                if (iNodeModel.provides(Feature.OCHNC_DCN_CIRCUIT)) {
                    nArray = OchncHelper.getOutPoints(n, iEntityModel, iNodeModel);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Cannot get available entities for OCHNC DCN: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(Integer.toHexString(nArray[i]));
            }
            db.println("Node " + iNodeModel + " - DROP entities for " + n + ": [" + stringBuffer + "]");
        }
        return OchncHelper.entModelFromIndex(iNodeModel, nArray, bl2, bl);
    }

    public static List<IEntityModel> getAddPortsForOchnc(INodeModel iNodeModel) {
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            int[] nArray;
            block5: {
                nArray = new int[]{};
                try {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailAddEntitiesForOchnc();
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Cannot get available entities for OCHNC: " + exception.getMessage());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (db.on()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Node " + iNodeModel + " - ADD entities for " + ": [" + stringBuffer + "]");
            }
            return OchncHelper.entModelFromIndex(iNodeModel, nArray);
        }
        throw new FeatureNotSupported("OchPortsHelper.getAddPortsForOchnc() is not supported");
    }

    private static int[] getOutPoints(int n, IEntityModel iEntityModel, INodeModel iNodeModel) throws NoSuchEquipment {
        int[] nArray;
        block4: {
            nArray = new int[]{};
            try {
                nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailOchncPathEntities(n, iEntityModel.getEntityIndex());
            }
            catch (AlreadyInUse alreadyInUse) {
                if (db.on()) {
                    db.println("The OCHNC Path for channel " + iEntityModel + " is already in use");
                }
                if (alreadyInUse.hasEntityIndex()) {
                    nArray = iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT) ? alreadyInUse.getEntityIndexes() : new int[]{alreadyInUse.getEntityIndex()};
                }
                if (!db.on()) break block4;
                db.println("AlreadyInUse exception did not report the index of the entity using the OCHNC path!");
            }
        }
        return nArray;
    }

    public static IYCableModel getSplitterModel(IPortModel iPortModel) {
        block3: {
            INodeModel iNodeModel = iPortModel.getNodeModel();
            int n = iPortModel.getEntityIndex();
            if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                try {
                    return iNodeModel.getINodeOpticsTopologyModel().getSplitterModel(n);
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    if (!db.on()) break block3;
                    db.println("The Splitter for line 0x" + Integer.toHexString(n) + " is not available");
                }
            }
        }
        return null;
    }

    public static IPortModel getSplitterPort(int n, IEntityModel iEntityModel) {
        return OchncHelper.getSplitterPort(iEntityModel.getNodeModel(), iEntityModel.getEntityIndex(), n);
    }

    public static boolean isSplitterPGLinePort(INodeModel iNodeModel, int n, int n2) {
        return OchncHelper.getSplitterPort(iNodeModel, n, n2) != null;
    }

    public static IPortModel[] getSplitterPGLinePorts(INodeModel iNodeModel, int n) {
        if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
            IPortModel[] iPortModelArray = OchncHelper.getSplitterPGInternalPorts(iNodeModel, n);
            ISideModels iSideModels = iNodeModel.getSideModels();
            IPortModel[] iPortModelArray2 = new IPortModel[iPortModelArray.length * 2];
            for (int i = 0; i < iPortModelArray.length; ++i) {
                IInterfaceModel iInterfaceModel = iPortModelArray[i].getInterfaceModel();
                if (!(iInterfaceModel instanceof IOpticsModel)) continue;
                IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
                try {
                    ISideModel iSideModel = iSideModels.getSideById(iOpticsModel.getSide());
                    iPortModelArray2[i * 2] = OchncHelper.portModelFromIndex(iNodeModel, iSideModel.getLineOut());
                    iPortModelArray2[i * 2 + 1] = OchncHelper.portModelFromIndex(iNodeModel, iSideModel.getLineIn());
                    continue;
                }
                catch (WrongNodeSide wrongNodeSide) {
                    if (db.on()) {
                        db.println("Cannot found a match of line out for internal Splitter " + iOpticsModel);
                    }
                    return new IPortModel[0];
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    return new IPortModel[0];
                }
            }
            return iPortModelArray2;
        }
        return new IPortModel[0];
    }

    public static IPortModel[] getSplitterPGInternalPorts(INodeModel iNodeModel, int n) {
        if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
            try {
                IYCableModel iYCableModel = iNodeModel.getINodeOpticsTopologyModel().getSplitterModel(n);
                IPortModel[] iPortModelArray = new IPortModel[]{OchncHelper.portModelFromIndex(iNodeModel, iYCableModel.getMainEntityIndex()), OchncHelper.portModelFromIndex(iNodeModel, iYCableModel.getProtectEntityIndex())};
                return iPortModelArray;
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (db.on()) {
                    db.println("The Splitter for line 0x" + Integer.toHexString(n) + " is not available");
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return new IPortModel[0];
    }

    public static void checkAreConnectedByOCHNCPath(INetElement iNetElement, int n, int n2, int n3) throws xLinkNotUsable {
        int n4;
        INodeModel iNodeModel;
        if (db.on()) {
            db.println("Verifying available OCHNC path from " + iNetElement.getName() + "/" + Integer.toHexString(n) + " to " + iNetElement.getName() + "/" + Integer.toHexString(n2));
        }
        if (!(iNodeModel = iNetElement.getNodeModel()).provides(Feature.OCH_TRAIL_PROVISIONING)) {
            throw new xLinkNotUsable("Node " + iNetElement.getName() + " release must be updated to 7.0 or later");
        }
        INodeOpticsTopologyModel iNodeOpticsTopologyModel = iNetElement.getNodeModel().getINodeOpticsTopologyModel();
        int[] nArray = new int[]{};
        try {
            nArray = iNodeOpticsTopologyModel.getAvailOchncPathEntities(n3, n);
            if (db.on()) {
                StringBuffer stringBuffer = new StringBuffer("Found " + nArray.length + " OCHNC paths: ");
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    stringBuffer.append(" " + Integer.toHexString(nArray[n4]));
                }
                db.println(stringBuffer.toString());
            }
        }
        catch (AlreadyInUse alreadyInUse) {
            if (db.on()) {
                db.println("OCHNC channel already used: " + alreadyInUse.getMessage());
            }
            throw new xLinkNotUsable("Channel " + Wavelength.getWavelengthStringFromWavelength(n3) + " is already in use");
        }
        catch (NoSuchEquipment noSuchEquipment) {
            if (db.on()) {
                db.println("Cannot check OCHNC channel: " + noSuchEquipment.getMessage());
            }
            throw new xLinkNotUsable("Cannot check availability of channel " + Wavelength.getWavelengthStringFromWavelength(n3) + ": " + noSuchEquipment.getMessage());
        }
        if (nArray.length == 0) {
            throw new xLinkNotUsable("Unavailable Channel " + Wavelength.getWavelengthStringFromWavelength(n3) + " on " + iNetElement.getName());
        }
        boolean bl = false;
        for (n4 = 0; !bl && n4 < nArray.length; ++n4) {
            if (nArray[n4] != n2) continue;
            bl = true;
            if (!db.on()) continue;
            db.println("Found OCHNC path between " + Integer.toHexString(n) + " and " + Integer.toHexString(n2) + " on node " + iNetElement.getName());
        }
        if (!bl) {
            if (db.on()) {
                db.println("Cannot find OCHNC path");
            }
            throw new xLinkNotUsable("Unavailable Channel " + Wavelength.getWavelengthStringFromWavelength(n3));
        }
    }

    public static boolean isSplitterPGUnprotectedPort(INodeModel iNodeModel, int n) {
        try {
            IPortModel iPortModel = (IPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n);
            IYCableModel iYCableModel = OchncHelper.getSplitterModel(iPortModel);
            if (iYCableModel != null && n != iYCableModel.getMainEntityIndex() && n != iYCableModel.getProtectEntityIndex() && n != OchncHelper.getReverse(iNodeModel, iYCableModel.getMainEntityIndex()) && n != OchncHelper.getReverse(iNodeModel, iYCableModel.getProtectEntityIndex())) {
                return true;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return false;
    }

    public static ISideModel getSideFromLineInOut(IPortModel iPortModel) {
        IInterfaceModel iInterfaceModel;
        INodeModel iNodeModel = iPortModel.getNodeModel();
        if (iNodeModel.provides(Feature.OPTICAL_SIDE) && (iInterfaceModel = iPortModel.getInterfaceModel()) instanceof IOpticsModel) {
            IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
            try {
                return iNodeModel.getSideModels().getSideById(iOpticsModel.getSide());
            }
            catch (WrongNodeSide wrongNodeSide) {
                if (db.on()) {
                    db.println("Cannot found a match of side for " + iOpticsModel);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public static int getSideFromPortIndex(INodeModel iNodeModel, int n) {
        block6: {
            try {
                IInterfaceModel iInterfaceModel;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IPortModel iPortModel = (IPortModel)iEntityTableModel.getEntityModelByIndex(n);
                if (!iNodeModel.provides(Feature.OPTICAL_SIDE) || !((iInterfaceModel = iPortModel.getInterfaceModel()) instanceof IOpticsModel)) break block6;
                IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
                try {
                    return OchncHelper.getSideModel(iNodeModel, iOpticsModel.getSide()).getId();
                }
                catch (WrongNodeSide wrongNodeSide) {
                    if (db.on()) {
                        db.println("Cannot find a match of side for " + iOpticsModel);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block6;
                db.println("Cannot find entity for index " + n);
            }
        }
        return 0;
    }

    private static int getReverse(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel = OchncHelper.entModelFromIndex(iNodeModel, n);
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IOpticsModel) {
            try {
                return ((IOpticsModel)iInterfaceModel).getReversePort();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return 0;
    }

    public static IPortModel getReversePort(IPortModel iPortModel) {
        IInterfaceModel iInterfaceModel;
        if (iPortModel.getNodeModel().provides(Feature.OCHNC_SPLITTER_CIRCUIT) && (iInterfaceModel = iPortModel.getInterfaceModel()) instanceof IOpticsModel) {
            try {
                int n = ((IOpticsModel)iInterfaceModel).getReversePort();
                return OchncHelper.portModelFromIndex(iPortModel.getNodeModel(), n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private static IPortModel getSplitterPort(INodeModel iNodeModel, int n, int n2) {
        IPortModel iPortModel;
        block3: {
            iPortModel = null;
            if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                try {
                    iPortModel = iNodeModel.getINodeOpticsTopologyModel().getSplitterEntity(n, n2);
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    if (!db.on()) break block3;
                    db.println("The Splitter for channel " + n2 + " line 0x" + Integer.toHexString(n) + " is not available");
                }
            }
        }
        return iPortModel;
    }

    private static List<IEntityModel> entModelFromIndex(INodeModel iNodeModel, int[] nArray) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            try {
                linkedList.add(iEntityTableModel.getEntityModelByIndex(nArray[i]));
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return linkedList;
    }

    private static List<IEntityModel> entModelFromIndex(INodeModel iNodeModel, int[] nArray, boolean bl, boolean bl2) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if (bl && (i == 0 && bl2 || i == 1 && !bl2)) {
                if (!db.on()) continue;
                db.println("Node " + iNodeModel + " skip " + Integer.toHexString(nArray[i]) + " entity for " + (bl2 ? "PROTECT" : "WORKING") + "list");
                continue;
            }
            try {
                linkedList.add(iEntityTableModel.getEntityModelByIndex(nArray[i]));
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return linkedList;
    }

    private static IEntityModel entModelFromIndex(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException {
        return iNodeModel.getEntityTable().getEntityModelByIndex(n);
    }

    private static IPortModel portModelFromIndex(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException {
        return (IPortModel)OchncHelper.entModelFromIndex(iNodeModel, n);
    }

    private static ISideModel getSideModel(INodeModel iNodeModel, int n) throws WrongNodeSide {
        if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
            return iNodeModel.getSideModels().getSideById(n);
        }
        if (iNodeModel.provides(Feature.OPTICAL_SIDE)) {
            ISideModel[] iSideModelArray = iNodeModel.getSideModels().getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                if (iSideModelArray[i].getId() != n) continue;
                return iSideModelArray[i];
            }
        }
        throw new WrongNodeSide("Invalid SideId specified 0x" + Integer.toHexString(n));
    }
}

