/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhIpTunnelTerm;
import cerent.cms.model.IOhIpTunnelTermModel;
import cerent.cms.model.IOhTerm;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOhXcon;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.InvalidOhXcon;
import cerent.cms.model.InvalidUdcRate;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetCmsCommFailException;
import cerent.cms.model.NetModelObserver;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.HashMap;
import java.util.Observable;
import java.util.Set;

public class OhConnectionModels
extends NetModelObserver
implements IOhConnectionModels,
IObserver {
    IOhConnectionModels delegate;
    NodeModel node;

    public OhConnectionModels(NodeModel nodeModel) {
        super(nodeModel.db.getChildDebug("OhConnectionModels"));
        this.node = nodeModel;
        this.delegate = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    public void init() {
        this.init0();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.finer("destroy");
        }
        super.destroy();
    }

    private void destroyDelegate() {
        block5: {
            if (this.db.on()) {
                this.db.finer("destroyDelegate");
            }
            this.delegate.deleteObserver((IObserver)this);
            if (!this.node.provides(Feature.NMD_BASED_CM_DESTROY)) {
                if (this.db.on()) {
                    this.db.println("OCMs.destroyDelegate(): NMD_BASED_CM_DESTROY Feature is not provided.");
                }
                try {
                    this.delegate.destroy();
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block5;
                    this.db.println("OCMs:destroyDelegate():" + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.delegate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.finer("dispose");
        }
        OhConnectionModels ohConnectionModels = this;
        synchronized (ohConnectionModels) {
            if (this.delegate != null) {
                this.destroyDelegate();
            }
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(IOhConnectionModels iOhConnectionModels) {
        if (this.db.on()) {
            this.db.fine("setDelegate");
        }
        OhConnectionModels ohConnectionModels = this;
        synchronized (ohConnectionModels) {
            if (this.delegate != null) {
                this.destroyDelegate();
            }
            this.delegate = iOhConnectionModels;
            this.delegate.addObserver((IObserver)this);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable == this.delegate) {
            if (this.db.on()) {
                this.db.info("Sending update Message " + object);
            }
            this.setChanged();
            this.notifyObservers(object);
        } else {
            IOhConnectionModels iOhConnectionModels;
            if (this.db.on()) {
                this.db.fine("update from " + iObservable.getClass().toString());
            }
            if ((iOhConnectionModels = this.delegate) != null) {
                iOhConnectionModels.update((Observable)iObservable, object);
            }
        }
    }

    private IOhConnectionModels getDelegate() {
        IOhConnectionModels iOhConnectionModels = this.delegate;
        if (iOhConnectionModels == null) {
            throw new NetCmsCommFailException("No delegate for OhConnectionModels");
        }
        return iOhConnectionModels;
    }

    public IOhTermModel[] getOhTermModels() {
        return this.getDelegate().getOhTermModels();
    }

    public IOhXconModel[] getOhXconModels() {
        return this.getDelegate().getOhXconModels();
    }

    public IOhIpTunnelTermModel[] getOhIpTunnelTermModels() {
        return this.getDelegate().getOhIpTunnelTermModels();
    }

    public IOhTermModel createOhTerm(ICircuitId iCircuitId, IOhTerm iOhTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, InvalidUdcRate, ProvisionError {
        return this.delegate.createOhTerm(iCircuitId, iOhTerm);
    }

    public IOhXconModel createOhXcon(ICircuitId iCircuitId, IOhXcon iOhXcon) throws InvalidOhXcon, Busy, OhMaxConnections {
        return this.delegate.createOhXcon(iCircuitId, iOhXcon);
    }

    public IOhIpTunnelTermModel createOhIpTunnelTerm(ICircuitId iCircuitId, IOhIpTunnelTerm iOhIpTunnelTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError {
        return this.delegate.createOhIpTunnelTerm(iCircuitId, iOhIpTunnelTerm);
    }

    public void setCircuitNameMap(HashMap hashMap) {
        IOhConnectionModels iOhConnectionModels = this.delegate;
        if (iOhConnectionModels != null) {
            iOhConnectionModels.setCircuitNameMap(hashMap);
        }
    }

    public Set getAvailAicPorts(OhCircuitType ohCircuitType) {
        return this.getDelegate().getAvailAicPorts(ohCircuitType);
    }

    public Set getAvailOpticalPorts(OhCircuitType ohCircuitType) throws AbstractCmsNoSuchEntityException, NoSuchInterface {
        return this.getDelegate().getAvailOpticalPorts(ohCircuitType);
    }

    public boolean isChannelInUse(int n, OhChannelType ohChannelType) {
        return this.delegate.isChannelInUse(n, ohChannelType);
    }

    public boolean isChannelAvailable(int n, OhChannelType ohChannelType) {
        return this.delegate.isChannelAvailable(n, ohChannelType);
    }
}

