/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.circuits.CircuitFilter;
import cerent.cms.model.circuits.CircuitUpgradeListener;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.event.EventListenerList;

public class CircuitDataSource
extends AbstractRowDataSource
implements Observer,
Runnable {
    protected NetCircuitManager ncm = NetCircuitManager.instance();
    protected IModel uiModel = null;
    private IModel newScope = null;
    private List circuits = new ArrayList(0);
    private HashMap circuitsMap = new HashMap();
    private List filteredCircuits = new ArrayList(0);
    private HashMap filteredCircuitsMap = new HashMap();
    private Set displayedCircuits = new HashSet(0);
    private Set allCircuits = new HashSet();
    private HashSet changedCircuits = new HashSet();
    private Thread timerThread = null;
    private Object timer = new Object();
    private boolean isVisible = false;
    private boolean isDisposed = false;
    private boolean refreshAllCircuits;
    private boolean refreshNewCircuits;
    private boolean filterChange;
    private HashSet newCircuitsFromNCM = new HashSet();
    private HashSet upgradableCircuits = new HashSet();
    protected static final SDebug db = new SDebug("CircuitDataSource");
    private static final int UPDATE_FREQUENCY = 2000;
    private CircuitFilter cktFilter = null;
    private int networkViewLayer;
    private EventListenerList circuitUpgradeListenerList = new EventListenerList();

    public CircuitDataSource(IModel iModel) {
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        this.newScope = iModel;
        this.refreshAllCircuits = true;
        this.refreshNewCircuits = false;
        this.filterChange = false;
        String string = "";
        string = iModel == null ? "Network" : (iModel instanceof INodeModel ? ((INodeModel)iModel).getName() : iModel.getNodeModel().getName() + "_" + iModel.toString());
        this.timerThread = new Thread((Runnable)this, "TimerThreadToRefreshCircuitsPane");
        this.timerThread.start();
        this.ncm.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                Object object = this.timer;
                synchronized (object) {
                    block13: {
                        if (this.isVisible) {
                            this.updateCircuits();
                            try {
                                this.timer.wait(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                if (db.on()) {
                                    db.println("InterruptedException: TimerThread Interrupted");
                                }
                                break block13;
                            }
                        }
                        try {
                            this.timer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!db.on()) break block13;
                            db.println("InterruptedException: TimerThread Interrupted");
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Exception in " + this.timerThread.getName());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println(this.timerThread.getName() + " getting disposed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisible(boolean bl) {
        if (db.on()) {
            db.println("Setting isVisible=" + bl);
        }
        Object object = this.timer;
        synchronized (object) {
            if (bl) {
                this.isVisible = true;
                this.timer.notify();
            } else {
                this.isVisible = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (db.on()) {
            db.println("in dispose()");
        }
        this.isDisposed = true;
        Iterator iterator = this.timer;
        synchronized (iterator) {
            this.timer.notify();
        }
        this.ncm.deleteObserver(this);
        if (this.isEthernetCard(this.uiModel) || this.isFibreChannelCard(this.uiModel)) {
            this.uiModel.deleteObserver((Observer)this);
        }
        iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            ((INetCircuit)iterator.next()).deleteObserver(this);
        }
        if (this.cktFilter != null) {
            this.cktFilter.dispose();
        }
        this.uiModel = null;
    }

    protected Collection getCircuitsWithinScope() {
        Collection collection;
        if (this.uiModel instanceof INodeModel) {
            collection = this.ncm.getCircuits((INodeModel)this.uiModel);
        } else if (this.uiModel instanceof IModuleModel) {
            IModuleModel iModuleModel = (IModuleModel)this.uiModel;
            collection = new HashSet(this.ncm.getCircuits(iModuleModel.getConnectionsList()));
        } else if (this.uiModel instanceof IEntityModel) {
            IEntityModel iEntityModel = (IEntityModel)this.uiModel;
            collection = new HashSet(this.ncm.getCircuits(iEntityModel.getNodeModel(), iEntityModel.getShelfId()));
        } else {
            collection = this.ncm.getCircuits();
            ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
            for (INetCircuit iNetCircuit : collection) {
                if (this.networkViewLayer == 1) {
                    if (iNetCircuit.getCircuitTypeObj().isOchncType() || iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() || iNetCircuit.getCircuitTypeObj().isOchccCircuitType()) continue;
                    arrayList.add(iNetCircuit);
                    continue;
                }
                if (this.networkViewLayer != 2 || !iNetCircuit.getCircuitTypeObj().isOchncType() && !iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && !iNetCircuit.getCircuitTypeObj().isOchccCircuitType()) continue;
                arrayList.add(iNetCircuit);
            }
            if (arrayList.size() > 0) {
                collection.removeAll(arrayList);
                if (db.on()) {
                    db.println("Network View Layer filter applyed for " + (this.networkViewLayer == 1 ? "DWDM" : "TDM"));
                }
            }
        }
        if (db.on()) {
            if (this.uiModel == null) {
                db.println("Circuits in scope NET=" + collection.size());
            } else {
                db.println("Circuits in scope " + this.uiModel.getClass().getName() + "=" + collection.size());
            }
        }
        return collection;
    }

    private void updateNewCircuits() {
        if (db.on()) {
            db.println("updateNewCircuits");
        }
        boolean bl = false;
        Collection collection = this.getCircuitsWithinScope();
        HashSet hashSet = collection instanceof HashSet ? (HashSet)collection : new HashSet(collection);
        int n = this.circuits.size();
        int n2 = this.filteredCircuits.size();
        for (INetCircuit iNetCircuit : this.newCircuitsFromNCM) {
            iNetCircuit.addObserver(this);
            if (!this.allCircuits.add(iNetCircuit) || !hashSet.contains(iNetCircuit)) continue;
            this.circuitsMap.put(iNetCircuit, new Integer(this.circuits.size()));
            this.circuits.add(iNetCircuit);
            this.displayedCircuits.add(iNetCircuit);
            if (this.filtering() && this.cktFilter.doesMatch(iNetCircuit)) {
                this.filteredCircuitsMap.put(iNetCircuit, new Integer(this.filteredCircuits.size()));
                this.filteredCircuits.add(iNetCircuit);
            }
            if (iNetCircuit.getState() == 5) {
                this.upgradableCircuits.add(iNetCircuit);
            }
            bl = true;
        }
        this.refreshNewCircuits = false;
        this.newCircuitsFromNCM.clear();
        if (bl) {
            if (this.filtering()) {
                this.fireRowsAdded(n2, this.filteredCircuits.size() - 1);
            } else {
                this.fireRowsAdded(n, this.circuits.size() - 1);
            }
        }
        this.fireCircuitUpgradeChanged();
    }

    public void updateAllCircuits() {
        if (db.on()) {
            db.println("updateAllCircuits started");
        }
        boolean bl = false;
        Collection collection = this.getCircuitsWithinScope();
        HashSet hashSet = new HashSet(this.ncm.getCircuits());
        HashSet hashSet2 = collection instanceof HashSet ? (HashSet)collection : new HashSet(collection);
        for (INetCircuit iNetCircuit : this.allCircuits) {
            if (hashSet.contains(iNetCircuit)) continue;
            iNetCircuit.deleteObserver(this);
            if (!this.displayedCircuits.contains(iNetCircuit)) continue;
            this.upgradableCircuits.remove(iNetCircuit);
            if (db.on()) {
                db.println("delete displayed ckt " + iNetCircuit.getCircuitName());
            }
            bl = true;
        }
        for (INetCircuit iNetCircuit : hashSet) {
            if (!this.allCircuits.contains(iNetCircuit)) {
                iNetCircuit.addObserver(this);
                if (hashSet2.contains(iNetCircuit)) {
                    if (iNetCircuit.getState() == 5) {
                        this.upgradableCircuits.add(iNetCircuit);
                    }
                    if (db.on()) {
                        db.println("add new displayed ckt " + iNetCircuit.getCircuitName());
                    }
                    bl = true;
                    continue;
                }
                if (!db.on()) continue;
                db.println("new non displayed ckt " + iNetCircuit.getCircuitName());
                continue;
            }
            if ((!this.displayedCircuits.contains(iNetCircuit) || hashSet2.contains(iNetCircuit)) && (this.displayedCircuits.contains(iNetCircuit) || !hashSet2.contains(iNetCircuit))) continue;
            if (db.on()) {
                db.println("ckt " + iNetCircuit.getCircuitName() + " changed scope");
            }
            if (iNetCircuit.getState() == 5) {
                if (hashSet2.contains(iNetCircuit)) {
                    this.upgradableCircuits.add(iNetCircuit);
                } else if (this.displayedCircuits.contains(iNetCircuit)) {
                    this.upgradableCircuits.remove(iNetCircuit);
                }
            }
            bl = true;
        }
        if (bl) {
            this.circuits = new ArrayList(hashSet2);
            this.circuitsMap.clear();
            int n = this.circuits.size();
            for (int i = 0; i < n; ++i) {
                this.circuitsMap.put(this.circuits.get(i), new Integer(i));
            }
            this.displayedCircuits = hashSet2;
            this.changedCircuits.clear();
            if (this.filtering()) {
                this.buildFilterArray();
            }
            this.fireDataSourceChanged();
        } else if (!this.changedCircuits.isEmpty()) {
            this.updateChangedCircuits();
        }
        this.refreshAllCircuits = false;
        this.allCircuits = hashSet;
        this.fireCircuitUpgradeChanged();
        if (db.on()) {
            db.println("updateAllCircuits done");
        }
    }

    public synchronized void setCircuitScope(IModel iModel) {
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        if (this.uiModel != iModel) {
            this.newScope = iModel;
            this.setVisible(true);
        }
    }

    private synchronized void updateCircuits() {
        if (db.on()) {
            db.println(this.timerThread.getName() + " in updateCircuits(): " + "Time = " + System.currentTimeMillis());
        }
        if (this.newScope != this.uiModel) {
            if (this.isEthernetCard(this.uiModel) || this.isFibreChannelCard(this.uiModel)) {
                this.uiModel.deleteObserver((Observer)this);
            } else if (this.isEthernetCard(this.newScope) || this.isFibreChannelCard(this.newScope)) {
                this.newScope.addObserver((Observer)this);
            }
            this.uiModel = this.newScope;
            this.refreshAllCircuits = true;
        }
        if (this.refreshAllCircuits) {
            this.refreshNewCircuits = false;
            this.newCircuitsFromNCM.clear();
            this.updateAllCircuits();
        } else {
            if (this.refreshNewCircuits) {
                this.updateNewCircuits();
            }
            if (!this.changedCircuits.isEmpty()) {
                this.updateChangedCircuits();
            }
        }
        if (this.filterChange) {
            this.buildNewFilter();
            this.filterChange = false;
        }
    }

    private boolean isEthernetCard(IModel iModel) {
        block3: {
            try {
                if (iModel instanceof IModuleModel) {
                    int n = ((IModuleModel)iModel).getEqType();
                    return n == 15 || n == 14;
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return false;
    }

    private boolean isFibreChannelCard(IModel iModel) {
        block3: {
            try {
                if (iModel instanceof IModuleModel) {
                    int n = ((IModuleModel)iModel).getEqType();
                    return n == 143;
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return false;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (this.refreshAllCircuits) {
            if (db.on()) {
                db.println("update from " + observable + ": refresh all already requested");
            }
            return;
        }
        if (observable instanceof INetCircuit) {
            INetCircuit iNetCircuit = (INetCircuit)((Object)observable);
            if (db.on()) {
                db.println("update ckt=" + iNetCircuit.getCircuitName());
            }
            if (iNetCircuit.isCircuitRefValid()) {
                if (this.displayedCircuits.contains(iNetCircuit) && this.getCircuitsWithinScope().contains(iNetCircuit)) {
                    if (db.on()) {
                        db.println("adding ckt to changed list");
                    }
                    this.changedCircuits.add(iNetCircuit);
                } else {
                    if (db.on()) {
                        db.println("ckt not displayed: refresh all requested");
                    }
                    this.refreshAllCircuits = true;
                }
            } else {
                if (db.on()) {
                    db.println("ckt deleted: refresh all requested");
                }
                this.refreshAllCircuits = true;
            }
        } else {
            this.newCircuitsFromNCM.add(object);
            this.refreshNewCircuits = true;
            if (db.on()) {
                db.println("update: refresh all requested:ncm/ethercard");
            }
        }
    }

    private void updateChangedCircuits() {
        if (db.on()) {
            db.println("updateChangedCircuits started");
        }
        for (INetCircuit iNetCircuit : this.changedCircuits) {
            Integer n = null;
            n = this.filtering() ? (Integer)this.filteredCircuitsMap.get(iNetCircuit) : (Integer)this.circuitsMap.get(iNetCircuit);
            if (n == null) continue;
            this.fireBulkRowUpdated(n, iNetCircuit, iNetCircuit);
            if (iNetCircuit.getState() == 5) {
                this.upgradableCircuits.add(iNetCircuit);
                continue;
            }
            this.upgradableCircuits.remove(iNetCircuit);
        }
        this.changedCircuits.clear();
        this.fireBulkUpdateView();
        this.fireCircuitUpgradeChanged();
        if (db.on()) {
            db.println("updateChangedCircuits done");
        }
    }

    public Collection getAllObjects() {
        if (this.filtering()) {
            return this.filteredCircuits;
        }
        return this.circuits;
    }

    public Object getObjectAtRow(int n) {
        try {
            if (this.filtering()) {
                return this.filteredCircuits.get(n);
            }
            return this.circuits.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getRowCount() {
        if (this.filtering()) {
            return this.filteredCircuits.size();
        }
        return this.circuits.size();
    }

    private boolean filtering() {
        return this.cktFilter != null && this.cktFilter.isActive();
    }

    public void addCircuitUpgradeListener(CircuitUpgradeListener circuitUpgradeListener) {
        if (CircuitDataSource.db.on) {
            db.println("addCircuitUpgradeListener " + circuitUpgradeListener);
        }
        this.circuitUpgradeListenerList.add(CircuitUpgradeListener.class, circuitUpgradeListener);
        circuitUpgradeListener.setCircuitsUpgradable(!this.upgradableCircuits.isEmpty());
    }

    public void removeCircuitUpgradeListener(CircuitUpgradeListener circuitUpgradeListener) {
        if (CircuitDataSource.db.on) {
            db.println("removeCircuitUpgradeListener " + circuitUpgradeListener);
        }
        this.circuitUpgradeListenerList.remove(CircuitUpgradeListener.class, circuitUpgradeListener);
    }

    private void fireCircuitUpgradeChanged() {
        if (CircuitDataSource.db.on) {
            db.println("fireCircuitUpgradeChanged: upgrade ckts=" + !this.upgradableCircuits.isEmpty());
        }
        Object[] objectArray = this.circuitUpgradeListenerList.getListenerList();
        boolean bl = !this.upgradableCircuits.isEmpty();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CircuitUpgradeListener.class) continue;
            ((CircuitUpgradeListener)objectArray[i + 1]).setCircuitsUpgradable(bl);
        }
    }

    public void setEnabled(boolean bl) {
        if (CircuitDataSource.db.on) {
            db.println("Enabled=" + bl);
            db.println("timerThread=" + this.timerThread);
            if (this.timerThread != null) {
                db.println("timerThread.isAlive() = " + this.timerThread.isAlive());
            }
        }
        if (bl) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public CircuitFilter getCircuitFilter() {
        if (this.cktFilter == null) {
            this.cktFilter = new CircuitFilter();
            this.cktFilter.addListener(this);
        }
        return this.cktFilter;
    }

    public void removeCircuitFilterListener() {
        if (this.cktFilter != null) {
            this.cktFilter.removeListener(this);
        }
    }

    public void setCircuitFilter(CircuitFilter circuitFilter) {
        this.cktFilter = circuitFilter;
    }

    public void filterChanged() {
        this.filterChange = true;
        this.setVisible(true);
    }

    private void buildNewFilter() {
        if (this.buildFilterArray()) {
            this.fireDataSourceChanged();
        }
    }

    private boolean buildFilterArray() {
        if (this.cktFilter == null) {
            return false;
        }
        this.filteredCircuits.clear();
        this.filteredCircuitsMap.clear();
        for (INetCircuit iNetCircuit : this.circuits) {
            if (iNetCircuit instanceof NetVcatCircuit && iNetCircuit.isOpenEndedVcatCircuit()) {
                List list = ((NetVcatCircuit)iNetCircuit).getAllMemberCircuits();
                for (INetCircuit iNetCircuit2 : list) {
                    if (!this.cktFilter.doesMatch(iNetCircuit2)) continue;
                    this.filteredCircuitsMap.put(iNetCircuit2, new Integer(this.filteredCircuits.size()));
                    this.filteredCircuits.add(iNetCircuit2);
                }
                continue;
            }
            if (!this.cktFilter.doesMatch(iNetCircuit)) continue;
            this.filteredCircuitsMap.put(iNetCircuit, new Integer(this.filteredCircuits.size()));
            this.filteredCircuits.add(iNetCircuit);
        }
        return true;
    }

    public void setNetworkViewLayerFilter(int n) {
        this.networkViewLayer = n;
        this.refreshAllCircuits = true;
        this.setVisible(true);
    }
}

