/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.model.circuits.ICircuitAccessor;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;

public class NetCircuitAccessor
implements ICircuitAccessor {
    @Override
    public int getCircuitType(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getCircuitType();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getCircuitSize(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getCircuitSize();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public String getCircuitName(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getCircuitName();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    @Override
    public int getCircuitDirection(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getCircuitDir();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getCircuitOptChannel(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getCircuitOptChannel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getCircuitStatus(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getState();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getCircuitServiceState(INetCircuit iNetCircuit) {
        int n = iNetCircuit.getServiceState();
        if (n == 6) {
            n = 2;
        }
        if (n == 5) {
            n = 1;
        }
        return n;
    }

    @Override
    public int getCircuitProtectionType(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getProtType();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public String getSrcCktPort(INetCircuit iNetCircuit) {
        return this.getPortNumString(iNetCircuit.getPrimarySource());
    }

    @Override
    public String getDstCktPort(NetCircuitDropInfo netCircuitDropInfo) {
        return this.getPortNumString(netCircuitDropInfo.getNetCktEnd());
    }

    private String getPortNumString(INetCircuitEnd iNetCircuitEnd) {
        if (iNetCircuitEnd != null && !iNetCircuitEnd.isNodeDrop()) {
            try {
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                IPortModel iPortModel = null;
                IModuleModel iModuleModel = null;
                if (iEntityModel instanceof IModuleModel) {
                    iModuleModel = (IModuleModel)iEntityModel;
                } else if (iEntityModel != null) {
                    iModuleModel = iEntityModel.getModuleModel();
                }
                if (iModuleModel != null) {
                    IHoNum iHoNum = iNetCircuitEnd.getHoNum();
                    ILoNum iLoNum = iNetCircuitEnd.getLoNum();
                    if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.C310MA)) {
                        iPortModel = iModuleModel.getPortModelForPath(iEntityModel, iLoNum, iHoNum);
                    } else {
                        int n = iModuleModel.getPortForPath(iLoNum, iHoNum);
                        if (n > 0) {
                            return String.valueOf(n);
                        }
                    }
                }
                if (iPortModel == null && iEntityModel instanceof IPortModel) {
                    iPortModel = (IPortModel)iEntityModel;
                }
                if (iPortModel != null) {
                    return PortHelper.getPortNumString(iPortModel);
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        } else {
            SDebug.root.severe("NetCircuitAccessor: getPortNumString cktEnd is null");
        }
        return "";
    }

    @Override
    public Iterator getDstCktDrops(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getDrops().iterator();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return new LinkedList().iterator();
        }
    }

    @Override
    public int getSrcCktSlot(INetCircuit iNetCircuit) {
        try {
            INetCircuitEnd iNetCircuitEnd = iNetCircuit.getPrimarySource();
            return iNetCircuitEnd.getSlotNumber();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getSrcCktShelf(INetCircuit iNetCircuit) {
        try {
            return iNetCircuit.getPrimarySource().getEntityModel().getShelfId();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getDstCktSlot(NetCircuitDropInfo netCircuitDropInfo) {
        try {
            return netCircuitDropInfo.getSlotNumber();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int getDstCktShelf(NetCircuitDropInfo netCircuitDropInfo) {
        try {
            return netCircuitDropInfo.getEntityModel().getShelfId();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return -1;
        }
    }

    @Override
    public boolean useLink(INetCircuit iNetCircuit, INetLink iNetLink) {
        boolean bl = this.circuitUseLink(iNetCircuit, iNetLink);
        INetLink iNetLink2 = iNetLink.getReverseLink();
        if (iNetLink2 != null) {
            bl = bl || this.circuitUseLink(iNetCircuit, iNetLink2);
        }
        return bl;
    }

    private boolean circuitUseLink(INetCircuit iNetCircuit, INetLink iNetLink) {
        CompositeNetLink compositeNetLink = CompositeNetLink.getCompositeLink(iNetLink);
        if (compositeNetLink != null) {
            return iNetCircuit.useLink(compositeNetLink);
        }
        return iNetCircuit.useLink(iNetLink);
    }

    @Override
    public boolean useBlsr(INetCircuit iNetCircuit, BlsrRingModel blsrRingModel) {
        BlsrSpan[] blsrSpanArray = blsrRingModel.getWorkingBlsrSpans();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            if (!this.useLink(iNetCircuit, blsrSpanArray[i].getOriginalLink()) && !this.useLink(iNetCircuit, blsrSpanArray[i].getReverseLink())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useNetElement(INetCircuit iNetCircuit, INetElement[] iNetElementArray) {
        for (int i = 0; i < iNetElementArray.length; ++i) {
            if (!iNetCircuit.doesCircuitUseNetElem(iNetElementArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSingleSource(INetCircuit iNetCircuit) {
        return iNetCircuit.getSources().size() == 1;
    }

    @Override
    public boolean hasSingleDrop(INetCircuit iNetCircuit) {
        return iNetCircuit.getDrops().size() == 1;
    }

    @Override
    public boolean hasMultipleSources(INetCircuit iNetCircuit) {
        return iNetCircuit.getSources().size() > 1;
    }

    @Override
    public boolean hasMultipleDrops(INetCircuit iNetCircuit) {
        return iNetCircuit.getDrops().size() > 1;
    }
}

