/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.RollManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.Timer;

public class RollDataSource
extends AbstractRowDataSource
implements Observer,
ActionListener {
    private RollManager rm;
    private IModel uiModel = null;
    private IModel newScope = null;
    private List rolls = new ArrayList(0);
    private HashMap rollsMap = new HashMap();
    private Set displayedRolls = new HashSet(0);
    private Set allRolls = new HashSet();
    private HashSet changedRolls = new HashSet();
    private Timer updateTimer = null;
    private boolean refreshAllRolls;
    private boolean refreshNewRolls;
    private LinkedList newRollsFromRM = new LinkedList();
    private static SDebug db = new SDebug("RollDataSource");
    private static final int UPDATE_FREQUENCY = 2000;

    public RollDataSource(IModel iModel) {
        this.rm = RollManager.instance();
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        this.newScope = iModel;
        this.refreshAllRolls = true;
        this.refreshNewRolls = false;
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setCoalesce(true);
        this.updateTimer.setInitialDelay(0);
        this.updateTimer.start();
        this.rm.addObserver(this);
    }

    public synchronized void dispose() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        this.rm.deleteObserver(this);
        Iterator iterator = this.allRolls.iterator();
        while (iterator.hasNext()) {
            ((NetRoll)((Object)iterator.next())).deleteObserver(this);
        }
    }

    private Collection getRollsWithinScope() {
        Collection collection;
        if (this.uiModel instanceof INodeModel) {
            collection = this.rm.getRolls((INodeModel)this.uiModel);
        } else if (this.uiModel instanceof IModuleModel) {
            IModuleModel iModuleModel = (IModuleModel)this.uiModel;
            collection = new HashSet(this.rm.getRolls(iModuleModel.getConnectionsList()));
        } else {
            collection = this.rm.getRolls();
        }
        if (db.on()) {
            if (this.uiModel == null) {
                db.println("Number of rolls in scope network = " + collection.size());
            } else {
                db.println("Number of rolls in scope " + this.uiModel.getClass().getName() + " = " + collection.size());
            }
        }
        return collection;
    }

    private HashSet getRollsWithinScopeHS() {
        Collection collection = this.getRollsWithinScope();
        if (collection instanceof HashSet) {
            return (HashSet)collection;
        }
        return new HashSet(collection);
    }

    private void updateNewRolls() {
        int n;
        boolean bl = false;
        HashSet hashSet = this.getRollsWithinScopeHS();
        int n2 = n = this.rolls.size();
        for (NetRoll netRoll : this.newRollsFromRM) {
            netRoll.addObserver(this);
            if (!this.allRolls.add(netRoll) || !hashSet.contains((Object)netRoll)) continue;
            this.rolls.add(netRoll);
            this.displayedRolls.add(netRoll);
            this.rollsMap.put(netRoll, new Integer(n2));
            ++n2;
            bl = true;
        }
        this.refreshNewRolls = false;
        this.newRollsFromRM.clear();
        if (bl) {
            this.fireRowsAdded(n, n2 - 1);
        }
    }

    private void updateAllRolls() {
        if (db.on()) {
            db.println("updateAllRolls started");
        }
        boolean bl = false;
        Collection collection = this.getRollsWithinScope();
        HashSet hashSet = new HashSet(this.rm.getRolls());
        HashSet hashSet2 = collection instanceof HashSet ? (HashSet)collection : new HashSet(collection);
        for (NetRoll netRoll : this.allRolls) {
            if (hashSet.contains((Object)netRoll)) continue;
            netRoll.deleteObserver(this);
            if (!this.displayedRolls.contains((Object)netRoll)) continue;
            if (db.on()) {
                db.println("delete displayed roll " + this.getDebugString(netRoll));
            }
            bl = true;
        }
        for (NetRoll netRoll : hashSet) {
            if (!this.allRolls.contains((Object)netRoll)) {
                netRoll.addObserver(this);
                if (hashSet2.contains((Object)netRoll)) {
                    if (db.on()) {
                        db.println("add new displayed roll " + this.getDebugString(netRoll));
                    }
                    bl = true;
                    continue;
                }
                if (!db.on()) continue;
                db.println("new non displayed roll " + this.getDebugString(netRoll));
                continue;
            }
            if ((!this.displayedRolls.contains((Object)netRoll) || hashSet2.contains((Object)netRoll)) && (this.displayedRolls.contains((Object)netRoll) || !hashSet2.contains((Object)netRoll))) continue;
            if (db.on()) {
                db.println("roll " + this.getDebugString(netRoll) + " changed scope");
            }
            bl = true;
        }
        if (bl) {
            this.rolls = new ArrayList(hashSet2);
            this.rollsMap.clear();
            int n = this.rolls.size();
            for (int i = 0; i < n; ++i) {
                this.rollsMap.put(this.rolls.get(i), new Integer(i));
            }
            this.displayedRolls = hashSet2;
            this.changedRolls.clear();
            this.fireDataStructureChanged();
        } else if (!this.changedRolls.isEmpty()) {
            this.updateChangedRolls();
        }
        this.refreshAllRolls = false;
        this.allRolls = hashSet;
        if (db.on()) {
            db.println("updateAllRolls done");
        }
    }

    public synchronized void setRollScope(IModel iModel) {
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        if (this.uiModel != iModel) {
            this.newScope = iModel;
            this.updateTimer.restart();
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.updateTimer) {
            if (this.newScope != this.uiModel) {
                this.uiModel = this.newScope;
                this.refreshAllRolls = true;
            }
            if (this.refreshAllRolls) {
                this.refreshNewRolls = false;
                this.newRollsFromRM.clear();
                this.updateAllRolls();
            } else {
                if (this.refreshNewRolls) {
                    this.updateNewRolls();
                }
                if (!this.changedRolls.isEmpty()) {
                    this.updateChangedRolls();
                }
            }
        }
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (this.refreshAllRolls) {
            if (db.on()) {
                db.println("update from " + observable + ": refresh all already requested");
            }
            return;
        }
        if (observable instanceof NetRoll) {
            NetRoll netRoll = (NetRoll)((Object)observable);
            if (db.on()) {
                db.println("update roll = " + this.getDebugString(netRoll));
            }
            if (!netRoll.isRollRefValid()) {
                if (db.on()) {
                    db.println("roll deleted: refresh all requested");
                }
                this.refreshAllRolls = true;
            } else if (this.displayedRolls.contains((Object)netRoll)) {
                if (db.on()) {
                    db.println("adding roll to changed list");
                }
                this.changedRolls.add(netRoll);
            } else {
                if (db.on()) {
                    db.println("roll not displayed: refresh all requested");
                }
                this.refreshAllRolls = true;
            }
        } else {
            this.newRollsFromRM.add(object);
            this.refreshNewRolls = true;
        }
    }

    private void updateChangedRolls() {
        if (db.on()) {
            db.println("updateChangedRolls started");
        }
        for (NetRoll netRoll : this.changedRolls) {
            Integer n = (Integer)this.rollsMap.get((Object)netRoll);
            if (n == null) continue;
            this.fireBulkRowUpdated(n, (Object)netRoll, (Object)netRoll);
        }
        this.changedRolls.clear();
        this.fireBulkUpdateView();
        if (db.on()) {
            db.println("updateChangedRolls done");
        }
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rolls.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getRowCount() {
        return this.rolls.size();
    }

    public void setEnabled(boolean bl) {
        if (db.on()) {
            db.println("Enabled=" + bl);
        }
        if (bl) {
            this.updateTimer.restart();
        } else {
            this.updateTimer.stop();
        }
    }

    private String getDebugString(NetRoll netRoll) {
        return netRoll.getRollFromCircuitName() + ":" + netRoll.getRollToCircuitName() + ":" + netRoll.getPathString() + ":" + netRoll.getRollFromPathString() + ":" + netRoll.getRollToPathString();
    }
}

