/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ucp.IUcpLinkModel;
import cerent.cms.model.ucp.IUcpLinks;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public class UcpLinks
extends Model
implements IUcpLinks {
    private static final SDebug ucpLinksDb = new SDebug("UcpLinks");
    IUcpLinks delegate;
    NodeModel nodeModel = null;

    public UcpLinks(NodeModel nodeModel) {
        super(ucpLinksDb);
        this.nodeModel = nodeModel;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public IUcpLinkModel[] getLinks() throws AbstractCmsIOException {
        return this.delegate != null && this.nodeModel.provides(Feature.UCP_UNIC) ? this.delegate.getLinks() : new IUcpLinkModel[]{};
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        super.destroy();
    }

    private void destroyDelegate() {
        if (this.db.on()) {
            this.db.println("destroyDelegate");
        }
        this.delegate.deleteObserver((Observer)this);
        this.delegate = null;
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose");
        }
        if (this.delegate != null) {
            this.destroyDelegate();
        }
        super.dispose();
    }

    public void setDelegate(IUcpLinks iUcpLinks) {
        if (this.db.on()) {
            this.db.println("setDelegate");
        }
        if (this.delegate != null) {
            this.destroyDelegate();
        }
        this.delegate = iUcpLinks;
        this.delegate.addObserver((Observer)this);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == this.delegate) {
            if (this.db.on) {
                this.db.println("Sending update Message " + object);
            }
            this.setChanged();
            this.notifyObservers(object);
        } else {
            IUcpLinks iUcpLinks;
            if (this.db.on()) {
                this.db.println("update from " + observable.getClass().toString());
            }
            if ((iUcpLinks = this.delegate) != null) {
                this.delegate.update(observable, object);
            }
        }
    }
}

