/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IProtectionType;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.MemberPrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConnectionValidator {
    protected static ConnectionValidator validator;
    private static final SDebug db;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public static synchronized ConnectionValidator instance() {
        if (validator == null) {
            validator = new ConnectionValidator();
        }
        return validator;
    }

    protected boolean validateConn(NetCircuitNode netCircuitNode) {
        if (netCircuitNode.getState() == 3 && netCircuitNode instanceof LoCircuitNode && netCircuitNode.getConn() == null) {
            return false;
        }
        if (!this.validateNeConnectionConstraints(netCircuitNode)) {
            return false;
        }
        INetCircuit iNetCircuit = netCircuitNode.getCircuit();
        if (iNetCircuit.isBidirectional()) {
            return this.validateBiDirectionalConn(netCircuitNode);
        }
        return this.validateUniDirectionalConn(netCircuitNode);
    }

    protected boolean validateBiDirectionalConn(NetCircuitNode netCircuitNode) {
        MemberPrefs memberPrefs;
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBiDirectionalConn() at " + netCircuitNode.getName());
        }
        if (netCircuitNode instanceof DualConnectionCircuitNode) {
            return this.validateBiDirectionalDualConn(netCircuitNode);
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode.getCircuit();
        List list = netCircuitNode.getSources();
        List list2 = netCircuitNode.getDrops();
        LinkedList linkedList = netCircuitNode.getOrigSpans();
        LinkedList linkedList2 = netCircuitNode.getTermSpans();
        LinkedList linkedList3 = netCircuitNode.getBiSpans();
        int n = netCircuitNode.countNumInputs();
        int n2 = netCircuitNode.countNumOutputs();
        int n3 = netCircuitNode.countNumOmniSpans();
        int n4 = n + n2;
        if (netCircuitNode.getNodeDrop() != null) {
            if (netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType() && (n4 == 2 && n == 1 || n4 == 1 || n4 == 0 && netCcatCircuit.getCktNodeListSize() == 1)) {
                return true;
            }
            if (netCcatCircuit.getCircuitTypeObj().isTunnelCircuitType() && n4 == 1) {
                return true;
            }
            return netCcatCircuit.getCircuitTypeObj().isLAPCircuitType() && n2 == 0 && n == 1;
        }
        n4 = n + n2 + n3;
        boolean bl = false;
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBiDirConn: " + netCircuitNode.getName() + " numIn=" + n + " numOut=" + n2 + " numOmni=" + n3);
            db.println("                   sources=" + list.size() + " drops=" + list2.size());
        }
        if ((memberPrefs = netCcatCircuit.getMemberPrefs()) != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(netCircuitNode.getNetElement())) {
            int n5 = netCircuitNode.nodeUtil.findBiDirectionalConnType();
            if (ConnectionValidator.dbgOn()) {
                db.println("validateBiDirConn: connType: " + EnumStrings.getString(IConnectionType.class, (int)n5));
            }
            switch (n5) {
                case 2: 
                case 13: 
                case 14: {
                    return true;
                }
            }
        }
        if (n3 > 0 && n < 3) {
            bl = this.validateOmniSpanProtection(netCircuitNode, linkedList3);
            if (n == 1 && n2 == 1) {
                if (list.size() == 0 && list2.size() == 0) {
                    return this.validateSpanProtection(netCircuitNode, linkedList) && this.validateSpanProtection(netCircuitNode, linkedList2) && bl;
                }
                if (list.size() == n && list2.size() == 0) {
                    return this.validateSpanProtection(netCircuitNode, linkedList) && bl;
                }
                if (list.size() == 0 && list2.size() == n2) {
                    return this.validateSpanProtection(netCircuitNode, linkedList2) && bl;
                }
            } else if (n3 == 2 && n == 0 && n2 == 0) {
                return bl;
            }
            if (ConnectionValidator.dbgOn()) {
                db.println("Cannot find a valid combo for omni spans " + n3);
            }
            return false;
        }
        if (n4 == 2) {
            return n == 1 && n2 == 1;
        }
        if (n4 == 3) {
            if (list.size() > 0) {
                if (list.size() + linkedList2.size() == n) {
                    if (list.size() == 1 && linkedList2.size() == 0) {
                        return this.validateSpanProtection(netCircuitNode, linkedList);
                    }
                    if (list.size() == 1 && linkedList2.size() == 1) {
                        return this.validateCircuitEndsUnProt(netCircuitNode, list) && this.validateSpanProtection(netCircuitNode, linkedList2);
                    }
                    return this.validateCircuitEndsUnProt(netCircuitNode, list);
                }
                return list2.size() > 0 && list.size() == 1 && list2.size() == 1 && n == 2;
            }
            if (list2.size() > 0) {
                if (list2.size() + linkedList.size() == n2) {
                    if (list2.size() == 1 && linkedList.size() == 0) {
                        return this.validateSpanProtection(netCircuitNode, linkedList2);
                    }
                    if (list2.size() == 1 && linkedList.size() == 1) {
                        return this.validateCircuitEndsUnProt(netCircuitNode, list2) && this.validateSpanProtection(netCircuitNode, linkedList);
                    }
                    return this.validateCircuitEndsUnProt(netCircuitNode, list2);
                }
                return false;
            }
            if (n == 2) {
                return this.validateSpanProtection(netCircuitNode, linkedList2);
            }
            if (n == 1) {
                return this.validateSpanProtection(netCircuitNode, linkedList);
            }
            return false;
        }
        if (n4 == 4) {
            if (n == 2 && n2 == 2) {
                return this.validateCircuitEndsUnProt(netCircuitNode, list) && this.validateCircuitEndsUnProt(netCircuitNode, list2) && this.validateSpanProtection(netCircuitNode, linkedList2) && this.validateSpanProtection(netCircuitNode, linkedList);
            }
            return false;
        }
        return false;
    }

    private boolean validateBiDirectionalDualConn(NetCircuitNode netCircuitNode) {
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBiDirectionalDualConn() " + netCircuitNode.getName());
        }
        if (!(netCircuitNode instanceof DualConnectionCircuitNode)) {
            return false;
        }
        NetCircuitNode netCircuitNode2 = ((DualConnectionCircuitNode)netCircuitNode).getFstCircuitNode();
        NetCircuitNode netCircuitNode3 = ((DualConnectionCircuitNode)netCircuitNode).getSecCircuitNode();
        int n = netCircuitNode.totalSpans();
        if (netCircuitNode2 instanceof LoTunnelNode && netCircuitNode3 instanceof LoTunnelNode) {
            return false;
        }
        if (netCircuitNode2 instanceof HoCircuitNode && netCircuitNode3 instanceof LoTunnelNode && n == netCircuitNode2.totalSpans() && n < 3) {
            return true;
        }
        return netCircuitNode2 instanceof HoCircuitNode && netCircuitNode3 instanceof HoCircuitNode && n == netCircuitNode2.totalSpans() + netCircuitNode3.totalSpans() && n < 5;
    }

    protected boolean validateUniDirectionalConn(NetCircuitNode netCircuitNode) {
        MemberPrefs memberPrefs;
        if (netCircuitNode.getState() == 2) {
            return true;
        }
        if (ConnectionValidator.dbgOn()) {
            db.println("validateUniDirectionalConn() at " + netCircuitNode.getName());
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode.getCircuit();
        List list = netCircuitNode.getSources();
        List list2 = netCircuitNode.getDrops();
        LinkedList linkedList = netCircuitNode.getOrigSpans();
        LinkedList linkedList2 = netCircuitNode.getTermSpans();
        LinkedList linkedList3 = netCircuitNode.getBiSpans();
        int n = netCircuitNode.countNumInputs();
        int n2 = netCircuitNode.countNumOutputs();
        int n3 = netCircuitNode.countNumOmniSpans();
        if (ConnectionValidator.dbgOn()) {
            db.println("validateUniDirConn: " + netCircuitNode.getName() + " numIn=" + n + " numOut=" + n2 + " numOmni=" + n3);
            db.println("                   sources=" + list.size() + " drops=" + list2.size());
        }
        if ((memberPrefs = netCcatCircuit.getMemberPrefs()) != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(netCircuitNode.getNetElement())) {
            int n4 = netCircuitNode.nodeUtil.findUniDirectionalConnType();
            switch (n4) {
                case 0: 
                case 4: 
                case 6: 
                case 15: 
                case 16: {
                    return true;
                }
            }
        }
        if (netCircuitNode.getState() == 0) {
            if (n3 > 0 && n3 < 3) {
                if (list.size() == 2 && !this.validateCircuitEndsUnProt(netCircuitNode, list)) {
                    return false;
                }
                if (list2.size() == 2 && !this.validateCircuitEndsUnProt(netCircuitNode, list2)) {
                    return false;
                }
                if (n == 1) {
                    if (list.size() == 0) {
                        if (list2.size() > 0 && n2 > list2.size()) {
                            return this.validateSpanProtection(netCircuitNode, linkedList2) && this.validateOmniSpanProtection(netCircuitNode, linkedList3) && this.validateSpanProtection(netCircuitNode, linkedList);
                        }
                        if (list2.size() == 0 && n2 > 0) {
                            return this.validateSpanProtection(netCircuitNode, linkedList) && this.validateSpanProtection(netCircuitNode, linkedList2) && this.validateOmniSpanProtection(netCircuitNode, linkedList3);
                        }
                        if (list2.size() > 0 && n2 == list2.size()) {
                            return this.validateSpanProtection(netCircuitNode, linkedList2) && this.validateOmniSpanProtection(netCircuitNode, linkedList3);
                        }
                    } else if (list.size() == n && list2.size() == 0) {
                        return this.validateOmniSpanProtection(netCircuitNode, linkedList3) && this.validateSpanProtection(netCircuitNode, linkedList);
                    }
                } else if (n3 == 2 && n == 0) {
                    return this.validateOmniSpanProtection(netCircuitNode, linkedList3);
                }
                if (ConnectionValidator.dbgOn()) {
                    db.println("Cannot find a valid combo for omni spans " + n3);
                }
                return false;
            }
            if (n3 >= 3) {
                return false;
            }
            if (list.size() > 0) {
                if (netCcatCircuit.getCktOperation() == 1 && (n2 < 1 || n2 > 2 || n > 2)) {
                    return false;
                }
                if (list.size() == 2 && !this.validateCircuitEndsUnProt(netCircuitNode, list)) {
                    return false;
                }
                if (list2.size() == 2 && !this.validateCircuitEndsUnProt(netCircuitNode, list2)) {
                    return false;
                }
                if (netCircuitNode.countNumOrigSpans() == 2) {
                    if (netCcatCircuit.getCktOperation() == 1 && !this.validateSpanProtection(netCircuitNode, linkedList)) {
                        return false;
                    }
                    if (netCcatCircuit.isMonitorCircuit()) {
                        return false;
                    }
                }
                return true;
            }
            if (list2.size() > 0) {
                if (netCircuitNode.countNumTermSpans() != 1 && netCircuitNode.countNumTermSpans() != 2) {
                    return false;
                }
                if (netCcatCircuit.getCktOperation() == 1 && (netCircuitNode.countNumOrigSpans() != 0 || list2.size() > 2)) {
                    return false;
                }
                if (netCircuitNode.countNumTermSpans() == 2 && !this.validateSpanProtection(netCircuitNode, linkedList2)) {
                    return false;
                }
                if (netCircuitNode.isOpenEndedSelector()) {
                    return this.validateCircuitEndsUnProt(netCircuitNode, list2);
                }
                return true;
            }
            if (netCircuitNode.countNumTermSpans() != 1 && netCircuitNode.countNumTermSpans() != 2) {
                return false;
            }
            if (netCircuitNode.countNumOrigSpans() != 1 && netCircuitNode.countNumOrigSpans() != 2) {
                return false;
            }
            if (netCircuitNode.countNumTermSpans() == 2 && !this.validateSpanProtection(netCircuitNode, linkedList2)) {
                return false;
            }
            return netCircuitNode.countNumOrigSpans() != 2 || this.validateSpanProtection(netCircuitNode, linkedList);
        }
        if (netCircuitNode.getState() == 3) {
            if (!(netCircuitNode.countRoutedOrigSpans() == 0 && netCircuitNode.countRoutedDrops() == 1 || netCircuitNode.countRoutedOrigSpans() == 1 && netCircuitNode.countRoutedDrops() == 0 || netCircuitNode.countRoutedOrigSpans() == 2 && netCircuitNode.countRoutedDrops() == 0)) {
                return false;
            }
            return netCircuitNode.countRoutedOrigSpans() != 2 || this.validateRoutedOrigSpanProtection(netCircuitNode, linkedList);
        }
        if (ConnectionValidator.dbgOn()) {
            db.println("validateUniDirectionalConn() - Invalid node state");
        }
        return false;
    }

    private boolean validateOmniSpanProtection(NetCircuitNode netCircuitNode, List list) {
        boolean bl = true;
        if (ConnectionValidator.dbgOn()) {
            db.println("validateOmniSpanProtection at " + netCircuitNode.getName());
        }
        for (NetCircuitSpan netCircuitSpan : list) {
            if (netCircuitNode.findRoutingDir(netCircuitSpan) != eSpanDirection.BIDIRECTIONAL || !netCircuitSpan.getNetLinkSpan().getOmni()) continue;
            bl = bl && netCircuitSpan.getLink().isFullyUnprotected();
        }
        return bl;
    }

    private boolean validateSpanProtection(NetCircuitNode netCircuitNode, List list) {
        if (ConnectionValidator.dbgOn()) {
            db.println("validateSpanProtection at " + netCircuitNode.getName());
        }
        boolean bl = netCircuitNode.isUpsrOver1Plus1Enabled();
        for (NetCircuitSpan netCircuitSpan : list) {
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                if (netCircuitSpan.getLink().inBLSR()) continue;
                return false;
            }
            if (netCircuitSpan.getLink().getProtectionType() == 3) continue;
            if (bl) {
                if (netCircuitSpan.getLink().getProtectionType() == 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean validateRoutedOrigSpanProtection(NetCircuitNode netCircuitNode, List list) {
        if (ConnectionValidator.dbgOn()) {
            db.println("validateRoutedOrigSpanProtection at " + netCircuitNode.getName());
        }
        boolean bl = netCircuitNode.isUpsrOver1Plus1Enabled();
        for (NetCircuitSpan netCircuitSpan : list) {
            if (bl) {
                if (netCircuitSpan.getSrcState() != 2 || netCircuitSpan.getLink().isFullyUnprotected() || netCircuitSpan.getLink().getProtectionType() == 1) continue;
                return false;
            }
            if (netCircuitSpan.getSrcState() != 2 || netCircuitSpan.getLink().isFullyUnprotected()) continue;
            if (ConnectionValidator.dbgOn()) {
                db.println("validateRoutedOrigSpanProtection: false");
            }
            return false;
        }
        return true;
    }

    protected boolean validateCircuitEndsUnProt(NetCircuitNode netCircuitNode, List list) {
        if (ConnectionValidator.dbgOn()) {
            db.println("validateCircuitEndsUnProt at " + netCircuitNode.getName());
        }
        boolean bl = netCircuitNode.isUpsrOver1Plus1Enabled();
        int n = list.size();
        if (bl && n > 0) {
            return this.validateUpsrOverOnePlusOne(list);
        }
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return this.validateCircuitEndUnProt((NetCircuitEnd)list.get(0));
        }
        if (n == 2) {
            return this.validateCircuitEndUnProt((NetCircuitEnd)list.get(0)) && this.validateCircuitEndUnProt((NetCircuitEnd)list.get(1));
        }
        return false;
    }

    protected boolean validateUpsrOverOnePlusOne(List list) {
        NetCircuitEnd netCircuitEnd;
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        if (ConnectionValidator.dbgOn()) {
            db.println("validateUpsrOverOnePlusOne on a list of circuit ends");
        }
        NetCircuitEnd netCircuitEnd2 = netCircuitEnd = (NetCircuitEnd)list.get(0);
        if (list.size() == 2) {
            netCircuitEnd = (NetCircuitEnd)list.get(1);
        }
        int n = netCircuitEnd2.getCircuitEnd().getPortNum();
        int n2 = netCircuitEnd.getCircuitEnd().getPortNum();
        INodeModel iNodeModel = netCircuitEnd2.getNodeModel();
        if (iNodeModel != null) {
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
                iEntityModel2 = iNodeModel.getEntityTable().getEntityModelByIndex(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        } else {
            return false;
        }
        if (iEntityModel instanceof IPortModel && iEntityModel2 instanceof IPortModel) {
            IPortModel iPortModel;
            IPortModel iPortModel2;
            block22: {
                iPortModel2 = (IPortModel)iEntityModel;
                iPortModel = (IPortModel)iEntityModel2;
                if (iPortModel2 instanceof ITdmPortModel && iPortModel instanceof ITdmPortModel) {
                    try {
                        ITdmPortModel iTdmPortModel = (ITdmPortModel)iPortModel2;
                        ITdmPortModel iTdmPortModel2 = (ITdmPortModel)iPortModel;
                        IElementModel iElementModel = iTdmPortModel.getElementModel();
                        IElementModel iElementModel2 = iTdmPortModel2.getElementModel();
                        if (iElementModel instanceof IOnePlusOneModel) {
                            if (iElementModel2 instanceof IOnePlusOneModel) {
                                if (iElementModel.equals(iElementModel2)) {
                                    if (ConnectionValidator.dbgOn()) {
                                        db.println(" AllowingUpsrOverOnePlusOne: Path1&2 on Same 1+1 ");
                                    }
                                    return true;
                                }
                                if (ConnectionValidator.dbgOn()) {
                                    db.println(" DisAllowingUpsrOverOnePlusOne: Path1&2 on different 1+1s");
                                }
                                return false;
                            }
                            if (ConnectionValidator.dbgOn()) {
                                db.println(" DisAllowingUpsrOverOnePlusOne: Path1 on 1+1, Path2 is Not");
                            }
                            return false;
                        }
                        if (iElementModel2 instanceof IOnePlusOneModel) {
                            if (ConnectionValidator.dbgOn()) {
                                db.println(" DisAllowingUpsrOverOnePlusOne: Path2 on 1+1, Path1 is Not");
                            }
                            return false;
                        }
                    }
                    catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                        if (!ConnectionValidator.dbgOn()) break block22;
                        db.println("validateCktEnd: caught Exception => ");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                    }
                }
            }
            if (iPortModel2.isOptical() && iPortModel.isOptical()) {
                if (ConnectionValidator.dbgOn()) {
                    db.println("UpsrOverOnePlusOne: Both paths are optical ");
                }
                return !iPortModel2.hasOpticalProtection() && !iPortModel.hasOpticalProtection();
            }
            if (!iPortModel2.isOptical() && !iPortModel.isOptical()) {
                if (ConnectionValidator.dbgOn()) {
                    db.println("UpsrOverOnePlusOne: Both paths are NON-optical (electrical) ");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean validateCircuitEndUnProt(NetCircuitEnd netCircuitEnd) {
        IEntityModel iEntityModel = null;
        int n = netCircuitEnd.getCircuitEnd().getPortNum();
        INodeModel iNodeModel = netCircuitEnd.getNodeModel();
        if (ConnectionValidator.dbgOn()) {
            db.println("validateCircuitEndUnProt " + netCircuitEnd.prettyString());
        }
        if (iNodeModel != null) {
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        } else {
            return false;
        }
        if (iEntityModel instanceof IPortModel) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            return iPortModel.isOptical() && !iPortModel.hasOpticalProtection() || Feature.provides((INodeModel)iNodeModel, (Feature)Feature.BACKHAUL_CIRCUITS) && 19 == iPortModel.getPayloadType();
        }
        return false;
    }

    protected boolean validateBLSRTimeSlots(NetCircuitNode netCircuitNode) throws SanityCheckFailed {
        HashMap hashMap;
        String string;
        INetLink iNetLink;
        HashMap<String, HashMap> hashMap2 = new HashMap<String, HashMap>();
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode.getCircuit();
        List list = netCircuitNode.getSources();
        List list2 = netCircuitNode.getDrops();
        INetElement iNetElement = netCircuitNode.getNetElement();
        Iterator<Object> iterator = list.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                Iterator iterator2 = (NetCircuitEnd)iterator.next();
                iNetLink = netCcatCircuit.getNetwork().findNetLinkFromSource(false, ((NetCircuitEnd)((Object)iterator2)).getNetElement(), ((NetCircuitEnd)((Object)iterator2)).getEntityIndex(), ((NetCircuitEnd)((Object)iterator2)).getHoNum());
                if (iNetLink == null || !(iNetLink instanceof NetLink) || (string = iNetLink.blsrRingName(iNetElement)) == "") continue;
                if (!hashMap2.containsKey(string)) {
                    hashMap = new HashMap();
                    hashMap2.put(string, hashMap);
                } else {
                    hashMap = (HashMap)hashMap2.get(string);
                }
                hashMap.put(iNetLink, ((NetLink)iNetLink).getProtectionType());
            }
            iterator = list2.iterator();
        }
        for (Iterator iterator2 : netCircuitNode.getAllSpans().keySet()) {
            iNetLink = ((NetCircuitSpan)((Object)iterator2)).getLink();
            string = iNetLink.blsrRingName(iNetElement);
            if (!(iNetLink instanceof NetLink) || string == "") continue;
            if (!hashMap2.containsKey(string)) {
                hashMap = new HashMap();
                hashMap2.put(string, hashMap);
            } else {
                hashMap = (HashMap)hashMap2.get(string);
            }
            hashMap.put((NetLink)iNetLink, ((NetLink)iNetLink).getProtectionType());
        }
        for (HashMap hashMap3 : hashMap2.values()) {
            if (this.validateBLSRTimeSlots(netCircuitNode, hashMap3)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateBLSRTimeSlots(NetCircuitNode netCircuitNode, Map<INetLink, Integer> map) throws SanityCheckFailed {
        Object object3;
        INetLink iNetLink;
        Object object2;
        TreeMap<NetLink, Object> treeMap = new TreeMap<NetLink, Object>(new NetLinkComparator());
        TreeMap<NetLink, Object> treeMap2 = new TreeMap<NetLink, Object>(new NetLinkComparator());
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode.getCircuit();
        List list = netCircuitNode.getSources();
        List list2 = netCircuitNode.getDrops();
        INetElement iNetElement = netCircuitNode.getNetElement();
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBLSRTimeSlots: node " + netCircuitNode.getName());
        }
        Iterator<Object> iterator = netCircuitNode.getSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                object2 = (NetCircuitEnd)iterator.next();
                iNetLink = netCcatCircuit.getNetwork().findNetLinkFromSource(false, ((NetCircuitEnd)object2).getNetElement(), ((NetCircuitEnd)object2).getEntityIndex(), ((NetCircuitEnd)object2).getHoNum(), ((NetCircuitEnd)object2).getLoNum());
                if (iNetLink == null || !(iNetLink instanceof NetLink) || !map.containsKey(iNetLink)) continue;
                if (!treeMap.containsKey(iNetLink)) {
                    treeMap.put((NetLink)iNetLink, object2);
                    continue;
                }
                if (((NetCircuitEnd)object2).equals(treeMap.get(iNetLink))) continue;
                return false;
            }
            if (netCcatCircuit.getCircuitNodes().size() == 1 && i == 0 && treeMap.values().isEmpty()) break;
            iterator = netCircuitNode.getDrops().iterator();
        }
        object2 = netCircuitNode.getOrigSpans();
        LinkedList linkedList = netCircuitNode.getTermSpans();
        for (Object object3 : netCircuitNode.getAllSpans().keySet()) {
            iNetLink = ((NetCircuitSpan)object3).getLink();
            if (!(iNetLink instanceof NetLink) || !map.containsKey(iNetLink)) continue;
            treeMap2.put((NetLink)iNetLink, object3);
        }
        object3 = new LinkedList();
        ((LinkedList)object3).addAll(treeMap.keySet());
        ((LinkedList)object3).addAll(treeMap2.keySet());
        NetLink[] netLinkArray = ((LinkedList)object3).toArray(new NetLink[0]);
        boolean bl = netCcatCircuit.getCircuitTypeObj().isLoCircuitType();
        boolean[] blArray = new boolean[]{false, false};
        IHoNum iHoNum = null;
        IHoNum iHoNum2 = null;
        ILoNum iLoNum = null;
        ILoNum iLoNum2 = null;
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        for (int i = 0; i < ((LinkedList)object3).size(); ++i) {
            Object object4;
            NetLink netLink = netLinkArray[i];
            if (treeMap.containsKey(netLink)) {
                object4 = (NetCircuitEnd)treeMap.get(netLink);
                iHoNum = ((NetCircuitEnd)object4).getHoNum();
                blArray[0] = true;
                if (bl) {
                    iLoNum = ((NetCircuitEnd)object4).getLoNum();
                }
            } else {
                object4 = (NetCircuitSpan)treeMap2.get(netLink);
                iHoNum = ((NetCircuitSpan)object4).getHoNum(iNetElement);
                if (bl) {
                    iLoNum = ((NetCircuitSpan)object4).getLoNum();
                }
            }
            for (int j = i + 1; j < ((LinkedList)object3).size(); ++j) {
                boolean bl2;
                Object object5;
                NetLink netLink2 = netLinkArray[j];
                if (treeMap.containsKey(netLink2)) {
                    object5 = (NetCircuitEnd)treeMap.get(netLink2);
                    iHoNum2 = ((NetCircuitEnd)object5).getHoNum();
                    blArray[1] = true;
                    if (bl) {
                        iLoNum2 = ((NetCircuitEnd)object5).getLoNum();
                    }
                } else {
                    object5 = (NetCircuitSpan)treeMap2.get(netLink2);
                    iHoNum2 = ((NetCircuitSpan)object5).getHoNum(iNetElement);
                    if (bl) {
                        iLoNum2 = ((NetCircuitSpan)object5).getLoNum();
                    }
                }
                boolean bl3 = object2.contains(treeMap2.get(netLink)) || list.contains(treeMap.get(netLink)) || object2.contains(treeMap2.get(netLink2)) || list.contains(treeMap.get(netLink2));
                boolean bl4 = bl2 = linkedList.contains(treeMap2.get(netLink)) || list2.contains(treeMap.get(netLink)) || linkedList.contains(treeMap2.get(netLink2)) || list2.contains(treeMap.get(netLink2));
                if (!bl3 || !bl2) continue;
                int n = map.get(netLink);
                int n2 = map.get(netLink2);
                try {
                    if (!netLink.isBlsr() && n == 0 && this.isHoInRangePca2F(netCircuitNode, netLink, iHoNum)) {
                        n = 5;
                    }
                    if (!netLink2.isBlsr() && n2 == 0 && this.isHoInRangePca2F(netCircuitNode, netLink2, iHoNum2)) {
                        n2 = 5;
                    }
                }
                catch (ObjNotFound objNotFound) {
                    throw new SanityCheckFailed("Physical link not found for circuit " + netCcatCircuit.getCircuitName() + " on node " + netCircuitNode.getName());
                }
                this.validateBlsrTsiDebug(netLink, n);
                this.validateBlsrTsiDebug(netLink2, n2);
                if (netCcatCircuit.hasBlsrDri() && netLink.inBLSR() && netLink2.inBLSR()) {
                    IHoNum[] iHoNumArray = new IHoNum[]{iHoNum, iHoNum2};
                    NetLink[] netLinkArray2 = new NetLink[]{netLink, netLink2};
                    int[] nArray = new int[]{n, n2};
                    iHoNumArray = this.validateBlsrDriTimeSlots(netCircuitNode, netLinkArray2, nArray, iNetElement, iHoNumArray, treeMap2, blArray, netCircuitNode.getDriNodeType(), bl);
                    iHoNum = iHoNumArray[0];
                    iHoNum2 = iHoNumArray[1];
                } else {
                    if (NetProtectionType.isPcaType(n) && !NetProtectionType.isPcaType(n2) || NetProtectionType.isBlsrType(n) && !NetProtectionType.isBlsrType(n2)) {
                        return false;
                    }
                    if (NetProtectionType.isPcaType(n) || NetProtectionType.isPcaType(n2)) continue;
                }
                if (list.size() != 0) continue;
                if (!hoLoComparator.isEqual(iHoNum, iHoNum2)) {
                    if (ConnectionValidator.dbgOn()) {
                        db.println("validateBLSRTimeSlots: HoNum1: " + iHoNum.prettyString() + " HoNum2: " + iHoNum2.prettyString());
                    }
                    return false;
                }
                if (!bl || hoLoComparator.isEqual(iLoNum, iLoNum2)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isHoInRangePca2F(NetCircuitNode netCircuitNode, NetLink netLink, IHoNum iHoNum) throws ObjNotFound {
        NetLink netLink2 = netLink.getPhysicalLink(netCircuitNode, iHoNum);
        if (netLink2 == null) {
            db.println("isHoInRangePca2F: physical link not found for node " + netCircuitNode.getName() + " link " + netLink.prettyString());
            throw new ObjNotFound("Physical link not found for circuit " + netCircuitNode.circuit.getCircuitName() + " on node " + netCircuitNode.getName());
        }
        int n = netLink2.getPhysicalSize() / 2 + 1;
        if (ConnectionValidator.dbgOn()) {
            db.println("isHoInRangePca2F: " + (iHoNum.getHoNum() >= n) + " for hoNum " + iHoNum.getHoNum() + " firstPcaSts " + n + " on link " + netLink.prettyString());
        }
        return iHoNum.getHoNum() >= n;
    }

    private void validateBlsrTsiDebug(NetLink netLink, int n) {
        if (ConnectionValidator.dbgOn()) {
            String string = n >= 11 ? EnumStrings.getString(INetProtectionType.class, (int)n) : EnumStrings.getString(IProtectionType.class, (int)n);
            db.println("validateBLSRTimeSlots: associated protection " + string + " for link " + netLink.prettyString());
        }
    }

    private IHoNum[] validateBlsrDriTimeSlots(NetCircuitNode netCircuitNode, NetLink[] netLinkArray, int[] nArray, INetElement iNetElement, IHoNum[] iHoNumArray, TreeMap treeMap, boolean[] blArray, int n, boolean bl) throws SanityCheckFailed {
        int n2;
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBlsrDriTimeSlots " + iNetElement.getName());
        }
        boolean[] blArray2 = new boolean[]{false, false, false};
        boolean[] blArray3 = new boolean[]{false, false, false};
        NetLink netLink = netLinkArray[0];
        NetLink netLink2 = netLinkArray[1];
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBlsrDriTimeSlots: node " + netCircuitNode.getName());
            db.println("validateBlsrDriTimeSlots: link1 " + netLink.prettyString());
            db.println("validateBlsrDriTimeSlots: link2 " + netLink2.prettyString());
        }
        if (blArray[0] && NetProtectionType.isPcaType(n3) || blArray[1] && NetProtectionType.isPcaType(n4)) {
            throw new SanityCheckFailed("cannot have endPoint on PCA");
        }
        if ((n == 1 || n == 2 || n == 3) && (blArray[0] || blArray[1])) {
            throw new SanityCheckFailed("cannot have end point on BLSR link of DRI handoff node");
        }
        if (!blArray[0] && !blArray[1] && netLink.isBlsr() && netLink2.isBlsr()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)treeMap.get(netLink);
            if (netLink.isPca(iNetElement)) {
                blArray2[2] = true;
            }
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                blArray2[1] = true;
            }
            if (netCircuitSpan.isSecondaryCircuit()) {
                blArray2[0] = true;
            }
            netCircuitSpan = (NetCircuitSpan)treeMap.get(netLink2);
            if (netLink2.isPca(iNetElement)) {
                blArray3[2] = true;
            }
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                blArray3[1] = true;
            }
            if (netCircuitSpan.isSecondaryCircuit()) {
                blArray3[0] = true;
            }
            if (ConnectionValidator.dbgOn()) {
                boolean[][] blArrayArray = new boolean[][]{blArray2, blArray3};
                for (int i = 0; i < blArrayArray.length; ++i) {
                    db.print("link" + (i + 1) + " flags ");
                    for (int j = 0; j < blArrayArray[i].length; ++j) {
                        db.print(blArrayArray[i][j] + " ");
                    }
                    db.println("");
                }
            }
            int n5 = n2 = blArray2[0] && blArray2[1] && !blArray2[2] && blArray3[0] && blArray3[1] && !blArray3[2] || blArray2[0] && blArray2[1] && blArray2[2] && blArray3[0] && blArray3[1] && blArray3[2] || !blArray2[0] && !blArray2[1] && !blArray2[2] && blArray3[0] && blArray3[1] || blArray2[0] && blArray2[1] && !blArray3[0] && !blArray3[1] && !blArray3[2] || !blArray2[0] && !blArray2[2] && !blArray3[0] && !blArray3[2] ? 1 : 0;
            if (n2 == 0) {
                throw new SanityCheckFailed("violation of BLSR DRI timeslot rules");
            }
        }
        if (NetProtectionType.isPcaType(n3) && !NetProtectionType.isPcaType(n4) || !NetProtectionType.isPcaType(n3) && NetProtectionType.isPcaType(n4)) {
            if (n3 == 4 || n3 == 6) {
                return iHoNumArray;
            }
            if (n3 == 0 || n3 == 5) {
                int n6;
                int n7 = n6 = n3 == 0 ? 0 : 1;
                if (ConnectionValidator.dbgOn()) {
                    db.print("changing hoNum[" + n6 + "] from " + iHoNumArray[n6]);
                }
                int n8 = iHoNumArray[n6].getFramingType();
                NetLink netLink3 = netLink.getPhysicalLink(netCircuitNode, iHoNumArray[n6]);
                if (netLink3 == null) {
                    db.println("validateBlsrDriTimeSlots: physical link not found on node " + netCircuitNode.getName() + " link " + netLink.prettyString());
                    throw new SanityCheckFailed("Error: Unable to find physical link on node " + netCircuitNode.getName());
                }
                n2 = netLink3.getPhysicalSize() / 2 + 1;
                IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n8, n2);
                IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, -1);
                iHoNumArray[n6] = HoLoFactory.addHoNums(iHoNumArray[n6], iHoNum2);
                if (ConnectionValidator.dbgOn()) {
                    db.println(" to " + iHoNumArray[n6]);
                }
            }
        }
        return iHoNumArray;
    }

    protected void validateBlsrDriPcaSpans(NetCircuitNode netCircuitNode, ArrayList arrayList) throws SanityCheckFailed {
        if (!NetCircuitNodeUtil.isBlsrDriPrimary(netCircuitNode.getDriNodeType())) {
            return;
        }
        if (ConnectionValidator.dbgOn()) {
            db.println("validateBlsrDriPcaSpans at " + netCircuitNode.getName());
        }
        BlsrPrimaryInfo blsrPrimaryInfo2 = null;
        ArrayList<BlsrPrimaryInfo> arrayList2 = new ArrayList<BlsrPrimaryInfo>();
        Iterator iterator = netCircuitNode.getAllSpansList().iterator();
        boolean bl = false;
        INetElement iNetElement = netCircuitNode.getNetElement();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.getLink().inBLSR()) continue;
            blsrPrimaryInfo2 = new BlsrPrimaryInfo();
            blsrPrimaryInfo2.blsrName = netCircuitSpan.getLink().blsrRingName(iNetElement);
            blsrPrimaryInfo2.node = netCircuitNode;
            if (netCircuitSpan.getLink().isPca(iNetElement)) {
                blsrPrimaryInfo2.usesPca = true;
            }
            arrayList2.add(blsrPrimaryInfo2);
        }
        for (BlsrPrimaryInfo blsrPrimaryInfo2 : arrayList2) {
            for (BlsrPrimaryInfo blsrPrimaryInfo3 : arrayList) {
                if (!blsrPrimaryInfo3.blsrName.equals(blsrPrimaryInfo2.blsrName) || blsrPrimaryInfo3.node.equals(blsrPrimaryInfo2.node) || !blsrPrimaryInfo2.usesPca && !blsrPrimaryInfo3.usesPca) continue;
                if (ConnectionValidator.dbgOn()) {
                    db.println("hasInvalidBlsrDriPcaSpans: multiple primary nodes on the same BLSR using PCA " + blsrPrimaryInfo2.blsrName + " node " + blsrPrimaryInfo2.node.getName() + " uses PCA " + blsrPrimaryInfo2.usesPca + " node " + blsrPrimaryInfo3.node.getName() + " uses PCA " + blsrPrimaryInfo3.usesPca);
                }
                throw new SanityCheckFailed("BLSR " + blsrPrimaryInfo2.blsrName + " with multiple " + " primary handoffs can't use PCA and insure DRI protection");
            }
        }
        arrayList.addAll(arrayList2);
    }

    protected void sanityCheckBlsrDriPrimaryNode(NetCircuitNode netCircuitNode) throws SanityCheckFailed {
        int n = netCircuitNode.getSources().size();
        int n2 = netCircuitNode.getDrops().size();
        int n3 = netCircuitNode.getTotalInOuts();
        String string = netCircuitNode.getName();
        if (ConnectionValidator.dbgOn()) {
            db.println("sanityCheckBlsrDriPrimaryNode: " + string + " endpoints " + n3 + " sources " + n + " drops " + n2);
        }
        if (n3 < 3 || n3 > 4) {
            throw new SanityCheckFailed(string + " invalid number of spans " + n3);
        }
        if (n3 == 4 && (n != 0 || n2 != 0)) {
            throw new SanityCheckFailed(string + " sources or drops not allowed on IDRI nodes ");
        }
        if (netCircuitNode.countNumOmniSpans() > 1) {
            throw new SanityCheckFailed(string + " more than one omni span not allowed ");
        }
    }

    private boolean validateNeConnectionConstraints(NetCircuitNode netCircuitNode) {
        if (ConnectionValidator.dbgOn()) {
            db.println("validateNeConnectionConstraints() at " + netCircuitNode.getName());
        }
        if (!this.validateAdmOBXconConstraints(netCircuitNode)) {
            if (ConnectionValidator.dbgOn()) {
                db.println("  FAIL - ADMoB XCON constraint violation");
            }
            return false;
        }
        if (!this.validateAdmOBSelectorConstraints(netCircuitNode)) {
            if (ConnectionValidator.dbgOn()) {
                db.println("  FAIL - ADMoB selector constraint violation");
            }
            return false;
        }
        return true;
    }

    private boolean validateAdmOBXconConstraints(NetCircuitNode netCircuitNode) {
        if (!(netCircuitNode instanceof HoCircuitNode)) {
            return true;
        }
        if (netCircuitNode.getCircuit().isMemberOfVcat()) {
            return true;
        }
        HoCircuitNode hoCircuitNode = (HoCircuitNode)netCircuitNode;
        List list = this.getConnectionEntities(netCircuitNode);
        Iterator iterator = list.iterator();
        IEntityModel iEntityModel = (IEntityModel)iterator.next();
        if (!hoCircuitNode.isADMoBCard(iEntityModel)) {
            return true;
        }
        if (ConnectionValidator.dbgOn()) {
            db.println("validateAdmOBXconConstraints()");
        }
        if (hoCircuitNode.getCircuit().isMonitorCircuit()) {
            if (ConnectionValidator.dbgOn()) {
                db.println("Monitor circuit, check skipped.");
            }
            return true;
        }
        List list2 = Endpoints.getAvailEntitiesForDstHo(hoCircuitNode, iEntityModel.getEntityIndex());
        if (ConnectionValidator.dbgOn()) {
            db.println(" First Path: " + iEntityModel.toShortString());
            db.println(" Compatible Paths:");
            for (IEntityModel iEntityModel2 : list2) {
                db.println("  " + iEntityModel2.toShortString());
            }
        }
        while (iterator.hasNext()) {
            IEntityModel iEntityModel3 = (IEntityModel)iterator.next();
            if (ConnectionValidator.dbgOn()) {
                db.println(" Next Path: " + iEntityModel3.toShortString());
            }
            if (list2.contains(iEntityModel3)) continue;
            return false;
        }
        return true;
    }

    private boolean validateAdmOBSelectorConstraints(NetCircuitNode netCircuitNode) {
        if (!(netCircuitNode instanceof HoCircuitNode)) {
            return true;
        }
        if (netCircuitNode.getCircuit().isMemberOfVcat()) {
            return true;
        }
        HoCircuitNode hoCircuitNode = (HoCircuitNode)netCircuitNode;
        List list = hoCircuitNode.getSelectors();
        for (SelectorConnection selectorConnection : list) {
            IEntityModel iEntityModel;
            List list2 = selectorConnection.getExternalInputs();
            Iterator iterator = list2.iterator();
            Object var8_8 = null;
            List list3 = null;
            if (iterator.hasNext()) {
                var8_8 = iterator.next();
                iEntityModel = Endpoints.getEntityModelForPath(hoCircuitNode, var8_8);
                if (!hoCircuitNode.isADMoBCard(iEntityModel)) continue;
                list3 = Endpoints.getAvailEntitiesForSecHo(hoCircuitNode, iEntityModel.getEntityIndex());
                if (ConnectionValidator.dbgOn()) {
                    db.println("validateAdmOBSelectorConstraints()");
                    db.println(" First Path: " + iEntityModel.toShortString());
                    db.println(" Compatible Paths:");
                    for (IEntityModel iEntityModel2 : list3) {
                        db.println("  " + iEntityModel2.toShortString());
                    }
                }
            }
            while (iterator.hasNext()) {
                var8_8 = iterator.next();
                iEntityModel = Endpoints.getEntityModelForPath(hoCircuitNode, var8_8);
                if (ConnectionValidator.dbgOn()) {
                    db.println(" Next Path: " + iEntityModel.toShortString());
                }
                if (list3.contains(iEntityModel)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateAdmOBSelectorConstraints(NetCcatCircuit netCcatCircuit, NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) {
        if (netCircuitEnd.getNodeId() != netCircuitEnd2.getNodeId()) {
            return true;
        }
        if (!(netCircuitEnd instanceof HoCircuitEnd) || !(netCircuitEnd2 instanceof HoCircuitEnd)) {
            return true;
        }
        if (netCcatCircuit.isMemberOfVcat()) {
            return true;
        }
        INetElement iNetElement = netCircuitEnd.getNetElement();
        NetCircuitNode netCircuitNode = null;
        List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            netCircuitNode = list.size() > 1 ? netCcatCircuit.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
        }
        IEntityModel iEntityModel = Endpoints.getEntityModelForPath(netCircuitNode, netCircuitEnd);
        IEntityModel iEntityModel2 = Endpoints.getEntityModelForPath(netCircuitNode, netCircuitEnd2);
        if (netCircuitNode instanceof HoCircuitNode && !((HoCircuitNode)netCircuitNode).isADMoBCard(iEntityModel)) {
            return true;
        }
        List list2 = Endpoints.getAvailEntitiesForSecHo(netCircuitNode, netCircuitEnd.getEntityIndex());
        if (ConnectionValidator.dbgOn()) {
            db.println("validateAdmOBSelectorConstraints(): ");
            db.println("  primary = " + iEntityModel.toShortString());
            db.println("  secondary = " + iEntityModel2.toShortString());
            db.println("  secEntities = " + list2.size());
        }
        return list2.contains(iEntityModel2);
    }

    private List getConnectionEntities(NetCircuitNode netCircuitNode) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(netCircuitNode.getAllSpansList());
        arrayList2.addAll(netCircuitNode.getSources());
        arrayList2.addAll(netCircuitNode.getDrops());
        for (Object e : arrayList2) {
            IEntityModel iEntityModel = Endpoints.getEntityModelForPath(netCircuitNode, e);
            if (iEntityModel == null) continue;
            arrayList.add(iEntityModel);
        }
        return arrayList;
    }

    static {
        db = new SDebug("ConnectionValidator");
    }

    private class BlsrPrimaryInfo {
        String blsrName;
        NetCircuitNode node;
        boolean usesPca;

        private BlsrPrimaryInfo() {
        }
    }
}

