/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IAdminState;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitCreatStage;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.List;

public class NetCircuitEnd
implements INetCircuitEnd {
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    private static final SDebug db = new SDebug("NetCircuitEnd");
    private int stage;
    private ICircuitEnd cktEnd;

    public NetCircuitEnd() {
        this.stage = 0;
        this.cktEnd = new CircuitEnd();
    }

    public NetCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        this.stage = 0;
        this.cktEnd = new CircuitEnd(iCircuitEnd);
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT)) {
            this.cktEnd.setPathIdentifier(iCircuitEnd.getPathIdentifier());
        }
    }

    public NetCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iNetCircuitEnd;
        ICircuitEnd iCircuitEnd = netCircuitEnd.getCircuitEnd();
        this.stage = netCircuitEnd.getStage();
        this.cktEnd = new CircuitEnd(iCircuitEnd);
        if (Feature.provides((INodeModel)iNetCircuitEnd.getNodeModel(), (Feature)Feature.VCAT)) {
            this.cktEnd.setPathIdentifier(iCircuitEnd.getPathIdentifier());
        }
    }

    public NetCircuitEnd(int n, int n2, IHoLoNum iHoLoNum, boolean bl) {
        this();
        this.cktEnd.setNodeId(n);
        this.cktEnd.setPortNum(n2);
        this.setHoLoNum(iHoLoNum);
        this.setDropProt(bl);
    }

    public NetCircuitEnd(int n, int n2, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        this(n, n2, HoLoFactory.createHoLoNum(iHoNum, iLoNum), bl);
    }

    public NetCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoLoNum iHoLoNum, boolean bl) {
        this();
        if (iNodeModel != null) {
            this.cktEnd.setNodeId(iNodeModel.getNodeId());
        }
        if (iEntityModel != null) {
            this.cktEnd.setPortNum(iEntityModel.getEntityIndex());
        }
        this.setHoLoNum(iHoLoNum);
        this.setDropProt(bl);
    }

    public NetCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        this(iNodeModel, iEntityModel, HoLoFactory.createHoLoNum(iHoNum, iLoNum), bl);
    }

    public void dispose() {
    }

    public static boolean areNodeIdAndSlotAndHoLoEqual(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) {
        return netCircuitEnd.getCircuitEnd().getNodeId() == netCircuitEnd2.getCircuitEnd().getNodeId() && netCircuitEnd.getSlotNumber() == netCircuitEnd2.getSlotNumber() && NetCircuitEnd.areHoLoNumsEqual(netCircuitEnd.getCircuitEnd().getHoLoNum(), netCircuitEnd2.getCircuitEnd().getHoLoNum());
    }

    protected static boolean areHoLoNumsEqual(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        IHoNum iHoNum;
        IHoNum iHoNum2 = iHoLoNum.getHoNum();
        boolean bl = holoComp.isEqual(iHoNum2, iHoNum = iHoLoNum2.getHoNum());
        if (bl) {
            ILoNum iLoNum = iHoLoNum.getLoNum();
            ILoNum iLoNum2 = iHoLoNum2.getLoNum();
            bl = holoComp.isEqual(iLoNum, iLoNum2);
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof NetCircuitEnd) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)object;
            bl = netCircuitEnd.getCircuitEnd().getNodeId() == this.getCircuitEnd().getNodeId() && netCircuitEnd.getCircuitEnd().getPortNum() == this.getCircuitEnd().getPortNum() && NetCircuitEnd.areHoLoNumsEqual(netCircuitEnd.getCircuitEnd().getHoLoNum(), this.getCircuitEnd().getHoLoNum()) && netCircuitEnd.getPathIdentifier() == this.getPathIdentifier();
        }
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getCircuitEnd().getNodeId();
        n = 37 * n + this.getCircuitEnd().getPortNum();
        n = 37 * n + this.getCircuitEnd().getHoLoNum().hashCode();
        n = 37 * n + this.getPathIdentifier();
        return n;
    }

    @Override
    public int getNodeId() {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            return iNodeModel.getNodeId();
        }
        return 0;
    }

    public void setNode(int n) {
        if (this.dbgOn()) {
            this.debug("Setting the Node ID. Old Node Id = " + this.cktEnd.getNodeId() + " New Node Id = " + n);
        }
        this.cktEnd.setNodeId(n);
    }

    @Override
    public INetElement getNetElement() {
        Network network = Network.instance();
        INetElement iNetElement = null;
        if (this.cktEnd != null) {
            iNetElement = network.findNetElem(this.cktEnd.getNodeId());
        }
        return iNetElement;
    }

    @Override
    public INodeModel getNodeModel() {
        INodeModel iNodeModel = null;
        INetElement iNetElement = this.getNetElement();
        if (iNetElement != null) {
            iNodeModel = iNetElement.getNodeModel();
        }
        return iNodeModel;
    }

    @Override
    public void setNodeModel(INodeModel iNodeModel) {
        if (iNodeModel != null) {
            this.cktEnd.setNodeId(iNodeModel.getNodeId());
        } else {
            this.cktEnd.setNodeId(0);
        }
    }

    @Override
    public IEntityModel getEntityModel() throws ObjNotFound {
        return this.getEntityModel(this.getEntityIndex());
    }

    public IEntityModel getEntityModel(int n) throws ObjNotFound {
        IEntityModel iEntityModel = null;
        IEntityTableModel iEntityTableModel = null;
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel != null) {
                if (n != 0) {
                    block13: {
                        try {
                            iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!this.dbgOn()) break block13;
                            db.println("getEntityModel()-ERROR: Exception while getting entity model for " + this.prettyString());
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                    if (iEntityModel == null && this.dbgOn()) {
                        db.println("getEntityModel()-ERROR: null entity model for " + this.prettyString());
                    }
                } else if (this.dbgOn()) {
                    db.println("getEntityModel()-ERROR: entityIndex is 0");
                }
            } else if (this.dbgOn()) {
                db.println("getEntityModel()-ERROR: IEntityTableModel is null for " + iNodeModel.getHostName());
            }
        } else if (this.dbgOn()) {
            db.println("getEntityModel()-ERROR: Node is null");
        }
        if (iEntityModel != null) {
            return iEntityModel;
        }
        throw new ObjNotFound("Unable to get entity model for " + this.prettyString());
    }

    @Override
    public int getEntityIndex() {
        return this.cktEnd.getPortNum();
    }

    @Override
    public int getSlotNumber() {
        IEntityModel iEntityModel = null;
        int n = -1;
        try {
            iEntityModel = this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getEntityIndex());
            n = iEntityModel.getSlot();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            n = -1;
        }
        return n;
    }

    @Override
    public void setEntityIndex(int n) {
        this.cktEnd.setPortNum(n);
    }

    public ICircuitEnd getCircuitEnd() {
        return this.cktEnd;
    }

    public void setCircuitEnd(ICircuitEnd iCircuitEnd) {
        this.cktEnd = iCircuitEnd;
    }

    @Override
    public IHoLoNum getHoLoNum() {
        return this.cktEnd.getHoLoNum();
    }

    @Override
    public IHoNum getHoNum() {
        return this.cktEnd.getHoLoNum().getHoNum();
    }

    public IHoNum getRelativeHoNum(IPoolModel iPoolModel) {
        IHoNum iHoNum = this.cktEnd.getHoLoNum().getHoNum();
        if (iHoNum == null) {
            return null;
        }
        int n = iHoNum.getFramingType();
        IHoNum iHoNum2 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPoolModel.includedPath().getStartingHo(n) : iPoolModel.includedPath().getStartingHo();
        return HoLoFactory.removeOffset(iHoNum, iHoNum2);
    }

    @Override
    public ILoNum getLoNum() {
        return this.cktEnd.getHoLoNum().getLoNum();
    }

    @Override
    public void setHoLoNum(IHoLoNum iHoLoNum) {
        this.cktEnd.setHoLoNum(iHoLoNum);
    }

    @Override
    public void setHoNum(IHoNum iHoNum) {
        this.cktEnd.getHoLoNum().setHoNum(iHoNum);
    }

    @Override
    public void setLoNum(ILoNum iLoNum) {
        this.cktEnd.getHoLoNum().setLoNum(iLoNum);
    }

    @Override
    public boolean getDropProt() {
        return this.cktEnd.getDropProt();
    }

    @Override
    public void setDropProt(boolean bl) {
        this.cktEnd.setDropProt(bl);
    }

    public boolean usesNetElement(INetElement iNetElement) {
        return this.getNodeId() == iNetElement.getNodeId();
    }

    public String prettyString() {
        if (this.getNodeModel() == null) {
            return "Unknown::" + this.getHoNum() + "::" + this.getLoNum();
        }
        String string = this.getNodeModel().getName() + "::";
        string = string + Integer.toHexString(this.cktEnd.getPortNum()) + "c";
        string = string + "::" + this.getHoNum() + "::" + this.getLoNum();
        string = string + "::" + this.getPathIdentifier();
        string = string + " (" + this.getClass().getName() + ")";
        return string;
    }

    public int getStage() {
        return this.stage;
    }

    public void setStage(int n) {
        if (this.dbgOn()) {
            this.debug(this.prettyString() + " state change: " + EnumStrings.getString(INetCircuitCreatStage.class, (int)this.stage) + "->" + EnumStrings.getString(INetCircuitCreatStage.class, (int)n));
        }
        this.stage = n;
    }

    public IPoolModel getHoPool() {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PARTIAL_PCA_CIRCUITS)) {
            return iNodeModel.getPoolModels().getPoolModel(this.getEntityIndex());
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(this.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            return null;
        }
        for (int i = 0; i < iPoolModelArray.length; ++i) {
            if (!iPoolModelArray[i].includedPath().contains(this.getHoNum())) continue;
            return iPoolModelArray[i];
        }
        return null;
    }

    public Object getPathDef(short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return null;
    }

    public Object getPathDef(short s, List list) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return this.getPathDef(s);
    }

    protected void setTl1LapCktEnd() {
    }

    protected boolean isTl1LapCktEnd() {
        return false;
    }

    protected ILoAditModel createLoAdit(ICircuitId iCircuitId) throws PathInUse, InvalidPath, NoMoreLoCapableHo {
        IPoolModel iPoolModel = this.getHoPool();
        if (iPoolModel != null) {
            return this.createLoAdit(iCircuitId, iPoolModel);
        }
        return null;
    }

    protected ILoAditModel createLoAdit(ICircuitId iCircuitId, IPoolModel iPoolModel) throws PathInUse, InvalidPath, NoMoreLoCapableHo {
        short s;
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        int n = this.getHoNum() != null ? this.getHoNum().getFramingType() : ((s = Network.instance().findNetElem(iPoolModel.getNodeModel()).getTdmProtocolTypeObj().isSonet()) != 0 ? 0 : 1);
        s = CircuitSize.getCircuitSize((int)CircuitSize.getLoTunnelSize((int)n).getEnum()).size2widthOfHoCircuit();
        IHoNum iHoNum = this.getRelativeHoNum(iPoolModel);
        HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, s, iHoNum, (short)this.getPathIdentifier());
        if (iCircuitId == null) {
            iCircuitId = this.getCircuitId();
        }
        INetCircuit iNetCircuit = NetCircuitManager.instance().getCircuitFromCircuitEnd(this);
        int n2 = 3;
        if (iNetCircuit != null) {
            n2 = iNetCircuit.getAdminState();
        }
        if (this.dbgOn()) {
            this.debug("createLoAdit for circuit end. HoNum=" + this.getHoNum() + ", relativeHoNum=" + iHoNum + ", adminState=" + EnumStrings.getString(IAdminState.class, (int)(n2 + 1)));
        }
        return iConnectionModels.createLoAdit(iCircuitId, (IHoPathDefModel)hoPathDefModel, n2);
    }

    protected ICircuitId getCircuitId() {
        CircuitId circuitId = new CircuitId(this.getNodeModel().getNodeId(), 0);
        return circuitId;
    }

    public void cleanupLoAditIfOldNe() {
        if (!this.getNodeModel().provides(Feature.TCCU)) {
            this.cleanupLoAdit();
        }
    }

    public void cleanupLoAdit() {
        block10: {
            IPoolModel iPoolModel = this.getHoPool();
            if (iPoolModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: ERROR-Pool not found");
                }
                return;
            }
            ILoAditModel iLoAditModel = this.findLoAdit(iPoolModel, this.getHoNum());
            if (iLoAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: LoAdit not found for HoNum=" + this.getHoNum() + "; Assume deleted");
                }
                return;
            }
            try {
                ICircuitId iCircuitId = iLoAditModel.getCircuitId();
                if (iCircuitId.getUniquePart().getUniqueId() != 0) {
                    return;
                }
                if (this.dbgOn()) {
                    this.debug("Destroying LoAdit on ds3XmCircuitEnd; HoNum = " + this.getHoNum());
                }
                iLoAditModel.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    this.debug("cleaunupLoAdits: LoAdit in use");
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block10;
                this.debug("cleanupLoAdit: LoAdit object does not exist; Assume deleted");
            }
        }
    }

    protected ILoAditModel findLoAdit(IPoolModel iPoolModel, IHoNum iHoNum) {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditsInPool(iPoolModel);
        if (iLoAditModelArray != null) {
            if (this.dbgOn()) {
                this.debug("findLoAdit(): " + iLoAditModelArray.length + " adits in pool for hoNum=" + iHoNum);
            }
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                try {
                    IHoNum iHoNum2;
                    ILoAditModel iLoAditModel = iLoAditModelArray[i];
                    if (iLoAditModel != null && holoComp.isEqual(iHoNum2 = HoPathDefModel.physicalHo(iLoAditModel.getHo()), iHoNum)) {
                        if (this.dbgOn()) {
                            this.debug("findLoAdit(): Returning adit for HO number " + iHoNum2);
                        }
                        return iLoAditModel;
                    }
                    continue;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isNodeDrop() {
        return false;
    }

    public boolean isEtherP2PCircuitEnd() {
        return false;
    }

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public int getPathIdentifier() {
        return this.cktEnd.getPathIdentifier();
    }

    @Override
    public void setPathIdentifier(int n) {
        this.cktEnd.setPathIdentifier(n);
    }

    protected boolean onXm() {
        return false;
    }

    protected boolean usePairPortlessPorts(NetCircuitEnd netCircuitEnd) {
        return false;
    }

    public static boolean areNodeIdAndHoLoEqual(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) {
        return netCircuitEnd.getCircuitEnd().getNodeId() == netCircuitEnd2.getCircuitEnd().getNodeId() && NetCircuitEnd.areHoLoNumsEqual(netCircuitEnd.getCircuitEnd().getHoLoNum(), netCircuitEnd2.getCircuitEnd().getHoLoNum());
    }

    public IPortModel getOtherPosPortModelFromPair() {
        IPortModel iPortModel = null;
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = this.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        int n = iEntityModel.getModuleModel().getEqType();
        int n2 = iEntityModel.getPositionInParent() - 1;
        List list = null;
        int n3 = n == 285 ? 165 : 105;
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        list = iModuleModel.getDescendantsOfEqType(n3);
        for (IPortModel iPortModel2 : list) {
            if (Feature.provides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && n == 285) {
                int n4 = iPortModel2.getPositionInParent() - 1;
                if ((n2 != iModuleModel.getRPREastPort() || n4 != iModuleModel.getRPRWestPort()) && (n2 != iModuleModel.getRPRWestPort() || n4 != iModuleModel.getRPREastPort())) continue;
                iPortModel = iPortModel2;
                break;
            }
            if (iEntityModel.equals(iPortModel2)) continue;
            iPortModel = iPortModel2;
            break;
        }
        return iPortModel;
    }

    public IPortModel getPortModelForIndex(int n) {
        IPortModel iPortModel = null;
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        try {
            iEntityModel = this.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        if (iEntityModel != null) {
            int n2 = iEntityModel.getModuleModel().getEqType();
            iEntityModel2 = iEntityModel instanceof IPortModel ? iEntityModel.getParent() : iEntityModel;
            List list = iEntityModel2.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                iEntityModel = (IEntityModel)list.get(i);
                if (iEntityModel.getEntityIndex() != n) continue;
                if (n2 == 273 && (iEntityModel.getEqType() == 186 || iEntityModel.getEqType() == 355)) {
                    iPortModel = (IPortModel)list.get(i + 1);
                    break;
                }
                iPortModel = (IPortModel)iEntityModel;
                break;
            }
        }
        return iPortModel;
    }
}

