/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.SvlanCircuitNode;
import cerent.cms.topo.INetElement;

public class NetCircuitNodeFactory {
    private NetCircuitNodeFactory() {
    }

    public static NetCircuitNode createCircuitNode(INetElement iNetElement, NetCcatCircuit netCcatCircuit) {
        ICircuitType iCircuitType = netCcatCircuit.getCircuitTypeObj();
        if (iCircuitType.isHoCircuitType() || iCircuitType.isEthernetCircuitType()) {
            return NetCircuitNodeFactory.createHoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
        }
        if (iCircuitType.isLAPCircuitType()) {
            if (netCcatCircuit.getSrcCircuitNode() == null) {
                return NetCircuitNodeFactory.createHoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
            }
            return NetCircuitNodeFactory.createLoTunnelCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
        }
        if (iCircuitType.isTunnelCircuitType()) {
            return NetCircuitNodeFactory.createLoTunnelCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
        }
        if (iCircuitType.isLoCircuitType()) {
            return NetCircuitNodeFactory.createLoCircuitNode(iNetElement, (LoCcatCircuit)netCcatCircuit);
        }
        if (iCircuitType.isOchncType()) {
            return NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
        }
        if (iCircuitType.isOchTrailTunnelCircuitType()) {
            return NetCircuitNodeFactory.createOchTrailTunnelCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
        }
        if (iCircuitType.isOchccCircuitType()) {
            return NetCircuitNodeFactory.createOchccCircuitNode(iNetElement, (OchccCircuit)netCcatCircuit);
        }
        if (iCircuitType.isSVLANType()) {
            return NetCircuitNodeFactory.createSvlanCircuitNode(iNetElement, (SvlanCircuit)netCcatCircuit);
        }
        return null;
    }

    public static NetCircuitNode createCircuitNode(INetElement iNetElement, NetCcatCircuit netCcatCircuit, Object object) {
        if (object instanceof IHoConnectionModel) {
            if (netCcatCircuit instanceof LoCcatCircuit) {
                if (((LoCcatCircuit)netCcatCircuit).isYCircuit) {
                    return NetCircuitNodeFactory.createLoYCircuitNode(iNetElement, (LoCcatCircuit)netCcatCircuit, object);
                }
                return null;
            }
            return NetCircuitNodeFactory.createHoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit, object);
        }
        if (object instanceof ILoAditModel) {
            return NetCircuitNodeFactory.createLoTunnelCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit, object);
        }
        if (object instanceof ILoConnectionModel) {
            return NetCircuitNodeFactory.createLoCircuitNode(iNetElement, (LoCcatCircuit)netCcatCircuit, object);
        }
        if (object instanceof IOchncConnectionModel) {
            return NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit, object);
        }
        if (object instanceof IOchTrailAditModel) {
            return NetCircuitNodeFactory.createOchTrailTunnelCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit, object);
        }
        if (object instanceof IOchccConnectionModel) {
            return NetCircuitNodeFactory.createOchccCircuitNode(iNetElement, (OchccCircuit)netCcatCircuit, object);
        }
        if (object instanceof ISvlanConnectionModel) {
            return NetCircuitNodeFactory.createSvlanCircuitNode(iNetElement, (SvlanCircuit)netCcatCircuit, object);
        }
        return null;
    }

    public static NetCircuitNode newNodeForAddSpan(INetElement iNetElement, NetCcatCircuit netCcatCircuit) {
        if (netCcatCircuit.getCircuitTypeObj().isLoCircuitType()) {
            return NetCircuitNodeFactory.createLoCircuitNode(iNetElement, (LoCcatCircuit)netCcatCircuit);
        }
        if (netCcatCircuit.getCircuitTypeObj().isOchncType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
        }
        if (netCcatCircuit.getCircuitTypeObj().isSVLANType()) {
            return NetCircuitNodeFactory.createSvlanCircuitNode(iNetElement, (SvlanCircuit)netCcatCircuit);
        }
        return NetCircuitNodeFactory.createHoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
    }

    protected static NetCircuitNode createHoCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit) {
        return new HoCircuitNode(iNetElement, hoCcatCircuit);
    }

    protected static NetCircuitNode createHoCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit, Object object) {
        return new HoCircuitNode(iNetElement, hoCcatCircuit, object);
    }

    protected static NetCircuitNode createLoCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit) {
        return new LoCircuitNode(iNetElement, loCcatCircuit);
    }

    protected static NetCircuitNode createLoCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit, Object object) {
        return new LoCircuitNode(iNetElement, loCcatCircuit, object);
    }

    protected static NetCircuitNode createLoYCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit, Object object) {
        return new LoYCircuitNode(iNetElement, loCcatCircuit, object);
    }

    protected static NetCircuitNode createLoTunnelCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit) {
        return new LoTunnelNode(iNetElement, hoCcatCircuit);
    }

    protected static NetCircuitNode createLoTunnelCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit, Object object) {
        return new LoTunnelNode(iNetElement, hoCcatCircuit, object);
    }

    protected static NetCircuitNode createOchncCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit) {
        return new OchncCircuitNode(iNetElement, ochncCircuit);
    }

    protected static NetCircuitNode createOchncCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit, Object object) {
        return new OchncCircuitNode(iNetElement, ochncCircuit, object);
    }

    protected static NetCircuitNode createOchTrailTunnelCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit) {
        return new OchTrailTunnelNode(iNetElement, ochncCircuit);
    }

    protected static NetCircuitNode createOchTrailTunnelCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit, Object object) {
        return new OchTrailTunnelNode(iNetElement, ochncCircuit, object);
    }

    protected static NetCircuitNode createOchccCircuitNode(INetElement iNetElement, OchccCircuit ochccCircuit) {
        return new OchccCircuitNode(iNetElement, ochccCircuit);
    }

    protected static NetCircuitNode createSvlanCircuitNode(INetElement iNetElement, SvlanCircuit svlanCircuit, Object object) {
        return new SvlanCircuitNode(iNetElement, svlanCircuit, object);
    }

    protected static NetCircuitNode createSvlanCircuitNode(INetElement iNetElement, SvlanCircuit svlanCircuit) {
        return new SvlanCircuitNode(iNetElement, svlanCircuit);
    }

    protected static NetCircuitNode createOchccCircuitNode(INetElement iNetElement, OchccCircuit ochccCircuit, Object object) {
        return new OchccCircuitNode(iNetElement, ochccCircuit, object);
    }

    protected static NetCircuitNode createDualConnectionCircuitNode(INetElement iNetElement, ICircuitType iCircuitType, NetCcatCircuit netCcatCircuit) {
        return new DualConnectionCircuitNode(iNetElement, iCircuitType, netCcatCircuit);
    }

    protected static NetCircuitNode createDualConnectionCircuitNode(NetCircuitNode netCircuitNode, Object object) {
        NetCircuitNode netCircuitNode2 = NetCircuitNodeFactory.createCircuitNode(netCircuitNode.getNetElement(), (NetCcatCircuit)netCircuitNode.getCircuit(), object);
        return new DualConnectionCircuitNode(netCircuitNode, netCircuitNode2);
    }

    protected static NetCircuitNode createDualConnectionCircuitNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        return new DualConnectionCircuitNode(netCircuitNode, netCircuitNode2);
    }
}

