/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.net.IFVCircuitSpan;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IAdminState;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IProtectionOp;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitCreatStage;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.ISpanProtectionOp;
import cerent.cms.ncp.IUpsrSpanState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InvalidSpanProtectionOp;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.ProtectionSwitchHelper;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public abstract class NetCircuitSpan
extends CmsObservable
implements INetCircuitSpan,
IFVCircuitSpan,
Observer {
    private static final SDebug db = new SDebug("NetCircuitSpan");
    protected NetCcatCircuit circuit;
    protected NetLinkSpan availSpan;
    private INetCircuitNode srcNCN;
    private INetCircuitNode dstNCN;
    private int srcState;
    private int dstState;
    protected boolean upsrLink;
    private int linkPhysicalType;
    private int linkProtectionType;
    private int linkPcaRevertMode;
    private int linkState;
    private boolean observerActive;
    private boolean blsrDriInterConnect;
    private boolean driSpan = false;
    private boolean disposed;
    private UpdateEvent updateEvent;
    public static final int SDH_ENCODING = 0;
    public static final int SONET_ENCODING = 1;

    public NetCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan, INetCircuitNode iNetCircuitNode, INetCircuitNode iNetCircuitNode2) {
        this(netCcatCircuit, netLinkSpan);
        this.srcNCN = iNetCircuitNode;
        this.dstNCN = iNetCircuitNode2;
    }

    public NetCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan) {
        this.circuit = netCcatCircuit;
        this.availSpan = netLinkSpan;
        this.srcState = 0;
        this.dstState = 0;
        this.observerActive = false;
        this.disposed = false;
        this.updateEvent = new UpdateEvent();
        this.upsrLink = false;
        this.blsrDriInterConnect = false;
        this.linkPhysicalType = this.getLink().getPhysicalType();
        this.linkProtectionType = this.getLink().getProtectionType();
        this.linkState = this.getLink().state();
        this.linkPcaRevertMode = this.getLink() instanceof NetLink ? ((NetLink)this.getLink()).getPcaRevertMode() : 0;
        this.srcNCN = null;
        this.dstNCN = null;
    }

    public NetCircuitSpan() {
    }

    @Override
    public boolean isInternalSpan() {
        if (this.srcNCN != null && this.dstNCN != null) {
            if (this.srcNCN.getNetElement() == this.dstNCN.getNetElement()) {
                return true;
            }
        } else if (this.getNetLinkSpan().getLink().getLinkType() == 10) {
            if (this.dbgOn()) {
                this.debug("Warning !! NetCircuitSpan.isInternalSpan->srcNcn or dstNcn Null");
            }
            return true;
        }
        return false;
    }

    protected boolean isLineProtected() {
        if (this.getLink().isLOTunnel() || this.getLink().isLAP()) {
            return ((NetLink)this.getLink()).getLotCircuit().isCircuitProtected();
        }
        return this.getLink().isProtected();
    }

    public String prettyString() {
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getSrcNCN();
        String string = "";
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
        String string2 = "";
        if (this.srcNCN instanceof DualConnectionCircuitNode) {
            string = string + "(DCN)";
        }
        string = this.srcNCN == null ? string + ", srcNCN=null, " : string + ", srcNCN!=null, ";
        if (this.dstNCN instanceof DualConnectionCircuitNode) {
            string2 = string2 + "(DCN)";
        }
        string2 = this.dstNCN == null ? string2 + ", dstNCN=null, " : string2 + ", dstNCN!=null, ";
        return this.availSpan.prettyString() + " src=" + EnumStrings.getString(INetCircuitCreatStage.class, (int)this.srcState) + " " + string + ": dst=" + EnumStrings.getString(INetCircuitCreatStage.class, (int)this.dstState) + " " + string2 + " (" + this.getClass().getName() + ")";
    }

    protected String prettyStringSpanState() {
        boolean bl = this.getNetLinkSpan().isSecondaryCircuit();
        return (this.upsrLink ? " (UPSR, " + this.prettyStringGetSpanState() + (this.getOmni() ? ", omni)" : ")") : "") + (this.circuit.isEthernet() ? " (ETHER, " + (this.active() ? "Fwrd)" : "Block)") : "") + (this.driSpan ? " DRI" : "") + (this.blsrDriInterConnect ? " BlsrInterx" : "") + (bl ? " BlsrSecondary" : "") + (this.disposed ? " disposed" : "");
    }

    private String prettyStringGetSpanState() {
        String string = "error";
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getSrcNCN();
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
        if (netCircuitNode != null && netCircuitNode2 != null) {
            string = EnumStrings.getString(IUpsrSpanState.class, (int)this.getSpanState(netCircuitNode.getNodeModel())) + "->" + netCircuitNode.getName() + ", " + EnumStrings.getString(IUpsrSpanState.class, (int)this.getSpanState(netCircuitNode2.getNodeModel())) + "->" + netCircuitNode2.getName();
        }
        return string;
    }

    protected boolean getDri() {
        return this.driSpan;
    }

    protected void setDri(boolean bl) {
        this.driSpan = bl;
    }

    @Override
    public INetLinkSpan getNetLinkSpan() {
        return this.availSpan;
    }

    @Override
    public INetLink getLink() {
        return this.availSpan == null ? null : this.availSpan.getLink();
    }

    @Override
    public INetLink getReverseLink() {
        return this.availSpan.getReverseLink();
    }

    @Override
    public ILoNum getLoNum() {
        return this.availSpan.getLoNum();
    }

    @Override
    public boolean preferred() {
        return false;
    }

    @Override
    public IHoNum getSrcHoNum() {
        return this.availSpan.getSrcHoNum();
    }

    @Override
    public IHoNum getDstHoNum() {
        return this.availSpan.getDstHoNum();
    }

    @Override
    public IHoNum getHoNum(INetElement iNetElement) {
        if (this.getLink() != null && iNetElement == this.getLink().getSrc()) {
            return this.getSrcHoNum();
        }
        if (this.getLink() != null && iNetElement == this.getLink().getDst()) {
            return this.getDstHoNum();
        }
        return null;
    }

    public IHoNum getInternalHoNum(INetCircuitNode iNetCircuitNode) {
        if (this.getLink() != null && iNetCircuitNode == this.srcNCN) {
            return this.getSrcHoNum();
        }
        if (this.getLink() != null && iNetCircuitNode == this.dstNCN) {
            return this.getDstHoNum();
        }
        return null;
    }

    public IHoNum getRelativeHoNum(INetElement iNetElement, IPoolModel iPoolModel) {
        IHoNum iHoNum = this.getHoNum(iNetElement);
        int n = iHoNum.getFramingType();
        IHoNum iHoNum2 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPoolModel.includedPath().getStartingHo(n) : iPoolModel.includedPath().getStartingHo();
        return HoLoFactory.removeOffset(iHoNum, iHoNum2);
    }

    @Override
    public boolean isUpsr() {
        return this.upsrLink;
    }

    @Override
    public boolean working() {
        return true;
    }

    protected void setCircuit(NetCcatCircuit netCcatCircuit) {
        this.circuit = netCcatCircuit;
    }

    @Override
    public boolean active() {
        boolean bl = false;
        int n = -1;
        if (this.srcState != 4 || this.dstState != 4) {
            return false;
        }
        if (this.circuit.getState() == 2) {
            return false;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        if (this.getLink() != null) {
            netCircuitNode = (NetCircuitNode)this.getSrcNCN();
            netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
        }
        if (netCircuitNode != null) {
            n = this.getSpanState(netCircuitNode.getNodeModel());
            if (n == 0 || n == 2) {
                return true;
            }
        } else if (this.dbgOn()) {
            this.debug("active()- source circuit node of span is null");
        }
        if (netCircuitNode2 != null) {
            n = this.getSpanState(netCircuitNode2.getNodeModel());
            if (n == 0 || n == 2) {
                return true;
            }
        } else if (this.dbgOn()) {
            this.debug("active()- dst circuit node of span is null");
        }
        return false;
    }

    @Override
    public boolean isForwarding() {
        if (this.srcState != 4 || this.dstState != 4) {
            return false;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        if (this.getLink() != null) {
            netCircuitNode = (NetCircuitNode)this.getSrcNCN();
            netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                this.debug("isForwarding: src circuit node of span is null");
            }
            return false;
        }
        if (netCircuitNode2 == null) {
            if (this.dbgOn()) {
                this.debug("isForwarding: dst circuit node of span is null");
            }
            return false;
        }
        return netCircuitNode.isForwardingSpan(this, null) && netCircuitNode2.isForwardingSpan(this, null);
    }

    private void performProtectionOpAtNode(NetCircuitNode netCircuitNode, int n) throws InvalidSpanProtectionOp {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        int n2 = -1;
        NetCircuitNode netCircuitNode2 = netCircuitNode;
        NetCircuitSpan netCircuitSpan = this;
        if (this.dbgOn()) {
            this.debug("performProtectionOpAtNode: op " + EnumStrings.getString(ISpanProtectionOp.class, (int)n) + " on node " + netCircuitNode2.getName());
        }
        while (netCircuitNode2 != null) {
            block53: {
                block52: {
                    if (this.dbgOn()) {
                        this.debug("------------------------------------------------------");
                        this.debug("Processing node " + netCircuitNode2.getName() + ". span " + netCircuitSpan.prettyString());
                    }
                    List list = netCircuitNode2.getWorkingSpans();
                    bl2 = false;
                    bl = false;
                    if (list.contains(netCircuitSpan)) {
                        bl = true;
                    } else {
                        List list2 = netCircuitNode2.getProtectSpans();
                        if (list2.contains(netCircuitSpan)) {
                            bl2 = true;
                        }
                    }
                    if (!bl) break block52;
                    if (this.dbgOn()) {
                        this.debug("working span");
                    }
                    switch (n) {
                        case 0: {
                            n2 = 0;
                            break block53;
                        }
                        case 4: {
                            n2 = 1;
                            break block53;
                        }
                        case 3: {
                            n2 = 4;
                            break block53;
                        }
                        case 1: {
                            n2 = 6;
                            break block53;
                        }
                        default: {
                            if (this.dbgOn()) {
                                this.debug("unknown span switch operation");
                            }
                            return;
                        }
                    }
                }
                if (bl2) {
                    if (this.dbgOn()) {
                        this.debug("protect span");
                    }
                    switch (n) {
                        case 0: {
                            n2 = 0;
                            break;
                        }
                        case 4: {
                            n2 = 1;
                            break;
                        }
                        case 3: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 5;
                            break;
                        }
                        default: {
                            if (this.dbgOn()) {
                                this.debug("unknown span switch operation");
                            }
                            return;
                        }
                    }
                }
            }
            if (bl || bl2) {
                String string2;
                if (this.dbgOn()) {
                    this.debug("performing node op : " + EnumStrings.getString(IProtectionOp.class, (int)n2));
                }
                try {
                    if (netCircuitSpan.belongsToPathZeroSelector(netCircuitNode2)) {
                        if (this.dbgOn()) {
                            this.debug("Belongs to path zero selector: performing set op");
                        }
                        netCircuitNode2.getUpsrOps(netCircuitSpan).setProtectionOp(n2);
                    } else if (netCircuitSpan.belongsToNonPathZeroSelector(netCircuitNode2)) {
                        if (netCircuitNode2.getNodeModel().provides(Feature.REV_PROT_OP)) {
                            if (this.dbgOn()) {
                                this.debug("Belongs to non path zero selector: performing set reverse op");
                            }
                            netCircuitNode2.getUpsrOps(netCircuitSpan).setReverseProtectionOp(n2);
                        } else {
                            if (this.dbgOn()) {
                                this.debug("Belongs to non path zero selector: Reverse protection op not supported, performing set op");
                            }
                            netCircuitNode2.getUpsrOps(netCircuitSpan).setProtectionOp(n2);
                        }
                    }
                }
                catch (ConnectionInLoopback connectionInLoopback) {
                    string2 = this.getInvalidOpExceptionString((Exception)((Object)connectionInLoopback));
                    if (this.dbgOn()) {
                        this.debug("Hit an exception: " + string2);
                    }
                    string = string + (bl3 ? ";\n" : "    ") + netCircuitNode2.getName() + "::" + string2;
                    bl3 = true;
                }
                catch (InvalidProtectionOp invalidProtectionOp) {
                    string2 = this.getInvalidOpExceptionString((Exception)((Object)invalidProtectionOp));
                    if (this.dbgOn()) {
                        this.debug("Hit an exception: " + string2);
                    }
                    string = string + (bl3 ? ";\n" : "    ") + netCircuitNode2.getName() + "::" + string2;
                    bl3 = true;
                }
                catch (InternalCommError internalCommError) {
                    string2 = this.getInvalidOpExceptionString((Exception)((Object)internalCommError));
                    if (this.dbgOn()) {
                        this.debug("Hit an exception: InternalCommError");
                    }
                    string = string + (bl3 ? ";\n" : "    ") + netCircuitNode2.getName() + "::" + "InternalCommError";
                    bl3 = true;
                }
                catch (ConnectionTypeError connectionTypeError) {
                    string2 = this.getInvalidOpExceptionString((Exception)((Object)connectionTypeError));
                    if (this.dbgOn()) {
                        this.debug("Hit an exception: ConnectionTypeError");
                    }
                    string = string + (bl3 ? ";\n" : "    ") + netCircuitNode2.getName() + "::" + "ConnectionTypeError";
                    bl3 = true;
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    string2 = this.getInvalidOpExceptionString((Exception)((Object)connectionInTestAccess));
                    if (this.dbgOn()) {
                        this.debug("Hit an exception: ConnectionInTestAccess");
                    }
                    string = string + (bl3 ? ";\n" : "    ") + netCircuitNode2.getName() + "::" + "ConnectionInTestAccess";
                    bl3 = true;
                }
                catch (ConnectionPathNotFound connectionPathNotFound) {
                    string2 = this.getInvalidOpExceptionString(connectionPathNotFound);
                    if (this.dbgOn()) {
                        this.debug("Hit an exception: ConnectionPathNotFound");
                    }
                    string = string + (bl3 ? ";\n" : "    ") + netCircuitNode2.getName() + "::" + "ConnectionPathNotFound";
                    bl3 = true;
                }
            }
            if (netCircuitNode2.getConnectionType() == 10 || netCircuitNode2.getConnectionType() == 11 || netCircuitNode2.getConnectionType() == 6) {
                netCircuitSpan = netCircuitNode2.findAltSpanForUpsrDri(netCircuitSpan);
            } else {
                if (netCircuitNode2.isUpsrBridge() || netCircuitNode2.isUpsrSelector()) {
                    if (!this.dbgOn()) break;
                    this.debug("Node " + netCircuitNode2.getName() + " is UPSR bridge or selector");
                    break;
                }
                netCircuitSpan = netCircuitNode2.getConnectionType() == 0 ? netCircuitNode2.findAltSpanForOneway(netCircuitSpan) : netCircuitNode2.findAlternateBiSpan(netCircuitSpan);
            }
            if (netCircuitSpan == null) {
                if (!this.dbgOn()) break;
                this.debug("unable to find alternate span at " + netCircuitNode2.getName());
                break;
            }
            netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan);
        }
        if (bl3) {
            string = string + ".";
            throw new InvalidSpanProtectionOp(string);
        }
        if (this.dbgOn()) {
            this.debug("returning from performProtectionOpAtNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performProtectionOp(int n) throws InvalidSpanProtectionOp {
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        String string = "";
        String string2 = "";
        boolean bl = false;
        if (this.dbgOn()) {
            this.debug("performProtectionOp " + EnumStrings.getString(ISpanProtectionOp.class, (int)n) + " for circuit " + this.circuit.getCircuitName() + " at span " + this.prettyString());
        }
        NetCcatCircuit netCcatCircuit = this.circuit;
        synchronized (netCcatCircuit) {
            if (!this.circuit.isCircuitRefValid()) {
                throw new InvalidSpanProtectionOp("Circuit got destroyed.");
            }
            if (this.circuit.getState() != 1 && this.circuit.getState() != 5) {
                throw new InvalidSpanProtectionOp("Circuit state must be DISCOVERED or DISCOVERED_TL1.");
            }
            if (this.getLink() != null) {
                netCircuitNode = (NetCircuitNode)this.getSrcNCN();
                netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
            }
            if (netCircuitNode != null) {
                try {
                    this.performProtectionOpAtNode(netCircuitNode, n);
                }
                catch (InvalidSpanProtectionOp invalidSpanProtectionOp) {
                    string = this.getInvalidOpExceptionString(invalidSpanProtectionOp);
                    bl = true;
                }
            }
            if (netCircuitNode2 != null) {
                try {
                    this.performProtectionOpAtNode(netCircuitNode2, n);
                }
                catch (InvalidSpanProtectionOp invalidSpanProtectionOp) {
                    string2 = this.getInvalidOpExceptionString(invalidSpanProtectionOp);
                    bl = true;
                }
            }
            if (bl) {
                String string3 = string + "\n" + string2;
                if (this.dbgOn()) {
                    this.debug("Failure message: " + string3);
                }
                throw new InvalidSpanProtectionOp(string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findSelectorNodeForNe(INetElement iNetElement, int n) throws IncorrectCircuitState, ConnectionPathNotFound {
        if (this.dbgOn()) {
            this.debug("findSelectorNodeForNe: for circuit " + this.circuit.getCircuitName() + " at span " + this.prettyString());
        }
        NetCircuitNode netCircuitNode = null;
        ProtectionSwitchHelper protectionSwitchHelper = null;
        NetCircuitSpan netCircuitSpan = this;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<ProtectionSwitchHelper> linkedList = new LinkedList<ProtectionSwitchHelper>();
        Object object = this.circuit;
        synchronized (object) {
            if (!this.circuit.isCircuitRefValid()) {
                throw new IncorrectCircuitState("Circuit got destroyed");
            }
            if (this.circuit.getState() != 1 && this.circuit.getState() != 5) {
                throw new IncorrectCircuitState("Circuit must be DISCOVERED or DISCOVERED_TL1");
            }
            if (this.getLink() != null) {
                if (this.getSrcNCN().getNetElement() == iNetElement) {
                    netCircuitNode = (NetCircuitNode)this.getSrcNCN();
                } else if (this.getDstNCN().getNetElement() == iNetElement) {
                    netCircuitNode = (NetCircuitNode)this.getDstNCN();
                }
            }
        }
        while (netCircuitNode != null) {
            block49: {
                block48: {
                    if (this.dbgOn()) {
                        this.debug("findSelectorNodeForNe: Processing node " + netCircuitNode.getName() + ". span " + netCircuitSpan.prettyString());
                    }
                    object = netCircuitNode.getWorkingSpans();
                    bl2 = false;
                    bl = false;
                    if (this.dbgOn()) {
                        this.debug("WorkingSpans.size() = " + object.size());
                    }
                    if (object.contains(netCircuitSpan)) {
                        bl = true;
                    } else {
                        List list = netCircuitNode.getProtectSpans();
                        if (this.dbgOn()) {
                            this.debug("ProtectSpans.size() = " + list.size());
                        }
                        if (list.contains(netCircuitSpan)) {
                            bl2 = true;
                        }
                    }
                    if (!bl) break block48;
                    if (this.dbgOn()) {
                        this.debug("working span");
                    }
                    switch (n) {
                        case 0: {
                            n2 = 0;
                            break block49;
                        }
                        case 4: {
                            n2 = 1;
                            break block49;
                        }
                        case 3: {
                            n2 = 4;
                            break block49;
                        }
                        case 1: {
                            n2 = 6;
                            break block49;
                        }
                        default: {
                            if (this.dbgOn()) {
                                this.debug("unknown span switch operation");
                            }
                            return linkedList;
                        }
                    }
                }
                if (bl2) {
                    if (this.dbgOn()) {
                        this.debug("protect span");
                    }
                    switch (n) {
                        case 0: {
                            n2 = 0;
                            break;
                        }
                        case 4: {
                            n2 = 1;
                            break;
                        }
                        case 3: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 5;
                            break;
                        }
                        default: {
                            if (this.dbgOn()) {
                                this.debug("unknown span switch operation");
                            }
                            return linkedList;
                        }
                    }
                }
            }
            if (bl || bl2) {
                if (this.dbgOn()) {
                    this.debug("performing node op : " + EnumStrings.getString(IProtectionOp.class, (int)n2));
                }
                if (netCircuitSpan.belongsToPathZeroSelector(netCircuitNode)) {
                    protectionSwitchHelper = new ProtectionSwitchHelper(netCircuitNode, n2, true, netCircuitSpan);
                    if (this.dbgOn()) {
                        this.debug("Node " + netCircuitNode.getName() + " belongs to path zero selector");
                    }
                } else if (netCircuitSpan.belongsToNonPathZeroSelector(netCircuitNode)) {
                    if (netCircuitNode.getNodeModel().provides(Feature.REV_PROT_OP)) {
                        protectionSwitchHelper = new ProtectionSwitchHelper(netCircuitNode, n2, false, netCircuitSpan);
                        if (this.dbgOn()) {
                            this.debug("Node " + netCircuitNode.getName() + " belongs to non path zero selector");
                        }
                    } else {
                        protectionSwitchHelper = new ProtectionSwitchHelper(netCircuitNode, n2, true, netCircuitSpan);
                        if (this.dbgOn()) {
                            this.debug("Node " + netCircuitNode.getName() + " belongs to non path zero selector, however reverse protection not supported.");
                        }
                    }
                }
                linkedList.add(protectionSwitchHelper);
            }
            if (netCircuitNode.getConnectionType() == 10 || netCircuitNode.getConnectionType() == 11 || netCircuitNode.getConnectionType() == 6) {
                netCircuitSpan = netCircuitNode.findAltSpanForUpsrDri(netCircuitSpan);
            } else {
                if (netCircuitNode.isUpsrBridge() || netCircuitNode.isUpsrSelector()) {
                    if (!this.dbgOn()) break;
                    this.debug("Node " + netCircuitNode.getName() + " is UPSR bridge or selector");
                    break;
                }
                netCircuitSpan = netCircuitNode.getConnectionType() == 0 ? netCircuitNode.findAltSpanForOneway(netCircuitSpan) : netCircuitNode.findAlternateBiSpan(netCircuitSpan);
            }
            if (netCircuitSpan == null) {
                if (!this.dbgOn()) break;
                this.debug("unable to find alternate span at " + netCircuitNode.getName());
                break;
            }
            netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchTrafficAway() throws InvalidSpanProtectionOp {
        if (!this.isUpsr()) {
            return;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        String string = "";
        if (this.dbgOn()) {
            this.debug("=====================================================");
            this.debug("switchTrafficAway() from span " + this.prettyString() + " on circuit " + this.getCircuit().getCircuitName());
        }
        NetCcatCircuit netCcatCircuit = this.circuit;
        synchronized (netCcatCircuit) {
            if (!this.circuit.isCircuitRefValid()) {
                throw new InvalidSpanProtectionOp("Circuit got destroyed");
            }
            if (this.circuit.getState() != 1 && this.circuit.getState() != 5) {
                throw new InvalidSpanProtectionOp("Circuit must be DISCOVERED or DISCOVERED_TL1");
            }
            if (this.getLink() != null) {
                netCircuitNode = (NetCircuitNode)this.getSrcNCN();
                netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
            }
            NetCircuitNode netCircuitNode3 = netCircuitNode;
            for (int i = 0; i < 2; ++i) {
                NetCircuitSpan netCircuitSpan = this;
                while (netCircuitNode3 != null) {
                    if ((netCircuitSpan.isWorkingSpan(netCircuitNode3) || netCircuitSpan.isProtectSpan(netCircuitNode3)) && netCircuitNode3.isUpsrSelector()) {
                        int n = netCircuitNode3.getUpsrReversionMode();
                        if (n == 1) {
                            netCircuitSpan.performProtectionOpAtNode(netCircuitNode3, 3);
                        } else if (n == 2) {
                            if (netCircuitSpan.isWorkingSpan(netCircuitNode3)) {
                                netCircuitSpan.performProtectionOpAtNode(netCircuitNode3, 3);
                            } else {
                                netCircuitSpan.performProtectionOpAtNode(netCircuitNode3, 4);
                            }
                        }
                    }
                    if (netCircuitNode3.upsrBridgeOrSelector()) {
                        if (!this.dbgOn()) break;
                        this.debug("Node " + netCircuitNode3.getName() + " is UPSR bridge or selector");
                        break;
                    }
                    if ((netCircuitSpan = netCircuitNode3.findAlternateBiSpan(netCircuitSpan)) == null) {
                        if (!this.dbgOn()) break;
                        this.debug("unable to find alternate span at " + netCircuitNode3.getName());
                        break;
                    }
                    netCircuitNode3 = netCircuitNode3.spanGetPeer(netCircuitSpan);
                }
                netCircuitNode3 = netCircuitNode2;
            }
        }
    }

    private boolean isWorkingSpan(NetCircuitNode netCircuitNode) {
        return netCircuitNode.getWorkingSpans().contains(this);
    }

    private boolean isProtectSpan(NetCircuitNode netCircuitNode) {
        return netCircuitNode.getProtectSpans().contains(this);
    }

    private int getProtectionOpAtNode(NetCircuitNode netCircuitNode) throws ConnectionPathNotFound {
        int n = 0;
        int n2 = 0;
        NetCircuitNode netCircuitNode2 = netCircuitNode;
        NetCircuitSpan netCircuitSpan = this;
        if (this.dbgOn()) {
            this.debug("getProtectionOpAtNode");
        }
        while (netCircuitNode2 != null) {
            if (this.dbgOn()) {
                this.debug("Processing node " + netCircuitNode2.getName() + ". span " + netCircuitSpan.prettyString());
            }
            List list = netCircuitNode2.getWorkingSpans();
            boolean bl = false;
            boolean bl2 = false;
            if (list.contains(netCircuitSpan)) {
                bl2 = true;
            } else {
                List list2 = netCircuitNode2.getProtectSpans();
                if (list2.contains(netCircuitSpan)) {
                    bl = true;
                }
            }
            int n3 = 0;
            if (bl2) {
                if (this.dbgOn()) {
                    this.debug("span is a working span");
                }
                if (netCircuitSpan.belongsToPathZeroSelector(netCircuitNode2)) {
                    if (this.dbgOn()) {
                        this.debug("Belongs to path zero selector: performing get op");
                    }
                    n = netCircuitNode2.getUpsrOps(netCircuitSpan).getProtectionOp();
                } else if (netCircuitSpan.belongsToNonPathZeroSelector(netCircuitNode2)) {
                    if (netCircuitNode2.getNodeModel().provides(Feature.REV_PROT_OP)) {
                        if (this.dbgOn()) {
                            this.debug("Belongs to non path zero selector: performing get reverse op");
                        }
                        n = netCircuitNode2.getUpsrOps(netCircuitSpan).getReverseProtectionOp();
                    } else {
                        n = netCircuitNode2.getUpsrOps(netCircuitSpan).getProtectionOp();
                        if (this.dbgOn()) {
                            this.debug("Belongs to non path zero selector: getReverseProtectionOp not supported, calling getProtectionOp");
                        }
                    }
                }
                if (this.dbgOn()) {
                    this.debug("node protection op is " + EnumStrings.getString(IProtectionOp.class, (int)n));
                }
            } else if (bl) {
                if (this.dbgOn()) {
                    this.debug("span is a protect span");
                }
                if (netCircuitSpan.belongsToPathZeroSelector(netCircuitNode2)) {
                    if (this.dbgOn()) {
                        this.debug("Belongs to path zero selector: performing get op");
                    }
                    n = netCircuitNode2.getUpsrOps(netCircuitSpan).getProtectionOp();
                } else if (netCircuitSpan.belongsToNonPathZeroSelector(netCircuitNode2)) {
                    if (netCircuitNode2.getNodeModel().provides(Feature.REV_PROT_OP)) {
                        if (this.dbgOn()) {
                            this.debug("Belongs to non path zero selector: performing get reverse op");
                        }
                        n = netCircuitNode2.getUpsrOps(netCircuitSpan).getReverseProtectionOp();
                    } else {
                        n = netCircuitNode2.getUpsrOps(netCircuitSpan).getProtectionOp();
                        if (this.dbgOn()) {
                            this.debug("Belongs to non path zero selector: getReverseProtectionOp not supported, calling getProtectionOp");
                        }
                    }
                }
                if (this.dbgOn()) {
                    this.debug("node protection op is " + EnumStrings.getString(IProtectionOp.class, (int)n));
                }
            }
            switch (n) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    n3 = 4;
                    break;
                }
                case 3: 
                case 4: {
                    n3 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n3 = 1;
                    break;
                }
                case 8: {
                    n3 = 2;
                    break;
                }
                default: {
                    if (this.dbgOn()) {
                        this.debug("unknown span switch operation");
                    }
                    n3 = 0;
                }
            }
            if (n2 < n3) {
                if (this.dbgOn()) {
                    this.debug("updating span op ");
                }
                n2 = n3;
            }
            if (netCircuitNode2.getConnectionType() == 10 || netCircuitNode2.getConnectionType() == 11 || netCircuitNode2.getConnectionType() == 6) {
                netCircuitSpan = netCircuitNode2.findAltSpanForUpsrDri(netCircuitSpan);
            } else {
                if (netCircuitNode2.isUpsrBridge() || netCircuitNode2.isUpsrSelector()) {
                    if (!this.dbgOn()) break;
                    this.debug("Node " + netCircuitNode2.getName() + " is UPSR bridge or selector");
                    break;
                }
                netCircuitSpan = netCircuitNode2.getConnectionType() == 0 ? netCircuitNode2.findAltSpanForOneway(netCircuitSpan) : netCircuitNode2.findAlternateBiSpan(netCircuitSpan);
            }
            if (netCircuitSpan == null) {
                if (!this.dbgOn()) break;
                this.debug("unable to find alternate span at " + netCircuitNode2.getName());
                break;
            }
            netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan);
        }
        if (this.dbgOn()) {
            this.debug("return span Op : " + EnumStrings.getString(ISpanProtectionOp.class, (int)n2));
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProtectionOp() {
        if (this.dbgOn()) {
            this.debug("protectionOp");
        }
        NetCcatCircuit netCcatCircuit = this.circuit;
        synchronized (netCcatCircuit) {
            int n;
            int n2;
            NetCircuitNode netCircuitNode;
            NetCircuitNode netCircuitNode2;
            if (!this.circuit.isCircuitRefValid()) {
                return 0;
            }
            if (this.circuit.getState() != 1 && this.circuit.getState() != 5) {
                return 0;
            }
            if (this.getLink() != null) {
                netCircuitNode2 = (NetCircuitNode)this.getSrcNCN();
                netCircuitNode = (NetCircuitNode)this.getDstNCN();
            } else {
                netCircuitNode2 = null;
                netCircuitNode = null;
            }
            try {
                n2 = this.getProtectionOpAtNode(netCircuitNode2);
                n = this.getProtectionOpAtNode(netCircuitNode);
            }
            catch (ConnectionPathNotFound connectionPathNotFound) {
                db.println("getProtectionOp: caught unexpected exception");
                SDebug.printStackTrace((Throwable)connectionPathNotFound);
                return 0;
            }
            return n2 > n ? n2 : n;
        }
    }

    protected boolean belongsToPathZeroSelector(NetCircuitNode netCircuitNode) throws ConnectionPathNotFound {
        if (netCircuitNode instanceof DualConnectionCircuitNode) {
            return netCircuitNode.getUpsrOps(this) != null;
        }
        if (netCircuitNode.getNumberOfPaths() < 3) {
            return false;
        }
        SelectorConnection selectorConnection = netCircuitNode.findSelectorWithInput(this);
        if (selectorConnection != null) {
            Iterator iterator = selectorConnection.inPuts.iterator();
            while (iterator.hasNext()) {
                Object object = selectorConnection.getExternalInput(iterator.next());
                if (object == null) continue;
                if (object instanceof NetCircuitSpan && netCircuitNode.getConnectionPathIndex((NetCircuitSpan)object) == 0) {
                    if (this.dbgOn()) {
                        db.println("belongsToPathZeroSelector: path zero selector node " + netCircuitNode.getName() + " span " + this.prettyString());
                    }
                    return true;
                }
                if (!(object instanceof NetCircuitEnd) || netCircuitNode.getConnectionPathIndex((NetCircuitEnd)object) != 0) continue;
                if (this.dbgOn()) {
                    db.println("belongsToPathZeroSelector: path zero selector node " + netCircuitNode.getName() + " span " + this.prettyString());
                }
                return true;
            }
        }
        return false;
    }

    protected boolean belongsToNonPathZeroSelector(NetCircuitNode netCircuitNode) throws ConnectionPathNotFound {
        if (netCircuitNode instanceof DualConnectionCircuitNode) {
            return false;
        }
        List list = netCircuitNode.getPathList();
        if (netCircuitNode.getNumberOfPaths() < 4) {
            return false;
        }
        SelectorConnection selectorConnection = netCircuitNode.findSelectorWithInput(this);
        if (selectorConnection != null) {
            boolean bl;
            boolean bl2 = bl = !this.belongsToPathZeroSelector(netCircuitNode);
            if (bl && this.dbgOn()) {
                db.println("belongsToNonPathZeroSelector: NON path zero selector node " + netCircuitNode.getName() + " span " + this.prettyString());
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inUpsr2BlsrConversion() {
        if (this.dbgOn()) {
            this.debug("inUpsr2BlsrConversion");
        }
        NetCcatCircuit netCcatCircuit = this.circuit;
        synchronized (netCcatCircuit) {
            NetCircuitNode netCircuitNode;
            NetCircuitNode netCircuitNode2;
            if (!this.circuit.isCircuitRefValid()) {
                return false;
            }
            if (!this.circuit.inConversion()) {
                return false;
            }
            if (this.getLink() != null) {
                netCircuitNode2 = (NetCircuitNode)this.getSrcNCN();
                netCircuitNode = (NetCircuitNode)this.getDstNCN();
            } else {
                netCircuitNode2 = null;
                netCircuitNode = null;
            }
            boolean bl = this.inConversionAtNode(netCircuitNode2);
            boolean bl2 = this.inConversionAtNode(netCircuitNode);
            return bl || bl2;
        }
    }

    private boolean inConversionAtNode(NetCircuitNode netCircuitNode) {
        boolean bl = false;
        NetCircuitNode netCircuitNode2 = netCircuitNode;
        NetCircuitSpan netCircuitSpan = this;
        if (this.dbgOn()) {
            this.debug("inConversionAtNode");
        }
        while (netCircuitNode2 != null) {
            if (netCircuitNode2.upsrBridgeOrSelector()) {
                if (!netCircuitNode2.inConnectionConversion()) break;
                bl = netCircuitNode2.getConnectionConversionModel().getUpgradeOperation() == 1;
                break;
            }
            if ((netCircuitSpan = netCircuitNode2.findAlternateBiSpan(netCircuitSpan)) == null) {
                if (!this.dbgOn()) break;
                this.debug("unable to find alternate span at " + netCircuitNode2.getName());
                break;
            }
            netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan);
        }
        return bl;
    }

    @Override
    public INetCircuit getCircuit() {
        return this.circuit;
    }

    private void addLinkObserver() {
        if (this.dbgOn()) {
            this.debug("Adding link observer");
        }
        this.updateEvent.init();
        this.getLink().addObserver(this);
        if (this.getLink().isVirtual() && this.getCircuit().isBidirectional() && this.getReverseLink() != null) {
            if (this.dbgOn()) {
                this.debug("Adding revlink observer for VL cases");
            }
            this.getReverseLink().addObserver(this);
        }
        this.observerActive = true;
    }

    private void deleteLinkObserver() {
        if (this.dbgOn()) {
            this.debug("Deleting link observer");
        }
        this.getLink().deleteObserver(this);
        this.updateEvent.init();
        this.observerActive = false;
    }

    private void deleteReverseLinkObserver() {
        INetLink iNetLink = this.getReverseLink();
        if (iNetLink != null) {
            iNetLink.deleteObserver(this);
            if (this.dbgOn()) {
                this.debug("NCSpan: removed reverse link observer");
            }
        } else if (this.dbgOn()) {
            this.debug("NCSpan: reverse link null, observer not removed");
        }
    }

    @Override
    public int getSrcState() {
        return this.srcState;
    }

    @Override
    public int getDstState() {
        return this.dstState;
    }

    @Override
    public INetCircuitNode getSrcNCN() {
        return this.srcNCN;
    }

    @Override
    public INetCircuitNode getDstNCN() {
        return this.dstNCN;
    }

    @Override
    public void setSrcNCN(INetCircuitNode iNetCircuitNode) {
        this.srcNCN = iNetCircuitNode;
    }

    @Override
    public void setDstNCN(INetCircuitNode iNetCircuitNode) {
        this.dstNCN = iNetCircuitNode;
    }

    public void setSrcState(int n) {
        this.setState(true, n);
    }

    public void setDstState(int n) {
        this.setState(false, n);
    }

    private void setState(boolean bl, int n) {
        String string;
        int n2;
        if (bl) {
            n2 = this.srcState;
            this.srcState = n;
            string = " srcState";
        } else {
            n2 = this.dstState;
            this.dstState = n;
            string = " dstState";
        }
        if (this.dbgOn()) {
            this.debug("Span: " + this.availSpan.prettyString() + string + " change: " + EnumStrings.getString(INetCircuitCreatStage.class, (int)n2) + "->" + EnumStrings.getString(INetCircuitCreatStage.class, (int)n));
        }
        if (this.getLink() == null) {
            return;
        }
        if (this.srcState == 4 && this.dstState == 4 && !this.observerActive) {
            this.addLinkObserver();
            if (this.getLink().isDeleted()) {
                if (this.dbgOn()) {
                    this.debug("setState: Link already deleted; queuing event");
                }
                this.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "deleted");
            }
        } else if (this.observerActive) {
            this.deleteLinkObserver();
        }
    }

    protected void setState(NetCircuitNode netCircuitNode, int n) {
        if (!this.isInternalSpan() && this.dbgOn()) {
            db.println("Error!!! wrong setState method called.");
        }
    }

    protected eSpanDirection biSpanDir(INetElement iNetElement) {
        return this.availSpan.biSpanDir(iNetElement);
    }

    public IEntityModel getEntityModel(INetElement iNetElement) throws AbstractCmsNoSuchEntityException {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (this.getLink() == null) {
            return null;
        }
        IEntityModel iEntityModel = iNetElement == this.getLink().getSrc() ? iNodeModel.getEntityTable().getEntityModelByIndex(this.getLink().getSrcEntityIndex()) : iNodeModel.getEntityTable().getEntityModelByIndex(this.getLink().getDstEntityIndex());
        return iEntityModel;
    }

    public int getEntityIndex(INetElement iNetElement) {
        if (this.getLink() == null) {
            return -1;
        }
        if (iNetElement == this.getLink().getSrc()) {
            return this.getLink().getSrcEntityIndex();
        }
        if (iNetElement == this.getLink().getDst()) {
            return this.getLink().getDstEntityIndex();
        }
        return -1;
    }

    public int getInternalEntityIndex(INetCircuitNode iNetCircuitNode) {
        if (this.getLink() == null) {
            return -1;
        }
        if (iNetCircuitNode == this.srcNCN) {
            return this.getLink().getSrcEntityIndex();
        }
        if (iNetCircuitNode == this.dstNCN) {
            return this.getLink().getDstEntityIndex();
        }
        return -1;
    }

    protected IPoolModel getHoPool(INetElement iNetElement) {
        if (iNetElement == this.getLink().getSrc()) {
            return this.getLink().getSrcPool();
        }
        return this.getLink().getDstPool();
    }

    protected abstract IPathDefModel getPathDef(INetElement var1, short var2) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo;

    protected IPathDefModel getPathDef(NetCircuitNode netCircuitNode, short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return null;
    }

    protected ILoAditModel getLoAdit(INetElement iNetElement) {
        IPoolModel iPoolModel = this.getHoPool(iNetElement);
        return this.getLoAdit(iNetElement, iPoolModel);
    }

    protected ILoAditModel getLoAdit(INetElement iNetElement, IPoolModel iPoolModel) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditsInPool(iPoolModel);
        if (iLoAditModelArray != null) {
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                try {
                    ILoAditModel iLoAditModel = iLoAditModelArray[i];
                    if (iLoAditModel != null && HoPathDefModel.physicalHo(iLoAditModel.getHo()).equals(this.getHoNum(iNetElement))) {
                        return iLoAditModel;
                    }
                    continue;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
        }
        return null;
    }

    protected ILoAditModel createLoAdit(INetElement iNetElement, ICircuitId iCircuitId) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        IPoolModel iPoolModel = this.getHoPool(iNetElement);
        if (iPoolModel != null) {
            return this.createLoAdit(iNetElement, iCircuitId, iPoolModel);
        }
        return null;
    }

    protected ILoAditModel createLoAdit(INetElement iNetElement, ICircuitId iCircuitId, IPoolModel iPoolModel) throws PathInUse, InvalidPath, NoMoreLoCapableHo {
        INodeModel iNodeModel = ((NetElement)iNetElement).getNodeModel();
        HoPathDefModel hoPathDefModel = null;
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        int n = this.getHoNum(iNetElement).getFramingType();
        int n2 = CircuitSize.getLoTunnelSize((int)n).getEnum();
        short s = CircuitSize.getCircuitSize((int)n2).size2widthOfHoCircuit();
        hoPathDefModel = new HoPathDefModel(iPoolModel, s, this.getRelativeHoNum(iNetElement, iPoolModel), 0);
        if (PortGrouping.getInstance().isInCreation()) {
            if (this.dbgOn()) {
                db.println("In creation");
            }
            try {
                PortGrouping.setPortGroupState(hoPathDefModel, true);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return null;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                SDebug.printStackTrace((Throwable)unsupportedOperation);
                return null;
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
                return null;
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
                return null;
            }
        }
        if (this.circuit.getCircuitTypeObj().isTunnelCircuitType() || this.circuit.getCircuitTypeObj().isLAPCircuitType()) {
            if (this.dbgOn()) {
                this.debug("createLoAdit for span. Ho Num = " + this.getHoNum(iNetElement) + ", adminState=" + EnumStrings.getString(IAdminState.class, (int)(this.circuit.getAdminState() + 1)));
            }
            ILoAditModel iLoAditModel = iConnectionModels.createLoAdit(iCircuitId, (IHoPathDefModel)hoPathDefModel, this.circuit.getAdminState());
            if (iNodeModel.provides(Feature.TCCU)) {
                try {
                    iLoAditModel.setConnectionName(this.circuit.getCircuitName());
                }
                catch (InvalidCircuitName invalidCircuitName) {
                    SDebug.printStackTrace((Throwable)invalidCircuitName);
                }
            }
            return iLoAditModel;
        }
        if (this.dbgOn()) {
            this.debug("createLoAdit for span. Ho Num = " + this.getHoNum(iNetElement) + ", adminState=" + EnumStrings.getString(IAdminState.class, (int)(this.circuit.getAdminState() + 1)));
        }
        return iConnectionModels.createLoAdit(iCircuitId, (IHoPathDefModel)hoPathDefModel, this.circuit.getAdminState());
    }

    protected void cleanupLoAditIfOldNe(INetElement iNetElement) {
        if (!iNetElement.getNodeModel().provides(Feature.TCCU)) {
            this.cleanupLoAdit(iNetElement);
        }
    }

    protected void cleanupLoAdit(INetElement iNetElement) {
        block8: {
            if (this.availSpan.getLoNum() == null) {
                return;
            }
            IPoolModel iPoolModel = this.getHoPool(iNetElement);
            if (iPoolModel == null) {
                return;
            }
            ILoAditModel iLoAditModel = this.getLoAdit(iNetElement, iPoolModel);
            if (iLoAditModel == null) {
                return;
            }
            try {
                ICircuitId iCircuitId = iLoAditModel.getCircuitId();
                if (iCircuitId.getUniquePart().getUniqueId() != 0) {
                    return;
                }
                if (this.dbgOn()) {
                    this.debug("Destroying LoAdit on span");
                }
                iLoAditModel.localDestroy();
            }
            catch (Busy busy) {
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block8;
                this.debug("LoAdit already gone!");
            }
        }
    }

    protected void dispose(boolean bl) {
        NetCircuitNode netCircuitNode;
        if (this.dbgOn()) {
            this.debug("SpanImpl:dispose: disposing span " + this.prettyString());
        }
        boolean bl2 = this.circuit.isBidirectional() || this.isUpsr() || this.getNetLinkSpan().getOmni();
        super.destroy();
        if (this.observerActive && this.getLink() != null) {
            this.deleteLinkObserver();
            this.deleteReverseLinkObserver();
        }
        if ((netCircuitNode = (NetCircuitNode)this.getSrcNCN()) == null) {
            if (this.dbgOn()) {
                this.debug("SpanImpl:dispose: Couldn't find src cktnode");
            }
        } else if (this.getSrcState() == 2) {
            netCircuitNode.removeRoutedSpan(this, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
        } else {
            netCircuitNode.disposeActiveSpan(this, bl);
        }
        if ((netCircuitNode = (NetCircuitNode)this.getDstNCN()) == null) {
            if (this.dbgOn()) {
                this.debug("SpanImpl:dispose: Couldn't find dst cktnode");
            }
        } else if (this.getDstState() == 2) {
            netCircuitNode.removeRoutedSpan(this, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
        } else {
            netCircuitNode.disposeActiveSpan(this, bl);
        }
        this.circuit.disposeActiveSpan(this);
        this.disposed = true;
    }

    protected void dispose() {
        super.destroy();
        if (this.observerActive && this.getLink() != null) {
            this.deleteLinkObserver();
            this.deleteReverseLinkObserver();
        }
        this.disposed = true;
    }

    public boolean disposed() {
        return this.disposed;
    }

    @Override
    public int getProtectionType() {
        if (this.driSpan) {
            return 18;
        }
        if (this.isUpsr()) {
            return 13;
        }
        if (this.getLink().isLOTunnel() || this.getLink().isLAP()) {
            return ((NetLink)this.getLink()).getLotCircuit().getProtType();
        }
        return this.getLink().getProtectionType();
    }

    @Override
    public boolean isPca() {
        return this.getLink().isPca();
    }

    @Override
    public boolean isNonRevertivePca() {
        if (this.getLink() instanceof NetLink) {
            return ((NetLink)this.getLink()).isNonRevertivePca();
        }
        return false;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (((Integer)object).equals(ModelUpdateType.DELETED)) {
            if (this.dbgOn()) {
                db.println("span.update: DELETED");
            }
            this.updateEvent.deleted = true;
            NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "deleted");
        } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (this.dbgOn()) {
                db.println("span.update: CHANGED");
            }
            this.updateEvent.changed = true;
            NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "changed");
        }
    }

    protected void runUpdate() {
        if (this.updateEvent.deleted) {
            this.updateEvent.deleted = false;
            if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(" NCSpan: runUpdate deleted");
            }
            if (this.dbgOn()) {
                db.println("span.runUpdate: DELETED");
            }
            this.updateDeleted();
        } else if (this.updateEvent.changed) {
            this.updateEvent.changed = false;
            if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(" NCSpan: runUpdate changed");
            }
            if (this.dbgOn()) {
                db.println("span.runUpdate: CHANGED");
            }
            this.updateChanged();
        }
    }

    protected void updateDeleted() {
        if (this.dbgOn()) {
            this.debug("Disposing the Link");
        }
        this.dispose(false);
        if (this.dbgOn()) {
            this.debug("updateDeleted: check circuit's completeness");
        }
        if (!this.circuit.circuitInfoActive()) {
            if (!this.circuit.tl1CircuitCompleteCheck()) {
                this.circuit.checkAndUpdateCircuit();
            }
        } else if (!this.circuit.completeCheck()) {
            this.circuit.checkAndUpdateCircuit();
        }
    }

    private void updateChanged() {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = this.getLink().getPhysicalType();
        if (n4 != this.linkPhysicalType) {
            if (this.dbgOn()) {
                db.println("span.runUpdate: physicalType changed");
            }
            this.linkPhysicalType = n4;
            bl = true;
        }
        if ((n3 = this.getLink().getProtectionType()) != this.linkProtectionType) {
            if (this.dbgOn()) {
                db.println("span.runUpdate: protectionType changed");
            }
            this.linkProtectionType = n3;
            bl2 = true;
        }
        if ((n2 = this.getLink().state()) != this.linkState) {
            if (this.dbgOn()) {
                db.println("span.runUpdate: link state changed");
            }
            this.linkState = n2;
            bl4 = true;
        }
        if (this.getLink() instanceof NetLink && (n = ((NetLink)this.getLink()).getPcaRevertMode()) != this.linkPcaRevertMode) {
            if (this.dbgOn()) {
                db.println("span.runUpdate: pcaRevertMode changed");
            }
            this.linkPcaRevertMode = n;
            bl3 = true;
        }
        if (bl4) {
            if (this.linkState == 2) {
                this.updateDeleted();
            }
        } else if (bl || bl2) {
            if (bl2) {
                this.circuit.getMarker().markUpsr();
                this.circuit.getMarker().markDri();
            }
            if (!this.getLink().isValidSrcHoNumber(this.getSrcHoNum()) || !this.getLink().isValidDstHoNumber(this.getDstHoNum())) {
                if (this.dbgOn()) {
                    this.debug("Span's HO no longer valid for link.  Forcing re-splice.");
                }
                this.updateDeleted();
            } else {
                this.circuit.setChanged();
            }
        } else if (bl3) {
            this.circuit.setChanged();
        }
    }

    @Override
    public int getDirection() {
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        if (this.getLink() == null) {
            return -1;
        }
        netCircuitNode = (NetCircuitNode)this.getSrcNCN();
        netCircuitNode2 = (NetCircuitNode)this.getDstNCN();
        if (netCircuitNode != null && netCircuitNode2 != null) {
            if (netCircuitNode.getDirection(this) == 1 && netCircuitNode2.getDirection(this) == 1) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int getSpanState(INodeModel iNodeModel) {
        if (!this.circuit.isCircuitRefValid()) {
            return 3;
        }
        if (this.circuit.getState() != 1 && this.circuit.getState() != 5 && this.circuit.getState() != 4 && this.circuit.getState() != 6 && this.circuit.getState() != 8) {
            return 3;
        }
        if (!this.upsrLink) {
            if (this.circuit.isEthernet()) {
                if (this.isForwarding()) {
                    return 0;
                }
                return 1;
            }
            return !this.circuit.isBidirectional() && iNodeModel.equals(this.getLink().getLinkModel().src()) ? 3 : 0;
        }
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.println("can not getUpsrSpanState on null node");
            }
            return 3;
        }
        int n = this.getUpsrSpanState(iNodeModel);
        if (n == 0 && this.circuit.isEthernet()) {
            if (this.isForwarding()) {
                return 0;
            }
            return 1;
        }
        return n;
    }

    @Override
    public int getUpsrSpanState(INodeModel iNodeModel) {
        if (!this.upsrLink) {
            return 0;
        }
        INetElement iNetElement = null;
        NetCircuitNode netCircuitNode = null;
        iNetElement = Network.instance().findNetElem(iNodeModel);
        if (iNetElement != null) {
            if (this.getSrcNCN().getNetElement() == iNetElement) {
                netCircuitNode = (NetCircuitNode)this.getSrcNCN();
            } else if (this.getDstNCN().getNetElement() == iNetElement) {
                netCircuitNode = (NetCircuitNode)this.getDstNCN();
            }
            if (netCircuitNode != null) {
                return this.getUpsrSpanState(netCircuitNode);
            }
        }
        return -1;
    }

    @Override
    public int getUpsrSpanState(INetCircuitNode iNetCircuitNode) {
        if (this.dbgOn()) {
            db.println("getUpsrSpanState called at node " + ((NetCircuitNode)iNetCircuitNode).getName() + " span " + this.availSpan.prettyString());
        }
        int n = ((NetCircuitNode)iNetCircuitNode).getUpsrSpanState(this, -1);
        if (this.dbgOn()) {
            db.println("getUpsrSpanState at node " + ((NetCircuitNode)iNetCircuitNode).getName() + " returning spanState = " + EnumStrings.getString(IUpsrSpanState.class, (int)n));
        }
        return n;
    }

    private String getInvalidOpExceptionString(Exception exception) {
        String string;
        try {
            string = (String)exception.getClass().getField("message").get(exception);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = "";
        }
        catch (SecurityException securityException) {
            string = "";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "";
        }
        catch (IllegalAccessException illegalAccessException) {
            string = "";
        }
        return string;
    }

    protected boolean dbgOn() {
        return (db.on() || NetCircuitManager.pkgDbgOn()) && !NetCircuitManager.pkgDbgSuppressed();
    }

    protected void debug(String string) {
        db.println(string);
    }

    public void setUpsrLink(boolean bl) {
        if (this.dbgOn() && bl) {
            this.debug("setUpsrLink: " + this.upsrLink + " on span " + this.prettyString());
        }
        this.upsrLink = bl;
    }

    public boolean getUpsrLink() {
        return this.upsrLink;
    }

    @Override
    public boolean getOmni() {
        return this.getNetLinkSpan().getOmni();
    }

    public boolean isSecondaryCircuit() {
        return this.getNetLinkSpan().isSecondaryCircuit();
    }

    public void setBlsrDriInterConnect(boolean bl) {
        if (this.dbgOn()) {
            db.println("setBlsrDriInterConnect: " + bl + " on span " + this.prettyString());
        }
        this.blsrDriInterConnect = bl;
    }

    @Override
    public boolean getBlsrDriInterConnect() {
        return this.blsrDriInterConnect;
    }

    protected Connection getPeerConnection(Connection connection) {
        NetCircuitNode netCircuitNode;
        NetCircuitNode netCircuitNode2 = connection.getNode();
        if (netCircuitNode2 != null && (netCircuitNode = netCircuitNode2.spanGetPeer(this)) != null) {
            return netCircuitNode.findConnectionWithOutput(this);
        }
        if (this.dbgOn()) {
            db.println("getPeerConnection: no peer connection for conn " + connection.getName() + " on node " + connection.getNodeName());
        }
        return null;
    }

    @Override
    public boolean isSrcFabricated() {
        return false;
    }

    @Override
    public boolean isDstFabricated() {
        return false;
    }

    public boolean isDriSpan() {
        return this.driSpan;
    }

    public int getSpanState(IFvNodeModel iFvNodeModel) {
        return 3;
    }

    public IFvNetLink getIFvLink() {
        return this.getLink();
    }

    private class UpdateEvent {
        public boolean changed;
        public boolean deleted;

        public UpdateEvent() {
            this.init();
        }

        public void init() {
            this.changed = false;
            this.deleted = false;
        }
    }
}

