/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.SDebug;
import java.util.HashMap;

public class NodeRoutingDirection {
    private static SDebug db = new SDebug("NodeRoutingDirection");
    private NetCircuitNode cktNode;
    private boolean nodeRoutingDirIsForward;
    private boolean lockedConn;
    private NetCircuitEnd ciLockedSourceEndpt;
    private NetCircuitEnd ciLockedDropEndpt;
    private boolean ciLockedSourceNodeDrop;
    private boolean ciLockedDropNodeDrop;
    private NetCircuitSpan lockedSpan;
    private static final int IDLE = 0;
    private static final int STARTED = 1;
    private static final int FINISHED = 2;
    private static final int REALIGNING = 3;
    private static final int REALIGNED = 4;
    private int state;
    private NetCircuitSpan invalidSpan;
    private NetCircuitEnd missingPath;
    private NetCircuitSpan unreversibleSpan;
    private static final eSpanDirection[] onewayFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] twowayFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING};
    private static final eSpanDirection[] upsrUpsrFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrHeadFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrDropFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrDcFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrEnFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] etherStitchFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] monitorFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrDriFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrIdriFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL};
    private static final eSpanDirection[] blsrIdriFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING};
    private static final eSpanDirection[] upsrBlsrIdriFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING};
    private static final eSpanDirection[] blsrDcFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] upsrBlsrDcFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] diagnosticFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] ochncTwowayFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] ochncTwowaySplitterFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, eSpanDirection.ORIGINATING};
    private static final eSpanDirection[] ochTrailProtFwdRoutingDirTbl = new eSpanDirection[]{eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING};

    public NodeRoutingDirection(NetCircuitNode netCircuitNode) {
        this.cktNode = netCircuitNode;
        this.setNodeRoutingDirToForward();
        this.lockedConn = false;
        this.ciLockedSourceEndpt = null;
        this.ciLockedDropEndpt = null;
        this.ciLockedSourceNodeDrop = false;
        this.ciLockedDropNodeDrop = false;
        this.lockedSpan = null;
        this.invalidSpan = null;
        this.unreversibleSpan = null;
        this.state = 0;
        this.missingPath = null;
    }

    public void start() {
        if (this.dbgOn()) {
            this.debug("Starting NodeRoutingDirection at " + this.getNodeName());
        }
        this.lockedConn = this.isUnidirectionalConnType() || this.connectionlessLapLinkNode();
        this.initCircuitInfoLocks();
        this.lockedSpan = null;
        this.invalidSpan = null;
        this.unreversibleSpan = null;
        this.state = 1;
        this.missingPath = null;
    }

    private void startRealignment() {
        if (this.dbgOn()) {
            this.debug("Starting realignment at " + this.getNodeName());
        }
        this.lockedSpan = null;
        this.state = 3;
    }

    private void initCircuitInfoLocks() {
        NetCircuitEnd netCircuitEnd2;
        this.ciLockedSourceEndpt = null;
        this.ciLockedDropEndpt = null;
        this.ciLockedSourceNodeDrop = false;
        this.ciLockedDropNodeDrop = false;
        if (this.lockedConn) {
            return;
        }
        for (NetCircuitEnd netCircuitEnd2 : this.cktNode.getConnectionPathEnds()) {
            if (this.isCircuitInfoSource(netCircuitEnd2)) {
                this.ciLockedSourceEndpt = netCircuitEnd2;
            }
            if (!this.isCircuitInfoDrop(netCircuitEnd2)) continue;
            this.ciLockedDropEndpt = netCircuitEnd2;
        }
        netCircuitEnd2 = NetCircuitEndFactory.createNodeDrop(this.getCircuit().getCircuitType(), this.getNetElement());
        if (this.isCircuitInfoSource(netCircuitEnd2)) {
            this.ciLockedSourceNodeDrop = true;
        }
        if (this.isCircuitInfoDrop(netCircuitEnd2)) {
            this.ciLockedDropNodeDrop = true;
        }
    }

    public void setNodeRoutingDirToCiSource() {
        boolean bl = false;
        if (!this.hasCiLockedSource() || this.hasLockedConn()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("setNodeRoutingDirToCiSource() at " + this.getNodeName());
        }
        if (this.ciLockedSourceEndpt != null) {
            if (!this.checkPathRoutingDir(this.ciLockedSourceEndpt, eSpanDirection.TERMINATING)) {
                bl = true;
            }
        } else if (this.ciLockedSourceNodeDrop) {
            if (this.cktNode.getBiSpans().size() == 1) {
                if (this.getPathRoutingDir(0) != eSpanDirection.ORIGINATING) {
                    bl = true;
                }
            } else if (this.cktNode.getBiSpans().size() == 2 && this.getPathRoutingDir(0) != eSpanDirection.TERMINATING) {
                bl = true;
            }
        }
        if (bl) {
            this.reverseNodeRoutingDir();
        }
    }

    public void setNodeRoutingDirToCiDrop() {
        boolean bl = false;
        if (!this.hasCiLockedDrop() || this.hasLockedConn()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("setNodeRoutingDirToCiDrop() at " + this.getNodeName());
        }
        if (this.ciLockedDropEndpt != null && !this.ciLockedDropNodeDrop && !this.ciLockedSourceNodeDrop) {
            if (!this.checkPathRoutingDir(this.ciLockedDropEndpt, eSpanDirection.ORIGINATING)) {
                bl = true;
            }
        } else if (this.ciLockedDropNodeDrop && this.cktNode.getBiSpans().size() == 1 && this.getPathRoutingDir(0) != eSpanDirection.TERMINATING) {
            bl = true;
        }
        if (bl) {
            this.reverseNodeRoutingDir();
        }
    }

    public void setNodeRoutingDirToLockedSpan() {
        eSpanDirection eSpanDirection2;
        if (!this.hasLockedSpan() || this.hasLockedConn()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("setNodeRoutingDirToLockedSpan() at " + this.getNodeName());
        }
        if (!this.checkPathRoutingDir(this.lockedSpan, eSpanDirection2 = this.cktNode.findRoutingDir(this.lockedSpan))) {
            this.reverseNodeRoutingDir();
        }
    }

    public void lockSpansAtPeerNodes() {
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.cktNode.getConnectionPathEnds()) {
            NetCircuitNode netCircuitNode;
            NetCircuitSpan netCircuitSpan;
            eSpanDirection eSpanDirection2;
            if ((eSpanDirection2 = this.getPathRoutingDir(n++)) == eSpanDirection.BIDIRECTIONAL || (netCircuitSpan = this.cktNode.getSpanFromCktEnd(netCircuitEnd)) == null || (netCircuitNode = this.cktNode.spanGetPeer(netCircuitSpan)) == null) continue;
            netCircuitNode.nodeRoutingDir.addLockedSpan(netCircuitSpan);
        }
    }

    private void addLockedSpan(NetCircuitSpan netCircuitSpan) {
        if (this.finished() || this.realigned() || this.hasLockedConn()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("addLockedSpan() at " + this.getNodeName());
        }
        this.lockedSpan = netCircuitSpan;
    }

    public void reverseRoutingDir() throws IncorrectCircuitState {
        if (this.lockedConn) {
            throw new IncorrectCircuitState("The node's routing direction is unidirectional.");
        }
        if (this.dbgOn()) {
            this.debug("Reversing node routing direction at " + this.getNodeName());
        }
        this.reverseNodeRoutingDir();
        this.setEndpointsToRoutingDir();
        this.setSpansToRoutingDir();
    }

    public void setEndpointsToRoutingDir() {
        eSpanDirection eSpanDirection2;
        int n;
        if (this.lockedConn) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("Setting endpoints to routing direction at " + this.getNodeName());
        }
        for (NetCircuitEnd netCircuitEnd : this.cktNode.getSources()) {
            if (this.isCircuitInfoSource(netCircuitEnd)) continue;
            try {
                n = this.cktNode.getConnectionPathIndex(netCircuitEnd);
            }
            catch (ConnectionPathNotFound connectionPathNotFound) {
                this.setPathNotFoundError(netCircuitEnd);
                continue;
            }
            eSpanDirection2 = this.getPathRoutingDir(n);
            if (eSpanDirection2 != eSpanDirection.ORIGINATING) continue;
            this.cktNode.changeSourceToDrop(netCircuitEnd);
        }
        for (NetCircuitEnd netCircuitEnd : this.cktNode.getDrops()) {
            if (this.isCircuitInfoDrop(netCircuitEnd)) continue;
            try {
                n = this.cktNode.getConnectionPathIndex(netCircuitEnd);
            }
            catch (ConnectionPathNotFound connectionPathNotFound) {
                this.setPathNotFoundError(netCircuitEnd);
                continue;
            }
            eSpanDirection2 = this.getPathRoutingDir(n);
            if (eSpanDirection2 != eSpanDirection.TERMINATING) continue;
            this.cktNode.changeDropToSource(netCircuitEnd);
        }
    }

    public void setSpansToRoutingDir() {
        if (this.lockedConn) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("Setting spans to routing direction at " + this.getNodeName());
        }
        HashMap hashMap = this.cktNode.getSpansRoutingDirMap();
        for (NetCircuitSpan netCircuitSpan : hashMap.keySet()) {
            NetCircuitSpan netCircuitSpan2;
            if (netCircuitSpan.disposed()) {
                if (!this.dbgOn()) continue;
                this.debug("Skipping disposed span: " + netCircuitSpan.prettyString());
                continue;
            }
            eSpanDirection eSpanDirection2 = (eSpanDirection)hashMap.get(netCircuitSpan);
            if (this.checkPathRoutingDir(netCircuitSpan, eSpanDirection2)) continue;
            if (this.dbgOn()) {
                this.debug("Changing span direction");
            }
            if ((netCircuitSpan2 = this.getCircuit().changeNetLinkDir(netCircuitSpan)) != null) continue;
            if (this.dbgOn()) {
                this.debug("ERROR-Unreversible span: " + netCircuitSpan.prettyString());
            }
            this.unreversibleSpan = netCircuitSpan;
        }
    }

    public boolean allSpansAreValid() {
        if (this.connectionlessLapLinkNode()) {
            return true;
        }
        if (this.dbgOn()) {
            this.debug("Validating span routing direction at " + this.getNodeName());
        }
        HashMap hashMap = this.cktNode.getSpansRoutingDirMap();
        for (NetCircuitSpan netCircuitSpan : hashMap.keySet()) {
            if (netCircuitSpan.disposed() || netCircuitSpan.getLink() instanceof VirtualNetLink || netCircuitSpan.getLink() instanceof DwdmNetLink || netCircuitSpan.getLink() instanceof LmpDataLinkNetLink || netCircuitSpan.isInternalSpan()) {
                if (!this.dbgOn()) continue;
                this.debug("Skipping disposed or Internal or VL based span: " + netCircuitSpan.prettyString());
                continue;
            }
            eSpanDirection eSpanDirection2 = (eSpanDirection)hashMap.get(netCircuitSpan);
            if (this.checkPathRoutingDir(netCircuitSpan, eSpanDirection2)) continue;
            if (this.dbgOn()) {
                this.debug("ERROR: Invalid span direction detected");
            }
            this.invalidSpan = netCircuitSpan;
            return false;
        }
        return true;
    }

    private boolean checkPathRoutingDir(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        return this.checkPathRoutingDir(this.cktNode.getSpanEndpoint(netCircuitSpan), eSpanDirection2);
    }

    private boolean checkPathRoutingDir(NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        int n;
        if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
            return true;
        }
        NetCircuitEnd netCircuitEnd2 = netCircuitEnd;
        try {
            n = this.cktNode.getConnectionPathIndex(netCircuitEnd2);
        }
        catch (ConnectionPathNotFound connectionPathNotFound) {
            this.setPathNotFoundError(netCircuitEnd);
            return true;
        }
        eSpanDirection eSpanDirection3 = this.getPathRoutingDir(n);
        return eSpanDirection3 == eSpanDirection2 || eSpanDirection3 == eSpanDirection.BIDIRECTIONAL;
    }

    public boolean hasLockedConn() {
        return this.lockedConn;
    }

    public boolean hasCiLockedSource() {
        return this.ciLockedSourceEndpt != null || this.ciLockedSourceNodeDrop;
    }

    public boolean hasCiLockedDrop() {
        return this.ciLockedDropEndpt != null || this.ciLockedDropNodeDrop && this.cktNode.getBiSpans().size() == 1;
    }

    public boolean hasLockedSpan() {
        return this.lockedSpan != null;
    }

    public boolean hasUnreversibleSpan() {
        return this.unreversibleSpan != null;
    }

    public void finish() {
        this.state = 2;
    }

    private boolean finished() {
        return this.state == 2;
    }

    private void finishRealignment() {
        if (this.dbgOn()) {
            this.debug("Finished realignment at " + this.getNodeName());
        }
        this.state = 4;
    }

    private boolean realigning() {
        return this.state == 3;
    }

    private boolean realigned() {
        return this.state == 4;
    }

    public eSpanDirection getPathSpliceDir(int n) {
        if (this.isUnidirectionalConnType()) {
            return this.getFwdPathRoutingDir(n);
        }
        return eSpanDirection.BIDIRECTIONAL;
    }

    protected eSpanDirection getPathRoutingDir(int n) {
        eSpanDirection eSpanDirection2 = this.getFwdPathRoutingDir(n);
        if (this.nodeRoutingDirIsForward) {
            return eSpanDirection2;
        }
        return NodeRoutingDirection.getOppositeRoutingDir(eSpanDirection2);
    }

    private eSpanDirection getFwdPathRoutingDir(int n) {
        eSpanDirection[] eSpanDirectionArray = this.getFwdRoutingDirTbl();
        int n2 = eSpanDirectionArray.length - 1;
        if (n > n2) {
            n = n2;
        }
        return eSpanDirectionArray[n];
    }

    private eSpanDirection[] getFwdRoutingDirTbl() {
        eSpanDirection[] eSpanDirectionArray;
        int n = this.cktNode.getConnectionType();
        switch (n) {
            case 0: {
                eSpanDirectionArray = onewayFwdRoutingDirTbl;
                break;
            }
            case 1: {
                eSpanDirectionArray = twowayFwdRoutingDirTbl;
                break;
            }
            case 2: {
                eSpanDirectionArray = upsrFwdRoutingDirTbl;
                break;
            }
            case 3: {
                eSpanDirectionArray = upsrUpsrFwdRoutingDirTbl;
                break;
            }
            case 4: {
                eSpanDirectionArray = upsrHeadFwdRoutingDirTbl;
                break;
            }
            case 5: {
                eSpanDirectionArray = upsrDropFwdRoutingDirTbl;
                break;
            }
            case 6: {
                eSpanDirectionArray = upsrDcFwdRoutingDirTbl;
                break;
            }
            case 7: {
                eSpanDirectionArray = upsrEnFwdRoutingDirTbl;
                break;
            }
            case 8: {
                eSpanDirectionArray = etherStitchFwdRoutingDirTbl;
                break;
            }
            case 9: {
                eSpanDirectionArray = monitorFwdRoutingDirTbl;
                break;
            }
            case 10: {
                eSpanDirectionArray = upsrDriFwdRoutingDirTbl;
                break;
            }
            case 11: {
                eSpanDirectionArray = upsrIdriFwdRoutingDirTbl;
                break;
            }
            case 12: {
                eSpanDirectionArray = ochncTwowayFwdRoutingDirTbl;
                break;
            }
            case 13: {
                eSpanDirectionArray = blsrIdriFwdRoutingDirTbl;
                break;
            }
            case 14: {
                eSpanDirectionArray = upsrBlsrIdriFwdRoutingDirTbl;
                break;
            }
            case 15: {
                eSpanDirectionArray = blsrDcFwdRoutingDirTbl;
                break;
            }
            case 16: {
                eSpanDirectionArray = upsrBlsrDcFwdRoutingDirTbl;
                break;
            }
            case 18: {
                eSpanDirectionArray = diagnosticFwdRoutingDirTbl;
                break;
            }
            case 19: {
                eSpanDirectionArray = ochTrailProtFwdRoutingDirTbl;
                break;
            }
            case 20: {
                eSpanDirectionArray = ochncTwowaySplitterFwdRoutingDirTbl;
                break;
            }
            default: {
                if (this.dbgOn()) {
                    this.debug("getFwdRoutingDirTbl: ERROR! Can't find fwdRoutingDirTbl, connType=" + n);
                }
                eSpanDirectionArray = null;
            }
        }
        return eSpanDirectionArray;
    }

    public boolean illegalUpsrDcNode() {
        if (this.cktNode.getConnectionType() != 6) {
            return false;
        }
        int n = 0;
        for (NetCircuitSpan netCircuitSpan : this.cktNode.getBiSpans()) {
            if (this.cktNode.findRoutingDir(netCircuitSpan) != eSpanDirection.ORIGINATING) continue;
            ++n;
        }
        return n == 2;
    }

    public void realignUpsrDcNode() {
        if (!this.illegalUpsrDcNode()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("realignUpsrDcNode(" + this.getNodeName() + ")");
        }
        for (NetCircuitSpan netCircuitSpan : this.cktNode.getBiSpans()) {
            this.realignUpsrDcBiSpan(netCircuitSpan);
        }
    }

    private void realignUpsrDcBiSpan(NetCircuitSpan netCircuitSpan) {
        if (this.dbgOn()) {
            this.debug("realignUpsrDcBiSpan(" + netCircuitSpan.availSpan.prettyString() + ")");
        }
        NetCircuitNode netCircuitNode = this.cktNode;
        NodeRoutingDirection nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan;
        nodeRoutingDirection.startRealignment();
        while (true) {
            if (nodeRoutingDirection.hasLockedSpan()) {
                nodeRoutingDirection.setNodeRoutingDirToLockedSpan();
                nodeRoutingDirection.setEndpointsToRoutingDir();
                nodeRoutingDirection.setSpansToRoutingDir();
            }
            if (netCircuitSpan2 == null) {
                if (this.dbgOn()) {
                    this.debug("realignUpsrDcBiSpan: Reached terminal node at " + netCircuitNode.getName());
                }
                nodeRoutingDirection.finishRealignment();
                break;
            }
            NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan2);
            NodeRoutingDirection nodeRoutingDirection2 = netCircuitNode2.nodeRoutingDir;
            if (nodeRoutingDirection2.realigned() || nodeRoutingDirection2.realigning()) {
                if (!this.dbgOn()) break;
                this.debug("realignUpsrDcBiSpan: Looped back to " + netCircuitNode.getName());
                break;
            }
            netCircuitNode2.setupConnListOnDiscovery();
            Connection connection = netCircuitNode2.findConnectionWithOutput(netCircuitSpan2);
            Connection connection2 = netCircuitNode2.findConnectionWithInput(netCircuitSpan2);
            if (this.dbgOn()) {
                this.debug("currNode = " + netCircuitNode.getName());
                this.debug("peerNode = " + netCircuitNode2.getName());
                this.debug("downConn:");
                if (connection != null) {
                    connection.prettyString(db);
                }
                this.debug("upConn:");
                if (connection2 != null) {
                    connection2.prettyString(db);
                }
            }
            if (connection == null || connection2 == null) {
                if (this.dbgOn()) {
                    this.debug("realignUpsrDcBiSpan: Hit unidirectional connection at " + netCircuitNode2.getName());
                }
                nodeRoutingDirection.finishRealignment();
                break;
            }
            if (netCircuitNode.findRoutingDir(netCircuitSpan2) == eSpanDirection.ORIGINATING) {
                if (this.dbgOn()) {
                    this.debug("realignUpsrDcBiSpan: Reversing biSpan direction");
                }
                if ((netCircuitSpan2 = this.getCircuit().changeNetLinkDir(netCircuitSpan2)) == null) {
                    if (!this.dbgOn()) break;
                    this.debug("realignUpsrDcBiSpan: changeNetLinkDir() failure; aborting...");
                    break;
                }
            }
            nodeRoutingDirection.finishRealignment();
            if (connection instanceof SelectorConnection || connection2 instanceof SelectorConnection) {
                if (!this.dbgOn()) break;
                this.debug("realignUpsrDcBiSpan: Hit selector at " + netCircuitNode2.getName());
                break;
            }
            nodeRoutingDirection2.startRealignment();
            nodeRoutingDirection2.addLockedSpan(netCircuitSpan2);
            netCircuitSpan2 = connection.getInSpans().size() == 1 ? (NetCircuitSpan)connection.getInSpans().get(0) : null;
            netCircuitNode = netCircuitNode2;
            nodeRoutingDirection = nodeRoutingDirection2;
        }
    }

    public static eSpanDirection getOppositeRoutingDir(eSpanDirection eSpanDirection2) {
        if (eSpanDirection2 == eSpanDirection.ORIGINATING) {
            return eSpanDirection.TERMINATING;
        }
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            return eSpanDirection.ORIGINATING;
        }
        return eSpanDirection2;
    }

    public void setNodeRoutingDirToForward() {
        this.nodeRoutingDirIsForward = true;
    }

    private void reverseNodeRoutingDir() {
        boolean bl = this.nodeRoutingDirIsForward = !this.nodeRoutingDirIsForward;
        if (this.dbgOn()) {
            String string = this.nodeRoutingDirIsForward ? "forward" : "backward";
            this.debug("Changed node routing direction at " + this.getNodeName() + " to " + string);
        }
    }

    private boolean isCircuitInfoSource(NetCircuitEnd netCircuitEnd) {
        return this.getCircuit().circuitInfoActive() && this.getCircuit().isSource(netCircuitEnd);
    }

    private boolean isCircuitInfoDrop(NetCircuitEnd netCircuitEnd) {
        return this.getCircuit().circuitInfoActive() && this.getCircuit().isDrop(netCircuitEnd);
    }

    private boolean isUnidirectionalConnType() {
        return this.cktNode.isUnidirectionalConnType() || this.cktNode.getConnectionType() == 12 || this.cktNode.getConnectionType() == 20;
    }

    public boolean connectionlessLapLinkNode() {
        return this.cktNode.getConn() == null;
    }

    private NetCcatCircuit getCircuit() {
        return this.cktNode.circuit;
    }

    private INetElement getNetElement() {
        return this.cktNode.getNetElement();
    }

    private String getNodeName() {
        return this.cktNode.getName();
    }

    private void setPathNotFoundError(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("ERROR: Could not find path " + netCircuitEnd.prettyString());
        }
        this.missingPath = netCircuitEnd;
    }

    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println(" Connection Paths: ");
        if (this.missingPath != null) {
            sDebug.println(" *** MISSING PATH ***:");
            sDebug.println("   " + this.missingPath.prettyString());
        }
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.cktNode.getConnectionPathEnds()) {
            String string;
            if (this.cktNode instanceof DualConnectionCircuitNode) {
                DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)this.cktNode;
                n = dualConnectionCircuitNode.convertConnectionPathIndex(n);
            }
            try {
                string = this.getPathRoutingDir(n).toAbbrev();
            }
            catch (RuntimeException runtimeException) {
                string = "???";
            }
            sDebug.println("   " + n++ + " " + string + " " + netCircuitEnd.prettyString());
        }
        if (this.invalidSpan != null) {
            sDebug.println(" *** INVALID SPAN ***:");
            sDebug.println("   " + this.invalidSpan.availSpan.prettyString());
        }
        if (this.unreversibleSpan != null) {
            sDebug.println(" *** UNREVERSIBLE SPAN ***:");
            sDebug.println("   " + this.unreversibleSpan.availSpan.prettyString());
        }
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

