/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchncPathDefModel;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;

public class OchncCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("OchncCircuitSpan");
    private int optChannel;
    private int srcEntityIndex;
    private int dstEntityIndex;
    private int spanState = 0;

    public OchncCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan, INetCircuitNode iNetCircuitNode, INetCircuitNode iNetCircuitNode2) {
        super(netCcatCircuit, netLinkSpan, iNetCircuitNode, iNetCircuitNode2);
        this.optChannel = netCcatCircuit.getCircuitOptChannel();
        this.srcEntityIndex = netLinkSpan.getLink().getSrcEntityIndex();
        this.dstEntityIndex = netLinkSpan.getLink().getDstEntityIndex();
        if (this.dbgOn()) {
            db.println("OchncCircuitSpan object instantiated");
        }
    }

    protected int getOptChannel() {
        return this.optChannel;
    }

    @Override
    public int getEntityIndex(INetElement iNetElement) {
        if (this.getLink() == null) {
            return -1;
        }
        if (iNetElement == this.getLink().getSrc()) {
            return this.srcEntityIndex;
        }
        return this.dstEntityIndex;
    }

    public int getEntityIndex(NetCircuitNode netCircuitNode) {
        if (netCircuitNode == null) {
            return -1;
        }
        if (netCircuitNode == this.getSrcNCN()) {
            return this.srcEntityIndex;
        }
        if (netCircuitNode == this.getDstNCN()) {
            return this.dstEntityIndex;
        }
        return -1;
    }

    @Override
    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound {
        if (this.dbgOn()) {
            db.println("getPathDef: optChannel " + this.optChannel + " EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)));
        }
        OchncPathDefModel ochncPathDefModel = new OchncPathDefModel(iNetElement.getNodeModel(), this.optChannel, this.getEntityIndex(iNetElement), s);
        return ochncPathDefModel;
    }

    @Override
    public int getSpanState(INodeModel iNodeModel) {
        OchncCircuit ochncCircuit = (OchncCircuit)this.getCircuit();
        if (!ochncCircuit.isSplitterProtectedCircuit()) {
            return super.getSpanState(iNodeModel);
        }
        if (!ochncCircuit.isCircuitRefValid()) {
            return 3;
        }
        if (ochncCircuit.getState() != 1 && ochncCircuit.getState() != 5 && ochncCircuit.getState() != 4 && ochncCircuit.getState() != 6) {
            return 3;
        }
        return this.spanState;
    }

    public void setSpanState(int n) {
        this.spanState = n;
    }

    public OchncCircuitEnd getSrcCircuitEnd() {
        return new OchncCircuitEnd(this.getLink().getSrc(), this.srcEntityIndex, this.optChannel);
    }

    public OchncCircuitEnd getDstCircuitEnd() {
        return new OchncCircuitEnd(this.getLink().getDst(), this.dstEntityIndex, this.optChannel);
    }

    @Override
    protected IPathDefModel getPathDef(NetCircuitNode netCircuitNode, short s) throws ObjNotFound {
        INetElement iNetElement = netCircuitNode.getNetElement();
        if (this.dbgOn()) {
            db.println("getPathDef: optChannel " + this.optChannel + " EntIdx " + Integer.toHexString(this.getEntityIndex(netCircuitNode)));
        }
        OchncPathDefModel ochncPathDefModel = new OchncPathDefModel(iNetElement.getNodeModel(), this.optChannel, this.getEntityIndex(netCircuitNode), s);
        return ochncPathDefModel;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public String prettyString() {
        return super.prettyString() + "(WL=" + Wavelength.getWavelengthStringFromWavelength(this.getOptChannel()) + ")";
    }

    public String toString() {
        return this.prettyString();
    }

    @Override
    public int getSpanState(IFvNodeModel iFvNodeModel) {
        return this.getSpanState(iFvNodeModel);
    }
}

