/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.Feature;
import cerent.cms.ncp.ConnectionValidator;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SrgViolation;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.PortSrg;
import cerent.cms.route.SlotSrg;
import cerent.cms.route.Spt;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.util.TDMTerminology;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class RouteValidator {
    protected static RouteValidator validator;

    public static synchronized RouteValidator instance() {
        if (validator == null) {
            validator = new RouteValidator();
        }
        return validator;
    }

    public void validateRoute(NetCcatCircuit netCcatCircuit) throws SanityCheckFailed {
        Object object2;
        boolean bl = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object2 : netCcatCircuit.getCircuitSpans()) {
            linkedList.add(object2);
            if (!((NetCircuitSpan)object2).getOmni()) continue;
            bl = true;
        }
        object2 = netCcatCircuit.getMemberPrefs();
        if (object2 != null) {
            if (((MemberPrefs)object2).getDriNodePrefs().size() != 0) {
                bl = true;
            }
            if (((MemberPrefs)object2).getPathProtection() == 5 && !bl) {
                List list = netCcatCircuit.getCircuitNodeFromNE(netCcatCircuit.getDropNE());
                INetCircuitNode iNetCircuitNode = null;
                if (list != null) {
                    iNetCircuitNode = (INetCircuitNode)list.get(0);
                }
                TDMTerminology tDMTerminology = iNetCircuitNode.getNodeModel().getTDMTerminology();
                String string = tDMTerminology.getRingTerms(1);
                throw new SanityCheckFailed("The DRI checkbox is selected but the path is not DRI protected.\n\nIf you are creating a " + string + "-DRI, please also ensure:\n- Primary and secondary nodes are specified.\n- A secondary path is specified.");
            }
        }
        List list = new LinkedList();
        if (netCcatCircuit.getCktOperation() != 5) {
            list = netCcatCircuit.getCircuitNodes();
        }
        this.validateRoute(netCcatCircuit, linkedList, list, (MemberPrefs)object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateRoute(NetCcatCircuit netCcatCircuit, List list, List list2, MemberPrefs memberPrefs) throws SanityCheckFailed {
        Object object;
        Object object22;
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        for (Object object22 : list2) {
            if (!ConnectionValidator.instance().validateConn((NetCircuitNode)object22)) {
                throw new SanityCheckFailed("Invalid span combination at Node " + ((NetCircuitNode)object22).getName());
            }
            linkedList.add(((NetCircuitNode)object22).getNetElement());
        }
        object22 = new LinkedList();
        LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
        LinkedList<INetCircuitSpan> linkedList3 = new LinkedList<INetCircuitSpan>();
        LinkedList<INetLink> linkedList4 = new LinkedList<INetLink>();
        for (INetCircuitSpan iNetCircuitSpan : list) {
            object = iNetCircuitSpan.getLink();
            if (!object.canSupportCircuitDirection(netCcatCircuit.getCircuitDir())) {
                throw new SanityCheckFailed("Circuit Path does not support given directionality (uni/bi)");
            }
            if (iNetCircuitSpan.getSrcState() == 2) {
                linkedList2.add((INetLink)object);
                linkedList3.add(iNetCircuitSpan);
            } else {
                linkedList4.add((INetLink)object);
            }
            if (iNetCircuitSpan.getNetLinkSpan().getOmni() || iNetCircuitSpan.getBlsrDriInterConnect()) continue;
            ((LinkedList)object22).add(object);
        }
        boolean bl = netCcatCircuit.isOverlayRing();
        if (Spt.anyLoops(netCcatCircuit.srcCircuitNode.getNetElement(), (LinkedList)object22)) {
            if (!netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
                if (!bl) {
                    if (netCcatCircuit.getPrimarySource().getNetElement() != netCcatCircuit.getPrimaryDrop().getNetElement()) throw new SanityCheckFailed("Loop detected in selected route");
                    if (Spt.anyInvalidRings(netCcatCircuit.srcCircuitNode.getNetElement(), linkedList, (LinkedList)object22)) {
                        throw new SanityCheckFailed("Loop detected in selected route");
                    }
                }
            } else {
                if (Spt.anyInvalidRings(netCcatCircuit.srcCircuitNode.getNetElement(), linkedList, (LinkedList)object22)) {
                    throw new SanityCheckFailed("Loop detected in selected route");
                }
                this.checkLinkDiversity((LinkedList)object22);
            }
        }
        if (netCcatCircuit.getCktOperation() != 5 && linkedList2.size() != 0 && linkedList4.size() != 0 && !bl) {
            for (INetLink iNetLink : linkedList2) {
                for (INetLink iNetLink2 : linkedList4) {
                    if (iNetLink.getDst() == iNetLink2.getDst()) {
                        throw new SanityCheckFailed("An existing link and a newly chosen link terminate on node " + iNetLink.getDst().getName());
                    }
                    if ((iNetLink2.isLOTunnel() && !iNetLink.isLOTunnel() || iNetLink2.isLAP() && !iNetLink.isLAP()) && iNetLink2.getLinksList().contains(iNetLink)) {
                        throw new SanityCheckFailed("An existing link and a newly chosen link terminate on node " + iNetLink.getDst().getName());
                    }
                    if ((!iNetLink.isLOTunnel() || iNetLink2.isLOTunnel()) && (!iNetLink.isLAP() || iNetLink2.isLAP()) || !iNetLink.getLinksList().contains(iNetLink2)) continue;
                    throw new SanityCheckFailed("An existing link and a newly chosen link terminate on node " + iNetLink2.getDst().getName());
                }
            }
        }
        if (memberPrefs != null && (memberPrefs.getPathProtection() == 0 || memberPrefs.getPathProtection() == 5)) {
            if (memberPrefs.getDiversityOption() == 1) {
                this.checkNodalDiversity(list2);
            }
            if (netCcatCircuit.getCktOperation() == 5) {
                object = new LinkedList<INetLink>(linkedList4);
                ((LinkedList)object).addAll(linkedList2);
                this.checkLinkDiversity((LinkedList)object);
            } else {
                this.checkLinkDiversity(linkedList2);
            }
        }
        if (netCcatCircuit.getCktOperation() == 5 || netCcatCircuit.isMonitorCircuit()) return;
        this.sanityCheckBLSRTimeSlots(list2);
    }

    private void sanityCheckBLSRTimeSlots(List list) throws SanityCheckFailed {
        ConnectionValidator connectionValidator = ConnectionValidator.instance();
        for (NetCircuitNode netCircuitNode : list) {
            if (connectionValidator.validateBLSRTimeSlots(netCircuitNode)) continue;
            throw new SanityCheckFailed("Invalid " + NetCircuitNode.getTDMTerminology(netCircuitNode.getNodeModel()).getRingTerms(1) + " same time slot requirement on node " + netCircuitNode.getName());
        }
    }

    private void checkNodalDiversity(List list) throws SanityCheckFailed {
        for (NetCircuitNode netCircuitNode : list) {
            if (!netCircuitNode.getSources().isEmpty() || netCircuitNode.countNumInputs() < 2 || netCircuitNode.countRoutedOrigSpans() < 2 || netCircuitNode.driNodeType == 1) continue;
            throw new SanityCheckFailed("Nodal Diverse Path Requirement is not met. The node in question is : " + netCircuitNode.getNetElement().getName());
        }
    }

    private void checkLinkDiversity(LinkedList linkedList) throws SanityCheckFailed {
        HashSet<PortSrg> hashSet = new HashSet<PortSrg>();
        while (linkedList.size() != 0) {
            Object object2;
            INetLink iNetLink = (INetLink)linkedList.removeFirst();
            for (Object object2 : iNetLink.getLinksList()) {
                hashSet.add(new PortSrg(object2.getSrc(), object2.getSrcEntityIndex(), object2.getSrcShelfNumber(), object2.getSrcSlotNumber(), object2.getSrcPortNumber()));
                hashSet.add(new PortSrg(object2.getDst(), object2.getDstEntityIndex(), object2.getDstShelfNumber(), object2.getDstSlotNumber(), object2.getDstPortNumber()));
            }
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                INetLink iNetLink2 = (INetLink)object2.next();
                try {
                    iNetLink2.containsSrg(hashSet);
                }
                catch (xLinkNotUsable xLinkNotUsable2) {
                    throw new SanityCheckFailed("Slot Diverse Path Requirement is not met.\nThe Link is: " + iNetLink2.prettyString());
                }
            }
        }
    }

    public LinkedList getSrgFailureList(List list) {
        INetLink iNetLink;
        Object object2;
        LinkedList<Object> linkedList = new LinkedList();
        HashMap<INetLink, SrgViolation> hashMap = new HashMap<INetLink, SrgViolation>();
        LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
        for (Object object2 : list) {
            iNetLink = object2.getLink();
            if (object2.getSrcState() != 2 && (object2.getSrcState() != 4 || object2.getCircuit().getState() == 3)) continue;
            linkedList2.add(iNetLink);
            if (!object2.getOmni() || object2.getSrcState() != 2 || object2.getDstState() != 2) continue;
            linkedList2.add(iNetLink.getReverseLink());
        }
        object2 = new HashSet();
        while (linkedList2.size() != 0) {
            iNetLink = (INetLink)linkedList2.removeFirst();
            if (iNetLink instanceof OchTrailTunnelNetLink) {
                object2.add(new SlotSrg(iNetLink.getSrc(), iNetLink.getSrcShelfNumber(), iNetLink.getSrcSlotNumber(), true));
                object2.add(new SlotSrg(iNetLink.getDst(), iNetLink.getDstShelfNumber(), iNetLink.getDstSlotNumber(), false));
            } else {
                for (INetLink iNetLink2 : iNetLink.getLinksList()) {
                    if (!iNetLink2.getSrc().getNodeModel().provides(Feature.UPSR_SLOTDIV_NR)) {
                        object2.add(new SlotSrg(iNetLink2.getSrc(), iNetLink2.getSrcShelfNumber(), iNetLink2.getSrcSlotNumber(), true));
                    }
                    if (iNetLink2.getDst().getNodeModel().provides(Feature.UPSR_SLOTDIV_NR)) continue;
                    object2.add(new SlotSrg(iNetLink2.getDst(), iNetLink2.getDstShelfNumber(), iNetLink2.getDstSlotNumber(), false));
                }
            }
            for (INetLink iNetLink2 : linkedList2) {
                try {
                    iNetLink2.containsSrg((Collection)object2);
                }
                catch (xLinkNotUsable xLinkNotUsable2) {
                    SrgViolation srgViolation = new SrgViolation("The Slot Diverse Path Requirement is not met at one or both ends of the following span(s).", iNetLink2);
                    hashMap.put(iNetLink2, srgViolation);
                }
            }
        }
        linkedList = new LinkedList(hashMap.values());
        return linkedList;
    }
}

