/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.Connection;
import cerent.cms.ncp.InternalCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SelectorConnection
extends Connection {
    private static final SDebug db = new SDebug("SelectorConnection");
    private Connection head;
    protected LinkedList handoffs = new LinkedList();
    protected boolean isProtected = true;

    public SelectorConnection(String string) {
        super(string);
    }

    @Override
    public boolean isSelector() {
        return true;
    }

    @Override
    protected boolean isFedByDriHandoffs() {
        NetCircuitNode netCircuitNode;
        if (this.head != null && (netCircuitNode = this.head.getNode()) != null && netCircuitNode.getDri()) {
            return true;
        }
        if (this.head == null && this.handoffs.size() == 2) {
            netCircuitNode = ((Connection)this.handoffs.get(0)).getNode();
            NetCircuitNode netCircuitNode2 = ((Connection)this.handoffs.get(1)).getNode();
            return netCircuitNode.getDri() && netCircuitNode2.getDri();
        }
        return false;
    }

    protected void addHandoff(Connection connection) {
        if (this.handoffs.size() > 1) {
            db.println("addHandoff: Error attempting to add handoff with " + this.handoffs.size() + " existing handoffs");
            return;
        }
        if (!this.handoffs.contains(connection)) {
            this.handoffs.add(connection);
        }
    }

    @Override
    public Connection getSelectorHead() {
        return this.head;
    }

    protected void setUpsrHead(Connection connection) {
        this.head = connection;
    }

    @Override
    public boolean addInput(Object object) {
        if (this.inPuts.size() >= 2) {
            if (this.dbgOn()) {
                db.println("addInput: ERROR! two inputs already present");
            }
            return false;
        }
        if (!this.checkEndPoint(object)) {
            return false;
        }
        this.inPuts.add(object);
        return true;
    }

    @Override
    protected boolean isFedBy(Connection connection) {
        Iterator iterator = this.getInSpans().iterator();
        while (iterator.hasNext()) {
            if (!this.isFedBy(connection, this, (NetCircuitSpan)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private Connection findUpsrHead(List list) {
        if (list.size() < 2) {
            return null;
        }
        for (Connection connection : (List)list.get(0)) {
            for (Connection connection2 : (List)list.get(1)) {
                if (!connection.equals(connection2)) continue;
                return connection;
            }
        }
        return null;
    }

    protected Connection findUpsrHead() {
        ArrayList<List> arrayList = new ArrayList<List>();
        Iterator iterator = this.getInSpans().iterator();
        this.setUpsrHead(null);
        this.handoffs.clear();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.dbgOn()) {
                db.println("findUpsrHead: starting on " + this.getName() + " connection on node " + this.getNodeName() + " inSpan " + netCircuitSpan.prettyString());
            }
            arrayList.add(this.collectSelectorHeadCandidates(new ArrayList(), netCircuitSpan));
        }
        this.setUpsrHead(this.findUpsrHead(arrayList));
        if (this.dbgOn()) {
            db.println("findUpsrHead: " + (this.getSelectorHead() == null ? "no head found" : " found head " + this.getSelectorHead().getName() + " connection on node " + this.getSelectorHead().getNodeName()) + " for " + this.getName() + " connection on " + this.getNodeName());
        }
        return this.getSelectorHead();
    }

    protected int markBlsrDriHandoffs() {
        int n = 0;
        for (NetCircuitSpan netCircuitSpan : this.getInSpans()) {
            if (this.dbgOn()) {
                db.println("markBlsrDriHandoffs: starting on " + this.getName() + " connection on node " + this.getNodeName() + " span " + netCircuitSpan.prettyString());
            }
            n += this.markBlsrDriHandoffs(this, this.getSelectorHead(), netCircuitSpan);
        }
        return n;
    }

    @Override
    protected boolean isBlsrDriSelector() {
        boolean bl = false;
        Iterator iterator = this.getInSpans().iterator();
        Iterator iterator2 = this.outPuts.iterator();
        block0: while (iterator2.hasNext() && !bl) {
            NetCircuitSpan netCircuitSpan;
            Object e = iterator2.next();
            NetCircuitSpan netCircuitSpan2 = netCircuitSpan = e instanceof NetCircuitSpan ? (NetCircuitSpan)e : null;
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan3 = (NetCircuitSpan)iterator.next();
                if (this.dbgOn()) {
                    db.println("isBlsrDriSelector: starting on " + this.getName() + " on node " + this.getNodeName() + this.printStartingSpan(netCircuitSpan3));
                }
                if (!this.isBlsrDriPath(this, netCircuitSpan3)) continue;
                bl = true;
                continue block0;
            }
        }
        if (this.dbgOn()) {
            db.println("isBlsrDriSelector: " + bl + " for " + this.getName() + " connection on node " + this.getNodeName());
        }
        return bl;
    }

    @Override
    protected boolean isValidBlsrDriSelector() {
        NetCircuitSpan netCircuitSpan;
        int n = 0;
        int n2 = 0;
        NetCircuitNode netCircuitNode = this.getNode();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        if (netCircuitNode == null || !this.isBlsrDriSelector() || this.outPuts.size() == 0) {
            return false;
        }
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan = this.outPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)this.outPuts.get(0) : null;
        if (this.isBlsrUpsrDri()) {
            ++n2;
        }
        Iterator iterator = this.inPuts.iterator();
        while (iterator.hasNext() && n >= 0) {
            String string;
            Object e = iterator.next();
            NetCircuitSpan netCircuitSpan3 = e instanceof NetCircuitSpan ? (NetCircuitSpan)e : null;
            NetCircuitSpan netCircuitSpan4 = this.getExternalInSpan(netCircuitSpan3);
            stringBuffer.replace(0, stringBuffer.length(), this.getBlsrDriSecondaryPathInitState(netCircuitSpan4));
            boolean bl = netCircuitSpan4 != null && netCircuitSpan4.getLink().inBLSR() && netCircuitSpan != null && netCircuitSpan.getLink().inBLSR();
            String string2 = string = bl ? netCircuitSpan.getLink().blsrRingName(netCircuitNode.getNetElement()) : "";
            if (this.dbgOn()) {
                db.println("isValidBlsrDriHandoff: starting on " + this.getName() + " connection on node " + netCircuitNode.getName() + " secondaryPathState " + stringBuffer + (string.length() > 0 ? " with output for BLSR " + string : "") + this.printStartingSpan(netCircuitSpan3));
            }
            if ((n = this.validDriHandoffPairCount(this, this.getSelectorHead(), netCircuitSpan3, new StringBuffer(string), stringBuffer, arrayList2, arrayList, 0)) <= 0) continue;
            n2 += n;
        }
        if (this.dbgOn()) {
            String string = n == -1 ? "an invalid DRI handoff pair" : n2 + " valid DRI handoff " + (n2 == 1 ? "pair" : "pairs");
            db.println("isValidBlsrDriHandoff: Found " + string + " feeding the " + this.getName() + " connection on node " + netCircuitNode.getName() + (netCircuitSpan != null ? " with output span " + netCircuitSpan.prettyString() : ""));
        }
        boolean bl = n2 == 2 && n != -1 && !this.hasBothInputsOnSecondaryPath();
        netCircuitNode.circuit.driConfigurationError = !bl;
        return bl;
    }

    private boolean isBlsrUpsrDri() {
        boolean bl;
        Connection connection = this.getSelectorHead();
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null || connection == null) {
            return false;
        }
        NetCircuitNode netCircuitNode2 = connection.getNode();
        if (netCircuitNode2 == null) {
            return false;
        }
        int n = netCircuitNode.getDriNodeType();
        int n2 = netCircuitNode2.getDriNodeType();
        boolean bl2 = bl = !NetCircuitNodeUtil.isBlsrDriHandoff(n) && NetCircuitNodeUtil.isBlsrDriHandoff(n2) || NetCircuitNodeUtil.isBlsrDriHandoff(n) && !NetCircuitNodeUtil.isBlsrDriHandoff(n2) || connection.isUpsrHead3Profile();
        if (bl && this.dbgOn()) {
            db.println("isBlsrUpsrDri: BLSR to UPSR DRI profile detected for the " + this.getName() + " connection on node " + netCircuitNode.getName());
        }
        return bl;
    }

    private String getBlsrDriSecondaryPathInitState(NetCircuitSpan netCircuitSpan) {
        boolean bl;
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null) {
            return "";
        }
        boolean bl2 = netCircuitSpan != null && netCircuitSpan.getLink().isPca(netCircuitNode.getNetElement());
        boolean bl3 = netCircuitSpan != null && netCircuitSpan.getNetLinkSpan().isSecondaryCircuit();
        boolean bl4 = bl = netCircuitSpan != null && netCircuitSpan.getLink().inBLSR();
        if (bl2 || bl3) {
            return "true";
        }
        if (this.hasPcaInput() || this.hasSecondaryInput()) {
            return "defined";
        }
        if (bl) {
            return "protected";
        }
        return "unprotected";
    }

    private boolean hasPcaInput() {
        Iterator iterator = this.getInSpans().iterator();
        NetCircuitNode netCircuitNode = this.getNode();
        while (netCircuitNode != null && iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = this.getExternalInSpan((NetCircuitSpan)iterator.next());
            if (netCircuitSpan == null || netCircuitSpan.getLink() == null || !netCircuitSpan.getLink().isPca(netCircuitNode.getNetElement())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSecondaryInput() {
        Iterator iterator = this.getInSpans().iterator();
        NetCircuitNode netCircuitNode = this.getNode();
        while (netCircuitNode != null && iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = this.getExternalInSpan((NetCircuitSpan)iterator.next());
            if (netCircuitSpan == null || netCircuitSpan.getNetLinkSpan() == null || !netCircuitSpan.getNetLinkSpan().isSecondaryCircuit()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasBothInputsOnSecondaryPath() {
        ArrayList<NetCircuitSpan> arrayList;
        if (this.isBlsrUpsrDri()) {
            return false;
        }
        int n = 0;
        Iterator iterator = this.inPuts.iterator();
        ArrayList<NetCircuitSpan> arrayList2 = arrayList = this.dbgOn() ? new ArrayList<NetCircuitSpan>(this.outPuts.size()) : null;
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan;
            Object e = iterator.next();
            if (!(e instanceof NetCircuitSpan) || (netCircuitSpan = this.getExternalInSpan((NetCircuitSpan)e)) == null || netCircuitSpan.getNetLinkSpan() == null || !netCircuitSpan.getNetLinkSpan().isSecondaryCircuit()) continue;
            if (this.dbgOn()) {
                arrayList.add(netCircuitSpan);
            }
            ++n;
        }
        if (this.dbgOn() && n > 1) {
            db.println("hasBothInputsOnSecondaryPath: Warning - " + this.getName() + " has " + n + " secondary path input spans on " + this.getNodeName() + ":");
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                db.println("hasBothInputsOnSecondaryPath: " + ((NetCircuitSpan)iterator.next()).getNetLinkSpan().prettyString());
            }
        }
        return n > 1;
    }

    @Override
    protected boolean hasValidUpsrDriHandoffInterconnect(Connection connection) {
        for (Object e : this.inPuts) {
            NetCircuitSpan netCircuitSpan;
            NetCircuitSpan netCircuitSpan2 = netCircuitSpan = e instanceof NetCircuitSpan ? (NetCircuitSpan)e : null;
            if (this.dbgOn()) {
                db.println("hasValidUpsrDriHandoffInterconnect: starting on the " + this.getName() + " connection on node " + this.getNodeName() + " span " + this.printStartingSpan(netCircuitSpan));
                db.println("hasValidUpsrDriHandoffInterconnect: looking for the " + connection.getName() + " connection on node " + connection.getNodeName());
            }
            if (!this.selectorPathHasInterconnectToDriPeer(this, netCircuitSpan, connection)) continue;
            return true;
        }
        return false;
    }

    private String printStartingSpan(NetCircuitSpan netCircuitSpan) {
        NetCircuitSpan netCircuitSpan2 = this.getExternalInSpan(netCircuitSpan);
        return " inSpan " + (netCircuitSpan == null ? "null" : (netCircuitSpan2 == null || this.getSelectorHead() != null && netCircuitSpan.isInternalSpan() && this.getSelectorHead().equals(((InternalCircuitSpan)netCircuitSpan).getSrcConn()) ? netCircuitSpan.prettyString() : netCircuitSpan2.prettyString()));
    }

    @Override
    protected void prettyString(SDebug sDebug) {
        if (!sDebug.on() && !NetCircuitManager.pkgDbgOn()) {
            return;
        }
        super.prettyString(sDebug);
        sDebug.println("      head: " + (this.getSelectorHead() == null ? "undefined" : this.getSelectorHead().getName() + " connection on node " + this.getSelectorHead().getNodeName()));
        for (Connection connection : this.handoffs) {
            sDebug.println("   handoff: " + connection.getName() + " connection on node " + connection.getNodeName());
        }
    }
}

