/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILocalCirData;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2ChannelGroupModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitCreatStage;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuitNode;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SvlanCircuit
extends NetCcatCircuit {
    private static final SDebug db = new SDebug("SvlanCircuit");
    private short svlan = 0;
    private boolean isProtected = false;
    private LinkedList<NetlinkBandwidthWrapper> orderedLinkList = null;

    protected SvlanCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
        this.svlan = circuitCreatInfo.svlan();
        this.isProtected = circuitCreatInfo.isProtected();
    }

    protected SvlanCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.svlan = circuitCreatInfo.svlan();
        this.isProtected = this.isSvlanProtected();
        this.clearChanged();
    }

    @Override
    protected synchronized void addCircuitSpan(INetLinkSpan iNetLinkSpan, RoutePrefs routePrefs) throws NoRoute {
        NetCircuitSpan netCircuitSpan;
        Object object;
        NetCircuitNode netCircuitNode;
        int n;
        if (this.dbgOn()) {
            this.debug("SVLAN addCircuitSpan - checking for MCN link " + iNetLinkSpan.getLink().prettyString() + " Dst link endpoint " + Integer.toHexString(iNetLinkSpan.getLink().getDstEntityIndex()));
        }
        INetElement iNetElement = iNetLinkSpan.getSrc();
        INetElement iNetElement2 = iNetLinkSpan.getDst();
        int n2 = iNetLinkSpan.getLink().getSrcEntityIndex();
        int n3 = iNetLinkSpan.getLink().getDstEntityIndex();
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = SvlanCircuitHelper.getGZOtherTrunkPort(iNetElement, n2);
        int n7 = SvlanCircuitHelper.getGZOtherTrunkPort(iNetElement2, n3);
        n4 = SvlanCircuitHelper.getGZConnectedTrunk(iNetElement, n6);
        n5 = SvlanCircuitHelper.getGZConnectedTrunk(iNetElement2, n7);
        if (iNetElement == routePrefs.getSrc()) {
            n = routePrefs.getcktSrcEntityIndex();
            if (SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement, n, n2, false)) {
                if (this.dbgOn()) {
                    this.debug("No need for MCN, ckt SRC(" + iNetElement.getName() + ") endpoint is on the same card of the out span.");
                }
            } else {
                bl = true;
                if (this.dbgOn()) {
                    this.debug("MCN on ckt SRC(" + iNetElement.getName() + ") node");
                }
            }
        } else {
            List list = this.getCircuitNodeFromNE(iNetElement);
            if (list.size() == 1) {
                netCircuitNode = (NetCircuitNode)list.get(0);
                object = netCircuitNode.getAllSpansList();
                NetCircuitSpan netCircuitSpan2 = null;
                if (object.size() > 0) {
                    netCircuitSpan2 = (NetCircuitSpan)object.get(0);
                    int n8 = 0;
                    n8 = netCircuitSpan2.getLink().getDst() == iNetElement ? netCircuitSpan2.getLink().getDstEntityIndex() : netCircuitSpan2.getLink().getSrcEntityIndex();
                    if (SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement, n8, n2, false)) {
                        if (this.dbgOn()) {
                            this.debug("No need for MCN, node(" + iNetElement.getName() + ") in and out spans on the same card.");
                        }
                    } else {
                        bl = true;
                        if (this.dbgOn()) {
                            this.debug("MCN on node(" + iNetElement.getName() + ")");
                        }
                    }
                }
            }
        }
        if (iNetElement2 == routePrefs.getDst()) {
            n = routePrefs.getcktDstEntityIndex();
            if (SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement2, n, n3, false)) {
                if (this.dbgOn()) {
                    this.debug("No need for MCN, ckt DST(" + iNetElement2.getName() + ") endpoint is on the same card of the in span.");
                }
            } else {
                bl2 = true;
                if (this.dbgOn()) {
                    this.debug("MCN on ckt DST(" + iNetElement2.getName() + ") node");
                }
            }
        }
        if (bl) {
            List list = this.getCircuitNodeFromNE(iNetElement);
            netCircuitNode = null;
            object = null;
            if (list != null) {
                if (list.size() == 1) {
                    if (this.dbgOn()) {
                        this.debug("1 SVLAN xconn already created on src(" + iNetElement.getName() + ") span node");
                    }
                    netCircuitNode = (NetCircuitNode)list.get(0);
                    if (this.dbgOn()) {
                        this.debug("Creating the missed SVLAN xconn on src(" + iNetElement.getName() + ") span node");
                    }
                    object = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
                    this.insertCktNode((NetCircuitNode)object);
                    int n9 = 0;
                    if (iNetElement == routePrefs.getSrc()) {
                        n9 = routePrefs.getcktSrcEntityIndex();
                        if (this.dbgOn()) {
                            this.debug("Existing connection end point on " + iNetElement.getName() + " is src ckt endpoint " + Integer.toHexString(routePrefs.getcktSrcEntityIndex()));
                        }
                    } else {
                        LinkedList linkedList = netCircuitNode.getBiSpans();
                        if (linkedList != null && linkedList.size() > 0) {
                            netCircuitSpan = (NetCircuitSpan)linkedList.get(0);
                            n9 = netCircuitSpan.getLink().getDstEntityIndex();
                            if (this.dbgOn()) {
                                this.debug("Existing connection end point on " + iNetElement.getName() + " is dst entity idx of current link " + Integer.toHexString(n9));
                            }
                        } else if (this.dbgOn()) {
                            this.debug("WARNING!!! The connection already present in the node has no span.");
                        }
                    }
                    if (SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement, n9, n6, false)) {
                        ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n6);
                        ((SvlanCircuitNode)object).setInternalEntityIdx(n4);
                    } else {
                        ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n4);
                        ((SvlanCircuitNode)object).setInternalEntityIdx(n6);
                    }
                } else if (list.size() == 2) {
                    if (this.dbgOn()) {
                        this.debug("2 SVLAN xconns already present on src(" + iNetElement.getName() + ") span node");
                        this.debug("internal ent idxs: " + Integer.toHexString(((SvlanCircuitNode)list.get(0)).getInternalEntityIdx()) + " & " + Integer.toHexString(((SvlanCircuitNode)list.get(1)).getInternalEntityIdx()));
                    }
                } else if (this.dbgOn()) {
                    this.debug("ERROR! more than 2 SVLAN xconns on src(" + iNetElement.getName() + ") span node");
                }
            } else {
                if (this.dbgOn()) {
                    this.debug("Creating 2 SVLAN xconns on src(" + iNetElement.getName() + ") span node");
                }
                netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
                ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n6);
                this.insertCktNode(netCircuitNode);
                object = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
                ((SvlanCircuitNode)object).setInternalEntityIdx(n4);
                this.insertCktNode((NetCircuitNode)object);
            }
            if (netCircuitNode != null && object != null) {
                InternalNetLink internalNetLink = new InternalNetLink(iNetElement, iNetElement, n4, n6, null, null);
                NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, netCircuitNode, (INetCircuitNode)object);
                if (this.dbgOn()) {
                    this.debug("Created the internal splicing span: " + Integer.toHexString(n6) + "->" + Integer.toHexString(n4));
                }
                netCircuitSpan.setSrcState(2);
                netCircuitSpan.setDstState(2);
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                ((NetCircuitNode)object).addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                this.insertCktSpan(netCircuitSpan);
            }
        }
        if (bl2) {
            List list = this.getCircuitNodeFromNE(iNetElement2);
            netCircuitNode = null;
            object = null;
            if (list != null) {
                if (list.size() == 1) {
                    if (this.dbgOn()) {
                        this.debug("1 SVLAN xconn already created on dst(" + iNetElement2.getName() + ") span node");
                    }
                    netCircuitNode = (NetCircuitNode)list.get(0);
                    if (this.dbgOn()) {
                        this.debug("Creating the missed SVLAN xconn on dst(" + iNetElement2.getName() + ") span node");
                    }
                    object = NetCircuitNodeFactory.createCircuitNode(iNetElement2, this);
                    this.insertCktNode((NetCircuitNode)object);
                    int n10 = 0;
                    if (iNetElement2 == routePrefs.getDst()) {
                        n10 = routePrefs.getcktDstEntityIndex();
                        if (this.dbgOn()) {
                            this.debug("Existing connection end point " + iNetElement2.getName() + " is dst ckt endpoint " + Integer.toHexString(routePrefs.getcktDstEntityIndex()) + " analyzing span " + iNetLinkSpan.getLink().prettyString());
                        }
                    } else if (this.dbgOn()) {
                        this.debug("WARNING!!! Destination node must be the Ckt destination too.");
                    }
                    if (SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement2, n10, n7, false)) {
                        ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n7);
                        ((SvlanCircuitNode)object).setInternalEntityIdx(n5);
                    } else {
                        ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n5);
                        ((SvlanCircuitNode)object).setInternalEntityIdx(n7);
                    }
                } else if (list.size() == 2) {
                    if (this.dbgOn()) {
                        this.debug("2 SVLAN xconns already present on dst(" + iNetElement2.getName() + ") span node");
                        this.debug("internal ent idxs: " + Integer.toHexString(((SvlanCircuitNode)list.get(0)).getInternalEntityIdx()) + " & " + Integer.toHexString(((SvlanCircuitNode)list.get(1)).getInternalEntityIdx()));
                    }
                } else if (this.dbgOn()) {
                    this.debug("ERROR! more than 2 SVLAN xconns on dst(" + iNetElement2.getName() + ") span node");
                }
            } else {
                if (this.dbgOn()) {
                    this.debug("Creating 2 SVLAN xconns on dst(" + iNetElement2.getName() + ") span node");
                }
                netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement2, this);
                ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n7);
                this.insertCktNode(netCircuitNode);
                object = NetCircuitNodeFactory.createCircuitNode(iNetElement2, this);
                ((SvlanCircuitNode)object).setInternalEntityIdx(n5);
                this.insertCktNode((NetCircuitNode)object);
            }
            if (netCircuitNode != null && object != null) {
                InternalNetLink internalNetLink = new InternalNetLink(iNetElement2, iNetElement2, n7, n5, null, null);
                NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, netCircuitNode, (INetCircuitNode)object);
                if (this.dbgOn()) {
                    this.debug("Created the internal splicing span: " + Integer.toHexString(n7) + "->" + Integer.toHexString(n5));
                }
                netCircuitSpan.setSrcState(2);
                netCircuitSpan.setDstState(2);
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                ((NetCircuitNode)object).addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                this.insertCktSpan(netCircuitSpan);
            }
        }
        this.operator.addCircuitSpan(iNetLinkSpan, routePrefs);
    }

    @Override
    public synchronized void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        int n = iNetCircuitEnd.getEntityIndex();
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() > 1) {
                if (this.dbgOn()) {
                    db.println("addDrop(): two SVLAN xconns already there, no further work.");
                }
                this.operator.addDrop(iNetCircuitEnd, routePrefs);
            } else {
                SvlanCircuitNode svlanCircuitNode = (SvlanCircuitNode)list.get(0);
                List list2 = svlanCircuitNode.getPathList();
                if (list2 != null && list2.size() > 0) {
                    ISvlanPathDefModel iSvlanPathDefModel = (ISvlanPathDefModel)list2.get(0);
                    int n2 = iSvlanPathDefModel.getPortEntityIdx();
                    if (SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement, n, n2, false)) {
                        if (this.dbgOn()) {
                            db.println("addDrop(): the drop being added is on the same card, no further work.");
                        }
                        this.operator.addDrop(iNetCircuitEnd, routePrefs);
                    } else {
                        if (this.dbgOn()) {
                            db.println("addDrop(): the drop being added is on the other 1+1 L2 card, need to add new cktnode");
                        }
                        int[] nArray = SvlanCircuitHelper.getGZTrunkPorts(iNetElement, n);
                        int n3 = 0;
                        int n4 = 0;
                        for (int i = 0; i < nArray.length; ++i) {
                            n4 = SvlanCircuitHelper.getGZConnectedTrunk(iNetElement, nArray[i]);
                            if (n4 == 0) continue;
                            n3 = nArray[i];
                            break;
                        }
                        if (n3 != 0 && n4 != 0) {
                            if (this.dbgOn()) {
                                this.debug("Creating the missed SVLAN xconn on " + svlanCircuitNode.getName());
                            }
                            NetCircuitNode netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
                            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo((NetCircuitEnd)iNetCircuitEnd, 2);
                            netCircuitNode.addDropInfo(netCircuitDropInfo);
                            this.insertCktNode(netCircuitNode);
                            this.insertDrop(netCircuitDropInfo);
                            svlanCircuitNode.setInternalEntityIdx(n4);
                            ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(n3);
                            InternalNetLink internalNetLink = new InternalNetLink(iNetElement, iNetElement, n4, n3, null, null);
                            NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, svlanCircuitNode, netCircuitNode);
                            if (this.dbgOn()) {
                                this.debug("Created the internal splicing span: " + Integer.toHexString(n4) + "->" + Integer.toHexString(n3));
                            }
                            netCircuitSpan.setSrcState(2);
                            netCircuitSpan.setDstState(2);
                            svlanCircuitNode.setState(3);
                            svlanCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                            netCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                            this.insertCktSpan(netCircuitSpan);
                            this.setTl1Compatible(true);
                            if (this.getState() != 0) {
                                this.setState(3);
                            }
                        } else if (this.dbgOn()) {
                            db.println("addDrop(): ERROR!!! not able to get the 1+1 L2 ports layout.");
                        }
                    }
                } else if (this.dbgOn()) {
                    db.println("addDrop(): ERROR!!! not able to get the pathdef from the cktnode.");
                }
            }
        } else if (this.dbgOn()) {
            db.println("addDrop(): ERROR!!! not able to get the cktnodes from " + iNetElement.getName());
        }
    }

    @Override
    public INetCircuitSpan getCircuitSpanFromNetLink(INetLink iNetLink) {
        INetLink iNetLink2;
        INetCircuitSpan iNetCircuitSpan = super.getCircuitSpanFromNetLink(iNetLink);
        if (iNetLink.isVirtual() && iNetCircuitSpan == null && (iNetLink2 = iNetLink.getReverseLink()) != null) {
            iNetCircuitSpan = super.getCircuitSpanFromNetLink(iNetLink2);
        }
        return iNetCircuitSpan;
    }

    @Override
    protected boolean validateCircuitTopology() {
        if (this.dbgOn()) {
            db.println("validateCircuitTopology()");
        }
        if (this.isSvlanProtected()) {
            if (this.dbgOn()) {
                db.println("validateCircuitTopology(): SVLAN Protected");
            }
            if (!this.isProtectionRingComplete()) {
                if (this.dbgOn()) {
                    db.println("validateCircuitTopology(): The circuit is NOT a complete ring.");
                }
                return false;
            }
            if (this.dbgOn()) {
                db.println("validateCircuitTopology(): The ring is complete.");
            }
        }
        if (this.getSourcesSize() == 1 && this.getCktNodeListSize() >= 2 && (this.isSvlanProtected() && this.getDropsSize() >= 0 || this.getDropsSize() >= 1)) {
            if (this.hasSourceOrDropsTrunkNNI()) {
                if (this.dbgOn()) {
                    db.println("validateCircuitTopology: Circuit " + this.getCircuitName() + " has source/drops NNI");
                    db.println("Number of nodes = " + this.getCktNodeListSize());
                    db.println("Number of sources = " + this.getSourcesSize());
                    db.println("Number of drops = " + this.getDropsSize());
                }
                return false;
            }
            if (this.dbgOn()) {
                db.println("validateCircuitTopology: Circuit " + this.getCircuitName() + " is OK");
                db.println("Number of nodes = " + this.getCktNodeListSize());
                db.println("Number of sources = " + this.getSourcesSize());
                db.println("Number of drops = " + this.getDropsSize());
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("validateCircuitTopology: Circuit " + this.getCircuitName() + " has invalid nodes/drops/sources");
            db.println("Number of nodes = " + this.getCktNodeListSize());
            db.println("Number of sources = " + this.getSourcesSize());
            db.println("Number of drops = " + this.getDropsSize());
        }
        return false;
    }

    public short getSvlan() {
        return this.svlan;
    }

    @Override
    protected void updateDeleted() {
        if (this.dbgOn()) {
            db.println("SVLAN circuit updateDeleted()!!!");
        }
        this.dispose();
    }

    @Override
    public int getCircuitSpanNum() {
        List list = this.getCircuitSpans();
        Iterator iterator = list.iterator();
        int n = list.size();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.isInternalSpan()) continue;
            --n;
        }
        return n;
    }

    @Override
    public int getProtType() {
        if (this.isProtected()) {
            return 11;
        }
        return 3;
    }

    @Override
    public boolean setCircuitLevelSourcesAndDrops(List list, List list2) {
        this.setSources(null);
        this.setDrops(null);
        this.setChanged();
        this.getNodeLevelSourcesAndDrops(list, list2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.insertSource((NetCircuitEnd)iterator.next());
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.insertDrop(new NetCircuitDropInfo((NetCircuitEnd)iterator.next(), 2));
        }
        this.updateCircuitSourceInfo();
        this.updateCircuitDropInfo();
        return this.setSrcCircuitNode();
    }

    @Override
    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        List list3;
        for (Iterator iterator : this.getCircuitNodes()) {
            list.addAll(((NetCircuitNode)((Object)iterator)).getSources());
            list2.addAll(((NetCircuitNode)((Object)iterator)).getDrops());
        }
        if (this.getState() == 2) {
            if (this.dbgOn()) {
                db.println("getNodeLevelSourcesAndDrops(): the circuit is being deleted, no need to go further.");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("getNodeLevelSourcesAndDrops(): check for missing sources or drops");
        }
        if (this.isProtectionRingComplete()) {
            if (this.dbgOn()) {
                db.println("getNodeLevelSourcesAndDrops(): protected SVLAN circuit complete.");
                db.println("getNodeLevelSourcesAndDrops(): node sources => " + list.size());
                db.println("getNodeLevelSourcesAndDrops(): node drops => " + list2.size());
            }
            if (list.size() == 0 && list2.size() == 1) {
                this.changeDropToSourceOnNode((NetCircuitEnd)list2.get(0));
                list.add(list2.remove(0));
                if (this.dbgOn()) {
                    db.println("getNodeLevelSourcesAndDrops(): only 1 drop -> exchanged drop and src.");
                }
            } else if (list.size() == 1 && list2.size() == 0) {
                if (this.dbgOn()) {
                    db.println("getNodeLevelSourcesAndDrops(): only 1 src is fine.");
                }
            } else if (list.size() == 0) {
                if (list2.size() > 0) {
                    if (this.dbgOn()) {
                        db.println("getNodeLevelSourcesAndDrops(): no source add one");
                    }
                    this.changeDropToSourceOnNode((NetCircuitEnd)list2.get(0));
                    list.add(list2.remove(0));
                }
            } else if (list.size() > 1) {
                if (this.dbgOn()) {
                    db.println("getNodeLevelSourcesAndDrops(): too many sources, move to drop list.");
                }
                list3 = list.subList(1, list.size());
                for (NetCircuitEnd netCircuitEnd : list3) {
                    this.changeSourceToDropOnNode(netCircuitEnd);
                }
                list2.addAll(list3);
                list3.clear();
            } else if (list2.size() == 0) {
                if (this.dbgOn()) {
                    db.println("getNodeLevelSourcesAndDrops(): 1 source no drop");
                }
            } else if (this.dbgOn()) {
                db.println("getNodeLevelSourcesAndDrops(): 1 source 1 or more drops");
            }
        } else {
            if (this.dbgOn()) {
                db.println("getNodeLevelSourcesAndDrops(): linear SVLAN circuit.");
            }
            if (list.size() == 0) {
                if (list2.size() > 0) {
                    if (this.dbgOn()) {
                        db.println("getNodeLevelSourcesAndDrops(): no source add one");
                    }
                    this.changeDropToSourceOnNode((NetCircuitEnd)list2.get(0));
                    list.add(list2.remove(0));
                }
            } else if (list.size() > 1) {
                if (this.dbgOn()) {
                    db.println("getNodeLevelSourcesAndDrops(): too many sources, move to drop list.");
                }
                list3 = list.subList(1, list.size());
                for (NetCircuitEnd netCircuitEnd : list3) {
                    this.changeSourceToDropOnNode(netCircuitEnd);
                }
                list2.addAll(list3);
                list3.clear();
            } else if (list2.size() == 0) {
                if (this.dbgOn()) {
                    db.println("getNodeLevelSourcesAndDrops(): 1 source no drop");
                }
            } else if (this.dbgOn()) {
                db.println("getNodeLevelSourcesAndDrops(): 1 source 1 or more drops");
            }
            if (this.dbgOn()) {
                db.println("getNodeLevelSourcesAndDrops(): nodeLevelSources: " + list.size() + " nodeLevelDrops: " + list2.size());
            }
        }
    }

    @Override
    public void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        if (iNetCircuitEnd instanceof NetCircuitDropInfo) {
            this.getOperator().deleteDrop(((NetCircuitDropInfo)iNetCircuitEnd).getNetCktEnd());
        } else {
            this.getOperator().deleteDrop(iNetCircuitEnd);
        }
    }

    public void changeSourceToDropOnNode(NetCircuitEnd netCircuitEnd) {
        NetCircuitNode netCircuitNode = this.getCircuitNodeFromCktEnd(netCircuitEnd);
        if (netCircuitNode != null) {
            netCircuitNode.changeSourceToDrop(netCircuitEnd);
        }
    }

    public void changeDropToSourceOnNode(NetCircuitEnd netCircuitEnd) {
        NetCircuitNode netCircuitNode = this.getCircuitNodeFromCktEnd(netCircuitEnd);
        if (netCircuitNode != null) {
            netCircuitNode.changeDropToSource(netCircuitEnd);
        }
    }

    public void reAlignCircuitSourceAndDrop() {
        this.initSourcesAndDrops();
    }

    @Override
    public void sanityCheck() throws SanityCheckFailed {
        super.sanityCheck();
        if (this.isProtectionRingComplete() && this.getState() == 0) {
            Object object;
            Object object2;
            Object object32;
            List list = this.getCircuitSpans();
            boolean bl = false;
            int n = 0;
            boolean bl2 = false;
            block2: for (Object object32 : list) {
                object2 = new int[]{0, 0};
                object2[0] = ((NetCircuitSpan)object32).getInternalEntityIndex(((NetCircuitSpan)object32).getSrcNCN());
                if (((NetCircuitSpan)object32).isInternalSpan()) {
                    object2[1] = ((NetCircuitSpan)object32).getInternalEntityIndex(((NetCircuitSpan)object32).getDstNCN());
                }
                if (db.on()) {
                    db.println("Looking for FRP Master on Node " + ((NetCircuitSpan)object32).getSrcNCN().getNodeModel().getName());
                }
                object = ((NetCircuitSpan)object32).getSrcNCN().getNodeModel();
                IEntityTableModel iEntityTableModel = object.getEntityTable();
                try {
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        IEntityModel iEntityModel;
                        IXPL2ModuleModel iXPL2ModuleModel;
                        if (object2[i] == false || !(iXPL2ModuleModel = (IXPL2ModuleModel)(iEntityModel = iEntityTableModel.getEntityModelByIndex((int)object2[i])).getModuleModel()).isFrpMasterCard()) continue;
                        bl = true;
                        ++n;
                        if (!iXPL2ModuleModel.isFrpEnabled()) continue;
                        bl2 = true;
                        break block2;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (!bl) {
                throw new SanityCheckFailed("No master node defined for the circuit.");
            }
            if (n > 1) {
                throw new SanityCheckFailed("Too many master nodes defined in the ring.");
            }
            if (!bl2) {
                throw new SanityCheckFailed("Protection state is not enabled on master node.");
            }
            List list2 = this.getDrops();
            if (list2.size() > 0 && (object2 = (Object)this.getCircuitNodeFromCktEnd(((NetCircuitDropInfo)(object32 = (NetCircuitDropInfo)list2.get(0))).getNetCktEnd())) != null) {
                ((NetCircuitNode)object2).removeDrop(((NetCircuitDropInfo)object32).getNetCktEnd());
                object = this.getCircuitInfo().getCircuitName();
                this.reAlignCircuitSourceAndDrop();
                this.updateCircuitName((String)object);
            }
        }
    }

    public NetlinkBandwidthWrapper[] checkSvlanBandwidth(boolean bl, INetCircuitEnd iNetCircuitEnd) {
        Object object;
        Object object2;
        Object object32;
        int n;
        INetLink iNetLink;
        INetLink iNetLink2;
        Object object4;
        this.orderedLinkList = new LinkedList();
        int n2 = 0;
        boolean bl2 = false;
        INetElement iNetElement = this.getSourceNE();
        INetElement iNetElement2 = this.getDropNE();
        if (this.isProtected()) {
            bl2 = true;
            iNetElement2 = this.getSourceNE();
        }
        if (!bl) {
            object4 = iNetElement;
            iNetLink2 = null;
            iNetLink = null;
            while (bl2 || object4 != iNetElement2) {
                bl2 = false;
                n = 0;
                for (Object object32 : this.getCircuitSpans()) {
                    if (((NetCircuitSpan)object32).getLink() instanceof InternalNetLink || ((NetCircuitSpan)object32).getLink().getSrc() != object4 || ((NetCircuitSpan)object32).getLink() == iNetLink2 || ((NetCircuitSpan)object32).getReverseLink() == iNetLink) continue;
                    this.orderedLinkList.add(new NetlinkBandwidthWrapper(((NetCircuitSpan)object32).getLink()));
                    object4 = ((NetCircuitSpan)object32).getLink().getDst();
                    iNetLink2 = ((NetCircuitSpan)object32).getLink();
                    iNetLink = ((NetCircuitSpan)object32).getReverseLink();
                    n = 1;
                    break;
                }
                if (n == 0) {
                    for (Object object32 : this.getCircuitSpans()) {
                        if (((NetCircuitSpan)object32).getLink() instanceof InternalNetLink || ((NetCircuitSpan)object32).getLink().getDst() != object4 || ((NetCircuitSpan)object32).getLink() == iNetLink2 || ((NetCircuitSpan)object32).getReverseLink() == iNetLink) continue;
                        this.orderedLinkList.add(new NetlinkBandwidthWrapper(((NetCircuitSpan)object32).getLink().getReverseLink()));
                        object4 = ((NetCircuitSpan)object32).getLink().getReverseLink().getDst();
                        iNetLink2 = ((NetCircuitSpan)object32).getLink();
                        iNetLink = ((NetCircuitSpan)object32).getReverseLink();
                        n = 1;
                        break;
                    }
                }
                if (n != 0) continue;
                db.println("Unable to order NetLinks for Svlans bandwidth evaluation, evaluation aborted.");
                return new NetlinkBandwidthWrapper[0];
            }
        } else {
            object4 = iNetElement2;
            iNetLink2 = null;
            iNetLink = null;
            while (bl2 || object4 != iNetElement) {
                bl2 = false;
                n = 0;
                for (Object object32 : this.getCircuitSpans()) {
                    if (((NetCircuitSpan)object32).getLink() instanceof InternalNetLink || ((NetCircuitSpan)object32).getLink().getDst() != object4 || ((NetCircuitSpan)object32).getLink() == iNetLink2 || ((NetCircuitSpan)object32).getReverseLink() == iNetLink) continue;
                    if (!this.isProtected()) {
                        this.orderedLinkList.add(new NetlinkBandwidthWrapper(((NetCircuitSpan)object32).getLink()));
                    } else {
                        this.orderedLinkList.addFirst(new NetlinkBandwidthWrapper(((NetCircuitSpan)object32).getLink().getReverseLink()));
                    }
                    object4 = ((NetCircuitSpan)object32).getLink().getSrc();
                    iNetLink2 = ((NetCircuitSpan)object32).getLink();
                    iNetLink = ((NetCircuitSpan)object32).getReverseLink();
                    n = 1;
                    break;
                }
                if (n == 0) {
                    for (Object object32 : this.getCircuitSpans()) {
                        if (((NetCircuitSpan)object32).getLink() instanceof InternalNetLink || ((NetCircuitSpan)object32).getLink().getSrc() != object4 || ((NetCircuitSpan)object32).getLink() == iNetLink2 || ((NetCircuitSpan)object32).getReverseLink() == iNetLink) continue;
                        if (!this.isProtected()) {
                            this.orderedLinkList.add(new NetlinkBandwidthWrapper(((NetCircuitSpan)object32).getLink().getReverseLink()));
                        } else {
                            this.orderedLinkList.addFirst(new NetlinkBandwidthWrapper(((NetCircuitSpan)object32).getLink()));
                        }
                        object4 = ((NetCircuitSpan)object32).getLink().getReverseLink().getSrc();
                        iNetLink2 = ((NetCircuitSpan)object32).getLink();
                        iNetLink = ((NetCircuitSpan)object32).getReverseLink();
                        n = 1;
                        break;
                    }
                }
                if (n != 0) continue;
                db.println("Unable to order NetLinks for Reverse Svlans bandwidth evaluation, evaluation aborted.");
                return new NetlinkBandwidthWrapper[0];
            }
        }
        object4 = (NetlinkBandwidthWrapper)this.orderedLinkList.iterator().next();
        int n3 = 0;
        int n4 = 0;
        n = 0;
        INodeModel iNodeModel = null;
        object32 = DropPosition.NOTCONFIGURED;
        if (!bl) {
            if (iNetCircuitEnd != null && this.isProtected()) {
                n = iNetCircuitEnd.getEntityIndex();
                iNodeModel = iNetCircuitEnd.getNodeModel();
                object32 = DropPosition.INNER;
            } else if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() == iNetElement.getNodeModel()) {
                n = iNetCircuitEnd.getEntityIndex();
                iNodeModel = iNetElement.getNodeModel();
                object32 = DropPosition.SRC;
            } else if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() == iNetElement2.getNodeModel()) {
                object32 = DropPosition.DST;
            } else if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() != iNetElement2.getNodeModel()) {
                n = iNetCircuitEnd.getEntityIndex();
                iNodeModel = iNetCircuitEnd.getNodeModel();
                object32 = DropPosition.INNER;
            } else if (iNetCircuitEnd == null) {
                n = this.circuitInfo.getSrcInfo()[0].getPortNum();
                iNodeModel = iNetElement.getNodeModel();
            }
        } else if (iNetCircuitEnd != null && this.isProtected()) {
            n = iNetCircuitEnd.getEntityIndex();
            iNodeModel = iNetCircuitEnd.getNodeModel();
            object32 = DropPosition.INNER;
        } else if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() == iNetElement2.getNodeModel()) {
            n = iNetCircuitEnd.getEntityIndex();
            iNodeModel = iNetElement2.getNodeModel();
            object32 = DropPosition.SRC;
        } else if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() == iNetElement.getNodeModel()) {
            object32 = DropPosition.DST;
        } else if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() != iNetElement.getNodeModel()) {
            n = iNetCircuitEnd.getEntityIndex();
            iNodeModel = iNetCircuitEnd.getNodeModel();
            object32 = DropPosition.INNER;
        } else if (iNetCircuitEnd == null) {
            n = ((NetCircuitDropInfo)this.getCktDrops().get(0)).getCircuitDropInfo().getDropPoint().getPortNum();
            iNodeModel = iNetElement2.getNodeModel();
        }
        if (object32 == DropPosition.NOTCONFIGURED || object32 == DropPosition.SRC || object32 == DropPosition.INNER) {
            try {
                IPortModel iPortModel = (IPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n);
                object2 = iPortModel.getInterfaceModel();
                object = null;
                object = object2 instanceof IXPLLayer2LineModel ? (IXPLLayer2LineModel)object2 : (IXPLLayer2LineModel)object2.getHigherLayerModelsForNet()[0];
                try {
                    n3 = object.getCIR();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n4 = this.getPortSize(iNodeModel, n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (object32 == DropPosition.INNER) {
            n2 = n3;
            n4 = 0;
            n3 = 0;
        }
        int n5 = n3 * n4;
        object2 = this.orderedLinkList.get(this.orderedLinkList.size() - 1);
        if (object32 == DropPosition.INNER) {
            this.calculateIncomingAggBWFromDst(((NetlinkBandwidthWrapper)object2).getLink(), new ArrayList<INetElement>(), new HashMap<Short, Integer>(), new HashMap<Short, Integer>(), bl, iNetCircuitEnd, n2);
        } else {
            this.calculateIncomingAggBWFromDst(((NetlinkBandwidthWrapper)object2).getLink(), new ArrayList<INetElement>(), new HashMap<Short, Integer>(), new HashMap<Short, Integer>(), bl, null, 0);
        }
        object = new ArrayList();
        int n6 = 0;
        for (NetlinkBandwidthWrapper netlinkBandwidthWrapper : this.orderedLinkList) {
            n6 = netlinkBandwidthWrapper.getSvlanTagAggregatedBW() + n5;
            if (!bl) {
                netlinkBandwidthWrapper.setCurrentBW(n6);
            } else {
                netlinkBandwidthWrapper.setCurrentReverseBW(n6);
            }
            String string = netlinkBandwidthWrapper.getLink().prettyString().substring(0, netlinkBandwidthWrapper.getLink().prettyString().indexOf("."));
            if (n6 > netlinkBandwidthWrapper.getMaxBW()) {
                ((ArrayList)object).add(netlinkBandwidthWrapper);
                if (!db.on()) continue;
                db.println("Invalid span " + string + " used for an SVLAN circuit, bandwidth is " + (float)n6 / 1000.0f + (bl ? " reverse" : "not reverse"));
                continue;
            }
            if (!db.on()) continue;
            db.println("Valid span " + string + " used for an SVLAN circuit, bandwidth is " + (float)n6 / 1000.0f + (bl ? " reverse" : "not reverse"));
        }
        return ((ArrayList)object).toArray(new NetlinkBandwidthWrapper[0]);
    }

    private void calculateIncomingAggBWFromDst(INetLink iNetLink, List<INetElement> list, HashMap<Short, Integer> hashMap, HashMap<Short, Integer> hashMap2, boolean bl, INetCircuitEnd iNetCircuitEnd, int n) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2 = false;
        HashMap<Short, Integer> hashMap3 = new HashMap<Short, Integer>(hashMap2);
        if (list.size() == 0) {
            bl2 = true;
        }
        INodeModel iNodeModel = null;
        int n2 = 0;
        if (!bl) {
            iNodeModel = iNetLink.getSrc().getNodeModel();
            list.add(iNetLink.getSrc());
            n2 = iNetLink.getSrcEntityIndex();
        } else {
            iNodeModel = iNetLink.getDst().getNodeModel();
            list.add(iNetLink.getDst());
            n2 = iNetLink.getDstEntityIndex();
        }
        NetlinkBandwidthWrapper netlinkBandwidthWrapper = this.getNetlinkBandwidthWrapperFromNetLink(iNetLink);
        try {
            if (iNetCircuitEnd != null && iNetCircuitEnd.getNodeModel() == iNodeModel && !this.isProtected()) {
                if (netlinkBandwidthWrapper != null) {
                    netlinkBandwidthWrapper.addSvlanTag(this.svlan, n * this.getPortSize(iNodeModel, iNetCircuitEnd.getEntityIndex()));
                }
                if ((bl2 || hashMap.containsKey(this.svlan)) && (object3 = hashMap.get(this.svlan)) != null) {
                    hashMap.put(this.svlan, (Integer)object3 + n * this.getPortSize(iNodeModel, iNetCircuitEnd.getEntityIndex()));
                }
            }
            object3 = iNodeModel.getSvlanCircuitModels().getLocalCirs(n2);
            for (ILocalCirData object4 : object3) {
                object2 = null;
                HashSet<SvlanCircuit> hashSet = NetCircuitManager.instance().getSvlanCircuits(iNodeModel);
                Object object5 = hashSet.iterator();
                while (object5.hasNext()) {
                    SvlanCircuit svlanCircuit = object5.next();
                    if (svlanCircuit.getSvlan() != object4.getVlan() || !svlanCircuit.isProtected()) continue;
                    object2 = svlanCircuit;
                }
                if (object2 != null) {
                    object5 = hashMap3.get(object4.getVlan());
                    if (object5 == null) {
                        object5 = 0;
                    }
                    hashMap3.put(object4.getVlan(), (Integer)object5 + object4.getCIR() * this.getPortSize(iNodeModel, object4.getIndex()));
                }
                if (netlinkBandwidthWrapper != null) {
                    netlinkBandwidthWrapper.addSvlanTag(object4.getVlan(), object4.getCIR() * this.getPortSize(iNodeModel, object4.getIndex()));
                }
                if (!bl2 && !hashMap.containsKey(object4.getVlan()) || (object5 = hashMap.get(object4.getVlan())) == null) continue;
                hashMap.put(object4.getVlan(), (Integer)object5 + object4.getCIR() * this.getPortSize(iNodeModel, object4.getIndex()));
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        object3 = new HashMap();
        boolean bl3 = false;
        if (netlinkBandwidthWrapper == null) {
            bl3 = true;
        }
        try {
            object = iNodeModel.getSvlanCircuitModels().getPassThroughSvlans(n2);
            block6: for (Integer n3 : ((HashMap)object).keySet()) {
                for (short s : (short[])((HashMap)object).get(n3)) {
                    ((HashMap)object3).put(s, 0);
                    if (bl2) {
                        hashMap.put(s, 0);
                    }
                    if (!this.isProtected || this.svlan != s) continue;
                    netlinkBandwidthWrapper.addSvlanTag(s, n * this.getPortSize(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityIndex()));
                }
                object2 = hashMap2.keySet().iterator();
                while (object2.hasNext()) {
                    Short s = (Short)object2.next();
                    if (hashMap.containsKey(s)) {
                        netlinkBandwidthWrapper.addSvlanTag(s, hashMap2.get(s));
                        continue;
                    }
                    hashMap3.put(s, 0);
                }
                for (INetLink iNetLink2 : Network.instance().getNetLinks()) {
                    int n4;
                    if (!bl) {
                        if (iNetLink2.getDstEntityIndex() != n3.intValue() || iNetLink2.getDst() != iNetLink.getSrc()) continue;
                        n4 = 0;
                        Object object6 = list.iterator();
                        while (object6.hasNext()) {
                            if (iNetLink2.getSrc() != object6.next()) continue;
                            n4 = 1;
                        }
                        if (n4 != 0) continue block6;
                        object6 = this.getNetlinkBandwidthWrapperFromNetLink(iNetLink2);
                        if (object6 != null) {
                            bl3 = true;
                        }
                        this.calculateIncomingAggBWFromDst(iNetLink2, list, (HashMap<Short, Integer>)object3, hashMap3, bl, iNetCircuitEnd, n);
                        continue block6;
                    }
                    if (iNetLink2.getSrcEntityIndex() != n3.intValue() || iNetLink2.getSrc() != iNetLink.getDst()) continue;
                    n4 = 0;
                    Object object7 = list.iterator();
                    while (object7.hasNext()) {
                        if (iNetLink2.getDst() != object7.next()) continue;
                        n4 = 1;
                    }
                    if (n4 != 0) continue block6;
                    object7 = this.getNetlinkBandwidthWrapperFromNetLink(iNetLink2);
                    if (object7 != null) {
                        bl3 = true;
                    }
                    this.calculateIncomingAggBWFromDst(iNetLink2, list, (HashMap<Short, Integer>)object3, hashMap3, bl, iNetCircuitEnd, n);
                    continue block6;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if (!bl3) {
            object = null;
            for (NetlinkBandwidthWrapper netlinkBandwidthWrapper2 : this.orderedLinkList) {
                Iterator<INetElement> iterator;
                boolean bl4;
                if (!bl) {
                    if (netlinkBandwidthWrapper2.getLink().getDst() != iNetLink.getSrc()) continue;
                    bl4 = false;
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (netlinkBandwidthWrapper2.getLink().getSrc() != iterator.next()) continue;
                        bl4 = true;
                    }
                    if (bl4) continue;
                    object = netlinkBandwidthWrapper2;
                    continue;
                }
                if (netlinkBandwidthWrapper2.getLink().getSrc() != iNetLink.getDst()) continue;
                bl4 = false;
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (netlinkBandwidthWrapper2.getLink().getDst() != iterator.next()) continue;
                    bl4 = true;
                }
                if (bl4) continue;
                object = netlinkBandwidthWrapper2;
            }
            if (object != null) {
                this.calculateIncomingAggBWFromDst(((NetlinkBandwidthWrapper)object).getLink(), list, (HashMap<Short, Integer>)object3, hashMap3, bl, iNetCircuitEnd, n);
            }
        }
        for (Short s : ((HashMap)object3).keySet()) {
            Integer n5;
            if (netlinkBandwidthWrapper != null) {
                netlinkBandwidthWrapper.addSvlanTag(s, (Integer)((HashMap)object3).get(s));
            }
            if (!hashMap.containsKey(s) || (n5 = hashMap.get(s)) == null) continue;
            hashMap.put(s, n5 + (Integer)((HashMap)object3).get(s));
        }
    }

    private int getPortSize(INodeModel iNodeModel, int n) {
        int n2;
        int n3;
        block9: {
            Object object;
            int n4 = 0;
            n3 = 1;
            try {
                IXPLLayer2LineModel iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iNodeModel, n);
                if (iXPLLayer2LineModel.isChannelGroup()) {
                    object = ((IXPL2ChannelGroupModel)iXPLLayer2LineModel).getL1PortList();
                    if (object != null && ((int[])object).length > 0) {
                        n4 = ((IXPL2ChannelGroupModel)iXPLLayer2LineModel).getL1PortList()[0];
                        n3 = ((IXPL2ChannelGroupModel)iXPLLayer2LineModel).getL1PortList().length;
                    }
                } else {
                    n4 = n;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            if (n4 == 0 && db.on()) {
                db.println("SvlanCircuit::getPortType - port index could not be retrieved.");
            }
            n2 = 0;
            object = null;
            try {
                object = (IPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n4);
                n2 = object.getEqType() == 316 ? 1 : (object.getEqType() == 167 ? 10 : 100);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (n2 == 0 && db.on()) {
            db.println("SvlanCircuit::getPortType - port size could not be determined.");
        }
        return n2 * n3;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    private boolean isSvlanProtected() {
        boolean bl;
        block3: {
            bl = false;
            try {
                INodeModel iNodeModel;
                IEntityTableModel iEntityTableModel;
                IEntityModel iEntityModel;
                IModuleModel iModuleModel;
                List list = this.getSources();
                INetCircuitEnd iNetCircuitEnd = null;
                if (list == null || list.size() <= 0 || !((iModuleModel = (iEntityModel = (iEntityTableModel = (iNodeModel = (iNetCircuitEnd = (INetCircuitEnd)list.get(0)).getNodeModel()).getEntityTable()).getEntityModelByIndex(iNetCircuitEnd.getEntityIndex())).getModuleModel()) instanceof IXPL2ModuleModel)) break block3;
                IVlanInfo[] iVlanInfoArray = ((IXPL2ModuleModel)iModuleModel).getVlanDb();
                for (int i = 0; i < iVlanInfoArray.length; ++i) {
                    if (iVlanInfoArray[i].getVlanId() != this.getSvlan()) continue;
                    bl = iVlanInfoArray[i].isVlanProtected();
                    break;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.dbgOn()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return bl;
    }

    private boolean hasSourceOrDropsTrunkNNI() {
        boolean bl;
        block9: {
            bl = false;
            try {
                List list;
                List list2 = this.getSources();
                INetCircuitEnd iNetCircuitEnd = null;
                if (list2 != null && list2.size() > 0) {
                    iNetCircuitEnd = (INetCircuitEnd)list2.get(0);
                    list = iNetCircuitEnd.getNodeModel();
                    IXPLLayer2LineModel iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface((INodeModel)list, iNetCircuitEnd.getEntityIndex());
                    boolean bl2 = SvlanCircuitHelper.isTrunk((INodeModel)list, iNetCircuitEnd.getEntityIndex());
                    if (iXPLLayer2LineModel.isNNI() && bl2) {
                        return true;
                    }
                }
                list = this.getDrops();
                for (NetCircuitDropInfo netCircuitDropInfo : list) {
                    INodeModel iNodeModel = netCircuitDropInfo.getNodeModel();
                    IXPLLayer2LineModel iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iNodeModel, netCircuitDropInfo.getEntityIndex());
                    boolean bl3 = SvlanCircuitHelper.isTrunk(iNodeModel, netCircuitDropInfo.getEntityIndex());
                    if (!iXPLLayer2LineModel.isNNI() || !bl3) continue;
                    return true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (InvalidOperation invalidOperation) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)invalidOperation);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.dbgOn()) break block9;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return bl;
    }

    public boolean isProtectionRingComplete() {
        return this.getCircuitSpanMap().size() == this.getCircuitNodes().size();
    }

    @Override
    protected synchronized boolean tl1CircuitCompleteCheck() {
        boolean bl = super.tl1CircuitCompleteCheck();
        if (bl) {
            if (this.dbgOn()) {
                db.println("tl1CircuitCompleteCheck(): performing splice listener cleanup");
            }
            this.cleanupSpliceListeners();
        }
        return bl;
    }

    @Override
    protected boolean setCircuitRoutingDirection() {
        if (this.dbgOn()) {
            db.println("setCircuitRoutingDirection SVLAN circuit: no need to change routing dir.");
        }
        return true;
    }

    @Override
    protected synchronized boolean reverseRoutingDir() throws IncorrectCircuitState {
        if (this.dbgOn()) {
            this.debug("reverseRoutingDir SVLAN circuit: no need to change routing dir.");
        }
        return true;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        NetCircuitManager.suppressPkgDbg();
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + SvlanCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        sDebug.println("        " + EnumStrings.getString(ICircuitType.class, (int)this.getCircuitType()) + "  " + EnumStrings.getString(ICircuitSize.class, (int)this.getCircuitSize()) + "  " + EnumStrings.getString(ICircuitDirection.class, (int)this.getCircuitDir()));
        sDebug.println("        SVLAN ID=" + this.getSvlan() + "  protType=" + this.protType.getProtectionTypeString());
        sDebug.println("");
        sDebug.println("srcNode: " + (this.srcNodeModel == null ? "null" : this.srcNodeModel.getName()));
        sDebug.println("");
        sDebug.println("Source(s) :");
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            sDebug.println(" " + netCircuitEnd.prettyString() + " " + EnumStrings.getString(INetCircuitCreatStage.class, (int)netCircuitEnd.getStage()));
        }
        sDebug.println("");
        sDebug.println("Drop(s) :");
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            sDebug.println(" " + netCircuitDropInfo.getNetCktEnd().prettyString() + " " + EnumStrings.getString(INetCircuitCreatStage.class, (int)netCircuitDropInfo.getNetCktEnd().getStage()));
        }
        this.printChild(sDebug);
        NetCircuitManager.permitPkgDbg();
    }

    private NetlinkBandwidthWrapper getNetlinkBandwidthWrapperFromNetLink(INetLink iNetLink) {
        if (this.orderedLinkList != null) {
            for (NetlinkBandwidthWrapper netlinkBandwidthWrapper : this.orderedLinkList) {
                if (netlinkBandwidthWrapper.getLink() != iNetLink) continue;
                return netlinkBandwidthWrapper;
            }
        }
        return null;
    }

    public void clearSvlanTags() {
        for (NetlinkBandwidthWrapper netlinkBandwidthWrapper : this.orderedLinkList) {
            netlinkBandwidthWrapper.clearSvlanTags();
        }
    }

    public void clearSvlanTagsAndBandwidthData() {
        for (NetlinkBandwidthWrapper netlinkBandwidthWrapper : this.orderedLinkList) {
            netlinkBandwidthWrapper.clearSvlanTags();
            netlinkBandwidthWrapper.setCurrentBW(0);
            netlinkBandwidthWrapper.setCurrentReverseBW(0);
        }
    }

    private static enum DropPosition {
        NOTCONFIGURED,
        SRC,
        INNER,
        DST;

    }

    public class NetlinkBandwidthWrapper {
        private INetLink innerLink = null;
        private int currentBW = 0;
        private int currentRevBW = 0;
        private int maxbw = 0;
        private HashMap<Short, Integer> svlanTags;

        public NetlinkBandwidthWrapper(INetLink iNetLink) {
            this.innerLink = iNetLink;
            this.svlanTags = new HashMap();
            int n = 0;
            INodeModel iNodeModel = null;
            int n2 = 0;
            iNodeModel = iNetLink.getSrc().getNodeModel();
            n2 = iNetLink.getSrcEntityIndex();
            IPortModel iPortModel = null;
            try {
                iPortModel = (IPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n2);
                n = iPortModel.getEqType() == 316 ? 100 : (iPortModel.getEqType() == 167 ? 1000 : 10000);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("SvlanCircuit::addCircuitSpan - Could not determine destination port TYPE.");
                }
                db;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            this.maxbw = n;
        }

        public INetLink getLink() {
            return this.innerLink;
        }

        public void setCurrentBW(int n) {
            this.currentBW = n;
        }

        public int getCurrentBW() {
            return this.currentBW;
        }

        public void setCurrentReverseBW(int n) {
            this.currentRevBW = n;
        }

        public int getCurrentReverseBW() {
            return this.currentRevBW;
        }

        public void addSvlanTag(short s, int n) {
            Integer n2 = 0;
            if (this.svlanTags.containsKey(s)) {
                n2 = this.svlanTags.get(s);
            }
            this.svlanTags.put(s, n2 + n);
        }

        public int getSvlanTagBW(short s) {
            return this.svlanTags.get(s);
        }

        public HashMap<Short, Integer> getSvlanTagAggregatedBW(Short[] shortArray) {
            HashMap<Short, Integer> hashMap = new HashMap<Short, Integer>();
            for (Short s : shortArray) {
                Integer n = this.svlanTags.get(s);
                if (s == null) continue;
                hashMap.put(s, n);
            }
            return hashMap;
        }

        public int getSvlanTagAggregatedBW() {
            int n = 0;
            Iterator<Short> iterator = this.svlanTags.keySet().iterator();
            while (iterator.hasNext()) {
                n += this.svlanTags.get(iterator.next()).intValue();
            }
            return n;
        }

        public void clearSvlanTags() {
            this.svlanTags.clear();
        }

        public int getMaxBW() {
            return this.maxbw;
        }
    }
}

