/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PathInUse;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNumberOfPaths;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuitNode;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.eSpanDirection;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SvlanCircuitNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("SvlanCircuitNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public SvlanCircuitNodeOperator(SvlanCircuitNode svlanCircuitNode) {
        super(svlanCircuitNode);
    }

    @Override
    protected void createConnection() throws CircuitProvError {
        block8: {
            ICircuitId iCircuitId = this.node.getCircuitId();
            if (SvlanCircuitNodeOperator.dbgOn()) {
                db.println("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + "; cktId=" + NetCircuit.prettyString(iCircuitId));
            }
            try {
                this.createConnection(iCircuitId);
            }
            catch (CTCUserException cTCUserException) {
                if (SvlanCircuitNodeOperator.dbgOn()) {
                    db.println("Exception while creating connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "A connection could not be created on the node " + this.getName() + ".";
                if (cTCUserException instanceof PathInUse) {
                    string = string + "\nThe selected SVLAN is already associated to a NNI interface or\nis part of a QinQ rule on the same card.";
                }
                throw new CircuitProvError(string);
            }
            catch (AdminStateProvisioningError adminStateProvisioningError) {
                if (!SvlanCircuitNodeOperator.dbgOn()) break block8;
                db.println("AdminStateProvisioningError while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
        }
        if (this.getConn() == null) {
            if (SvlanCircuitNodeOperator.dbgOn()) {
                db.println("ERROR!!! Connection Models returned NULL connection ");
            }
            throw new CircuitProvError(ErrorMsg.getString((EID)NEMC.EID_ERROR_CONNECTION_OBJECT_PARAM_1, (Object)this.getName()));
        }
    }

    @Override
    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws PathInUse, InvalidPath, InvalidCircuitName, WrongNumberOfPaths, WrongInterfaceType, NoSuchInterface, CTCUserException {
        if (SvlanCircuitNodeOperator.dbgOn()) {
            this.prettyPrint(arrayList.toArray(new ISvlanPathDefModel[0]), "input");
            this.prettyPrint(arrayList2.toArray(new ISvlanPathDefModel[0]), "output");
        }
        ISvlanPathDefModel[][] iSvlanPathDefModelArrayArray = new ISvlanPathDefModel[][]{arrayList.toArray(new ISvlanPathDefModel[0]), arrayList2.toArray(new ISvlanPathDefModel[0])};
        this.createSvlanConnOnNE(iCircuitId, iSvlanPathDefModelArrayArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createSvlanConnOnNE(ICircuitId iCircuitId, ISvlanPathDefModel[][] iSvlanPathDefModelArray) throws PathInUse, InvalidPath, InvalidCircuitName, WrongNumberOfPaths, WrongInterfaceType, NoSuchInterface, CTCUserException {
        ISvlanConnectionModel iSvlanConnectionModel = null;
        int n = this.node.getConnectionType();
        ISvlanPathDefModel[] iSvlanPathDefModelArray2 = iSvlanPathDefModelArray[0];
        ISvlanPathDefModel[] iSvlanPathDefModelArray3 = iSvlanPathDefModelArray[1];
        int n2 = iSvlanPathDefModelArray2.length + iSvlanPathDefModelArray3.length;
        ISvlanPathDefModel[] iSvlanPathDefModelArray4 = null;
        String string = this.node.getConnName();
        ISvlanCircuitModels iSvlanCircuitModels = this.node.getNodeModel().getSvlanCircuitModels();
        if (SvlanCircuitNodeOperator.dbgOn()) {
            db.println("createSvlanConnOnNE(" + this.getName() + "):connType=" + EnumStrings.getString(IConnectionType.class, (int)n));
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            block12: {
                if (n != 21) {
                    if (!SvlanCircuitNodeOperator.dbgOn()) return;
                    db.println("ERROR!!! createSvlanConnOnNE Unknown: connection type " + n);
                    return;
                }
                if (n2 == 2) {
                    iSvlanPathDefModelArray4 = new ISvlanPathDefModel[2];
                    if (iSvlanPathDefModelArray2.length == 1 && iSvlanPathDefModelArray3.length == 1) {
                        iSvlanPathDefModelArray4[0] = iSvlanPathDefModelArray2[0];
                        iSvlanPathDefModelArray4[1] = iSvlanPathDefModelArray3[0];
                        break block12;
                    } else {
                        if (!SvlanCircuitNodeOperator.dbgOn()) return;
                        db.println("createSvlanConnOnNE wrong number of paths: " + n2 + " in: " + iSvlanPathDefModelArray2.length + " out: " + iSvlanPathDefModelArray3.length);
                        return;
                    }
                }
                if (n2 != 3) {
                    if (!SvlanCircuitNodeOperator.dbgOn()) return;
                    db.println("createSvlanConnOnNE wrong number of paths: " + n2 + " in: " + iSvlanPathDefModelArray2.length + " out: " + iSvlanPathDefModelArray3.length);
                    return;
                }
                iSvlanPathDefModelArray4 = new ISvlanPathDefModel[3];
                if (iSvlanPathDefModelArray2.length == 2 && iSvlanPathDefModelArray3.length == 1) {
                    iSvlanPathDefModelArray4[0] = iSvlanPathDefModelArray2[0];
                    iSvlanPathDefModelArray4[1] = iSvlanPathDefModelArray2[1];
                    iSvlanPathDefModelArray4[2] = iSvlanPathDefModelArray3[0];
                } else {
                    if (!SvlanCircuitNodeOperator.dbgOn()) return;
                    db.println("createSvlanConnOnNE wrong number of paths: " + n2 + " in: " + iSvlanPathDefModelArray2.length + " out: " + iSvlanPathDefModelArray3.length);
                    return;
                }
            }
            iSvlanConnectionModel = iSvlanCircuitModels.createSvlanConnection(iSvlanPathDefModelArray4, string, false);
            if (iSvlanConnectionModel != null) {
                this.node.setConn((IConnectionModel)iSvlanConnectionModel);
                if (!NetCircuit.isNullCircuitId(iCircuitId)) return;
                this.node.registerNullCircuitConnection(this.node.getNetElement(), iSvlanConnectionModel);
            } else {
                if (!SvlanCircuitNodeOperator.dbgOn()) return;
                db.println("ERROR!!! svlanConn is NULL.");
            }
            return;
        }
    }

    @Override
    protected void modifyConnectionDropsAndSpans() throws CircuitProvError {
        for (NetCircuitEnd netCircuitEnd : this.node.getDrops()) {
            if (netCircuitEnd.getStage() != 2) continue;
            if (SvlanCircuitNodeOperator.dbgOn()) {
                db.println("Adding routed drop to connection");
            }
            try {
                this.node.addOutputToConnModel(netCircuitEnd);
                this.node.addConnectionPathEnd(netCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                if (SvlanCircuitNodeOperator.dbgOn()) {
                    db.println("failed to add output");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "The output to the connection on the node " + this.getName() + " cannot be added.";
                throw new CircuitProvError(string);
            }
            netCircuitEnd.setStage(3);
        }
        for (NetCircuitSpan netCircuitSpan : this.node.getBiSpans()) {
            if (netCircuitSpan.getSrcState() != 2) continue;
            if (SvlanCircuitNodeOperator.dbgOn()) {
                db.println("Adding routed span to connection");
            }
            try {
                this.node.addOutputToConnModel(netCircuitSpan);
                this.node.addConnectionPathEnd(netCircuitSpan);
            }
            catch (CTCUserException cTCUserException) {
                if (SvlanCircuitNodeOperator.dbgOn()) {
                    db.println("failed to add output");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "The output to the connection on the node " + this.getName() + " cannot be added.";
                throw new CircuitProvError(string);
            }
        }
    }

    protected void addOutput(ISvlanPathDefModel iSvlanPathDefModel) throws CTCUserException {
        List list = this.node.getPathList();
        ISvlanPathDefModel[] iSvlanPathDefModelArray = list.toArray(new ISvlanPathDefModel[0]);
        ISvlanCircuitModels iSvlanCircuitModels = this.node.getNodeModel().getSvlanCircuitModels();
        if (SvlanCircuitNodeOperator.dbgOn()) {
            db.print("addOutput @ Node " + this.getName() + " Current paths: ");
            for (int i = 0; i < iSvlanPathDefModelArray.length; ++i) {
                db.print("Path #" + i + ": " + Integer.toHexString(iSvlanPathDefModelArray[i].getPortEntityIdx()) + ", ");
            }
            db.println("Add Path: " + Integer.toHexString(iSvlanPathDefModel.getPortEntityIdx()));
        }
        iSvlanCircuitModels.addRemoveSvlanConnPath(iSvlanPathDefModelArray, iSvlanPathDefModel, false);
        this.addPathsToConnectionModel(iSvlanPathDefModel);
    }

    protected void addPathsToConnectionModel(ISvlanPathDefModel iSvlanPathDefModel) throws CTCUserException {
        ISvlanConnectionModel iSvlanConnectionModel = (ISvlanConnectionModel)this.node.getConn();
        iSvlanConnectionModel.addPath(iSvlanPathDefModel);
    }

    protected void removePathsFromConnectionModel(ISvlanPathDefModel iSvlanPathDefModel) throws CTCUserException {
        ISvlanConnectionModel iSvlanConnectionModel = (ISvlanConnectionModel)this.node.getConn();
        iSvlanConnectionModel.removePath(iSvlanPathDefModel);
    }

    @Override
    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        if (SvlanCircuitNodeOperator.dbgOn()) {
            db.println("deleteDrop called at node " + this.getName());
        }
        int n = this.node.getDrops().size() + this.node.getSources().size();
        int n2 = this.node.getBiSpans().size();
        if (n == 1 && n2 == 1) {
            block26: {
                try {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("deleteDrop() - 1 src/drop & 1 span for node  " + this.getName());
                    }
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("Busy destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionHasFarendLoopback destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberInvalidState destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("InvalidPath destroying a SVLAN connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)invalidPath);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!SvlanCircuitNodeOperator.dbgOn()) break block26;
                    db.println("WrongInterfaceType destroying a SVLAN connection in deleteDrop.");
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
            this.destroyInputs();
        } else {
            try {
                if (SvlanCircuitNodeOperator.dbgOn()) {
                    db.println(n + " endpoints at node " + this.getName());
                }
                this.deleteDropFromConnection((NetCircuitEnd)iNetCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                if (SvlanCircuitNodeOperator.dbgOn()) {
                    db.println("unable to remove drop from connection");
                }
                String string = "The drop from the connection on the node " + this.getName() + " cannot be deleted.";
                throw new DeletionError(string);
            }
            this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
        }
    }

    @Override
    protected void deleteBiSpan(NetCircuitSpan netCircuitSpan) throws DeletionError {
        if (SvlanCircuitNodeOperator.dbgOn()) {
            db.println("deleteBiSpan: Node " + this.getName() + " Span " + netCircuitSpan.prettyString());
        }
        try {
            this.node.removeOutputFromConnModel(netCircuitSpan);
            this.node.updateNumberOfPaths();
        }
        catch (CTCUserException cTCUserException) {
            throw new DeletionError(cTCUserException.getMessage());
        }
        if (netCircuitSpan.isInternalSpan()) {
            if (netCircuitSpan.getLink().getSrcEntityIndex() == ((SvlanCircuitNode)this.node).getInternalEntityIdx()) {
                netCircuitSpan.setSrcState(0);
            } else {
                netCircuitSpan.setDstState(0);
            }
        } else if (netCircuitSpan.getLink().getSrc() == this.node.getNetElement()) {
            netCircuitSpan.setSrcState(0);
        } else {
            netCircuitSpan.setDstState(0);
        }
        this.removeActiveBiSpan(netCircuitSpan);
        int n = this.node.getDrops().size() + this.node.getSources().size();
        int n2 = this.node.getBiSpans().size();
        if (n == 0 && n2 == 1) {
            block36: {
                try {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("deleteBiSpan() - 0 src/drop & 1 span for node  " + this.getName());
                    }
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("Busy destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionHasFarendLoopback destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberInvalidState destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (SvlanCircuitNodeOperator.dbgOn()) {
                        db.println("InvalidPath destroying a SVLAN connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)invalidPath);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!SvlanCircuitNodeOperator.dbgOn()) break block36;
                    db.println("WrongInterfaceType destroying a SVLAN connection in deleteDrop.");
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            for (NetCircuitSpan netCircuitSpan2 : this.node.getBiSpans()) {
                if (netCircuitSpan2.isInternalSpan()) {
                    if (netCircuitSpan2.getLink().getSrcEntityIndex() == ((SvlanCircuitNode)this.node).getInternalEntityIdx()) {
                        netCircuitSpan2.setSrcState(0);
                    } else {
                        netCircuitSpan2.setDstState(0);
                    }
                } else if (netCircuitSpan2.getLink().getSrc() == this.node.getNetElement()) {
                    netCircuitSpan2.setSrcState(0);
                } else {
                    netCircuitSpan2.setDstState(0);
                }
                NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan2);
                netCircuitNode.getOperator().deleteBiSpan(netCircuitSpan2);
                this.node.removeSpan(netCircuitSpan2, eSpanDirection.BIDIRECTIONAL);
            }
        }
    }

    @Override
    protected void destroyInputs() throws DeletionError {
        if (SvlanCircuitNodeOperator.dbgOn()) {
            db.println("destroying inputs at " + this.getName());
        }
        for (NetCircuitSpan netCircuitSpan : this.node.getBiSpans()) {
            if (netCircuitSpan.isInternalSpan()) {
                if (netCircuitSpan.getLink().getSrcEntityIndex() == ((SvlanCircuitNode)this.node).getInternalEntityIdx()) {
                    netCircuitSpan.setSrcState(0);
                } else {
                    netCircuitSpan.setDstState(0);
                }
            } else if (netCircuitSpan.getLink().getSrc() == this.node.getNetElement()) {
                netCircuitSpan.setSrcState(0);
            } else {
                netCircuitSpan.setDstState(0);
            }
            NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan);
            if (netCircuitNode != null) {
                netCircuitNode.getOperator().deleteBiSpan(netCircuitSpan);
            } else if (SvlanCircuitNodeOperator.dbgOn()) {
                db.println("WARNING!!! peernode null");
            }
            this.node.removeSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
    }

    protected void removeOutput(ISvlanPathDefModel iSvlanPathDefModel) throws CTCUserException {
        List list = this.node.getPathList();
        ISvlanPathDefModel[] iSvlanPathDefModelArray = list.toArray(new ISvlanPathDefModel[0]);
        ISvlanCircuitModels iSvlanCircuitModels = this.node.getNodeModel().getSvlanCircuitModels();
        if (SvlanCircuitNodeOperator.dbgOn()) {
            db.print("removeOutput @ Node " + this.getName() + " Current paths: ");
            for (int i = 0; i < iSvlanPathDefModelArray.length; ++i) {
                db.print("Path #" + i + ": " + Integer.toHexString(iSvlanPathDefModelArray[i].getPortEntityIdx()) + ", ");
            }
            db.println("Remove Path: " + Integer.toHexString(iSvlanPathDefModel.getPortEntityIdx()));
        }
        iSvlanCircuitModels.addRemoveSvlanConnPath(iSvlanPathDefModelArray, iSvlanPathDefModel, true);
        this.removePathsFromConnectionModel(iSvlanPathDefModel);
    }

    @Override
    protected void connLocalDestroy(boolean bl) throws WrongInterfaceType, InvalidPath, Busy {
        ISvlanCircuitModels iSvlanCircuitModels = this.node.getNodeModel().getSvlanCircuitModels();
        iSvlanCircuitModels.deleteSvlanConnection((ISvlanConnectionModel)this.getConn());
    }

    protected String prettyString(ISvlanPathDefModel iSvlanPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iSvlanPathDefModel.getPortEntityIdx()) + "::" + iSvlanPathDefModel.getSvlan();
    }

    protected void prettyPrint(ISvlanPathDefModel[] iSvlanPathDefModelArray, String string) {
        for (int i = 0; i < iSvlanPathDefModelArray.length; ++i) {
            db.println(string + " SvlanPath #" + i + " " + this.prettyString(iSvlanPathDefModelArray[i]));
        }
    }
}

