/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.GranularityFilter;
import cerent.cms.route.PathFilterFactory;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.VcatFilter;
import cerent.cms.route.xLinkNotUsable;

public class LoGranularityFilter
extends GranularityFilter {
    public LoGranularityFilter(RoutePrefs routePrefs, VcatFilter vcatFilter) {
        this.prefs = routePrefs;
        this.vcatFilter = vcatFilter;
        this.pathFilter = PathFilterFactory.create(routePrefs, this);
        routePrefs.getLog().getDebugLog().info("LoGranularityFilter: Created");
    }

    @Override
    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        if (this.prefs.getCheckSwitchingGranularity()) {
            if (!sptLink.getLink().isLOCapable()) {
                throw new xLinkNotUsable("Link is not capable of LO circuits");
            }
            if (sptLink.getLink().isLAP() && !this.prefs.getRequiredLinks().contains(sptLink.getLink())) {
                throw new xLinkNotUsable("Link is not capable of LO circuits because this link is VAP but not in required links list");
            }
        } else {
            this.prefs.getLog().getDebugLog().info("LoGranularityFilter: Do not CheckSwitching Granularity");
        }
        return super.isUsable(sptLink);
    }
}

