/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.AbstractLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.util.IHoLoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import java.util.Set;
import java.util.TreeSet;

public class LotLabelSet
extends AbstractLabelSet {
    protected Set loLabels;

    public LotLabelSet() {
        this.labels = new TreeSet();
        this.loLabels = new TreeSet();
    }

    @Override
    public ILabelSet copy() {
        LotLabelSet lotLabelSet = new LotLabelSet();
        lotLabelSet.addLabels(this.getLabelSet());
        return lotLabelSet;
    }

    @Override
    public void addLabel(ILabel iLabel) {
        super.addLabel(iLabel);
        if (iLabel instanceof IHoLoNum) {
            this.loLabels.add(((IHoLoNum)iLabel).getLoNum());
        }
    }

    @Override
    public void addLabels(Set set) {
        super.addLabels(set);
        for (ILabel iLabel : set) {
            if (!(iLabel instanceof IHoLoNum)) continue;
            this.loLabels.add(((IHoLoNum)iLabel).getLoNum());
        }
    }

    public Set getLoLabelSet() {
        return this.loLabels;
    }

    @Override
    public void removeLabel(ILabel iLabel) {
        super.removeLabel(iLabel);
        if (iLabel instanceof IHoLoNum) {
            ILoNum iLoNum = ((IHoLoNum)iLabel).getLoNum();
            this.loLabels.remove(iLoNum);
        }
    }

    @Override
    public void intersect(ILabelSet iLabelSet) {
        int n = 0;
        if (iLabelSet == null) {
            this.labels.clear();
            return;
        }
        ILabel[] iLabelArray = this.labels.toArray(new ILabel[this.labels.size()]);
        ILabel[] iLabelArray2 = iLabelSet.getLabelSet().toArray(new ILabel[iLabelSet.size()]);
        this.labels.clear();
        this.loLabels.clear();
        for (int i = 0; i < iLabelArray.length; ++i) {
            int n2;
            for (n2 = n; n2 < iLabelArray2.length; ++n2) {
                if (iLabelArray[i].compareTo((Object)iLabelArray2[n2]) == 0) {
                    this.labels.add(iLabelArray[i]);
                    if (!(iLabelArray[i] instanceof IHoLoNum)) break;
                    this.loLabels.add(((IHoLoNum)iLabelArray[i]).getLoNum());
                    break;
                }
                if (iLabelArray2[n2].compareTo((Object)iLabelArray[i]) > 0) break;
            }
            n = n2;
        }
    }

    @Override
    public void intersectSelf(ILabelSet iLabelSet) {
        if (iLabelSet == null) {
            this.loLabels.clear();
            this.labels.clear();
            return;
        }
        if (iLabelSet instanceof LotLabelSet) {
            this.loLabels.retainAll(((LotLabelSet)iLabelSet).loLabels);
            ((LotLabelSet)iLabelSet).loLabels.retainAll(this.loLabels);
            this.intersectLabels();
            ((LotLabelSet)iLabelSet).intersectLabels();
        }
    }

    private void intersectLabels() {
        Set set = this.getLabelSet();
        ILabel[] iLabelArray = set.toArray(new ILabel[set.size()]);
        set.clear();
        for (int i = 0; i < iLabelArray.length; ++i) {
            IHoLoNum iHoLoNum;
            ILoNum iLoNum;
            if (!(iLabelArray[i] instanceof IHoLoNum) || !this.loLabels.contains(iLoNum = (iHoLoNum = (IHoLoNum)iLabelArray[i]).getLoNum())) continue;
            set.add(iHoLoNum);
        }
    }
}

