/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ILmpCtrlChannelModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAdv;
import cerent.cms.model.IOspfLSA;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.topo.IPartitioner;
import cerent.cms.topo.ManualPartitioner;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.cms.topo.TopologyAgent;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.SDebug;
import cerent.util.proxy.CtcProxyFactory;
import java.net.InetAddress;

public abstract class AbstractNodeIpPartitioner
implements IPartitioner {
    protected static final IIPAddressTranslator trans = IPAddressTranslator.instance();
    public static final int UNDEFINED_AREA_ID = -1;
    private static final SDebug sdb = new SDebug("Partitioner");
    private SDebug db;

    protected static String toActual(String string) {
        return trans.getActualAddressDisplay(string);
    }

    protected static String toActual(IIpAddr iIpAddr) {
        return AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iIpAddr));
    }

    protected AbstractNodeIpPartitioner(SDebug sDebug) {
        this.db = sDebug == null ? sdb : sDebug;
    }

    protected AbstractNodeIpPartitioner() {
        this.db = sdb;
    }

    @Override
    public boolean isEnabled() {
        return ManualPartitioner.isPartitionerEnabled();
    }

    protected boolean isMember(IIpAddr iIpAddr, int n, long l, boolean bl) {
        boolean bl2;
        block3: {
            if (iIpAddr == null) {
                return true;
            }
            String string = AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iIpAddr));
            bl2 = false;
            Network network = Network.instance();
            try {
                bl2 = network.findNetElemByIp(string) != null ? true : this.isMember(string, n, l, bl);
            }
            catch (RuntimeException runtimeException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)runtimeException);
            }
        }
        return bl2;
    }

    protected abstract boolean isMember(String var1, int var2, long var3, boolean var5);

    protected abstract String getAllMembers();

    @Override
    public final boolean isMember(IOspfLSA iOspfLSA, IOspfAdv iOspfAdv, long l, TopologyAgent topologyAgent) {
        int n;
        boolean bl = true;
        IIpAddr iIpAddr = null;
        String string = "null";
        if (iOspfLSA != null) {
            iIpAddr = iOspfLSA.getNodeIp();
            n = iOspfLSA.getNodeId();
            bl = this.isMember(iIpAddr, n, l, false);
            string = Topology.IpAddrString(iIpAddr);
            this.processCandidate(AbstractNodeIpPartitioner.toActual(string), n, bl);
        }
        if (bl && iOspfAdv != null) {
            iIpAddr = iOspfAdv.getNodeIp();
            n = iOspfAdv.getNodeId();
            bl = this.isMember(iIpAddr, n, l, false);
            this.processCandidate(AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iIpAddr)), n, bl);
        }
        this.postProcess(iOspfLSA, iOspfAdv, l);
        if (this.db.isFinestEnabled()) {
            String string2 = "LSA for " + string;
            String string3 = iOspfAdv != null ? AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iOspfAdv.getNodeIp())) : "null";
            this.db.finest("isMember(" + string2 + ", " + string3 + ", " + l + ") returned: " + bl);
        }
        return bl;
    }

    @Override
    public boolean isMember(ILmpCtrlChannelModel iLmpCtrlChannelModel, INodeModel iNodeModel) {
        String string;
        boolean bl;
        block12: {
            bl = true;
            String string2 = null;
            Network network = Network.instance();
            if (iNodeModel != null) {
                int n = iNodeModel.getNodeId();
                string2 = AbstractNodeIpPartitioner.toActual(this.getIIpAddr(iNodeModel.getIpConfig(), iNodeModel.getSecureIpConfig()));
                bl = network.findNetElemByIp(string2) != null ? true : this.isMember(string2, n, -1L, false);
                this.processCandidate(string2, n, bl);
            }
            string = "???";
            try {
                if (bl && iLmpCtrlChannelModel != null) {
                    if (iLmpCtrlChannelModel.isRemoteCrs()) {
                        boolean bl2;
                        string = AbstractNodeIpPartitioner.toActual(iLmpCtrlChannelModel.getIRemoteNodeIpAddress());
                        int n = -1;
                        if (network.findNetElemByIp(string) != null) {
                            bl &= true;
                            bl2 = true;
                        } else {
                            bl2 = this.isMember(string, n, -1L, true);
                            bl &= bl2;
                        }
                        this.processCandidate(string, n, bl2);
                    } else {
                        if (this.db.on()) {
                            this.db.println("WARNING!!! isMember: remote node is  not CRS1");
                        }
                        bl &= false;
                    }
                }
            }
            catch (Exception exception) {
                bl &= false;
                if (!this.db.on()) break block12;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.postProcess(iLmpCtrlChannelModel, iNodeModel);
        if (this.db.isFinestEnabled()) {
            String string3;
            if (iLmpCtrlChannelModel == null) {
                string3 = "null";
            } else {
                String string4;
                int n = (string4 = iLmpCtrlChannelModel.getClass().getName()).lastIndexOf(".");
                string3 = string4.substring(n < 0 ? 0 : n + 1);
                string3 = string3 + " to peer: " + string;
            }
            this.db.finest("isMember(" + string3 + ", " + (iNodeModel == null ? "null" : iNodeModel.getName()) + ") returned: " + bl);
        }
        return bl;
    }

    @Override
    public boolean isMember(IServerTrailEnd iServerTrailEnd, INodeModel iNodeModel) {
        boolean bl = true;
        String string = null;
        Network network = Network.instance();
        if (iNodeModel != null) {
            int n = iNodeModel.getNodeId();
            string = AbstractNodeIpPartitioner.toActual(this.getIIpAddr(iNodeModel.getIpConfig(), iNodeModel.getSecureIpConfig()));
            bl = network.findNetElemByIp(string) != null ? true : this.isMember(string, n, -1L, false);
            this.processCandidate(string, n, bl);
        }
        String string2 = "???";
        if (bl && iServerTrailEnd != null) {
            boolean bl2;
            string2 = AbstractNodeIpPartitioner.toActual(iServerTrailEnd.getPeerIpAddr());
            int n = -1;
            if (network.findNetElemByIp(string2) != null) {
                bl &= true;
                bl2 = true;
            } else {
                bl2 = this.isMember(string2, n, -1L, false);
                bl &= bl2;
            }
            this.processCandidate(string2, n, bl2);
        }
        this.postProcess(iServerTrailEnd, iNodeModel);
        if (this.db.isFinestEnabled()) {
            String string3;
            if (iServerTrailEnd == null) {
                string3 = "null";
            } else {
                String string4;
                int n = (string4 = iServerTrailEnd.getClass().getName()).lastIndexOf(".");
                string3 = string4.substring(n < 0 ? 0 : n + 1);
                string3 = string3 + " to peer: " + string2;
            }
            this.db.finest("isMember(" + string3 + ", " + (iNodeModel == null ? "null" : iNodeModel.getName()) + ") returned: " + bl);
        }
        return bl;
    }

    @Override
    public boolean isMember(IVirtualLinkModel iVirtualLinkModel, INodeModel iNodeModel) {
        boolean bl = true;
        String string = null;
        Network network = Network.instance();
        if (iNodeModel != null) {
            string = AbstractNodeIpPartitioner.toActual(this.getIIpAddr(iNodeModel.getIpConfig(), iNodeModel.getSecureIpConfig()));
            int n = iNodeModel.getNodeId();
            bl = network.findNetElemByIp(string) != null ? true : this.isMember(string, n, -1L, false);
            this.processCandidate(string, n, bl);
        }
        String string2 = "???";
        String string3 = "???";
        if (bl && iVirtualLinkModel != null) {
            boolean bl2;
            string2 = AbstractNodeIpPartitioner.toActual(iVirtualLinkModel.getOrigNode());
            int n = -1;
            if (network.findNetElemByIp(string2) != null) {
                bl &= true;
                bl2 = true;
            } else {
                bl2 = this.isMember(string2, n, -1L, false);
                bl &= bl2;
            }
            this.processCandidate(string2, n, bl2);
            string3 = AbstractNodeIpPartitioner.toActual(iVirtualLinkModel.getTermNode());
            if (network.findNetElemByIp(string3) != null) {
                bl &= true;
                bl2 = true;
            } else {
                bl2 = this.isMember(string3, n, -1L, false);
                bl &= bl2;
            }
            this.processCandidate(string3, n, bl2);
        }
        this.postProcess(iVirtualLinkModel, iNodeModel);
        if (this.db.isFinestEnabled()) {
            String string4;
            if (iVirtualLinkModel == null) {
                string4 = "null";
            } else {
                String string5;
                int n = (string5 = iVirtualLinkModel.getClass().getName()).lastIndexOf(".");
                string4 = string5.substring(n < 0 ? 0 : n + 1);
                string4 = string4 + "from orig: " + string2 + " to term: " + string3;
            }
            this.db.finest("isMember(" + string4 + ", " + (iNodeModel == null ? "null" : iNodeModel.getName()) + ") returned: " + bl);
        }
        return bl;
    }

    protected IIpAddr getIIpAddr(IIpConfig iIpConfig, ISecureIpConfig iSecureIpConfig) {
        IIpAddr iIpAddr = null;
        if (iIpConfig != null) {
            boolean bl = CtcProxyFactory.isIPv6Network();
            iIpAddr = bl && iIpConfig.getNodeMode() ? iIpConfig.getIpv6Address() : (iSecureIpConfig != null ? iSecureIpConfig.getIpAddress() : iIpConfig.getIpAddress());
        }
        return iIpAddr;
    }

    @Override
    public void lastMember(long l, TopologyAgent topologyAgent) {
        if (this.db.on()) {
            String string = topologyAgent == null ? "null" : topologyAgent.getTopoHost().getActualAddressDisplay();
            this.db.println("AbstractIpPartitioner.lastMember(" + l + ", for topo host: " + string + ") enter");
        }
    }

    @Override
    public void lastMember(INodeModel iNodeModel, IPartitioner.AdjacencyType adjacencyType) {
        if (this.db.on()) {
            this.db.println("AbstractIpPartitioner.lastMember('" + (iNodeModel == null ? "null" : iNodeModel.getName()) + "', " + (Object)((Object)adjacencyType) + ") enter");
        }
    }

    @Override
    public boolean areNodesInSameTopo(InetAddress inetAddress, InetAddress inetAddress2) {
        return false;
    }

    protected void processCandidate(String string, int n, boolean bl) {
    }

    protected void postProcess(IOspfLSA iOspfLSA, IOspfAdv iOspfAdv, long l) {
    }

    protected void postProcess(IServerTrailEnd iServerTrailEnd, INodeModel iNodeModel) {
    }

    protected void postProcess(ILmpCtrlChannelModel iLmpCtrlChannelModel, INodeModel iNodeModel) {
    }

    protected void postProcess(IVirtualLinkModel iVirtualLinkModel, INodeModel iNodeModel) {
    }

    static void initBuiltInPartitionerIfConfigured(Network network) {
        ManualPartitioner.initBuiltInPartitionerIfConfigured(network);
    }
}

