/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LinkStateMachine;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.List;

public abstract class NonRoutableNetLink
extends AbstractNetLink {
    private boolean checking;
    private long ospfAreaId;
    protected boolean isSrcDwdmPort;
    protected boolean isDstDwdmPort;
    private boolean isSpliced;
    protected LinkStateMachine linkStateMc;

    protected NonRoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new NonRoutableNetLink");
        }
        this.isSpliced = false;
    }

    @Override
    protected void initializeDebug() {
        this.db = new NonRoutableNetLinkDebug("NLn" + NonRoutableNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + NonRoutableNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
    }

    public int getSrcSlot() {
        return this.srcSlot;
    }

    public int[] getSrcPort() {
        return this.srcPort;
    }

    public int getDstSlot() {
        return this.dstSlot;
    }

    public int[] getDstPort() {
        return this.dstPort;
    }

    public boolean isSrcDwdmPort() {
        return this.isSrcDwdmPort;
    }

    public boolean isDstDwdmPort() {
        return this.isDstDwdmPort;
    }

    public boolean isValid() {
        if (this.isDeleted()) {
            return false;
        }
        INetLink iNetLink = this.net.findReverseLink(this);
        if (iNetLink != null && iNetLink.isDeleted()) {
            return false;
        }
        return this.srcSlot != 0 && this.srcPort.length > 0 && this.dstSlot != 0 && this.dstPort.length > 0;
    }

    public boolean isSpliced() {
        return this.isSpliced;
    }

    public void setIsSpliced(boolean bl) {
        this.isSpliced = bl;
    }

    @Override
    public int state() {
        return this.linkModel.state();
    }

    @Override
    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (this.db.on()) {
            this.db.println("newState: state = " + (n == 1 ? "Up" : "Down."));
        }
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (this.linkStateMc != null) {
                if (n == 2) {
                    this.linkStateMc.driveSm(8);
                } else if (n == 1) {
                    this.linkStateMc.driveSm(9);
                }
            }
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    protected void oldState(int n) {
    }

    @Override
    protected void setChecking(boolean bl) {
        this.checking = bl;
    }

    @Override
    protected boolean inChecking() {
        return this.checking;
    }

    @Override
    public void setOspfAreaId(long l) {
        this.ospfAreaId = l;
    }

    @Override
    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    @Override
    public boolean isRoutable() {
        return false;
    }

    @Override
    public boolean isBlsrCapable() {
        return false;
    }

    @Override
    protected void refresh(int n, String string, byte by, int n2, int n3, int n4, int n5) {
        this.setProtectionType(n);
    }

    @Override
    protected void acquireSrcSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block17: {
            iNodeModel = this.getSrc().getNodeModel();
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getSrcEntityIndex());
                    if (iEntityModel != null) {
                        this.srcSlot = iEntityModel.getSlot();
                        this.srcPort = AbstractNetLink.getPortNum(iEntityModel);
                        if (this.db.on()) {
                            this.db.println("acquireSrcSlotAndPort: SRC slot => " + this.srcSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.srcPort));
                        }
                        if (iEntityModel instanceof IDwdmPortModel) {
                            if (((IDwdmPortModel)iEntityModel).isClientPort()) {
                                if (this.db.on()) {
                                    this.db.println("acquireSrcSlotAndPort: SRC DWDM Client port");
                                }
                                this.isSrcDwdmPort = false;
                            } else {
                                if (this.db.on()) {
                                    this.db.println("acquireSrcSlotAndPort: SRC DWDM Trunk port");
                                }
                                this.isSrcDwdmPort = true;
                            }
                        }
                        if (this.srcSlot != 0 && this.srcPort.length > 0) {
                            iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                            this.setChanged();
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = true;
                if (!this.db.on()) break block17;
                this.db.println("acquireSrcSlotAndPort: entity index invalid");
            }
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireSrcSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireSrcSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    @Override
    protected void acquireDstSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block17: {
            iNodeModel = this.getDst().getNodeModel();
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getDstEntityIndex());
                    if (iEntityModel != null) {
                        this.dstSlot = iEntityModel.getSlot();
                        this.dstPort = AbstractNetLink.getPortNum(iEntityModel);
                        if (this.db.on()) {
                            this.db.println("acquireDstSlotAndPort: DST slot => " + this.dstSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.dstPort));
                        }
                        if (iEntityModel instanceof IDwdmPortModel) {
                            if (((IDwdmPortModel)iEntityModel).isClientPort()) {
                                if (this.db.on()) {
                                    this.db.println("acquireDstSlotAndPort: DST DWDM Client port");
                                }
                                this.isDstDwdmPort = false;
                            } else {
                                if (this.db.on()) {
                                    this.db.println("acquireDstSlotAndPort: DST DWDM Trunk port");
                                }
                                this.isDstDwdmPort = true;
                            }
                        }
                        if (this.srcSlot != 0 && this.srcPort.length > 0) {
                            iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                            this.setChanged();
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = true;
                if (!this.db.on()) break block17;
                this.db.println("acquireDstSlotAndPort: entity index invalid");
            }
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireDstSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireDstSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    @Override
    public String prettyString() {
        return super.prettyString() + " " + this.getPhysicalTypeObj().getDisplayString(this.isSonetCapable());
    }

    @Override
    public List getAvailableHoNumbers(int n, int n2) {
        return null;
    }

    @Override
    public List getAvailableLoNumbers(IHoNum iHoNum, int n) {
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.net != null) {
            this.net.delete(this);
        }
    }

    public class NonRoutableNetLinkDebug
    extends SDebug {
        public NonRoutableNetLinkDebug(String string) {
            super(string);
        }

        public final void dump() {
            NonRoutableNetLink.this.db.println("======================================");
            NonRoutableNetLink.this.db.println("Src = " + NonRoutableNetLink.this.src.getHostName());
            NonRoutableNetLink.this.db.println("Dst = " + NonRoutableNetLink.this.dst.getHostName());
            NonRoutableNetLink.this.db.println("State = " + (NonRoutableNetLink.this.newState() == 1 ? "Up" : "Down"));
            NonRoutableNetLink.this.db.println("Topology ID = " + NonRoutableNetLink.this.topoId);
            if (NonRoutableNetLink.this.linkStateMc != null) {
                NonRoutableNetLink.this.db.println("src state = " + NonRoutableNetLink.this.linkStateMc.getCurrentSrcStateAsString());
                NonRoutableNetLink.this.db.println("dst state = " + NonRoutableNetLink.this.linkStateMc.getCurrentDstStateAsString());
            } else {
                NonRoutableNetLink.this.db.println("src state = Unknown");
                NonRoutableNetLink.this.db.println("dst state = Unknown");
            }
            NonRoutableNetLink.this.db.println("NetLink Type = " + NonRoutableNetLink.this.getLinkTypeObj());
            NonRoutableNetLink.this.db.println("Protection Type = " + NonRoutableNetLink.this.getProtectionTypeObj());
            NonRoutableNetLink.this.db.println("Physical Type = " + NonRoutableNetLink.this.getPhysicalTypeObj().getDisplayString(NonRoutableNetLink.this.isSonetCapable()));
            NonRoutableNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString(ILinkType.class, (int)NonRoutableNetLink.this.getPhysicalLinkType()));
            NonRoutableNetLink.this.db.println("Src XC Capable = " + NonRoutableNetLink.this.isXcCapable());
            NonRoutableNetLink.this.db.println("Dst XC Capable = " + NonRoutableNetLink.this.isNbrXcCapable());
            NonRoutableNetLink.this.db.println("Src Slot = " + NonRoutableNetLink.this.srcSlot);
            NonRoutableNetLink.this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])NonRoutableNetLink.this.srcPort));
            NonRoutableNetLink.this.db.println("Dst Slot = " + NonRoutableNetLink.this.dstSlot);
            NonRoutableNetLink.this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])NonRoutableNetLink.this.dstPort));
            NonRoutableNetLink.this.db.println("SRC DWDM = " + NonRoutableNetLink.this.isSrcDwdmPort);
            NonRoutableNetLink.this.db.println("DST DWDM = " + NonRoutableNetLink.this.isDstDwdmPort);
            NonRoutableNetLink.this.db.println("Cost = " + NonRoutableNetLink.this.linkModel.cost());
            NonRoutableNetLink.this.db.println("Spliced = " + NonRoutableNetLink.this.isSpliced);
        }

        public final void dumpLSMState() {
            NonRoutableNetLink.this.db.println("=============================");
            if (NonRoutableNetLink.this.linkStateMc != null) {
                NonRoutableNetLink.this.db.println("src state = " + NonRoutableNetLink.this.linkStateMc.getCurrentSrcStateAsString());
                NonRoutableNetLink.this.db.println("dst state = " + NonRoutableNetLink.this.linkStateMc.getCurrentDstStateAsString());
            } else {
                NonRoutableNetLink.this.db.println("src state = Unknown");
                NonRoutableNetLink.this.db.println("dst state = Unknown");
            }
        }

        public final void dumpObservers() {
            NonRoutableNetLink.this.db.println("======================================");
            NonRoutableNetLink.this.db.println("NonRoutableNetLink Observers:");
            NonRoutableNetLink.this.printObservers();
        }
    }
}

