/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.SvlanLinksRouteManager;
import cerent.cms.topo.Topology;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.LinkedList;

public class OchTrailTunnelNetLink
extends NetLink {
    private LinkedList fromSrcList;
    private LinkedList fromDstList;

    public OchTrailTunnelNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2, INetCircuit iNetCircuit) {
        super(network, iLinkModel, iNetElement, iNetElement2, topology, n, bl, linkedList, linkedList2, iNetCircuit);
        if (OchTrailHelper.isProtected(this.getSrc().getNodeModel(), this.getSrcEntityIndex())) {
            this.fillLinkedLists();
        }
    }

    @Override
    protected void initializeDebug() {
        this.db = new NetLink.NetLinkDebug(this, "NLv" + OchTrailTunnelNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + OchTrailTunnelNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
        if (this.db.on()) {
            this.db.println("NetLink: creating new OchTrail Tunnel NetLink");
        }
    }

    @Override
    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable: Link : " + this.prettyString());
        }
        for (Object object : this.getLinksList()) {
            if (object.state() != 1) {
                throw new xLinkNotUsable("Link is Not UP");
            }
            if (!object.getDst().getConnectionState()) {
                throw new xLinkNotUsable("DstLink is not in UP state");
            }
            if (object.getSrc().getConnectionState()) continue;
            throw new xLinkNotUsable("SrcLink is not in UP state");
        }
        this.containsSrg(routePrefs.getExcludeSrgs());
        if (routePrefs.isSvlanCircuit()) {
            Object object;
            object = new SvlanLinksRouteManager(this, this.db);
            return ((SvlanLinksRouteManager)object).isUsable(routePrefs, iNetLink);
        }
        if (routePrefs.isOchccCircuit()) {
            if (!this.getSrc().getConnectionState() || !this.getDst().getConnectionState()) throw new xLinkNotUsable("Src/DstLink is not in UP state");
            if (!this.getSrc().equals(routePrefs.getSrc()) || !this.getDst().equals(routePrefs.getDst())) throw new xLinkNotUsable("Link between " + this.getSrc().getName() + " and " + this.getDst().getName() + " cannot be used for ckt between " + routePrefs.getSrc().getName() + " and " + routePrefs.getDst().getName());
            if (OchTrailHelper.areTrunkAndClientCoLocated(this.getSrc(), routePrefs.getcktSrcEntityIndex(), this.getSrcEntityIndex()) && OchTrailHelper.areTrunkAndClientCoLocated(this.getDst(), routePrefs.getcktDstEntityIndex(), this.getDstEntityIndex())) return true;
            throw new xLinkNotUsable("Link srcId is " + Integer.toHexString(this.getSrcEntityIndex()) + ", but ckt srcId is " + Integer.toHexString(routePrefs.getcktSrcEntityIndex()));
        }
        if (!this.isLinkOnADMoaB()) throw new xLinkNotUsable("Link does not start/end over an ADM card.");
        if (routePrefs.getCircuitType() == 3 || routePrefs.getCircuitType() == 6) {
            return true;
        }
        this.checkADMoaBConstraints(routePrefs, iNetLink);
        return true;
    }

    private void fillLinkedLists() {
        this.fromSrcList = new LinkedList();
        this.fromDstList = new LinkedList();
        INetLink iNetLink2 = null;
        boolean bl = true;
        boolean bl2 = true;
        for (INetLink iNetLink2 : this.linksList) {
            if (iNetLink2 instanceof InternalNetLink) continue;
            LinkData linkData = null;
            if (bl && (linkData = this.isStartSrcLink(iNetLink2)) != null) {
                this.findFromSrcLinks(iNetLink2, linkData.previousNode, linkData.nextNode);
                bl = false;
            }
            if (bl2 && (linkData = this.isStartDstLink(iNetLink2)) != null) {
                this.findFromDstLinks(iNetLink2, linkData.previousNode, linkData.nextNode);
                bl2 = false;
            }
            if (bl || bl2) continue;
            break;
        }
    }

    private LinkData isStartSrcLink(INetLink iNetLink) {
        block6: {
            try {
                IEntityTableModel iEntityTableModel;
                IEntityModel iEntityModel;
                if (iNetLink.getSrc().equals(this.getSrc())) {
                    IEntityTableModel iEntityTableModel2 = iNetLink.getDst().getNodeModel().getEntityTable();
                    IEntityModel iEntityModel2 = iEntityTableModel2.getEntityModelByIndex(iNetLink.getDstEntityIndex());
                    if (OchPortsHelper.isPortTypeRx(iEntityModel2)) {
                        return new LinkData(iNetLink.getSrc().getNodeModel(), iNetLink.getDst().getNodeModel());
                    }
                } else if (iNetLink.getDst().equals(this.getSrc()) && OchPortsHelper.isPortTypeRx(iEntityModel = (iEntityTableModel = iNetLink.getSrc().getNodeModel().getEntityTable()).getEntityModelByIndex(iNetLink.getSrcEntityIndex()))) {
                    return new LinkData(iNetLink.getDst().getNodeModel(), iNetLink.getSrc().getNodeModel());
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return null;
    }

    private LinkData isStartDstLink(INetLink iNetLink) {
        block4: {
            try {
                IEntityTableModel iEntityTableModel;
                IEntityModel iEntityModel;
                if (iNetLink.getSrc().equals(this.getDst()) && OchPortsHelper.isPortTypeRx(iEntityModel = (iEntityTableModel = iNetLink.getDst().getNodeModel().getEntityTable()).getEntityModelByIndex(iNetLink.getDstEntityIndex()))) {
                    return new LinkData(iNetLink.getSrc().getNodeModel(), iNetLink.getDst().getNodeModel());
                }
                if (iNetLink.getDst().equals(this.getDst()) && OchPortsHelper.isPortTypeRx(iEntityModel = (iEntityTableModel = iNetLink.getSrc().getNodeModel().getEntityTable()).getEntityModelByIndex(iNetLink.getSrcEntityIndex()))) {
                    return new LinkData(iNetLink.getDst().getNodeModel(), iNetLink.getSrc().getNodeModel());
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return null;
    }

    private void findFromSrcLinks(INetLink iNetLink, INodeModel iNodeModel, INodeModel iNodeModel2) {
        if (this.db.on()) {
            this.db.print("Adding in srcList the Link started from src of Tunnel: " + iNetLink);
        }
        this.fromSrcList.add(iNetLink);
        if (iNodeModel2.equals(this.getDst().getNodeModel())) {
            return;
        }
        INetLink iNetLink2 = this.searchNextNetLink(iNodeModel, iNodeModel2);
        if (iNetLink2.getSrc().getNodeModel().equals(iNodeModel2)) {
            iNodeModel = iNodeModel2;
            iNodeModel2 = iNetLink2.getDst().getNodeModel();
        } else {
            iNodeModel = iNetLink2.getDst().getNodeModel();
            iNodeModel2 = iNetLink2.getSrc().getNodeModel();
        }
        if (iNetLink2 != null) {
            this.findFromSrcLinks(iNetLink2, iNodeModel, iNodeModel2);
        }
    }

    private INetLink searchNextNetLink(INodeModel iNodeModel, INodeModel iNodeModel2) {
        INodeModel iNodeModel3 = iNodeModel2;
        INodeModel iNodeModel4 = null;
        INodeModel iNodeModel5 = null;
        for (INetLink iNetLink : this.linksList) {
            if (iNetLink instanceof InternalNetLink) continue;
            iNodeModel4 = iNetLink.getSrc().getNodeModel();
            iNodeModel5 = iNetLink.getDst().getNodeModel();
            if (!(iNodeModel4.equals(iNodeModel3) && !OchPortsHelper.isPortTypeRx(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex()) ? !iNodeModel5.equals(iNodeModel) : iNodeModel5.equals(iNodeModel3) && !OchPortsHelper.isPortTypeRx(iNetLink.getDst().getNodeModel(), iNetLink.getDstEntityIndex()) && !iNodeModel4.equals(iNodeModel))) continue;
            return iNetLink;
        }
        return null;
    }

    private void findFromDstLinks(INetLink iNetLink, INodeModel iNodeModel, INodeModel iNodeModel2) {
        if (this.db.on()) {
            this.db.print("Adding in dstList the Link started from dst of Tunnel: " + iNetLink);
        }
        this.fromDstList.add(iNetLink);
        if (iNodeModel2.equals(this.getSrc().getNodeModel())) {
            return;
        }
        INetLink iNetLink2 = this.searchNextNetLink(iNodeModel, iNodeModel2);
        if (iNetLink2.getSrc().getNodeModel().equals(iNodeModel2)) {
            iNodeModel = iNodeModel2;
            iNodeModel2 = iNetLink2.getDst().getNodeModel();
        } else {
            iNodeModel = iNetLink2.getDst().getNodeModel();
            iNodeModel2 = iNetLink2.getSrc().getNodeModel();
        }
        if (iNetLink2 != null) {
            this.findFromDstLinks(iNetLink2, iNodeModel, iNodeModel2);
        }
    }

    public boolean isActive(INetLink iNetLink) {
        boolean bl = false;
        if (this.fromDstList == null) {
            return true;
        }
        if (this.fromSrcList.contains(iNetLink)) {
            if (OchTrailHelper.isActivePort(this.getDst().getNodeModel(), this.getDstEntityIndex())) {
                bl = true;
            }
        } else if (this.fromDstList.contains(iNetLink)) {
            if (OchTrailHelper.isActivePort(this.getSrc().getNodeModel(), this.getSrcEntityIndex())) {
                bl = true;
            }
        } else if (this.db.on()) {
            this.db.println("Link not found in any list, link:" + iNetLink + " - Tunnel: " + this);
        }
        if (this.db.on()) {
            if (bl) {
                this.db.println("The Link: " + iNetLink + " is directed to an active Trunk");
            } else {
                this.db.println("The Link: " + iNetLink + " is directed to a standby Trunk");
            }
        }
        return bl;
    }

    private class LinkData {
        INodeModel previousNode;
        INodeModel nextNode;

        LinkData(INodeModel iNodeModel, INodeModel iNodeModel2) {
            this.previousNode = iNodeModel;
            this.nextNode = iNodeModel2;
        }
    }
}

