/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AddNode2OnePlusOneModel;
import cerent.cms.model.Feature;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AddNode2OnePlusOneDialog;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WizardPane;
import cerent.util.IPAddressTranslator;
import cerent.util.NEMC;
import cerent.util.gui.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AndNodePane
extends WizardPane
implements ActionListener {
    private AddNode2OnePlusOneDialog parent;
    ButtonGroup radioButtonGroup = new ButtonGroup();
    JRadioButton byNodeNameRB = new JRadioButton("Or select from the following nodes:");
    JRadioButton byHostNameRB = new JRadioButton("Enter the node host name or Node address: ");
    JComboBox nodeNameCB = new JComboBox();
    JTextField hostNameTF = new JTextField();
    boolean byNodeNameSelected = false;

    public AndNodePane(String string, AddNode2OnePlusOneDialog addNode2OnePlusOneDialog) {
        super(string, addNode2OnePlusOneDialog);
        this.parent = addNode2OnePlusOneDialog;
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchorWest();
        gridBagPanel.inset(5, 10);
        this.radioButtonGroup.add(this.byHostNameRB);
        this.byHostNameRB.addActionListener(this);
        this.radioButtonGroup.add(this.byNodeNameRB);
        this.byNodeNameRB.addActionListener(this);
        gridBagPanel.add((Component)this.byHostNameRB, 1, 1);
        gridBagPanel.fill(2, 40);
        gridBagPanel.add((Component)this.hostNameTF, 2, 1);
        this.hostNameTF.setEnabled(false);
        this.hostNameTF.setText("None");
        gridBagPanel.fillNone();
        gridBagPanel.add((Component)this.byNodeNameRB, 1, 2);
        gridBagPanel.fill(2, 40);
        gridBagPanel.add((Component)this.nodeNameCB, 2, 2);
        gridBagPanel.add((Component)new JPanel(), 3, 1);
        gridBagPanel.add((Component)new JPanel(), 3, 2);
        this.nodeNameCB.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add(gridBagPanel, "Center");
    }

    private void calculateEnabledStatus() {
        if (this.byHostNameRB.isSelected()) {
            if (this.hostNameTF.getText().equals("None")) {
                this.hostNameTF.setText("");
            }
            this.hostNameTF.setEnabled(true);
            this.nodeNameCB.setEnabled(false);
            this.byNodeNameSelected = false;
        } else if (this.byNodeNameRB.isSelected()) {
            if (this.hostNameTF.getText().equals("")) {
                this.hostNameTF.setText("None");
            }
            this.hostNameTF.setEnabled(false);
            this.nodeNameCB.setEnabled(true);
            this.byNodeNameSelected = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.byHostNameRB || actionEvent.getSource() == this.byNodeNameRB) {
            this.calculateEnabledStatus();
        }
    }

    @Override
    public void refresh() {
        this.parent.setBackEnabled(true);
        this.parent.setNextEnabled(true);
        this.parent.setCancelEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validatePage() throws Exception {
        if (AndNodePane.db.on) {
            db.println("validatePage() called");
        }
        Object object = "";
        object = this.byNodeNameSelected ? this.nodeNameCB.getSelectedItem() : this.hostNameTF.getText();
        if (object == null || object.toString().length() == 0) {
            throw new Exception("Please specify the node to add.");
        }
        String string = object.toString();
        if (object instanceof DataItem) {
            string = ((DataItem)object).hostName;
        } else {
            try {
                string = InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new Exception("A node could not be found with the hostname or IP address \"" + string + "\".");
            }
        }
        if (string.equals(this.parent.netLink.getLinkModel().src().getHostName()) || string.equals(this.parent.netLink.getLinkModel().dst().getHostName())) {
            throw new Exception(object + " is already in the 1+1 protection scheme.");
        }
        Network network = Network.instance();
        INetElement iNetElement = network.findNetElemByIp(string);
        boolean bl = true;
        AddNode2OnePlusOneModel addNode2OnePlusOneModel = AddNode2OnePlusOneModel.instance();
        if (iNetElement == null) {
            bl = false;
            if (!network.isAddingNetEleCompleted()) {
                String string2 = NEMC.EID_CAN_NOT_ADD_NODE.getMessage();
                throw new Exception(string2);
            }
            NetworkModel.instance().addNetElement(string, null, null);
            try {
                this.parent.setCursor(new Cursor(3));
                for (int i = 0; i < 10; ++i) {
                    iNetElement = network.findNetElemByIp(string);
                    if (iNetElement != null && iNetElement.getNodeModel().isInited()) {
                        break;
                    }
                    Thread.sleep(1000L);
                }
            }
            finally {
                this.parent.setCursor(new Cursor(0));
            }
        }
        this.parent.newNodeName = object.toString();
        this.parent.newHostName = IPAddressTranslator.instance().getActualAddress(string) != null ? IPAddressTranslator.instance().getActualAddress(string).getHostAddress() : string;
        if (!iNetElement.getNodeModel().isInited()) {
            this.parent.setNodeUnreachable(true);
            this.parent.addUnreachableInfoPane("Node " + object + " Unreachable");
            return;
        }
        if (!bl && !iNetElement.getNodeModel().provides(Feature.ADDNODE2OPO)) {
            NetworkModel.instance().deleteNetElement(iNetElement, this.parent.nmap);
            throw new Exception("The software load on " + object + " does not support the addition of a node to a 1+1 protection group.");
        }
        if (!bl && !addNode2OnePlusOneModel.isNodeValidForUpgrade(iNetElement.getNodeModel(), this.parent.netLink.getLinkModel())) {
            NetworkModel.instance().deleteNetElement(iNetElement, this.parent.nmap);
            throw new Exception(object + " does not have enough optical ports.");
        }
        this.parent.newNetElement = iNetElement;
        this.parent.setNodeUnreachable(false);
        this.parent.addPortPane();
    }

    @Override
    protected String getStatusText() {
        if (AndNodePane.db.on) {
            db.println("getStatusText() called");
        }
        return "-Add node " + this.parent.newNodeName + "\n";
    }

    @Override
    public void enteringPage() {
        Object object;
        if (AndNodePane.db.on) {
            db.println("enteringPage() called");
        }
        ILinkModel iLinkModel = this.parent.netLink.getLinkModel();
        String string = iLinkModel.src().getHostName();
        String string2 = iLinkModel.dst().getHostName();
        Collection collection = Network.instance().getElements();
        Iterator iterator = collection.iterator();
        AddNode2OnePlusOneModel addNode2OnePlusOneModel = AddNode2OnePlusOneModel.instance();
        this.nodeNameCB.removeAllItems();
        DataItem dataItem = null;
        while (iterator.hasNext()) {
            object = (NetElement)iterator.next();
            String string3 = ((NetElement)object).getHostName();
            if (string3.equals(string) || string3.equals(string2) || !addNode2OnePlusOneModel.isNodeValidForUpgrade(((NetElement)object).getNodeModel(), this.parent.netLink.getLinkModel())) continue;
            DataItem dataItem2 = new DataItem(((NetElement)object).getName(), ((NetElement)object).getHostName());
            this.nodeNameCB.addItem(dataItem2);
            if (AndNodePane.db.on) {
                db.println("Add nodeName= " + dataItem2.nodeName + " hostName= " + IPAddressTranslator.instance().getActualAddressDisplay(dataItem2.hostName));
            }
            if (!string3.equals(this.parent.newHostName)) continue;
            dataItem = dataItem2;
        }
        if (dataItem != null) {
            this.nodeNameCB.setSelectedItem(dataItem);
        }
        if (this.nodeNameCB.getItemCount() > 0) {
            this.byNodeNameRB.setSelected(true);
            this.byNodeNameRB.setEnabled(true);
            this.nodeNameCB.setEnabled(true);
            this.hostNameTF.setText("");
        } else {
            this.byNodeNameRB.setEnabled(false);
            this.nodeNameCB.setEnabled(false);
            this.nodeNameCB.addItem("No nodes available");
            this.byHostNameRB.setSelected(true);
        }
        this.calculateEnabledStatus();
        object = this.parent.getSize();
        this.parent.setSize(new Dimension(((Dimension)object).width, 340));
        this.revalidate();
        this.parent.invalidate();
        this.parent.validate();
        this.parent.repaint();
    }

    @Override
    public void dispose() {
        if (AndNodePane.db.on) {
            db.println("dispose() called");
        }
        super.dispose();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.AndNodePane;
    }

    private static class DataItem {
        String nodeName;
        String hostName;

        public DataItem(String string, String string2) {
            this.nodeName = string;
            this.hostName = string2;
        }

        public String toString() {
            return this.nodeName;
        }
    }
}

