/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import java.util.ArrayList;
import java.util.List;

public class DwdmSide {
    public static final int UNKNOWN_SIDE_ID = 0;
    public static final int OMIDIR_SIDE_ID = 0;
    public static final String UNKNOWN_SIDE_LABEL = "Unknown";
    public static final String OMNIDIR_SIDE_LABEL = "Omnidir";
    private static final String ERROR_ON_SIDE_ID = "N/A";
    private static final int SIDE_LABEL_MASK = 255;
    private static final int SIDE_ROLE_MASK = 65280;
    private static final int SIDE_ROLE_SHIFT = 14;
    private static final int SIDE_WORKING_VALUE = 16384;
    private static final int SIDE_PROTECT_VALUE = 32768;
    public static final int WORKING_SIDE_ROLE = 1;
    public static final int PROTECTED_SIDE_ROLE = 2;
    public static final int NO_SIDE_ROLE = 0;
    public static final String SIDE_WORKING_STR = "(w)";
    public static final String SIDE_PROTECT_STR = "(p)";
    public static final int LEGACY = 2;
    public static final int MAXSIDE = 20;
    private static final List<SideEnum> sideEnumList = new ArrayList<SideEnum>();

    private DwdmSide() {
    }

    public static String[] getAllSides() {
        String[] stringArray = new String[sideEnumList.size()];
        for (int i = 0; i < sideEnumList.size(); ++i) {
            stringArray[i] = sideEnumList.get(i).toString();
        }
        return stringArray;
    }

    public static String getSideFromOffset(int n) {
        int n2 = DwdmSide.getSideLabelFromId(n);
        if (n2 > 0 && n2 <= sideEnumList.size()) {
            return sideEnumList.get(n2 - 1) + DwdmSide.getSideRoleString(n);
        }
        if (n2 == 0) {
            return UNKNOWN_SIDE_LABEL;
        }
        return ERROR_ON_SIDE_ID;
    }

    public static String getSideLabelFromOffset(int n) {
        int n2 = DwdmSide.getSideLabelFromId(n);
        if (n2 > 0 && n2 <= sideEnumList.size()) {
            return sideEnumList.get(n2 - 1).toString();
        }
        if (n2 == 0) {
            return UNKNOWN_SIDE_LABEL;
        }
        return ERROR_ON_SIDE_ID;
    }

    private static String getSideRoleString(int n) {
        switch (n & 0xFF00) {
            case 16384: {
                return SIDE_WORKING_STR;
            }
            case 32768: {
                return SIDE_PROTECT_STR;
            }
        }
        return "";
    }

    public static int getSideRole(int n) {
        return (n & 0xFF00) >> 14;
    }

    public static int getSideLabelFromId(int n) {
        return n & 0xFF;
    }

    public static int getSideId(int n, int n2) {
        return (n2 << 14) + n;
    }

    public static int getSideWorkingFromLabel(int n) {
        n = DwdmSide.getSideLabelFromId(n);
        return n | 0x4000;
    }

    public static int getSideProtectFromLabel(int n) {
        n = DwdmSide.getSideLabelFromId(n);
        return n | 0x8000;
    }

    public static int getIndexOf(String string) {
        if (string.equals(UNKNOWN_SIDE_LABEL)) {
            return 0;
        }
        if (string.equals(OMNIDIR_SIDE_LABEL)) {
            return 0;
        }
        for (int i = 0; i < sideEnumList.size(); ++i) {
            String string2 = sideEnumList.get(i).toString();
            if (!string.startsWith(string2)) continue;
            int n = i + 1;
            String string3 = string.substring(string2.length());
            if (string3 != null) {
                if (string3.equals(SIDE_WORKING_STR)) {
                    n += 16384;
                } else if (string3.equals(SIDE_PROTECT_STR)) {
                    n += 32768;
                }
            }
            return n;
        }
        return -1;
    }

    public static String getLabelOf(String string) {
        for (int i = 0; i < sideEnumList.size(); ++i) {
            if (!string.startsWith(sideEnumList.get(i).toString())) continue;
            return sideEnumList.get(i).toString();
        }
        return UNKNOWN_SIDE_LABEL;
    }

    public static boolean isRolePresent(String string) {
        return string.length() > 1;
    }

    public static int getMaxNumberSide() {
        return sideEnumList.size();
    }

    public static List<SideEnum> getSideEnumList() {
        return sideEnumList;
    }

    public static SideEnum getValue(int n) {
        int n2 = DwdmSide.getSideLabelFromId(n);
        for (int i = 0; i < sideEnumList.size(); ++i) {
            SideEnum sideEnum = sideEnumList.get(i);
            if (n2 != sideEnum.ord) continue;
            return new SideEnum(sideEnum.name, sideEnum.ord);
        }
        return null;
    }

    public static SideEnum getValue(String string) {
        for (int i = 0; i < sideEnumList.size(); ++i) {
            SideEnum sideEnum = sideEnumList.get(i);
            if (!sideEnum.name.equalsIgnoreCase(string)) continue;
            return new SideEnum(sideEnum.name, sideEnum.ord);
        }
        return null;
    }

    static {
        for (int i = 0; i < 20; ++i) {
            sideEnumList.add(new SideEnum(new String(new char[]{(char)(65 + i)}), i + 1));
        }
    }

    public static class SideEnum {
        private String name = "";
        private int ord = 0;

        private SideEnum(String string, int n) {
            this.name = string;
            this.ord = n;
        }

        public String toString() {
            return this.name;
        }

        public int toInt() {
            return this.ord;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            SideEnum sideEnum = (SideEnum)object;
            if (object == null) {
                return bl;
            }
            if (sideEnum.name.equals(this.name) && sideEnum.ord == this.ord) {
                bl = true;
            }
            return bl;
        }
    }
}

