/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityUnknownUser;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NodeSelectPane;
import cerent.cms.ui.PasswordChangePanel;
import cerent.cms.ui.PasswordExprWarningDialog;
import cerent.util.SDebug;
import cerent.util.gui.TextAreaDialog;
import com.cisco.ctc.CtcApplication;
import com.cisco.ctc.CtcLockDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ForcePasswordChangeDialog
extends JDialog
implements ActionListener,
Observer {
    private static final SDebug db = new SDebug("ForcePasswordChangeDialog");
    private static final int MARGIN = 5;
    private static final String TITLE = "Change Password";
    private PasswordChangePanel changePane;
    private NodeSelectPane nodeSelPane;
    private JCheckBox autoApplyCB;
    private JButton okButton;
    private JButton exitButton;
    private String userName;
    private HashSet nodesList = new HashSet();
    private boolean autoApplyFail;
    private WindowAdapter ctcLockListener = new WindowAdapter(){

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            CtcLockDialog ctcLockDialog = CtcLockDialog.instance();
            if (ctcLockDialog != null) {
                ctcLockDialog.removeWindowListener(this);
            }
            if (ForcePasswordChangeDialog.this.nodesList.size() > 0 || ForcePasswordChangeDialog.this.autoApplyFail) {
                ForcePasswordChangeDialog.this.show();
            }
        }
    };
    private static ForcePasswordChangeDialog _instance;

    public static ForcePasswordChangeDialog instance(Frame frame, String string) {
        if (_instance == null) {
            _instance = new ForcePasswordChangeDialog(frame, string);
        }
        return _instance;
    }

    private ForcePasswordChangeDialog(Frame frame, String string) {
        super(frame, TITLE);
        this.userName = string;
        Container container = this.getContentPane();
        container.setSize(new Dimension(400, 250));
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.changePane = new PasswordChangePanel(string, true);
        jPanel.add(this.changePane);
        this.autoApplyCB = new JCheckBox("Change password on all other nodes in the background");
        jPanel.add(this.autoApplyCB);
        container.add((Component)jPanel, "North");
        this.nodeSelPane = new NodeSelectPane(null, false);
        container.add(this.nodeSelPane);
        container.add((Component)this.getButtonPanel(), "South");
        this.autoApplyCB.addActionListener(this);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.init();
        Network.instance().getNetElementCreationNotifier().addObserver(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.nodesList.size() == 0) {
                if (!this.autoApplyCB.isSelected() || this.changePane.validatePassword()) {
                    this.autoApplyFail = false;
                    this.hide();
                }
            } else if (this.changePane.validatePassword()) {
                List list = this.nodeSelPane.getSelectedList();
                if (this.applyChange(list) && this.nodesList.size() == list.size()) {
                    this.autoApplyFail = false;
                    this.hide();
                    PasswordExprWarningDialog passwordExprWarningDialog = PasswordExprWarningDialog.instance(CtcApplication.instance().getMainPanel(), this.userName);
                    if (passwordExprWarningDialog.isShowing()) {
                        passwordExprWarningDialog.refreshAll();
                    }
                }
                if (list.size() != 0) {
                    this.nodesList.removeAll(list);
                    this.nodeSelPane.updateNodesList(this.nodesList, true, !this.autoApplyCB.isSelected());
                }
            }
        } else if (object == this.autoApplyCB) {
            this.nodeSelPane.toggleSelectedEnabled(true, !this.autoApplyCB.isSelected());
        } else if (object == this.exitButton) {
            CtcLockDialog.exitCtc(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        INodeModel iNodeModel = null;
        if (observable instanceof Network.NetElementCreationNotifier) {
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier;
            if (object instanceof NetElement && (abstractConnectionNotifier = (iNodeModel = ((NetElement)object).getNodeModel()).getConnectionNotifier()) != null) {
                abstractConnectionNotifier.addObserver(this);
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)((Object)observable);
            if (object == ModelUpdateType.DELETED) {
                connectionNotifier.deleteObserver(this);
            }
            iNodeModel = connectionNotifier.getNodeModel();
        }
        if (iNodeModel != null) {
            if (db.on()) {
                db.println("update: node= " + iNodeModel);
            }
            SwingUtilities.invokeLater(new Refresher(iNodeModel));
        }
    }

    private void init() {
        Iterator iterator = Network.instance().getElements().iterator();
        LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            if (!(iNetElement instanceof NetElement)) continue;
            INodeModel iNodeModel = iNetElement.getNodeModel();
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
            if (abstractConnectionNotifier != null) {
                abstractConnectionNotifier.addObserver(this);
            }
            if (!this.isPasswordChangeRequired(iNodeModel)) continue;
            linkedList.add(iNodeModel);
        }
        if (linkedList.size() != 0) {
            if (db.on()) {
                db.println("init: newList.size = " + linkedList.size());
            }
            SwingUtilities.invokeLater(new Refresher(linkedList));
        }
    }

    private void addNodeModel(List list) {
        boolean bl = this.autoApplyCB.isSelected();
        if (this.nodesList.addAll(list)) {
            this.nodeSelPane.updateNodesList(this.nodesList, true, !bl);
        }
        if (!this.isShowing() && !this.autoApplyFail) {
            boolean bl2 = true;
            if (bl) {
                if (this.applyChange(list)) {
                    bl2 = false;
                } else {
                    this.autoApplyFail = true;
                }
                if (this.nodesList.removeAll(list)) {
                    this.nodeSelPane.updateNodesList(this.nodesList, true, !bl);
                }
            }
            if (bl2) {
                CtcLockDialog ctcLockDialog = CtcLockDialog.instance();
                if (ctcLockDialog != null && ctcLockDialog.isShowing()) {
                    ctcLockDialog.addWindowListener(this.ctcLockListener);
                } else {
                    this.show();
                }
            }
        }
    }

    private void removeNodeModel(INodeModel iNodeModel) {
        if (this.nodesList.remove(iNodeModel)) {
            this.nodeSelPane.updateNodesList(this.nodesList, true, !this.autoApplyCB.isSelected());
        }
    }

    private void refresh(INodeModel iNodeModel) {
        if (this.isPasswordChangeRequired(iNodeModel)) {
            LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
            linkedList.add(iNodeModel);
            this.addNodeModel(linkedList);
        } else {
            this.removeNodeModel(iNodeModel);
        }
    }

    private boolean applyChange(List list) {
        Map.Entry entry;
        Map map = NetSecurityModel.instance().changePassword(this.userName, this.changePane.getOldPassword(), this.changePane.getNewPassword(), list);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getValue() == null) {
                iterator.remove();
                continue;
            }
            list.remove(entry.getKey());
        }
        if (db.on()) {
            db.println("applyChange: failed = " + map.size() + " success = " + list.size());
        }
        if (map.size() > 0) {
            entry = new StringBuffer();
            NetSecurityModel.formatFailedMap((StringBuffer)((Object)entry), map);
            new TextAreaDialog(JOptionPane.getFrameForComponent(this), "Password Change Failure", ((StringBuffer)((Object)entry)).toString());
            return false;
        }
        return true;
    }

    private boolean isPasswordChangeRequired(INodeModel iNodeModel) {
        if ((iNodeModel.isInited() || iNodeModel.isLiteInited()) && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SEC_FORCE_PASSWD_CHANGE)) {
            try {
                return iNodeModel.getSecurityModel().isPasswordChangeRequired(this.userName);
            }
            catch (SecurityUnknownUser securityUnknownUser) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.exitButton = this.makeActionButton("Exit...");
        jPanel.add(this.exitButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private class Refresher
    implements Runnable {
        private INodeModel nm;
        private List newList;

        Refresher(INodeModel iNodeModel) {
            this.nm = iNodeModel;
        }

        Refresher(List list) {
            this.newList = list;
        }

        @Override
        public void run() {
            if (this.nm != null) {
                ForcePasswordChangeDialog.this.refresh(this.nm);
            } else {
                ForcePasswordChangeDialog.this.addNodeModel(this.newList);
            }
        }
    }
}

