/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityUnknownUser;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PasswordExprWarningDialog
extends JDialog
implements ActionListener,
Observer {
    private static final int MARGIN = 5;
    private static final String TITLE = "Password Expiration Warning";
    private JButton okButton;
    private JTextArea jta;
    private String userName;
    private HashSet nodesList;
    private HashSet displayList;
    private static PasswordExprWarningDialog _instance;

    public static PasswordExprWarningDialog instance(Frame frame, String string) {
        if (_instance == null) {
            _instance = new PasswordExprWarningDialog(frame, string);
        }
        return _instance;
    }

    private JTextArea createTextArea(String string, Font font) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        jTextArea.setFont(font);
        return jTextArea;
    }

    private PasswordExprWarningDialog(Frame frame, String string) {
        super(frame, TITLE);
        this.userName = string;
        this.nodesList = new HashSet();
        this.displayList = new HashSet();
        JLabel jLabel = new JLabel(CerentDialog.WARNING_ICON);
        Font font = jLabel.getFont();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add(this.createTextArea("Please change password on the following node(s) before expiration to avoid disabling " + string + ":\n", font));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        this.jta = this.createTextArea("", font);
        container.add((Component)new UScrollPane((Component)this.jta));
        this.jta.setPreferredSize(new Dimension(350, 100));
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.init();
        Network.instance().getNetElementCreationNotifier().addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof Network.NetElementCreationNotifier) {
            if (object instanceof NetElement) {
                INodeModel iNodeModel = ((NetElement)object).getNodeModel();
                INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
                if (abstractConnectionNotifier != null) {
                    abstractConnectionNotifier.addObserver(this);
                }
                SwingUtilities.invokeLater(new Refresher(iNodeModel));
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)((Object)observable);
            if (object == ModelUpdateType.DELETED) {
                connectionNotifier.deleteObserver(this);
            }
            SwingUtilities.invokeLater(new Refresher(connectionNotifier.getNodeModel()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.displayList.clear();
            this.jta.setText("");
            this.hide();
        }
    }

    private void init() {
        Iterator iterator = Network.instance().getElements().iterator();
        LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            if (!(iNetElement instanceof NetElement)) continue;
            INodeModel iNodeModel = iNetElement.getNodeModel();
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
            if (abstractConnectionNotifier != null) {
                abstractConnectionNotifier.addObserver(this);
            }
            linkedList.add(iNodeModel);
        }
        SwingUtilities.invokeLater(new Refresher(linkedList));
    }

    public void refreshAll() {
        HashSet hashSet = new HashSet(this.displayList);
        this.nodesList.clear();
        this.displayList.clear();
        this.jta.setText("");
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.refresh((INodeModel)iterator.next());
        }
        this.hideDialogIfEmpty();
    }

    private void refresh(INodeModel iNodeModel) {
        int n = this.getRemainingPasswordDays(iNodeModel);
        if (n < 0) {
            this.nodesList.remove(iNodeModel);
        } else if (this.nodesList.add(iNodeModel) && this.displayList.add(iNodeModel)) {
            try {
                this.jta.append(" - " + iNodeModel.getName() + ": expired in " + n + " days.\n");
                this.pack();
                if (!this.isShowing()) {
                    this.show();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void hideDialogIfEmpty() {
        if (this.isShowing() && this.jta.getText().length() <= 0) {
            this.hide();
        }
    }

    private int getRemainingPasswordDays(INodeModel iNodeModel) {
        if ((iNodeModel.isInited() || iNodeModel.isLiteInited()) && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SEC_PASSWD_AGING)) {
            try {
                return iNodeModel.getSecurityModel().getRemainingPasswordDays(this.userName);
            }
            catch (SecurityUnknownUser securityUnknownUser) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private class Refresher
    implements Runnable {
        private Collection newList;
        private INodeModel nm;

        Refresher(INodeModel iNodeModel) {
            this.nm = iNodeModel;
        }

        Refresher(Collection collection) {
            this.newList = collection;
        }

        @Override
        public void run() {
            if (this.nm != null) {
                PasswordExprWarningDialog.this.refresh(this.nm);
            } else {
                Iterator iterator = this.newList.iterator();
                while (iterator.hasNext()) {
                    PasswordExprWarningDialog.this.refresh((INodeModel)iterator.next());
                }
            }
            PasswordExprWarningDialog.this.hideDialogIfEmpty();
        }
    }
}

