/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.BooleanPropertyEditor;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.ChoicePropertyEditor;
import cerent.util.gui.FilePropertyEditor;
import cerent.util.gui.GridPanel;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;

public class PrefsGeneralPropertyPane
extends AbstractPrefsPropertyPane {
    private FilePropertyEditor includeFileEdit;
    private IgnoreCheckableList previouslyIgnoredDialogs;
    private ChoicePropertyEditor dateFmtEdit;
    private SpinPropertyEditor maxHistEdit;
    private SpinPropertyEditor maxNodeHistEdit;
    private BooleanPropertyEditor useNeTimeZone;
    private AbstractPropertySheet parentSheet;
    private Preferences launcherPrefs;
    final String ignorableDialogDescriptionPath = "ctc.ignore.dialogs.description";
    final String ignorableDialogValuePath = "ctc.ignore.dialogs.value";

    public PrefsGeneralPropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.parentSheet = abstractPropertySheet;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void storePreviouslyIgnoredDialogs() {
        ListModel listModel = this.previouslyIgnoredDialogs.getModel();
        db.info("All " + listModel.getSize() + " " + "ctc.ignore.dialogs" + " " + "are being stored");
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableKeyedItem checkableKeyedItem = (CheckableKeyedItem)listModel.getElementAt(i);
            String string = checkableKeyedItem.getKey();
            String string2 = Preferences.getKeyFromFullName((String)string, (String)"ctc.ignore.dialogs.description");
            db.fine("Storing ctc.ignore.dialogs.value " + string2 + " " + checkableKeyedItem.isSelected());
            if (checkableKeyedItem.isSelected()) continue;
            this.prefs.removeAllProperties("ctc.ignore.dialogs.description", string2);
            this.prefs.removeAllProperties("ctc.ignore.dialogs.value", string2);
            if (this.launcherPrefs == null) continue;
            this.launcherPrefs.removeAllProperties("ctc.ignore.dialogs.description", string2);
            this.launcherPrefs.removeAllProperties("ctc.ignore.dialogs.value", string2);
        }
        if (this.launcherPrefs != null) {
            try {
                this.launcherPrefs.store();
            }
            catch (IOException iOException) {
                db.println("Caught IOException trying to save launcher prefs");
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        this.launcherPrefs = null;
    }

    @Override
    public void store() {
        this.store("ctc", "include", this.includeFileEdit);
        this.store("ctc", "history.max", this.maxHistEdit);
        this.store("ctc", "nodehistory.max", this.maxNodeHistEdit);
        this.store("ctc", "useNeTimeZone", this.useNeTimeZone);
        this.store("ctc", "dateFormat", this.dateFmtEdit);
        this.storePreviouslyIgnoredDialogs();
    }

    private void loadPreviouslyIgnoredDialogs(List list, IgnoreCheckableList ignoreCheckableList) {
        db.info("All " + list.size() + " " + "ctc.ignore.dialogs" + " " + "are being loaded");
        ArrayList<CheckableKeyedItem> arrayList = new ArrayList<CheckableKeyedItem>(0);
        for (String string : list) {
            String string2 = Preferences.getKeyFromFullName((String)string, (String)"ctc.ignore.dialogs.description");
            String string3 = this.getValueFromPrefs(string2);
            CheckableKeyedItem checkableKeyedItem = new CheckableKeyedItem(string, string3);
            checkableKeyedItem.setSelected(true);
            db.fine("Loading ctc.ignore.dialogs.value " + string2 + " " + checkableKeyedItem.isSelected());
            arrayList.add(checkableKeyedItem);
        }
        ignoreCheckableList.setListData(arrayList.toArray(new CheckableKeyedItem[0]));
    }

    private String getValueFromPrefs(String string) {
        String string2 = this.prefs.getProperty("ctc.ignore.dialogs.description", string, null);
        if (string2 == null) {
            string2 = this.launcherPrefs.getProperty("ctc.ignore.dialogs.description", string, null);
        }
        if (string2 == null) {
            string2 = "Unknown: " + string;
        }
        return string2;
    }

    @Override
    public void load() {
        this.load("ctc", "include", this.includeFileEdit);
        this.load("ctc", "history.max", this.maxHistEdit);
        this.load("ctc", "nodehistory.max", this.maxNodeHistEdit);
        this.load("ctc", "useNeTimeZone", this.useNeTimeZone);
        this.load("ctc", "dateFormat", this.dateFmtEdit);
        List list = this.prefs.getMatchingPropertyKeys("ctc.ignore.dialogs", "description");
        this.launcherPrefs = Preferences.instance((String)Preferences.getDefaultLauncherPrefsFileName());
        list.addAll(this.launcherPrefs.getMatchingPropertyKeys("ctc.ignore.dialogs", "description"));
        this.loadPreviouslyIgnoredDialogs(list, this.previouslyIgnoredDialogs);
    }

    private void initializeIgnorableDialogs(boolean bl) {
        ListModel listModel = this.previouslyIgnoredDialogs.getModel();
        db.info("All " + listModel.getSize() + " " + "ctc.ignore.dialogs" + " " + "are being set to " + bl);
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(bl);
        }
        this.previouslyIgnoredDialogs.repaint();
    }

    protected void ignoreIgnorableDialogsActionPerformed(ActionEvent actionEvent) {
        this.initializeIgnorableDialogs(true);
    }

    protected void unignoreIgnorableDialogsActionPerformed(ActionEvent actionEvent) {
        this.initializeIgnorableDialogs(false);
    }

    private JPanel getPreferencesManagementPanel() {
        this.includeFileEdit = new FilePropertyEditor("Include Other Preferences File:");
        this.includeFileEdit.setEditorSize(20);
        JLabel jLabel = new JLabel("Dialog boxes for which \"Do not show this message again\" is currently selected\nare listed below. Checked dialog boxes will continue to not be shown.\nUnchecked dialog boxes will be shown in the future.");
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.previouslyIgnoredDialogs = new IgnoreCheckableList();
        this.previouslyIgnoredDialogs.setVisibleRowCount(4);
        JButton jButton = new JButton("Don't Show Any");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsGeneralPropertyPane.this.ignoreIgnorableDialogsActionPerformed(actionEvent);
            }
        });
        JButton jButton2 = new JButton("Show All");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsGeneralPropertyPane.this.unignoreIgnorableDialogsActionPerformed(actionEvent);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Preferences Management"));
        jPanel.setPreferredSize(new Dimension(525, 200));
        jPanel.add((Component)this.includeFileEdit, "North");
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(jLabel);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add((Component)new UScrollPane((Component)this.previouslyIgnoredDialogs));
        box.add(box2);
        jPanel.add((Component)box, "Center");
        box2 = Box.createHorizontalBox();
        box2.add(jButton);
        box2.add(jButton2);
        jPanel.add((Component)box2, "South");
        return jPanel;
    }

    private void initialize() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        String[] stringArray = new String[]{"MM/DD/YY", "DD/MM/YY"};
        this.dateFmtEdit = new ChoicePropertyEditor("Date Format", stringArray, stringArray, 0, 0);
        this.maxHistEdit = new SpinPropertyEditor(" Maximum Network History Entries:", 100, 500, 100000);
        this.maxNodeHistEdit = new SpinPropertyEditor(" Maximum Node History Entries:     ", 100, 500, 10000);
        this.useNeTimeZone = new BooleanPropertyEditor("Display Events Using Each Node's Time Zone");
        this.maxHistEdit.setEditorSize(6);
        this.maxNodeHistEdit.setEditorSize(5);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.dateFmtEdit);
        jPanel.add(jPanel2);
        GridPanel gridPanel = new GridPanel(0, 0, 1, 1);
        gridPanel.setPreferredSize(new Dimension(425, 93));
        gridPanel.setBorder((Border)BorderFactory.createTitledBorder("Events"));
        gridPanel.addRow((JComponent)this.maxHistEdit, 0);
        gridPanel.addRow((JComponent)this.maxNodeHistEdit, 0);
        gridPanel.addRow((JComponent)this.useNeTimeZone, 0);
        jPanel.add((Component)gridPanel, gridBagConstraints);
        jPanel.add((Component)this.getPreferencesManagementPanel(), gridBagConstraints);
        this.load();
        this.notifyAllPropertyEditors(this);
        this.parentSheet.resetApply();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsGeneralPropertyPane;
    }

    private class CheckableKeyedItem
    extends CheckableItem {
        private String key;

        CheckableKeyedItem(String string, Object object) {
            super(object);
            this.key = string;
        }

        CheckableKeyedItem(String string, Object object, boolean bl) {
            super(object, bl);
            this.key = string;
        }

        String getKey() {
            return this.key;
        }
    }

    private class IgnoreCheckableList
    extends CheckableList {
        IgnoreCheckableList() {
        }

        @Override
        public void fireSelectionEvent(int n) {
            super.fireSelectionEvent(n);
            PrefsGeneralPropertyPane.this.parentSheet.setApply();
        }
    }
}

