/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.INodeModel;
import cerent.cms.ui.ExplorerController;
import cerent.cms.ui.ExplorerViewPane;
import cerent.cms.ui.ProxyClientTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class ProxyClientDialog
extends JDialog
implements TableModelListener,
ActionListener {
    private JPanel jPanel = null;
    private JPanel northJPane = null;
    private JPanel mainPane = null;
    private UScrollPane scrollPane = null;
    private JPanel buttonPanel = null;
    private JButton jButtonOK = null;
    private JPanel bottomPanel = null;
    private INodeModel curNM = null;
    private ExplorerViewPane parent = null;
    protected ProxyClientTableModel dataModel = null;
    private static final SDebug db = new SDebug("ProxyClientDialog");

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.jButtonOK.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.getClass().getName() == "javax.swing.JButton" && (JButton)object == this.jButtonOK) {
            if (ProxyClientDialog.db.on) {
                db.println("OK button pressed");
            }
            this.updateModelAndClose();
        }
    }

    public ProxyClientDialog(Frame frame, INodeModel iNodeModel) {
        super(frame, iNodeModel.getHostName() + ": Proxy Client List", true);
        this.curNM = iNodeModel;
        this.initialize();
        this.setSize(500, 100);
        this.setLocationRelativeTo(frame);
    }

    public void start() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProxyClientDialog.this.closeDialog();
            }
        });
    }

    private void initialize() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getUScrollPane(), "Center");
            this.mainPane.add((Component)this.getBottomPanel(), "South");
        }
        this.setContentPane(this.mainPane);
    }

    private JPanel getBottomPanel() {
        this.jButtonOK = new JButton();
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(this);
        this.jButtonOK.setEnabled(true);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add((Component)this.jButtonOK, null);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.buttonPanel, "Center");
        return this.bottomPanel;
    }

    private UScrollPane getUScrollPane() {
        if (this.scrollPane == null) {
            this.dataModel = new ProxyClientTableModel(ExplorerController.instance().getClientsForNE(this.curNM));
            this.dataModel.addTableModelListener(this);
            JTable jTable = new JTable(this.dataModel);
            jTable.setRowSelectionAllowed(false);
            jTable.setCellSelectionEnabled(true);
            TableColumn tableColumn = null;
            tableColumn = jTable.getColumn(this.dataModel.getColumnName(0));
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumn(this.dataModel.getColumnName(1));
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumn(this.dataModel.getColumnName(2));
            tableColumn.setPreferredWidth(20);
            jTable.setPreferredScrollableViewportSize(new Dimension(400, 350));
            this.scrollPane = new UScrollPane((Component)jTable);
        }
        return this.scrollPane;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void updateModelAndClose() {
        this.dispose();
    }
}

