/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.model.Busy;
import cerent.cms.model.Feature;
import cerent.cms.model.IApcDomainItem;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractPluginHolderPane;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.apc.ApcDomainDomainNode;
import cerent.cms.ui.apc.ApcDomainNode;
import cerent.cms.ui.apc.ApcDomainRootNode;
import cerent.cms.ui.apc.ApcDomainSpan;
import cerent.cms.ui.apc.ApcDomainSpanNode;
import cerent.cms.ui.apc.ApcDomainTreeCellRenderer;
import cerent.cms.ui.apc.ApcDomainsPanePlugin;
import cerent.util.IObservable;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ApcDomainSelectionPane
extends ObserverPane
implements TreeSelectionListener,
ActionListener {
    private static final String REFRESH_LABEL = "Refresh";
    private static final Font refreshLabelFont = new Font("Arial", 1, 10);
    private JLabel refreshLabel;
    private String refreshLabelText = "";
    private JButton refreshButton;
    private JTree domainsTree;
    private ObservableManager observableManager;
    private AbstractPluginHolderPane pluginHolder;
    private DefaultTreeModel treeModel;
    private boolean initialized = false;
    private boolean needToUpdate = false;
    private INodeModel selectedNode;
    private int sideId = -1;
    private Pane pluginPane;
    private Network netModel;
    private Collection elements;
    private ApcDomainRootNode rootNode = new ApcDomainRootNode();
    protected static final SDebug db = new SDebug("ApcDomainSelectionPane");

    public ApcDomainSelectionPane(AbstractPluginHolderPane abstractPluginHolderPane, String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.pluginHolder = abstractPluginHolderPane;
        this.observableManager = new ObservableManager((Observer)((Object)this), true);
        this.netModel = Network.instance();
        this.netModel.getNetElementCreationNotifier().addObserver(this.observableManager);
        this.elements = this.netModel.getAllElements();
        for (INetElement iNetElement : this.elements) {
            if (!ApcDomainSelectionPane.isAPCFeatureSupported(iNetElement.getNodeModel())) continue;
            iNetElement.addObserver(this.observableManager);
        }
        this.treeModel = new DefaultTreeModel(this.createTree(this.rootNode));
    }

    private void init() {
        this.domainsTree = new JTree(this.treeModel);
        this.domainsTree.setCellRenderer(new ApcDomainTreeCellRenderer(this));
        this.domainsTree.setShowsRootHandles(true);
        this.domainsTree.setScrollsOnExpand(true);
        this.domainsTree.putClientProperty("JTree.lineStyle", "Angled");
        TreeSelectionModel treeSelectionModel = this.domainsTree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        treeSelectionModel.addTreeSelectionListener(this);
        UScrollPane uScrollPane = new UScrollPane((Component)this.domainsTree);
        uScrollPane.setBorder((Border)BorderFactory.createTitledBorder("Selector"));
        this.setLayout(new BorderLayout());
        this.add((Component)uScrollPane, "Center");
        this.add(this.getButtonPanel(), "South");
        this.pluginPane = new ApcDomainsPanePlugin("APC domains", this.getUiModel(), this.domainsTree);
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(new Insets(5, 5, 5, 5));
        Font font = jButton.getFont();
        jButton.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        jButton.addActionListener(this);
        return jButton;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = this.makeButton(REFRESH_LABEL);
        this.enableComponent(this.refreshButton, this.getUiModel(), SecurityLevel.RETRIEVE);
        jPanel.add(this.refreshButton);
        this.refreshLabel = new JLabel(this.refreshLabelText);
        this.refreshLabel.setFont(refreshLabelFont);
        this.pluginHolder.addComponentToButtonPanel(this.refreshLabel);
        this.pluginHolder.updateUI();
        return jPanel;
    }

    private DefaultMutableTreeNode getRootDefaultMutableTreeNode() {
        return (DefaultMutableTreeNode)this.domainsTree.getModel().getRoot();
    }

    private ApcDomainRootNode getApcDomainRootNode() {
        return (ApcDomainRootNode)this.getRootDefaultMutableTreeNode().getUserObject();
    }

    private DefaultMutableTreeNode createTree(ApcDomainNode apcDomainNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(apcDomainNode);
        if (apcDomainNode instanceof ApcDomainDomainNode) {
            ((ApcDomainDomainNode)apcDomainNode).setDefaultMutableTreeNode(defaultMutableTreeNode);
        }
        ApcDomainNode[] apcDomainNodeArray = apcDomainNode.getChildren(new ApcDomainNode[0]);
        for (int i = 0; i < apcDomainNodeArray.length; ++i) {
            defaultMutableTreeNode.add(this.createTree(apcDomainNodeArray[i]));
        }
        return defaultMutableTreeNode;
    }

    private static boolean isAPCFeatureSupported(INodeModel iNodeModel) {
        return Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OPTICAL_SIDE);
    }

    @Override
    public void enteringPage() throws Exception {
        block8: {
            if (!this.initialized) {
                this.init();
                this.initialized = true;
            } else {
                try {
                    this.refreshFromModel();
                    this.domainsTree.setSelectionRow(0);
                }
                catch (Exception exception) {
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        super.enteringPage();
        if (this.observableManager != null) {
            int n = this.observableManager.getBlockingModeControllerState();
            if (n != 0) {
                if (db.on()) {
                    db.println("refreshing data source:" + n);
                }
                this.setNeedToUpdate(true);
            }
            this.observableManager.setPassing(true);
            if (db.on()) {
                db.println("setPassing:true");
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        this.observableManager.setPassing(false);
        this.pluginHolder.setPluginPane(null, "Empty", null);
    }

    public INodeModel getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n = this.domainsTree.getSelectionCount();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.selectedNode = null;
            TreePath treePath = this.domainsTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof ApcDomainRootNode) {
                try {
                    this.pluginHolder.setPluginPane(null, "APC domains", this.pluginPane);
                    this.pluginPane.refresh();
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof ApcDomainDomainNode) {
                try {
                    this.pluginHolder.setPluginPane(null, "APC domains", this.pluginPane);
                    this.pluginPane.refresh();
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof ApcDomainSpan) {
                try {
                    this.pluginHolder.setPluginPane(null, "Empty", null);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof ApcDomainSpanNode) {
                this.selectedNode = ((ApcDomainSpanNode)defaultMutableTreeNode.getUserObject()).getNodeModel();
                if (this.selectedNode != null && this.selectedNode.getConnectionState()) {
                    IDwdmApcModels iDwdmApcModels = this.selectedNode.getIDwdmApcModels();
                    this.sideId = ((ApcDomainSpanNode)defaultMutableTreeNode.getUserObject()).getSideId();
                    Pane pane = iDwdmApcModels.getApcPlugin(this.getParentView(), (short)this.sideId);
                    try {
                        this.pluginHolder.setPluginPane(this.selectedNode, this.selectedNode.getName() + ", side" + DwdmSide.getSideFromOffset(this.sideId), pane);
                        pane.refresh();
                    }
                    catch (Exception exception) {
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
    }

    public void refreshFromModel() {
        this.rootNode.clear();
        Collection collection = Network.instance().getElements();
        boolean bl = false;
        int n = collection.size();
        for (INetElement iNetElement : collection) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (iNodeModel == null || !AbstractPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.RETRIEVE)) continue;
            this.loadNe(iNetElement);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.createTree(this.rootNode);
        this.treeModel.setRoot(defaultMutableTreeNode);
    }

    @Override
    public void refresh() {
        block2: {
            try {
                this.refreshFromModel();
                this.domainsTree.setSelectionRow(0);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refresh();
            this.setNeedToUpdate(false);
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            String string = jMenuItem.getActionCommand();
            TreePath treePath = this.domainsTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ApcDomainSpan apcDomainSpan = (ApcDomainSpan)defaultMutableTreeNode.getUserObject();
            IApcDomainItem iApcDomainItem = null;
            IApcDomainItem iApcDomainItem2 = apcDomainSpan.getFrom();
            IApcDomainItem iApcDomainItem3 = apcDomainSpan.getTo();
            if (string.equals("From")) {
                iApcDomainItem = iApcDomainItem2;
                this.sideId = iApcDomainItem2.getSideOut();
            } else if (string.equals("To")) {
                iApcDomainItem = iApcDomainItem3;
                this.sideId = iApcDomainItem3.getSideIn();
            }
            this.selectedNode = ApcDomainNode.getNodeModel(iApcDomainItem);
            if (db.on()) {
                db.println("Requesting the APC Plugin Pane " + this.selectedNode.getName() + ", side " + DwdmSide.getSideFromOffset(this.sideId));
            }
            if (this.selectedNode != null && this.selectedNode.getConnectionState()) {
                IDwdmApcModels iDwdmApcModels = this.selectedNode.getIDwdmApcModels();
                Pane pane = iDwdmApcModels.getApcPlugin(this.getParentView(), (short)this.sideId);
                try {
                    this.pluginHolder.setPluginPane(this.selectedNode, this.selectedNode.getName() + ", side" + DwdmSide.getSideFromOffset(this.sideId), pane);
                    pane.refresh();
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        block21: {
            block19: {
                INetElement iNetElement;
                block20: {
                    if (db.on()) {
                        db.println("Received update: ob = " + observable + ", arg = " + object);
                    }
                    if (!(observable instanceof INetElement)) break block19;
                    iNetElement = (INetElement)((Object)observable);
                    if (!object.equals(ModelUpdateType.DELETED)) break block20;
                    iNetElement.deleteObserver(this.observableManager);
                    this.setNeedToUpdate(true);
                    break block21;
                }
                if (!object.equals(ModelUpdateType.ADDED) && !object.equals(ModelUpdateType.CHANGED) || !iNetElement.getConnectionState()) break block21;
                if (ApcDomainSelectionPane.isAPCFeatureSupported(iNetElement.getNodeModel())) {
                    this.setNeedToUpdate(true);
                } else {
                    iNetElement.deleteObserver(this.observableManager);
                }
                break block21;
            }
            if (observable instanceof Network.NetElementCreationNotifier) {
                if (db.on()) {
                    db.println("update: received NetElementCreationNotifier event");
                }
                ((INetElement)object).addObserver(this.observableManager);
            } else if (observable instanceof IDwdmApcModels) {
                if (db.on()) {
                    db.println("update: received IDwdmApcModels event");
                }
                if (object.equals(ModelUpdateType.ADDED)) {
                    this.setNeedToUpdate(true);
                }
            } else if (observable instanceof IDwdmApcModel) {
                IDwdmApcModel iDwdmApcModel = (IDwdmApcModel)observable;
                INodeModel iNodeModel = iDwdmApcModel.getNodeModel();
                int n = iDwdmApcModel.getApcNodeSide();
                if (db.on()) {
                    db.println("update: received IDwdmApcModel event from " + iNodeModel.getName() + ", side " + DwdmSide.getSideFromOffset(n));
                }
                ApcDomainRootNode apcDomainRootNode = this.getApcDomainRootNode();
                ApcDomainNode[] apcDomainNodeArray = apcDomainRootNode.getChildren(new ApcDomainNode[0]);
                if (object.equals(ModelUpdateType.DELETED)) {
                    if (this.sideId == n && this.selectedNode == iNodeModel) {
                        try {
                            this.pluginHolder.setPluginPane(null, "Empty", null);
                            this.selectedNode = null;
                        }
                        catch (Exception exception) {
                            KDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    ((IObservable)iDwdmApcModel).deleteObserver((Observer)((Object)this));
                    this.setNeedToUpdate(true);
                } else if (object.equals(ModelUpdateType.CHANGED)) {
                    for (int i = 0; i < apcDomainNodeArray.length; ++i) {
                        ApcDomainDomainNode apcDomainDomainNode;
                        ApcDomainNode apcDomainNode = apcDomainNodeArray[i];
                        if (!(apcDomainNode instanceof ApcDomainDomainNode) || !(apcDomainDomainNode = (ApcDomainDomainNode)apcDomainNode).containsNode(iNodeModel, n)) continue;
                        Object[] objectArray = apcDomainDomainNode.getDefaultMutableTreeNode().getPath();
                        TreePath treePath = new TreePath(objectArray);
                        this.domainsTree.getModel().valueForPathChanged(treePath, apcDomainDomainNode);
                    }
                }
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 200;
        return dimension;
    }

    public boolean isNeedToUpdate() {
        return this.needToUpdate;
    }

    public void setNeedToUpdate(boolean bl) {
        this.needToUpdate = bl;
        ApcDomainRootNode apcDomainRootNode = this.getApcDomainRootNode();
        Object[] objectArray = this.getRootDefaultMutableTreeNode().getPath();
        TreePath treePath = new TreePath(objectArray);
        this.domainsTree.getModel().valueForPathChanged(treePath, apcDomainRootNode);
    }

    @Override
    public void dispose() {
        if (this.observableManager != null) {
            this.observableManager.reset();
        }
        for (INetElement iNetElement : this.elements) {
            if (!ApcDomainSelectionPane.isAPCFeatureSupported(iNetElement.getNodeModel())) continue;
            iNetElement.deleteObserver(this.observableManager);
        }
        this.removeObservers();
        this.rootNode.clear();
        this.rootNode = null;
        super.dispose();
    }

    private void addObservers(IDwdmApcModels iDwdmApcModels) {
        ((Observable)iDwdmApcModels).addObserver(this.observableManager);
        IDwdmApcModel[] iDwdmApcModelArray = iDwdmApcModels.getAllDwdmApcModel();
        INodeModel iNodeModel = iDwdmApcModels.getNodeModel();
        if (iNodeModel.getConnectionState()) {
            for (IDwdmApcModel iDwdmApcModel : iDwdmApcModelArray) {
                ((Observable)iDwdmApcModel).addObserver(this.observableManager);
            }
        }
    }

    private void removeObservers() {
        for (int i = 0; i < this.domainsTree.getRowCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.domainsTree.getPathForRow(i).getLastPathComponent();
            if (!(defaultMutableTreeNode.getUserObject() instanceof ApcDomainDomainNode)) continue;
            ApcDomainDomainNode apcDomainDomainNode = (ApcDomainDomainNode)defaultMutableTreeNode.getUserObject();
            for (int j = 0; j < apcDomainDomainNode.getApcModels().size(); ++j) {
                ((Observable)apcDomainDomainNode.getApcModels().get(j)).deleteObserver((Observer)((Object)this));
                IDwdmApcModel[] iDwdmApcModelArray = ((IDwdmApcModels)apcDomainDomainNode.getApcModels().get(j)).getAllDwdmApcModel();
                for (int k = 0; k < iDwdmApcModelArray.length; ++k) {
                    ((Observable)iDwdmApcModelArray[k]).deleteObserver((Observer)((Object)this));
                }
            }
        }
    }

    private void loadNe(INetElement iNetElement) {
        block21: {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            try {
                if (db.on()) {
                    db.println("Node : " + iNodeModel.getName() + " - state: " + (iNodeModel.getConnectionState() ? "ACTIVE" : "NOT ACTIVE") + " - is Feature OPTICAL_SIDE supported ? " + Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OPTICAL_SIDE));
                }
                if (!iNodeModel.getConnectionState() || !Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OPTICAL_SIDE)) {
                    String string = null;
                    if (!iNodeModel.getConnectionState()) {
                        string = "The node is disconnected";
                    } else if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OPTICAL_SIDE)) {
                        string = "The APC Domain feature is not supported ";
                    } else if (Network.instance().getNodeModel(iNodeModel.getNodeId()) == null) {
                        string = "The node is unreachable";
                    }
                    return;
                }
                int n = iNodeModel.getNodeType();
                IDwdmApcModels iDwdmApcModels = iNodeModel.getIDwdmApcModels();
                if (n != 2 && n != 1 || iDwdmApcModels == null) break block21;
                this.addObservers(iDwdmApcModels);
                IDwdmApcModel[] iDwdmApcModelArray = iDwdmApcModels.getAllDwdmApcModel();
                boolean bl = false;
                for (int i = 0; i < iDwdmApcModelArray.length; ++i) {
                    IDwdmApcModel iDwdmApcModel = iDwdmApcModelArray[i];
                    if (db.on()) {
                        db.println("Discovered: side " + DwdmSide.getSideFromOffset(iDwdmApcModel.getApcNodeSide()));
                    }
                    if (iDwdmApcModelArray[i].getApcNodeSide() == 0) continue;
                    if (!this.rootNode.containsNode(iNodeModel, iDwdmApcModel.getApcNodeSide())) {
                        IApcDomainItem[] iApcDomainItemArray;
                        try {
                            iApcDomainItemArray = iDwdmApcModels.getNetApcDomain(iDwdmApcModel.getApcNodeSide());
                            if (db.on()) {
                                for (int j = 0; j < iApcDomainItemArray.length; ++j) {
                                    INodeModel iNodeModel2 = Network.instance().getNodeModel(iApcDomainItemArray[j].getNodeId());
                                    if (iNodeModel2 != null) {
                                        db.println(j + ") Domain item - Node: " + iNodeModel2.getName() + ",  Side In: 0x" + Integer.toHexString(iApcDomainItemArray[j].getSideIn()) + " - Side Out: 0x" + Integer.toHexString(iApcDomainItemArray[j].getSideOut()));
                                        continue;
                                    }
                                    db.println(j + ") Domain item - Node: is NULL,  Side In: 0x" + Integer.toHexString(iApcDomainItemArray[j].getSideIn()) + " - Side Out: 0x" + Integer.toHexString(iApcDomainItemArray[j].getSideOut()));
                                }
                            }
                            bl = this.allowAPCActions(iApcDomainItemArray);
                        }
                        catch (Busy busy) {
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)busy);
                            continue;
                        }
                        catch (Exception exception) {
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)exception);
                            continue;
                        }
                        ApcDomainDomainNode apcDomainDomainNode = new ApcDomainDomainNode(this.rootNode, iApcDomainItemArray, bl);
                        if (db.on()) {
                            db.println("Discovered: " + apcDomainDomainNode.getName());
                        }
                    } else if (db.on()) {
                        db.println("Apc Side already contains into another domain: Node: " + iDwdmApcModel.getNodeModel().getName() + ",  Side : 0x" + Integer.toHexString(iDwdmApcModel.getApcNodeSide()));
                    }
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block21;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private boolean allowAPCActions(IApcDomainItem[] iApcDomainItemArray) {
        boolean bl = true;
        for (IApcDomainItem iApcDomainItem : iApcDomainItemArray) {
            INodeModel iNodeModel = Network.instance().getNodeModel(iApcDomainItem.getNodeId());
            if (iNodeModel != null && iNodeModel.isInited() && AbstractPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.MAINTENANCE)) continue;
            return false;
        }
        return bl;
    }
}

