/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NodeModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.ui.RevertiveBehaviorRenderer;
import cerent.cms.ui.blsr.BlsrNodeComparator;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class BlsrRingColumnRenderer
extends AbstractColumnRenderer {
    public static final int RING_NAME = 0;
    public static final int RING_TYPE = 1;
    public static final int LINE_RATE = 2;
    public static final int RING_STATE = 3;
    public static final int NODES_LIST = 4;
    public static final int RING_REVERSION = 5;
    public static final int SPAN_REVERSION = 6;
    static final int BY_NAME = 0;
    static final int[][] columns = new int[][]{{0, 1, 2, 3, 4, 5, 6}};
    private JLabel label;
    private JTextArea textArea;
    private int mode;
    private static int EMPTY_BORDER_WIDTH = 2;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, EMPTY_BORDER_WIDTH, 0, EMPTY_BORDER_WIDTH);
    private int rtime1 = -1;
    private int rtime2 = -2;
    private IRevertiveBehavior rb1 = null;
    private IRevertiveBehavior rb2 = null;
    private static final SDebug db = new SDebug("BlsrRingColumnRenderer");

    public BlsrRingColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.textArea = new JTextArea();
        this.textArea.setOpaque(true);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
        this.textArea.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3 = 0;
        JComponent jComponent = this.label;
        this.label.setText("");
        BlsrRingModel blsrRingModel = (BlsrRingModel)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (this.mode) {
            case 0: {
                this.label.setText(blsrRingModel.getRingName());
                break;
            }
            case 1: {
                this.label.setText(blsrRingModel.getBlsrRingInfo().getRingTypeString());
                break;
            }
            case 2: {
                this.label.setText(blsrRingModel.getBlsrRingInfo().getRingSpeedString());
                break;
            }
            case 3: {
                this.label.setText(blsrRingModel.getStateString());
                break;
            }
            case 4: {
                jComponent = this.textArea;
                String string = "";
                FontMetrics fontMetrics = this.textArea.getFontMetrics(this.textArea.getFont());
                int n4 = jTable.getColumnModel().getColumn(jTable.convertColumnIndexToView(n2)).getWidth();
                int n5 = 20;
                BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
                int n6 = blsrNodeArray.length;
                int n7 = 0;
                String string2 = "";
                TreeSet<BlsrNode> treeSet = new TreeSet<BlsrNode>(new BlsrNodeComparator());
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    treeSet.add(blsrNodeArray[i]);
                }
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n8;
                    NodeModel nodeModel;
                    BlsrNode blsrNode = (BlsrNode)iterator.next();
                    if (null != blsrNode && null != (nodeModel = blsrNode.getNodeModel())) {
                        string2 = nodeModel.getName() + "(" + blsrNode.getNodeId() + ")";
                        if (iterator.hasNext()) {
                            string2 = string2 + ", ";
                        }
                    }
                    if ((n8 = fontMetrics.stringWidth(string2)) > n4) {
                        string = string + string2 + "\n";
                        n7 = 0;
                        continue;
                    }
                    if (n7 + n8 > n4) {
                        string = string + "\n" + string2;
                        n7 = n8;
                        continue;
                    }
                    string = string + string2;
                    n7 += n8;
                }
                this.textArea.setText(string);
                break;
            }
            case 5: {
                IRevertiveBehavior iRevertiveBehavior = blsrRingModel.getBlsrRingInfo().getRingReversion();
                if (null == iRevertiveBehavior) {
                    this.label.setText("");
                    break;
                }
                this.label.setText(RevertiveBehaviorRenderer.getString(iRevertiveBehavior));
                break;
            }
            case 6: {
                IRevertiveBehavior iRevertiveBehavior = blsrRingModel.getBlsrRingInfo().getSpanReversion();
                if (null == iRevertiveBehavior) {
                    this.label.setText("");
                    break;
                }
                this.label.setText(RevertiveBehaviorRenderer.getString(iRevertiveBehavior));
                break;
            }
            default: {
                this.label.setText("INVALID!!!");
            }
        }
        ((Component)jComponent).setForeground(color);
        ((Component)jComponent).setBackground(color2);
        if (jComponent == this.textArea) {
            int n9;
            int n10 = this.textArea.getPreferredSize().height;
            if (n10 > n3) {
                n3 = n10;
            }
            if ((n9 = jTable.getRowHeight(n)) != n3) {
                if (BlsrRingColumnRenderer.db.on) {
                    db.println("Changing table row height from " + n9 + " to " + n3);
                }
                jTable.setRowHeight(n, n3);
            }
        }
        return jComponent;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        BlsrRingModel blsrRingModel = (BlsrRingModel)object;
        BlsrRingModel blsrRingModel2 = (BlsrRingModel)object2;
        int n2 = 0;
        switch (this.mode) {
            case 0: {
                n2 = blsrRingModel.getRingName().compareTo(blsrRingModel2.getRingName());
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)blsrRingModel.getBlsrRingInfo().getRingType(), (int)blsrRingModel2.getBlsrRingInfo().getRingType());
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare((int)blsrRingModel.getBlsrRingInfo().getRingSpeed(), (int)blsrRingModel2.getBlsrRingInfo().getRingSpeed());
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((int)blsrRingModel.getState(), (int)blsrRingModel2.getState());
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)blsrRingModel.getBlsrNodes().length, (int)blsrRingModel2.getBlsrNodes().length);
                break;
            }
            case 5: {
                this.rb1 = blsrRingModel.getBlsrRingInfo().getRingReversion();
                this.rb2 = blsrRingModel2.getBlsrRingInfo().getRingReversion();
                this.rtime1 = -1;
                this.rtime2 = -1;
                if (this.rb1.getReversionMode() == 2) {
                    this.rtime1 = this.rb1.getReversionTime();
                }
                if (this.rb2.getReversionMode() == 2) {
                    this.rtime2 = this.rb2.getReversionTime();
                }
                n2 = ComparisonUtil.compare((int)this.rtime1, (int)this.rtime2);
                break;
            }
            case 6: {
                this.rb1 = blsrRingModel.getBlsrRingInfo().getRingReversion();
                this.rb2 = blsrRingModel2.getBlsrRingInfo().getRingReversion();
                this.rtime1 = -1;
                this.rtime2 = -1;
                if (this.rb1.getReversionMode() == 2) {
                    this.rtime1 = this.rb1.getReversionTime();
                }
                if (this.rb2.getReversionMode() == 2) {
                    this.rtime2 = this.rb2.getReversionTime();
                }
                n2 = ComparisonUtil.compare((int)this.rtime1, (int)this.rtime2);
                break;
            }
            default: {
                if (BlsrRingColumnRenderer.db.on) {
                    db.println("Unknown column number (mode) is: " + this.mode);
                }
                n2 = 0;
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers(int n) {
        if (n < 0 || n >= columns.length) {
            return null;
        }
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columns[n].length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = BlsrRingColumnRenderer.createBlsrRingColumnRenderer(columns[n][i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createBlsrRingColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Ring Name";
                n3 = 70;
                bl = true;
                n2 = 0;
                break;
            }
            case 1: {
                string = "Ring Type";
                n3 = 70;
                bl = true;
                n2 = 0;
                break;
            }
            case 2: {
                string = "Line Rate";
                n3 = 60;
                bl = true;
                n2 = 0;
                break;
            }
            case 3: {
                string = "Status";
                n3 = 55;
                bl = true;
                n2 = 0;
                break;
            }
            case 4: {
                string = "Nodes";
                n3 = 180;
                bl = true;
                n2 = 0;
                break;
            }
            case 5: {
                string = "Ring Reversion";
                n3 = 120;
                bl = true;
                n2 = 0;
                break;
            }
            case 6: {
                string = "Span Reversion";
                n3 = 120;
                bl = true;
                n2 = 0;
                break;
            }
            default: {
                string = "ERROR";
                n3 = 90;
                bl = false;
                n2 = 2;
            }
        }
        return new BlsrRingColumnRenderer(n, string, n3, bl, n2);
    }
}

