/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.model.blsr.InvalidRingNameException;
import cerent.cms.model.blsr.MultipleSpansInCardException;
import cerent.cms.model.blsr.OspfAreaException;
import cerent.cms.model.blsr.ParallelSpanAlreadyPresentException;
import cerent.cms.model.blsr.RingTooLargeException;
import cerent.cms.model.blsr.SpanNoLongerPresentException;
import cerent.cms.model.blsr.WigglingCircuitException;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.blsr.AbstractBlsrWizardPane;
import cerent.cms.ui.blsr.BlsrDesignMap;
import cerent.cms.ui.blsr.BlsrMapLink;
import cerent.cms.ui.blsr.BlsrMapNode;
import cerent.cms.ui.blsr.RingCreationDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RcdCreationPane
extends AbstractBlsrWizardPane
implements ActionListener {
    private static SDebug db = new SDebug("RcdCreationPane");
    private RingCreationDialog parent;
    protected BlsrDesignMap blsrDesignMap;
    protected boolean inited = false;
    public static final String ADD_SPAN = "Add Span";
    public static final String REMOVE_SPAN = "Remove Span";
    public static final String REVERSE_SPAN = "Reverse Span";
    public static final String ADD = "Add";
    protected static final String REMOVE = "Remove";
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JPanel selectedLinkPanel;
    private JPanel buttonPanel;
    private JPanel reasonPanel;
    private JLabel selectedLinkLabel;
    private JTextField selectedLinkTF;
    private JButton addButton;
    private JButton removeButton;
    private JButton reverseButton;
    private JButton reasonButton;
    private BlsrMapLink selectedLink = null;
    private BlsrMapNode selectedNode = null;
    private BlsrSpan[] potentialWorkingSpans = null;
    private HashSet observedSpans = new HashSet();
    private BlsrSpanReversionObserver reversionObserver = new BlsrSpanReversionObserver();
    private int numberOfSelectedSpans = 0;
    private String BLSR_TERM;
    private String STS_TERM;
    private String SDCC_TERM;

    public RcdCreationPane(String string, RingCreationDialog ringCreationDialog) {
        super(string, ringCreationDialog);
        this.parent = ringCreationDialog;
    }

    @Override
    public void enteringPage() throws Exception {
        BlsrRingModel blsrRingModel;
        super.enteringPage();
        if (!this.inited) {
            this.initialize();
        }
        this.updateButtonStates();
        this.parent.setNextEnabled(false);
        if ((this.parent.isFourFiber() || this.parent.getWizardMode() == 1) && (blsrRingModel = this.parent.getBlsrRingModel()) != null) {
            this.parent.setNextEnabled(blsrRingModel.isLoopComplete());
        }
        this.blsrDesignMap.reInitMap();
        this.blsrDesignMap.updateView();
    }

    private void updateMap(BlsrSpan blsrSpan, boolean bl) {
        INetLink iNetLink;
        if (RcdCreationPane.db.on) {
            db.println("    ==============================");
            db.println(">>> updateMap(blsrSpan=" + blsrSpan + ", includeLink=" + bl + ")");
        }
        if ((iNetLink = blsrSpan.getOriginalLink()) == null) {
            iNetLink = blsrSpan.getReverseLink();
        }
        if (iNetLink != null) {
            Object object;
            BlsrMapLink blsrMapLink = this.blsrDesignMap.getBlsrMapLink(blsrSpan);
            if (blsrMapLink instanceof BlsrMapLink) {
                object = blsrMapLink;
                if (RcdCreationPane.db.on) {
                    db.println("The BlsrMapLink is: " + object);
                }
                ((BlsrMapLink)object).setIncluded(bl);
                ((BlsrMapLink)object).setCenterLabel();
            } else if (RcdCreationPane.db.on) {
                db.println("No BlsrMapLink could be found for this BlsrSpan:" + blsrSpan);
            }
            object = blsrSpan.getWestSide();
            if (RcdCreationPane.db.on) {
                db.println("The westNode is: " + object);
            }
            BlsrMapNode blsrMapNode = null;
            if (object != null) {
                blsrMapNode = this.blsrDesignMap.getBlsrMapNode(this.getRealNodeModel(((BlsrNode)object).getNodeModel()));
                blsrMapNode.setBlsrNodeId(((BlsrNode)object).getNodeId());
                if (RcdCreationPane.db.on) {
                    db.println("The west node id is: " + ((BlsrNode)object).getNodeId());
                }
            } else if (RcdCreationPane.db.on) {
                db.println("The west node is null.");
            }
            BlsrNode blsrNode = blsrSpan.getEastSide();
            if (RcdCreationPane.db.on) {
                db.println("The eastNode is: " + blsrNode);
            }
            BlsrMapNode blsrMapNode2 = null;
            if (blsrNode != null) {
                blsrMapNode2 = this.blsrDesignMap.getBlsrMapNode(this.getRealNodeModel(blsrNode.getNodeModel()));
                blsrMapNode2.setBlsrNodeId(blsrNode.getNodeId());
                if (RcdCreationPane.db.on) {
                    db.println("The east node id is: " + blsrNode.getNodeId());
                }
            } else if (RcdCreationPane.db.on) {
                db.println("The east node is null.");
            }
        } else if (RcdCreationPane.db.on) {
            db.println("Trying to update the map for a BlsrSpan (" + blsrSpan + ") which has no underlying INetLink!");
        }
        if (!bl) {
            this.refreshAllNodeIds();
        }
        if (RcdCreationPane.db.on) {
            db.println("<<< updateMap()");
            db.println("    ==============================");
        }
    }

    private void refreshAllNodeIds() {
        MapNode[] mapNodeArray = this.blsrDesignMap.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            BlsrMapNode blsrMapNode = (BlsrMapNode)mapNodeArray[i];
            if (null != blsrMapNode) {
                NodeModel nodeModel = this.getRealNodeModel((INodeModel)blsrMapNode.getUserObject());
                if (null != nodeModel) {
                    BlsrNode blsrNode;
                    if (RcdCreationPane.db.on) {
                        db.println("tempNodeModel is: " + nodeModel.getClass() + ":" + nodeModel);
                    }
                    if (null != (blsrNode = this.parent.getBlsrRingModel().getBlsrNode(nodeModel))) {
                        short s = blsrNode.getNodeId();
                        if (RcdCreationPane.db.on) {
                            db.println("tempNodeId is: " + s);
                        }
                        blsrMapNode.setBlsrNodeId(s);
                        continue;
                    }
                    if (!RcdCreationPane.db.on) continue;
                    db.println("tempBlsrNode is null (expected if this node is not in ring)");
                    continue;
                }
                if (!RcdCreationPane.db.on) continue;
                db.println("tempNodeModel is null!");
                continue;
            }
            if (!RcdCreationPane.db.on) continue;
            db.println("tempBlsrMapNode is null!");
        }
        this.blsrDesignMap.updateView();
    }

    private void printDebugInfo(String string) {
        if (RcdCreationPane.db.on) {
            db.println(" ======= " + string + " ========");
            db.println("selectedLink is: " + this.selectedLink);
            if (this.selectedLink != null) {
                db.println("blsrSpan for that link is:: " + this.getBlsrSpanForLink(this.selectedLink));
            }
            db.println(" ===============");
        }
    }

    private void updateTerms(INodeModel iNodeModel) {
        TDMTerminology tDMTerminology;
        try {
            tDMTerminology = iNodeModel.getTDMTerminology();
        }
        catch (Exception exception) {
            tDMTerminology = NetworkDefaults.getCmsHostTDMTerms();
        }
        this.BLSR_TERM = tDMTerminology.getRingTerms(1);
        this.STS_TERM = tDMTerminology.getGeneralTerms(0);
        this.SDCC_TERM = tDMTerminology.getGeneralTerms(8);
    }

    private void addSpan() {
        if (RcdCreationPane.db.on) {
            db.println("----> addSpan()");
        }
        if (this.selectedLink != null) {
            BlsrSpan blsrSpan = this.getBlsrSpanForLink(this.selectedLink);
            BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
            this.addSpanByUser(blsrSpan);
            try {
                boolean bl = blsrRingModel.checkIfLoopIsComplete();
            }
            catch (SpanNoLongerPresentException spanNoLongerPresentException) {
                BlsrSpan[] blsrSpanArray = spanNoLongerPresentException.getBlsrSpans();
                String string = "The following spans are no longer present: \n";
                for (int i = 0; i < blsrSpanArray.length; ++i) {
                    string = string + blsrSpanArray[i] + "\n";
                }
                ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_BLSR_SPAN_DOWN, string);
                this.removeSpan();
                return;
            }
        }
        if (RcdCreationPane.db.on) {
            db.println("<---- addSpan()");
        }
    }

    private void addExtraSpan(BlsrSpan blsrSpan) {
        block16: {
            try {
                this.addSpanInternal(blsrSpan);
                this.updateTerms(blsrSpan.getNodeEndPoints()[0]);
            }
            catch (ParallelSpanAlreadyPresentException parallelSpanAlreadyPresentException) {
                if (RcdCreationPane.db.on) {
                    db.println("Extra span " + blsrSpan + " could not be added : " + parallelSpanAlreadyPresentException);
                }
            }
            catch (MultipleSpansInCardException multipleSpansInCardException) {
                if (RcdCreationPane.db.on) {
                    db.println("Extra span " + blsrSpan + " could not be added : " + multipleSpansInCardException);
                }
            }
            catch (OspfAreaException ospfAreaException) {
                if (RcdCreationPane.db.on) {
                    db.println("Extra span " + blsrSpan + " could not be added : " + ospfAreaException);
                }
            }
            catch (WigglingCircuitException wigglingCircuitException) {
                if (RcdCreationPane.db.on) {
                    db.println("Extra span " + blsrSpan + " could not be added : " + wigglingCircuitException);
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (RcdCreationPane.db.on) {
                    db.println("Extra span " + blsrSpan + " could not be added : " + sanityCheckFailed);
                }
            }
            catch (RingTooLargeException ringTooLargeException) {
                if (RcdCreationPane.db.on) {
                    db.println("Extra span " + blsrSpan + " could not be added : " + ringTooLargeException);
                }
            }
            catch (InvalidRingNameException invalidRingNameException) {
                if (db.on()) {
                    db.println("Span " + blsrSpan + " could not be added: " + invalidRingNameException);
                }
            }
            catch (Exception exception) {
                if (!RcdCreationPane.db.on) break block16;
                db.println("Unexpected exception caught trying to add this span==> " + blsrSpan);
                db.println("The Exception message is: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void updateExcludedLinks(long l) {
        Collection collection = this.blsrDesignMap.getLinkUserObjects();
        Iterator iterator = collection.iterator();
        BlsrMapLink blsrMapLink = null;
        BlsrSpan blsrSpan = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            blsrMapLink = (BlsrMapLink)this.blsrDesignMap.getMapLink(e);
            int n = blsrMapLink.getState();
            if (n == 3 || n == 6 || null == (blsrSpan = blsrMapLink.getBlsrSpan()) || blsrSpan.getOspfAreaId() == l) continue;
            blsrMapLink.setState(6);
        }
    }

    private void clearExcludedLinks() {
        Collection collection = this.blsrDesignMap.getLinkUserObjects();
        Iterator iterator = collection.iterator();
        BlsrMapLink blsrMapLink = null;
        Object var4_4 = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            blsrMapLink = (BlsrMapLink)this.blsrDesignMap.getMapLink(e);
            if (blsrMapLink.getState() != 6) continue;
            blsrMapLink.setIncluded(false);
        }
    }

    private void addSpanByUser(BlsrSpan blsrSpan) {
        block12: {
            try {
                this.addSpanInternal(blsrSpan);
                this.updateExcludedLinks(blsrSpan.getOspfAreaId());
                this.blsrDesignMap.updateView();
            }
            catch (ParallelSpanAlreadyPresentException parallelSpanAlreadyPresentException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_ADD_SPAN_PARALLEL_SPAN_EXISTS);
            }
            catch (MultipleSpansInCardException multipleSpansInCardException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_ADD_SPAN_MULTIPLE_SPANS);
            }
            catch (OspfAreaException ospfAreaException) {
                SDebug.printStackTrace((Throwable)ospfAreaException);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_OSPF_AREA_ERROR_PARAM_1, (Object)ospfAreaException.getMessage());
            }
            catch (WigglingCircuitException wigglingCircuitException) {
                Map map = null;
                try {
                    map = this.parent.getBlsrRingModel().getWigglingCircuits(blsrSpan);
                    StringBuffer stringBuffer = new StringBuffer("");
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                        stringBuffer.append("- " + iNetCircuit.getCircuitName() + (iterator.hasNext() ? "\n" : ""));
                    }
                    ErrorMsg.displayError((Component)((Object)this), NEMC.EID_CANT_ADD_SPAN_WIGGLING_CIRCUIT_PARAM_2, this.STS_TERM, stringBuffer);
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    ErrorMsg.displayError((Component)((Object)this), NEMC.EID_CANT_ADD_SPAN_WIGGLING_CIRCUIT_PARAM_2, this.STS_TERM, sanityCheckFailed.getMessage());
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                ErrorMsg.displayError((Component)((Object)this), NEMC.EID_CANT_ADD_SPAN_WIGGLING_CIRCUIT_PARAM_2, this.STS_TERM, sanityCheckFailed.getMessage());
            }
            catch (RingTooLargeException ringTooLargeException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_TOO_MANY_NODES);
            }
            catch (InvalidRingNameException invalidRingNameException) {
                SDebug.printStackTrace((Throwable)invalidRingNameException);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_ADD_SPAN_NAME_PARAM_1, (Object)Integer.toString(blsrSpan.getMaxRingNameLength()));
            }
            catch (Exception exception) {
                if (!RcdCreationPane.db.on) break block12;
                db.println("Unexpected exception caught trying to add this span==> " + blsrSpan);
                db.println("The Exception message is: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void addSpanInternal(BlsrSpan blsrSpan) throws ParallelSpanAlreadyPresentException, MultipleSpansInCardException, OspfAreaException, WigglingCircuitException, RingTooLargeException, InvalidRingNameException, SanityCheckFailed {
        if (RcdCreationPane.db.on) {
            db.println(">>> addSpan(blsrSpan=" + blsrSpan + ")");
        }
        if (blsrSpan != null) {
            BlsrSpan blsrSpan2;
            int n;
            BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
            long l = blsrSpan.getOspfAreaId();
            blsrRingModel.addBlsrSpan(blsrSpan);
            BlsrNode blsrNode = blsrSpan.getEastSide();
            BlsrNode blsrNode2 = blsrSpan.getWestSide();
            ArrayList<BlsrSpan> arrayList = new ArrayList<BlsrSpan>();
            ArrayList<BlsrSpan> arrayList2 = new ArrayList<BlsrSpan>();
            if (blsrNode != null && blsrNode2 != null) {
                for (n = 0; n < this.potentialWorkingSpans.length; ++n) {
                    blsrSpan2 = this.potentialWorkingSpans[n];
                    if (blsrSpan2.equals(blsrSpan) || blsrRingModel.containsBlsrSpan(blsrSpan2)) continue;
                    NetLink netLink = (NetLink)blsrSpan2.getOriginalLink();
                    if (netLink.getSrc().getNodeModel().equals(blsrNode.getNodeModel()) && netLink.getOspfAreaId() == l) {
                        arrayList.add(blsrSpan2);
                    } else if (netLink.getSrc().getNodeModel().equals(blsrNode2.getNodeModel()) && netLink.getOspfAreaId() == l) {
                        arrayList2.add(blsrSpan2);
                    }
                    if (netLink.getDst().getNodeModel().equals(blsrNode.getNodeModel()) && netLink.getOspfAreaId() == l) {
                        arrayList.add(blsrSpan2);
                        continue;
                    }
                    if (!netLink.getDst().getNodeModel().equals(blsrNode2.getNodeModel()) || netLink.getOspfAreaId() != l) continue;
                    arrayList2.add(blsrSpan2);
                }
            }
            if (RcdCreationPane.db.on) {
                db.println("========================================================");
                db.println("after adding span:" + blsrSpan);
                db.println("  eastSideSpans that were found=" + arrayList.size());
                for (n = 0; n < arrayList.size(); ++n) {
                    db.println("   " + n + "  " + (BlsrSpan)arrayList.get(n));
                }
                db.println("  westSideSpans that were found=" + arrayList2.size());
                for (n = 0; n < arrayList2.size(); ++n) {
                    db.println("   " + n + "  " + (BlsrSpan)arrayList2.get(n));
                }
            }
            if (RcdCreationPane.db.on) {
                db.println(" --- Checking the west side of the east node (" + blsrNode + ")...");
            }
            if (blsrNode.getWestMain() == null) {
                if (arrayList.size() == 1) {
                    blsrSpan2 = (BlsrSpan)arrayList.get(0);
                    BlsrNode blsrNode3 = this.getOtherSideBlsrNode(blsrSpan2, blsrNode);
                    if (blsrNode3 != null) {
                        if (blsrNode3.getEastMain() == null) {
                            if (RcdCreationPane.db.on) {
                                db.println("***** Automatically adding span: " + blsrSpan2);
                            }
                            this.addExtraSpan(blsrSpan2);
                        } else if (RcdCreationPane.db.on) {
                            db.println("Since the otherSideNode has the West port already set, I will not try adding span " + blsrSpan2);
                        }
                    } else {
                        if (RcdCreationPane.db.on) {
                            db.println("The other side BlsrNode is null - which means the node is not in the ring so adding:" + blsrSpan2);
                        }
                        this.addExtraSpan(blsrSpan2);
                    }
                } else if (RcdCreationPane.db.on) {
                    db.println("Because there is not exactly one span available, I won't try to add anything to the west side of " + blsrNode);
                }
            } else if (RcdCreationPane.db.on) {
                db.println("The west port is not null so I won't try to add anything to the west side of " + blsrNode);
            }
            if (RcdCreationPane.db.on) {
                db.println(" --- Checking the east side of the west node (" + blsrNode2 + ")...");
            }
            if (blsrNode2.getEastMain() == null) {
                if (arrayList2.size() == 1) {
                    blsrSpan2 = (BlsrSpan)arrayList2.get(0);
                    BlsrNode blsrNode4 = this.getOtherSideBlsrNode(blsrSpan2, blsrNode2);
                    if (blsrNode4 != null) {
                        if (blsrNode4.getWestMain() == null) {
                            if (RcdCreationPane.db.on) {
                                db.println("***** Automatically adding span: " + blsrSpan2);
                            }
                            this.addExtraSpan(blsrSpan2);
                        } else if (RcdCreationPane.db.on) {
                            db.println("Since the otherSideNode has the East port already set, I will not try adding span " + blsrSpan2);
                        }
                    } else {
                        if (RcdCreationPane.db.on) {
                            db.println("The other side BlsrNode is null - which means the node is not in the ring so adding:" + blsrSpan2);
                        }
                        this.addExtraSpan(blsrSpan2);
                    }
                } else if (RcdCreationPane.db.on) {
                    db.println("Because there is not exactly one span available, I won't try to add anything to the east side of " + blsrNode2);
                }
            } else if (RcdCreationPane.db.on) {
                db.println("The east port is not null so I won't try to add anything to the east side of " + blsrNode2);
            }
            this.updateMap(blsrSpan, true);
        }
        if (RcdCreationPane.db.on) {
            db.println("<<< addSpan()");
            this.spewBlsrRingInformation();
        }
        this.updateButtonStates();
    }

    private BlsrNode getOtherSideBlsrNode(BlsrSpan blsrSpan, BlsrNode blsrNode) {
        if (RcdCreationPane.db.on) {
            db.println(">>> getOtherSideBlsrNode(blsrSpan=" + blsrSpan + ", blsrNode=" + blsrNode);
        }
        BlsrNode blsrNode2 = null;
        NodeModel nodeModel = blsrNode.getNodeModel();
        if (RcdCreationPane.db.on) {
            db.println("startingNodeModel was: " + nodeModel);
        }
        INetLink iNetLink = null;
        iNetLink = blsrSpan.getOriginalLink();
        if (iNetLink == null) {
            iNetLink = blsrSpan.getReverseLink();
        }
        if (iNetLink != null) {
            if (RcdCreationPane.db.on) {
                db.println("netLink is: " + iNetLink);
            }
            NodeModel nodeModel2 = (NodeModel)iNetLink.getSrc().getNodeModel();
            NodeModel nodeModel3 = (NodeModel)iNetLink.getDst().getNodeModel();
            BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
            if (nodeModel2.equals(nodeModel)) {
                if (RcdCreationPane.db.on) {
                    db.println("Getting the BlsrNode for the dstNodeModel: " + nodeModel3);
                }
                blsrNode2 = blsrRingModel.getBlsrNode(nodeModel3);
            }
            if (nodeModel3.equals(nodeModel)) {
                if (RcdCreationPane.db.on) {
                    db.println("Getting the BlsrNode for the srcNodeModel: " + nodeModel2);
                }
                blsrNode2 = blsrRingModel.getBlsrNode(nodeModel2);
            }
        } else if (RcdCreationPane.db.on) {
            db.println("netLink is null!");
        }
        if (RcdCreationPane.db.on) {
            db.println("<<< getOtherSideBlsrNode returning: " + blsrNode2);
        }
        return blsrNode2;
    }

    private void removeSpan() {
        if (RcdCreationPane.db.on) {
            db.println(">>> removeSpan()");
        }
        if (this.selectedLink != null) {
            this.printDebugInfo("entering removeSpan()");
            BlsrSpan blsrSpan = this.getBlsrSpanForLink(this.selectedLink);
            BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
            if (blsrSpan == null) {
                if (RcdCreationPane.db.on) {
                    db.println("The blsrSpan you're trying to remove is null!  selectedLink = " + this.selectedLink);
                }
            } else {
                try {
                    blsrRingModel.removeBlsrSpan(blsrSpan);
                    if (blsrRingModel.getOspfArea() == null) {
                        if (RcdCreationPane.db.on) {
                            db.println("getOspfArea returned null -- clearing the EXCLUDED links.");
                        }
                        this.clearExcludedLinks();
                    }
                    this.updateMap(blsrSpan, false);
                }
                catch (IllegalStateException illegalStateException) {
                    SDebug.printStackTrace((Throwable)illegalStateException);
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ILLEGAL_STATE_EXCEPTION);
                }
                catch (Exception exception) {
                    if (RcdCreationPane.db.on) {
                        db.println("getOspfArea returned null -- clearing the EXCLUDED links.");
                    }
                    this.clearExcludedLinks();
                }
                this.updateMap(blsrSpan, false);
            }
        }
        this.printDebugInfo("exiting removeSpan()");
        if (RcdCreationPane.db.on) {
            db.println("<<< removeSpan()");
            this.spewBlsrRingInformation();
        }
        this.updateButtonStates();
    }

    public void reverseSpan() {
        block8: {
            if (RcdCreationPane.db.on) {
                db.println(">>> reverseSpan()");
            }
            if (this.selectedLink != null) {
                this.printDebugInfo("entering reverseSpan()");
                BlsrSpan blsrSpan = this.getBlsrSpanForLink(this.selectedLink);
                BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
                if (blsrSpan == null) {
                    if (RcdCreationPane.db.on) {
                        db.println("The blsrSpan you're trying to reverse is null!  selectedLink = " + this.selectedLink);
                    }
                } else {
                    try {
                        blsrRingModel.reverseSpanDirection(blsrSpan);
                    }
                    catch (Exception exception) {
                        if (!RcdCreationPane.db.on) break block8;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
        this.printDebugInfo("exiting reverseSpan()");
        if (RcdCreationPane.db.on) {
            db.println("<<< reverseSpan()");
            this.spewBlsrRingInformation();
        }
        this.updateButtonStates();
    }

    private void spewBlsrRingInformation() {
        Object object;
        int n;
        BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
        BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
        BlsrSpan[] blsrSpanArray = blsrRingModel.getPotentialWorkingSpans();
        db.println("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
        for (n = 0; n < blsrNodeArray.length; ++n) {
            object = blsrNodeArray[n];
            db.println("node " + n + " is: " + object);
            db.println("  eastMain is: " + ((BlsrNode)object).getEastMain());
            db.println("  westMain is: " + ((BlsrNode)object).getWestMain());
            db.println("  eastProtectPort is: " + ((BlsrNode)object).getEastProtectPort());
            db.println("  westProtectPort is: " + ((BlsrNode)object).getWestProtectPort());
        }
        for (n = 0; n < blsrSpanArray.length; ++n) {
            object = blsrSpanArray[n];
            db.println("workingSpans " + n + " is: " + object);
            db.println("  eastSide is: " + ((BlsrSpan)object).getEastSide());
            db.println("  eastProtectPort is: " + ((BlsrSpan)object).getEastProtectPort());
            db.println("  westSide is: " + ((BlsrSpan)object).getWestSide());
            db.println("  westProtectPort is: " + ((BlsrSpan)object).getWestProtectPort());
            db.println("    included in this ringModel? : " + blsrRingModel.containsBlsrSpan((BlsrSpan)object));
        }
        db.println("isLoopComplete returns: " + blsrRingModel.isLoopComplete());
        db.println("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("addButton")) {
            if (null != this.parent && null != this.selectedLink) {
                this.addSpan();
            }
        } else if (string.equals("removeButton")) {
            if (null != this.parent && null != this.selectedLink) {
                this.removeSpan();
            }
        } else if (string.equals("reverseButton")) {
            if (null != this.parent && null != this.selectedLink) {
                this.reverseSpan();
            }
        } else if (string.equals("reasonButton")) {
            if (null != this.parent) {
                BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
                if (null != blsrRingModel) {
                    SortedMap sortedMap = blsrRingModel.getBedEliminatedNodes();
                    if (sortedMap.isEmpty()) {
                        CerentDialog.infoDialog((Component)((Object)this), (String)"There are no eliminated nodes to display.", (String)"Nothing to display");
                    } else {
                        EliminatedNodesDialog eliminatedNodesDialog = new EliminatedNodesDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), sortedMap);
                        eliminatedNodesDialog.setVisible(true);
                    }
                } else if (RcdCreationPane.db.on) {
                    db.println("ringModel is null trying to get reasons");
                }
            } else if (RcdCreationPane.db.on) {
                db.println("parent is null trying to get reasons");
            }
        }
    }

    @Override
    public void validatePage() throws Exception {
    }

    @Override
    protected boolean okToProceed() {
        Map map;
        BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
        if (!blsrRingModel.getBlsrRingInfo().isFourFiber() && !(map = blsrRingModel.getSpansWithPotentialPCATraffic()).isEmpty()) {
            return this.askAllowUpperSTSCircuits(map);
        }
        return true;
    }

    private boolean askAllowUpperSTSCircuits(Map map) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<Object> hashSet = new HashSet<Object>();
        Collection collection = map.values();
        Iterator iterator = collection.iterator();
        Iterator iterator2 = null;
        while (iterator.hasNext()) {
            iterator2 = ((Collection)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                object = ((SpanRow)iterator2.next()).circuit;
                int n = object.getProtType();
                if (n == 18) {
                    if (!db.on()) continue;
                    db.println("parsing possible TO-PCA spans; ignoring " + object.getCircuitName() + " as it is DRI.");
                    continue;
                }
                hashSet.add(object);
                this.updateTerms(object.getSrcNetElement().getNodeModel());
            }
        }
        if (hashSet.isEmpty()) {
            return true;
        }
        object = hashSet.size() == 1 ? "is" : "are";
        String string = hashSet.size() == 1 ? "circuit" : "circuits";
        stringBuffer.append("There " + (String)object + " " + hashSet.size() + " " + string + " that will become PCA " + string + " if this " + this.BLSR_TERM + " is provisioned.\nWould you like to continue?");
        return CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Is it OK to route these circuits as PCA traffic?");
    }

    private INetElement getNetElement(MapNode mapNode) {
        if (mapNode == null) {
            return null;
        }
        NodeModel nodeModel = (NodeModel)mapNode.getUserObject();
        return Network.instance().getNetElem(nodeModel.getNodeId());
    }

    private NodeModel getNodeModel(MapNode mapNode) {
        if (mapNode == null) {
            return null;
        }
        return (NodeModel)mapNode.getUserObject();
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (bl) {
            this.selectedNode = mapNode instanceof BlsrMapNode ? (BlsrMapNode)mapNode : null;
            this.selectedLink = null;
            this.selectedLinkTF.setText("");
        } else {
            this.selectedNode = null;
        }
        this.updateButtonStates();
    }

    void linkSelected(MapLink mapLink, boolean bl) {
        if (bl) {
            if (mapLink instanceof BlsrMapLink) {
                this.selectedLink = (BlsrMapLink)mapLink;
                this.selectedLinkTF.setText(mapLink.getToolTipText());
            }
        } else {
            this.selectedLink = null;
            this.selectedLinkTF.setText("");
        }
        this.updateButtonStates();
    }

    private void initialize() {
        this.blsrDesignMap = new BlsrDesignMap(this);
        this.setLayout(new BorderLayout(2, 1));
        JComponent jComponent = this.blsrDesignMap.getGraphWindow();
        jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
        this.topPanel = RcdCreationPane.createHorizontalPanel(null);
        this.add(this.topPanel, "Center");
        this.topPanel.add(jComponent);
        this.bottomPanel = RcdCreationPane.createVerticalPanel(null);
        this.add(this.bottomPanel, "South");
        this.selectedLinkLabel = new JLabel("Selected Link: ");
        this.selectedLinkTF = new JTextField(35);
        this.selectedLinkTF.setEditable(false);
        this.selectedLinkPanel = RcdCreationPane.createHorizontalPanel(null);
        this.selectedLinkPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.selectedLinkPanel.add(this.selectedLinkLabel);
        this.selectedLinkPanel.add(this.selectedLinkTF);
        this.addButton = new JButton(ADD_SPAN);
        this.addButton.setActionCommand("addButton");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(REMOVE_SPAN);
        this.removeButton.setActionCommand("removeButton");
        this.removeButton.addActionListener(this);
        this.reverseButton = new JButton(REVERSE_SPAN);
        this.reverseButton.setActionCommand("reverseButton");
        this.reverseButton.addActionListener(this);
        this.buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(this.reverseButton);
        this.reasonButton = new JButton("Excluded Nodes...");
        this.reasonButton.setToolTipText("Lists the nodes excluded from this map and the reason why");
        this.reasonButton.setActionCommand("reasonButton");
        this.reasonButton.addActionListener(this);
        this.reasonPanel = RcdCreationPane.createHorizontalPanel(null);
        this.reasonPanel.add(this.reasonButton);
        this.bottomPanel.add(this.selectedLinkPanel);
        this.bottomPanel.add(this.buttonPanel);
        this.bottomPanel.add(this.reasonPanel);
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.inited = true;
    }

    @Override
    public void refresh() {
        if (!this.observedSpans.isEmpty()) {
            for (BlsrSpan blsrSpan : this.observedSpans) {
                blsrSpan.getReversionNotifier().deleteObserver(this.reversionObserver);
            }
        }
        this.potentialWorkingSpans = this.parent.getBlsrRingModel().getPotentialWorkingSpans();
        for (int i = 0; i < this.potentialWorkingSpans.length; ++i) {
            BlsrSpan blsrSpan = this.potentialWorkingSpans[i];
            blsrSpan.getReversionNotifier().addObserver(this.reversionObserver);
            this.observedSpans.add(blsrSpan);
        }
        if (null != this.blsrDesignMap) {
            if (RcdCreationPane.db.on) {
                db.println("blsrDesignMap is being cleared and reshown");
            }
            this.blsrDesignMap.showBlsrObjects();
            this.blsrDesignMap.setViewToCenter();
        } else if (RcdCreationPane.db.on) {
            db.println("***** blsrDesignMap is null in enteringPage");
        }
        this.updateButtonStates();
    }

    public RingCreationDialog getRingCreationDialog() {
        return this.parent;
    }

    public void updateButtonStates() {
        boolean bl;
        Object object;
        if (RcdCreationPane.db.on) {
            db.println("updateButtonStates() called");
        }
        if (null == this.selectedLink) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.reverseButton.setEnabled(false);
        } else {
            object = this.getBlsrSpanForLink(this.selectedLink);
            if (RcdCreationPane.db.on) {
                db.println("+++ Calling ringModel.containsBlsrSpan(" + object + ")");
            }
            bl = this.parent.getBlsrRingModel().containsBlsrSpan((BlsrSpan)object);
            if (RcdCreationPane.db.on) {
                db.println("--- Returned from ringModel.containsBlsrSpan(" + object + ")");
            }
            this.addButton.setEnabled(!bl);
            this.removeButton.setEnabled(bl);
            this.reverseButton.setEnabled(bl);
        }
        if (null != this.parent) {
            object = this.parent.getBlsrRingModel();
            if (null != object) {
                bl = ((BlsrRingModel)object).isLoopComplete();
                if (this.parent.getWizardMode() == 1) {
                    this.parent.setNextEnabled(bl);
                } else if (this.parent.isFourFiber()) {
                    this.parent.setNextEnabled(bl);
                } else {
                    this.parent.setFinishEnabled(bl);
                }
                if (bl) {
                    this.addButton.setEnabled(false);
                }
            } else if (RcdCreationPane.db.on) {
                db.println("in updateButtonStates, ringModel is null!");
            }
        } else if (RcdCreationPane.db.on) {
            db.println("in updateButtonStates, parent is null!");
        }
    }

    private BlsrSpan getBlsrSpanForLink(INetLink iNetLink) {
        int n;
        if (RcdCreationPane.db.on) {
            db.println(">>> getBlsrSpanForLink(INetLink netLink)");
        }
        if (iNetLink == null) {
            if (RcdCreationPane.db.on) {
                db.println("getBlsrSpanForLink returning null for null netLink.");
                db.println("<<< getBlsrSpanForLink(INetLink netLink)");
            }
            return null;
        }
        BlsrSpan blsrSpan = null;
        for (n = 0; n < this.potentialWorkingSpans.length; ++n) {
            blsrSpan = this.potentialWorkingSpans[n];
            if (blsrSpan.getOriginalLink() != iNetLink) continue;
            if (RcdCreationPane.db.on) {
                db.println("getBlsrSpanForLink returning:" + blsrSpan);
                db.println("<<< getBlsrSpanForLink(INetLink netLink)");
            }
            return blsrSpan;
        }
        for (n = 0; n < this.potentialWorkingSpans.length; ++n) {
            blsrSpan = this.potentialWorkingSpans[n];
            if (blsrSpan.getReverseLink() != iNetLink) continue;
            if (RcdCreationPane.db.on) {
                db.println("getBlsrSpanForLink returning (from reverse link):" + blsrSpan);
                db.println("<<< getBlsrSpanForLink(INetLink netLink)");
            }
            return blsrSpan;
        }
        if (RcdCreationPane.db.on) {
            db.println("getBlsrSpanForLink returning null - BlsrSpan found for link:" + iNetLink);
            db.println("<<< getBlsrSpanForLink(INetLink netLink)");
        }
        return null;
    }

    private BlsrSpan getBlsrSpanForLink(BlsrMapLink blsrMapLink) {
        INetLink iNetLink = (INetLink)blsrMapLink.getUserObject();
        return this.getBlsrSpanForLink(iNetLink);
    }

    public BlsrSpan[] getPotentialWorkingSpans() {
        return this.potentialWorkingSpans;
    }

    public void doubleClicked(MapLink mapLink) {
        BlsrRingModel blsrRingModel;
        BlsrSpan blsrSpan;
        if (mapLink != null && (blsrSpan = this.getBlsrSpanForLink((BlsrMapLink)mapLink)) != null && (blsrRingModel = this.parent.getBlsrRingModel()) != null) {
            if (blsrRingModel.containsBlsrSpan(blsrSpan)) {
                this.removeSpan();
            } else {
                this.addSpanByUser(blsrSpan);
                try {
                    boolean bl = blsrRingModel.checkIfLoopIsComplete();
                }
                catch (SpanNoLongerPresentException spanNoLongerPresentException) {
                    BlsrSpan[] blsrSpanArray = spanNoLongerPresentException.getBlsrSpans();
                    String string = "The following spans are no longer present: \n";
                    for (int i = 0; i < blsrSpanArray.length; ++i) {
                        string = string + blsrSpanArray[i] + "\n";
                    }
                    ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_BLSR_SPAN_DOWN, string);
                    this.removeSpan();
                    return;
                }
            }
        }
    }

    public BlsrRingModel getBlsrRingModel() {
        BlsrRingModel blsrRingModel = null;
        if (this.parent != null) {
            blsrRingModel = this.parent.getBlsrRingModel();
        }
        return blsrRingModel;
    }

    private NodeModel getRealNodeModel(INodeModel iNodeModel) {
        NodeModel nodeModel = null;
        if (iNodeModel instanceof NodeModel) {
            nodeModel = (NodeModel)iNodeModel;
        }
        return nodeModel;
    }

    @Override
    public void dispose() {
        if (RcdCreationPane.db.on) {
            db.println("dispose() called");
        }
        if (!this.observedSpans.isEmpty()) {
            for (BlsrSpan blsrSpan : this.observedSpans) {
                blsrSpan.getReversionNotifier().deleteObserver(this.reversionObserver);
            }
        }
        if (null != this.blsrDesignMap) {
            this.blsrDesignMap.dispose();
        }
        this.parent = null;
        super.dispose();
    }

    public boolean hasSelectedSpans() {
        BlsrSpan[] blsrSpanArray;
        boolean bl = false;
        BlsrRingModel blsrRingModel = this.parent.getBlsrRingModel();
        if (null != blsrRingModel && (blsrSpanArray = blsrRingModel.getWorkingBlsrSpans()).length > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public CSHelpID getHelpID() {
        CSHelpID cSHelpID = this.parent.getWizardMode() == 0 ? NetCSHelpConst.RcdCreationPane : NetCSHelpConst.UpsrToBlsrCreationPane;
        return cSHelpID;
    }

    public BlsrMapLink getSelectedLink() {
        return this.selectedLink;
    }

    public BlsrMapNode getSelectedNode() {
        return this.selectedNode;
    }

    private class BlsrSpanReversionObserver
    implements Observer {
        private BlsrSpanReversionObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            BlsrSpan blsrSpan = (BlsrSpan)object;
            if (db.on) {
                db.println("The BlsrSpan that reversed direction was: " + blsrSpan);
            }
            RcdCreationPane.this.updateMap(blsrSpan, true);
        }
    }

    private class EliminatedNodesDialog
    extends JDialog
    implements ActionListener {
        private Map eliminatedNodes;
        private JTextArea textArea;
        private JButton okButton;

        public EliminatedNodesDialog(Frame frame, Map map) {
            Object object;
            Object object2;
            Object object3;
            super(frame, "Excluded Nodes", true);
            this.eliminatedNodes = null;
            this.textArea = new JTextArea(10, 50);
            this.okButton = null;
            this.eliminatedNodes = map;
            this.textArea.setEditable(false);
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            String string = "";
            while (iterator.hasNext()) {
                object3 = (INodeModel)iterator.next();
                RcdCreationPane.this.updateTerms((INodeModel)object3);
                string = string + object3.getName() + " ";
                object2 = map.get(object3);
                object = (BlsrRingModel.BedEliminationReason)object2;
                string = object.equals(BlsrRingModel.BedEliminationReason.NO_BLSR_SUPPORT) ? string + "no compatible " + RcdCreationPane.this.BLSR_TERM + " support was found for this node" : (object.equals(BlsrRingModel.BedEliminationReason.DOES_NOT_PROVIDE) ? string + "has an older load that does not support the\n " + RcdCreationPane.this.BLSR_TERM + " wizard feature." : (object.equals(BlsrRingModel.BedEliminationReason.PATH_SELECTOR) ? string + "has path selectors." : (object.equals(BlsrRingModel.BedEliminationReason.BLSR_LIMIT_REACHED) ? string + "already has the maximum number of " + RcdCreationPane.this.BLSR_TERM + "s." : (object.equals(BlsrRingModel.BedEliminationReason.BLSR_WITH_SAME_RING_ID) ? string + "already has a " + RcdCreationPane.this.BLSR_TERM + " with this ring ID provisioned on it." : (object.equals(BlsrRingModel.BedEliminationReason.FOUR_FIBER_LIMIT_REACHED) ? string + "already has the maximum number of four-fiber " + RcdCreationPane.this.BLSR_TERM + "s." : (object.equals(BlsrRingModel.BedEliminationReason.NEEDED_SPAN_IN_BLSR) ? string + "does not have enough free working ports\n to provision this " + RcdCreationPane.this.BLSR_TERM + "." : (object.equals(BlsrRingModel.BedEliminationReason.NOT_IN_LOOP) ? string + "is not in a loop consisting of spans of the\n correct speed which are available for " + RcdCreationPane.this.BLSR_TERM + "\n provisioning." : (object.equals(BlsrRingModel.BedEliminationReason.NOT_ENOUGH_PROTECT_PORTS) || object.equals(BlsrRingModel.BedEliminationReason.ORDER_WIRE_ON_PROTECT_PORT) ? string + "does not have enough protect ports available.\n Protect ports must not have any overhead circuits, " + RcdCreationPane.this.SDCC_TERM + ",\n " + "IPCC or be used as a timing source, and the port must be enabled." : (object.equals(BlsrRingModel.BedEliminationReason.OPTICAL_PROTECTION_GROUP) ? string + "has an optical protection group defined on\n the working ports." : (object.equals(BlsrRingModel.BedEliminationReason.NOT_ENOUGH_SPANS_OF_RIGHT_SPEED) ? string + "does not have enough spans of the right speed\n available for " + RcdCreationPane.this.BLSR_TERM + " provisioning (check " + RcdCreationPane.this.SDCC_TERM + " terminations)." : (object.equals(BlsrRingModel.BedEliminationReason.FOUR_FIBER_INCAPABLE_NODE) ? string + "does not support four-fiber " + RcdCreationPane.this.BLSR_TERM + "s." : (object.equals(BlsrRingModel.BedEliminationReason.INSUFFICIENT_SECURITY_PERMISSION) ? string + "does not have a user with enough security\n permissions as the user you logged in with." : (object.equals(BlsrRingModel.BedEliminationReason.NODE_NOT_INITED) ? string + "is not initialized." : (object.equals(BlsrRingModel.BedEliminationReason.INCONSISTENT_MEDIUM_TYPE) ? string + "is connected to another node with a link that\n has inconsistent terminations (SDH/SONET)." : (object.equals(BlsrRingModel.BedEliminationReason.ALL_LINKS_ON_SAME_CARD) ? string + "has all of its links on the same card." : (object.equals(BlsrRingModel.BedEliminationReason.INCOMPATIBLE_FEATURE_VERSION) ? string + "does not have a compatible " + RcdCreationPane.this.BLSR_TERM + " version." : (object.equals(BlsrRingModel.BedEliminationReason.HIGH_LOW_HO_CIRCUIT) ? string + "has at least one circuit that occupies some\n portion of both the working and protect " + RcdCreationPane.this.STS_TERM + "\n regions of a needed span." : (object.equals(BlsrRingModel.BedEliminationReason.INVALID_OSPF_AREA) ? string + "does not have enough spans in the same OSPF area." : (object.equals(BlsrRingModel.BedEliminationReason.WIGGLING_CIRCUITS) ? string + "does not have enough spans. A needed span\n would cause a circuit to occupy different " + RcdCreationPane.this.STS_TERM + "\n " + "regions in any " + RcdCreationPane.this.BLSR_TERM + " involving this node." : (object.equals(BlsrRingModel.BedEliminationReason.NOT_ENOUGH_SPANS_WITHOUT_LDCC) ? string + "does not have enough spans with " + RcdCreationPane.this.SDCC_TERM + " terminations.\n " + "Only " + RcdCreationPane.this.SDCC_TERM + " terminations can be used when creating a " + RcdCreationPane.this.BLSR_TERM + "." : string + "some unknown error occurred: " + ((BlsrRingModel.BedEliminationReason)object).toString()))))))))))))))))))));
                string = string + "\n";
            }
            this.textArea.setText(string);
            this.okButton = new JButton("OK");
            this.okButton.setActionCommand("okButton");
            this.okButton.addActionListener(this);
            this.getContentPane().setLayout(new BorderLayout());
            object3 = new JPanel(new BorderLayout());
            object2 = new UScrollPane((Component)this.textArea);
            ((Container)object3).add((Component)object2, "Center");
            object = new JPanel();
            ((Container)object).add(this.okButton);
            this.getContentPane().add((Component)object3, "Center");
            this.getContentPane().add((Component)object, "South");
            this.pack();
            this.center(frame);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("okButton")) {
                this.setVisible(false);
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            this.okButton.removeActionListener(this);
            super.dispose();
        }

        public void center(Frame frame) {
            Dimension dimension = frame.getSize();
            Dimension dimension2 = this.getSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            this.setLocation(n + frame.getX(), n2 + frame.getY());
        }
    }
}

