/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.DuplicateRingId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.blsr.BlsrCompatBundle;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrProvisionException;
import cerent.cms.model.blsr.BlsrRingIdInUseException;
import cerent.cms.model.blsr.BlsrRingInfo;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.model.blsr.CircuitOnHighAndLowHOException;
import cerent.cms.model.blsr.IncompatibleBlsrNodesException;
import cerent.cms.model.blsr.InconsistentMediumTypeException;
import cerent.cms.model.blsr.InvalidProtectPortsSpecifiedException;
import cerent.cms.model.blsr.NodeUnreachableException;
import cerent.cms.model.blsr.OspfAreaException;
import cerent.cms.model.blsr.PathSelectorOnSpanException;
import cerent.cms.model.blsr.PortsInProtectionGroupException;
import cerent.cms.model.blsr.PortsNotEnabledException;
import cerent.cms.model.blsr.PortsNotSpecifiedException;
import cerent.cms.model.blsr.PortsSdccTerminatedException;
import cerent.cms.model.blsr.PortsWithOrderwireException;
import cerent.cms.model.blsr.SpanAlreadyInBlsrException;
import cerent.cms.model.blsr.SpanNoLongerPresentException;
import cerent.cms.model.blsr.TimingReferenceException;
import cerent.cms.model.blsr.TooManyBlsrException;
import cerent.cms.model.blsr.TopoUpgradeNotSupportedException;
import cerent.cms.model.blsr.WigglingCircuitException;
import cerent.cms.model.vf.BlsrVersion;
import cerent.cms.ncp.InServiceUpgradeError;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.blsr.AbstractBlsrWizardDialog;
import cerent.cms.ui.blsr.AbstractBlsrWizardPane;
import cerent.cms.ui.blsr.RcdAttrsPane;
import cerent.cms.ui.blsr.RcdCreationPane;
import cerent.cms.ui.blsr.RcdProtectPortPane;
import cerent.cms.ui.blsr.RcdUpsr2BlsrPane;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Set;
import javax.swing.JOptionPane;

public class RingCreationDialog
extends AbstractBlsrWizardDialog {
    private BlsrRingManager blsrRingManager = BlsrRingManager.instance();
    private BlsrRingModel blsrRingModel = null;
    private static INodeModel nodeModel;
    public static String GET_ATTRS;
    public static String DESIGN_PANE;
    public static String PROTECT_PORT_PANE;
    public static String UPSR2BLSR_FORCE_TRAFFIC_PANE;
    public static String UPSR2BLSR_CONVERSION_PANE;
    private static final UiToolkit uiToolkit;
    private static final int VIGN_WIDTH = 200;
    private static final int WIDTH = 750;
    private static String PREF_WIDTH;
    private static String PREF_TALL;
    static final int SHORT = 375;
    static final int TALL = 600;
    private RingCreationDebug ringCreationDebug;
    int tallWidth = 750;
    int tallHeight = 600;
    BlsrRingInfo blsrRingInfo = new BlsrRingInfo(null, -1, 2, 1, tdmTerm);
    RcdAttrsPane rcdAttrsPane;
    RcdCreationPane rcdCreationPane;
    RcdProtectPortPane rcdProtectPortPane;
    RcdUpsr2BlsrPane rcdUpsr2BlsrForceTrafficPane;
    RcdUpsr2BlsrPane rcdUpsr2BlsrConversionPane;
    private boolean insaneMode = false;
    private boolean revModified = false;
    protected static TDMTerminology tdmTerm;
    private static String STS_TERM;
    private static String dccTerm;
    private static String UPSR_TERM;
    private static final SDebug db;
    private static int wizardMode;
    public static final int CREATE = 0;
    public static final int UPSR2BLSR = 1;

    public static RingCreationDialog instance(Component component, INodeModel iNodeModel, int n, TDMTerminology tDMTerminology) {
        nodeModel = iNodeModel;
        wizardMode = n;
        tdmTerm = tDMTerminology;
        UPSR_TERM = tDMTerminology.getRingTerms(0);
        BLSR_TERM = tDMTerminology.getRingTerms(1);
        STS_TERM = tDMTerminology.getGeneralTerms(0);
        dccTerm = tDMTerminology.getGeneralTerms(8);
        GET_ATTRS = BLSR_TERM + " Attributes";
        DESIGN_PANE = "Create " + BLSR_TERM;
        PROTECT_PORT_PANE = "Protect Port Selection Pane";
        UPSR2BLSR_FORCE_TRAFFIC_PANE = UPSR_TERM + " to " + BLSR_TERM + " Force Traffic";
        UPSR2BLSR_CONVERSION_PANE = UPSR_TERM + " to " + BLSR_TERM + " Conversion";
        String string = n == 1 ? UPSR_TERM + " to " + BLSR_TERM + " Topology Conversion" : BLSR_TERM + " Creation";
        Frame frame = JOptionPane.getFrameForComponent(component);
        return new RingCreationDialog(frame, string);
    }

    private RingCreationDialog(Frame frame, String string) {
        super(frame, string);
        this.reset();
        this.createPanes();
        this.setLocationRelativeTo(frame);
        this.ringCreationDebug = new RingCreationDebug("ringCreationDebug", this);
    }

    private void createPanes() {
        if (RingCreationDialog.db.on) {
            db.println("createPanes() called");
        }
        this.addStatusPanel(new WizardDialog.StatusPanel(this, "/images/CTC_dialogVignette.gif", new Dimension(200, 375)));
        this.rcdAttrsPane = new RcdAttrsPane(GET_ATTRS, this, tdmTerm);
        this.addPage(this.rcdAttrsPane);
        if (wizardMode == 1) {
            this.rcdAttrsPane.setEnabledFourFiberButton(false);
        }
        this.rcdCreationPane = new RcdCreationPane(DESIGN_PANE, this);
        this.addPage(this.rcdCreationPane);
        if (wizardMode == 1) {
            this.rcdUpsr2BlsrForceTrafficPane = new RcdUpsr2BlsrPane(UPSR2BLSR_FORCE_TRAFFIC_PANE, this, 1);
            this.addPage(this.rcdUpsr2BlsrForceTrafficPane);
            this.rcdUpsr2BlsrConversionPane = new RcdUpsr2BlsrPane(UPSR2BLSR_CONVERSION_PANE, this, 2);
            this.addPage(this.rcdUpsr2BlsrConversionPane);
        } else {
            this.rcdProtectPortPane = new RcdProtectPortPane(PROTECT_PORT_PANE, this);
            this.addPage(this.rcdProtectPortPane);
        }
    }

    @Override
    protected void reset() {
        if (RingCreationDialog.db.on) {
            db.println("reset() called");
        }
        if (this.getStatusPanel() != null) {
            this.getStatusPanel().reset();
        }
        this.setFinishEnabled(false);
        this.readRingPrefs();
        this.setDialogSize(750, 375);
        if (wizardMode == 1) {
            this.setRingType(2);
        }
        super.reset();
    }

    void setDialogSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
        this.invalidate();
    }

    private String helpGetDefaultValue(String string, String string2) {
        block4: {
            try {
                string2 = nodeModel.getDefaultValue(string);
            }
            catch (NoSuchDefault noSuchDefault) {
                if (db.isWarningEnabled()) {
                    db.warning("Warning: NoSuchDefault on " + string);
                    SDebug.printStackTrace((Throwable)noSuchDefault);
                }
            }
            catch (Exception exception) {
                if (!db.isWarningEnabled()) break block4;
                db.warning("Warning: on " + string + ": " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string2;
    }

    private int getDefaultRevertive(String string, int n) {
        String string2 = this.helpGetDefaultValue(string, String.valueOf(n));
        n = string2.equalsIgnoreCase("true") ? 2 : 1;
        return n;
    }

    private int getDefaultReversionTime(String string, int n) {
        String string2 = this.helpGetDefaultValue(string, String.valueOf(n));
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            db.warning("Warning: NumberFormatException for " + string);
        }
        return n;
    }

    private void readRingPrefs() {
        if (RingCreationDialog.db.on) {
            db.println("Reading preferences now...");
        }
        Preferences preferences = Preferences.instance();
        this.tallWidth = preferences.getInt("ctc.net_blsr_wiz", PREF_WIDTH, 750);
        this.tallHeight = preferences.getInt("ctc.net_blsr_wiz", PREF_TALL, 600);
        this.blsrRingInfo.setRingType(preferences.getInt("ctc.net_blsr_wiz", "type", 2));
        this.blsrRingInfo.setRingSpeed(preferences.getInt("ctc.net_blsr_wiz", "speed", 2));
        int n = this.getDefaultRevertive("NODE.protection.blsr.RingRevertive", 2);
        int n2 = this.getDefaultReversionTime("NODE.protection.blsr.RingReversionTime", 300);
        RevertiveBehavior revertiveBehavior = new RevertiveBehavior(n, n2);
        this.blsrRingInfo.setUnprovisionedRingReversion(revertiveBehavior);
        n = this.getDefaultRevertive("NODE.protection.blsr.SpanRevertive", 2);
        n2 = this.getDefaultReversionTime("NODE.protection.blsr.SpanReversionTime", 300);
        RevertiveBehavior revertiveBehavior2 = new RevertiveBehavior(n, n2);
        this.blsrRingInfo.setUnprovisionedSpanReversion(revertiveBehavior2);
    }

    private void writeRingUIPrefs() {
        Preferences preferences = Preferences.instance();
        String string = this.getPageName();
        if (string == DESIGN_PANE) {
            this.tallWidth = this.getWidth();
            preferences.setInt("ctc.net_blsr_wiz", PREF_WIDTH, this.tallWidth);
            this.tallHeight = this.getHeight();
            preferences.setInt("ctc.net_blsr_wiz", PREF_TALL, this.tallHeight);
        }
    }

    private void writeRingPrefs() {
        if (RingCreationDialog.db.on) {
            db.println("Writing preferences now...");
        }
        Preferences preferences = Preferences.instance();
        preferences.setInt("ctc.net_blsr_wiz", "type", this.blsrRingInfo.getRingType());
        preferences.setInt("ctc.net_blsr_wiz", "speed", this.blsrRingInfo.getRingSpeed());
    }

    @Override
    protected void handleBack(String string) {
        if (RingCreationDialog.db.on) {
            db.println("handleBack(pageName=" + string + ") called");
        }
        this.writeRingUIPrefs();
        if (string == DESIGN_PANE) {
            boolean bl = true;
            if (null != this.rcdCreationPane && this.rcdCreationPane.hasSelectedSpans()) {
                bl = CerentDialog.yesNoDialog((Component)this, (String)"If you go back, you will lose the span selections\nmade in this pane.\n\nIs it OK to return to the previous page?", (String)"Confirmation");
            }
            if (bl) {
                this.showPage(GET_ATTRS, false);
            } else {
                this.rcdCreationPane.updateButtonStates();
            }
        } else if (string == PROTECT_PORT_PANE) {
            this.showPage(DESIGN_PANE, true);
        } else if (wizardMode == 1 && string == UPSR2BLSR_FORCE_TRAFFIC_PANE) {
            this.clearUpsr2BlsrUpgrade();
            this.showPage(DESIGN_PANE, true);
        } else {
            super.handleBack(string);
        }
        this.doLayout();
    }

    @Override
    protected void handleNext(String string) throws Exception {
        if (RingCreationDialog.db.on) {
            db.println("handleNext(pageName=" + string + ") called");
        }
        this.writeRingUIPrefs();
        boolean bl = true;
        if (string == GET_ATTRS) {
            String string2 = this.blsrRingInfo.getRingName();
            if (string2 != null && string2.trim().length() > 0) {
                Object object;
                Set set = this.blsrRingManager.getBlsrRingModel(string2);
                if (!set.isEmpty()) {
                    bl = false;
                    object = new String();
                    object = (String)object + "There is at least one ring named " + string2 + " in the network.\n";
                    object = (String)object + "It is illegal to have two rings with the same ring name for a given network element.\n";
                    object = (String)object + "Therefore, some nodes will not appear as candidates for this ring.\n";
                    object = (String)object + "\nAre you sure you want to continue?";
                    bl = CerentDialog.yesNoDialog((Component)this, (String)object, (String)"Confirmation");
                }
                if (bl) {
                    if (RingCreationDialog.db.on) {
                        db.println("Calling createBlsrRingModel now...");
                    }
                    this.blsrRingModel = wizardMode == 0 ? this.blsrRingManager.createBlsrRingModel(this.blsrRingInfo) : this.blsrRingManager.createBlsrRingModelForUpsr2BlsrConversion(this.blsrRingInfo);
                    if (RingCreationDialog.db.on) {
                        db.println("Returned from calling createBlsrRingModel now...");
                    }
                    if (RingCreationDialog.db.on) {
                        db.println("Calling getPotentialWorkingSpans...");
                    }
                    object = this.blsrRingModel.getPotentialWorkingSpans();
                    if (RingCreationDialog.db.on) {
                        db.println("Returned from calling getPotentialWorkingSpans... Spans found is: " + ((BlsrSpan[])object).length);
                    }
                    if (((BlsrSpan[])object).length <= 0) {
                        String string3 = "A(n) " + BLSR_TERM + " with these attributes cannot be created.  This means\n";
                        string3 = string3 + "that all of the nodes and spans in your network have been excluded for some\n";
                        string3 = string3 + "reason.  Click on the \"Excluded nodes...\" button to see a list\n";
                        string3 = string3 + "of nodes and why they cannot be included in the " + BLSR_TERM + " that you are creating.";
                        CerentDialog.infoDialog((Component)this, (String)string3, (String)("Cannot create " + BLSR_TERM));
                    }
                    this.writeRingPrefs();
                    this.showPage(DESIGN_PANE, false);
                    this.setBackEnabled(true);
                }
            }
        } else if (string == DESIGN_PANE && wizardMode == 1) {
            this.showPage(UPSR2BLSR_FORCE_TRAFFIC_PANE, false);
        } else if (string == PROTECT_PORT_PANE) {
            this.rcdProtectPortPane.printInfo();
        } else {
            super.handleNext(string);
        }
        this.doLayout();
    }

    @Override
    protected void handleCancel() {
        this.writeRingUIPrefs();
        if (wizardMode == 1) {
            this.clearUpsr2BlsrUpgrade();
            this.restoreAlarmPane();
        }
        super.handleCancel();
    }

    @Override
    protected void handleFinish() {
        this.writeRingUIPrefs();
        if (wizardMode == 1) {
            this.restoreAlarmPane();
        }
        super.handleFinish();
    }

    protected void restoreAlarmPane() {
        if (wizardMode != 1) {
            return;
        }
        this.rcdUpsr2BlsrConversionPane.leavingPage();
    }

    protected void clearUpsr2BlsrUpgrade() {
        if (wizardMode != 1) {
            return;
        }
        try {
            if (this.blsrRingModel != null) {
                this.blsrRingModel.clearUpsr2BlsrUpgrade();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void switchTrafficToShortestPath() throws Exception {
        if (wizardMode != 1) {
            return;
        }
        try {
            uiToolkit.setCursor(3);
            this.sanityCheck();
            db.println("RingCreationDialog: " + BLSR_TERM + " SanityCheck has passed." + "  Starting with " + UPSR_TERM + " to " + BLSR_TERM + " upgrade.");
            this.blsrRingModel.switchTrafficToShortestPath();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            String string = "The " + UPSR_TERM + " to " + BLSR_TERM + " upgrade failed during the sanity check.";
            throw new AnnotatedException(string, (Exception)sanityCheckFailed);
        }
        catch (InServiceUpgradeError inServiceUpgradeError) {
            String string = "The " + UPSR_TERM + " to " + BLSR_TERM + " upgrade operation failed to switch traffic to the shortest path.";
            throw new AnnotatedException(string, (Exception)inServiceUpgradeError);
        }
        finally {
            uiToolkit.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void apply() throws Exception {
        block16: {
            if (RingCreationDialog.db.on) {
                db.println("apply() called");
            }
            try {
                uiToolkit.setCursor(3);
                if (RingCreationDialog.db.on) {
                    db.println("Setting cursor to an hourglass");
                }
                boolean bl = false;
                if (wizardMode != 1) {
                    this.rcdProtectPortPane.apply();
                }
                this.sanityCheck();
                bl = true;
                if (!bl) break block16;
                try {
                    if (wizardMode == 1) {
                        db.println("RingCreationDialog: " + BLSR_TERM + " SanityCheck has passed.  Starting with " + UPSR_TERM + " to " + BLSR_TERM + " upgrade.");
                        this.blsrRingModel.upgradeUpsr2Blsr();
                    }
                    if (RingCreationDialog.db.on) {
                        db.println("+++ Calling blsrRingModel.provision()");
                    }
                    this.blsrRingModel.provision();
                    if (RingCreationDialog.db.on) {
                        db.println("--- Returned from blsrRingModel.provision()");
                    }
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    String string = "The " + UPSR_TERM + " to " + BLSR_TERM + " upgrade failed during the sanity check.";
                    throw new AnnotatedException(string, (Exception)sanityCheckFailed);
                }
                catch (InServiceUpgradeError inServiceUpgradeError) {
                    String string = "The " + UPSR_TERM + " to " + BLSR_TERM + " upgrade operation failed.";
                    throw new AnnotatedException(string, (Exception)inServiceUpgradeError);
                }
                catch (BlsrProvisionException blsrProvisionException) {
                    BlsrNode[] blsrNodeArray = blsrProvisionException.getBlsrNodes();
                    String string = "The " + BLSR_TERM + " could not be provisioned on the following nodes:\n";
                    for (int i = 0; i < blsrNodeArray.length; ++i) {
                        string = string + blsrNodeArray[i] + "\n";
                    }
                    throw new AnnotatedException(string, (Exception)blsrProvisionException);
                }
                String string = "The " + BLSR_TERM + " creation finished successfully.";
                if (wizardMode == 1) {
                    string = "The " + UPSR_TERM + " was successfully upgraded to " + BLSR_TERM + ".";
                }
                DetailedLog detailedLog = new DetailedLog(1, string);
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            }
            finally {
                uiToolkit.setCursor(0);
                if (RingCreationDialog.db.on) {
                    db.println("Setting cursor back to normal");
                }
            }
        }
    }

    @Override
    public boolean handleFinishException(Exception exception) {
        String string;
        if (RingCreationDialog.db.on) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if ((string = exception.getMessage()) == null) {
            string = exception.toString();
        }
        ErrorMsg.displayError(this, NEMC.EID_UNABLE_TO_PROV_BLSR_PARAM_2, BLSR_TERM, string);
        try {
            Set set = this.blsrRingManager.getBlsrRingModel(this.blsrRingModel.getRingName());
            for (BlsrRingModel blsrRingModel : set) {
                blsrRingModel.delete();
            }
        }
        catch (Exception exception2) {
            SDebug.printStackTrace((Throwable)exception2);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_UNABLE_TO_UNPROV_BLSR_PARAM_1, (Object)BLSR_TERM);
        }
        return true;
    }

    private void disposePane(AbstractBlsrWizardPane abstractBlsrWizardPane) {
        if (abstractBlsrWizardPane != null) {
            try {
                abstractBlsrWizardPane.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sanityCheck() throws Exception {
        try {
            if (!this.insaneMode) {
                if (RingCreationDialog.db.on) {
                    db.println("+++ Calling blsrRingModel.sanityCheck()");
                }
                this.blsrRingModel.sanityCheck();
                if (RingCreationDialog.db.on) {
                    db.println("--- Returned from blsrRingModel.sanityCheck()");
                }
            } else if (RingCreationDialog.db.on) {
                db.println("skipping sanityCheck call - because I am insane!");
            }
            boolean bl = false;
            if (this.isFourFiber()) {
                bl = this.blsrRingModel.getProtectExtensionByteMismatchSpans().length != 0;
            } else {
                boolean bl2 = bl = this.blsrRingModel.getWorkingExtensionByteMismatchSpans().length != 0 || this.blsrRingModel.getProtectExtensionByteMismatchSpans().length != 0;
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("There is at least one span which has a " + BLSR_TERM + " Extension\nByte mismatch. ");
                stringBuffer.append("The provisioning will continue but you\nwill need to go to the " + BLSR_TERM + " ");
                stringBuffer.append("edit window and correct\nthis problem by right-clicking on the red span(s) to\n");
                stringBuffer.append("change the extension byte to the same value on both\nsides of the span ");
                stringBuffer.append("before the " + BLSR_TERM + " will switch properly.\n");
                ErrorMsg.displayWarning((Component)this, (WID)NEMC.WID_EXTENSION_BYTE_MISMATCH_PARAM_1, (Object)stringBuffer.toString());
            }
        }
        catch (TooManyBlsrException tooManyBlsrException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught TooManyBlsrException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = tooManyBlsrException.getBlsrNodes();
            String string = "The following nodes cannot be provisioned because: \n";
            string = string + "    they already have two " + BLSR_TERM + "s provisioned";
            string = this.isFourFiber() ? string + "\n    or they already have a four-fiber " + BLSR_TERM + " provisioned.\n" : string + ".\n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)tooManyBlsrException);
        }
        catch (BlsrRingIdInUseException blsrRingIdInUseException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught BlsrRingIdInUseException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = blsrRingIdInUseException.getBlsrNodes();
            String string = "The following nodes already have a " + BLSR_TERM + " named " + this.getRingName() + ".\n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)blsrRingIdInUseException);
        }
        catch (SpanNoLongerPresentException spanNoLongerPresentException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught SpanNoLongerPresentException in sanityCheck()");
            }
            BlsrSpan[] blsrSpanArray = spanNoLongerPresentException.getBlsrSpans();
            String string = "The following spans are no longer present: \n";
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                string = string + blsrSpanArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)spanNoLongerPresentException);
        }
        catch (InconsistentMediumTypeException inconsistentMediumTypeException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught InconsistentMeditumTypeException in sanityCheck()");
            }
            BlsrSpan[] blsrSpanArray = inconsistentMediumTypeException.getBlsrSpans();
            String string = "The following spans have inconsistent medium type: \n";
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                string = string + blsrSpanArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)inconsistentMediumTypeException);
        }
        catch (PathSelectorOnSpanException pathSelectorOnSpanException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught PathSelectorOnSpanException in sanityCheck()");
            }
            BlsrSpan[] blsrSpanArray = pathSelectorOnSpanException.getBlsrSpans();
            String string = "The following spans have path selectors: \n";
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                string = string + blsrSpanArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)pathSelectorOnSpanException);
        }
        catch (CircuitOnHighAndLowHOException circuitOnHighAndLowHOException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught CircuitOnHighAndLowHOException in sanityCheck()");
            }
            BlsrSpan[] blsrSpanArray = circuitOnHighAndLowHOException.getBlsrSpans();
            String string = "The following spans have circuits which occupy both working and protect " + STS_TERM + " regions: \n";
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                string = string + blsrSpanArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)circuitOnHighAndLowHOException);
        }
        catch (InvalidProtectPortsSpecifiedException invalidProtectPortsSpecifiedException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught InvalidProtectPortsSpecifiedException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = invalidProtectPortsSpecifiedException.getBlsrNodes();
            String string = "The following nodes have invalid protect ports specified: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)invalidProtectPortsSpecifiedException);
        }
        catch (SpanAlreadyInBlsrException spanAlreadyInBlsrException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught SpanAlreadyInBlsrException in sanityCheck()");
            }
            BlsrSpan[] blsrSpanArray = spanAlreadyInBlsrException.getBlsrSpans();
            String string = "The following spans are already participating in " + BLSR_TERM + "s: \n";
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                string = string + blsrSpanArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)spanAlreadyInBlsrException);
        }
        catch (TimingReferenceException timingReferenceException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught TimingReferenceException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = timingReferenceException.getBlsrNodes();
            String string = "The following nodes have ports which are currently used as timing references: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)timingReferenceException);
        }
        catch (PortsSdccTerminatedException portsSdccTerminatedException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught PortsSdccTerminatedException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = portsSdccTerminatedException.getBlsrNodes();
            String string = "The following nodes have protect ports which currently have " + dccTerm + " terminations: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)portsSdccTerminatedException);
        }
        catch (PortsNotSpecifiedException portsNotSpecifiedException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught PortsNotSpecifiedException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = portsNotSpecifiedException.getBlsrNodes();
            String string = "The following nodes do not have properly specified protect ports: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)portsNotSpecifiedException);
        }
        catch (PortsNotEnabledException portsNotEnabledException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught PortsNotEnabledException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = portsNotEnabledException.getBlsrNodes();
            String string = "The following nodes have ports which are not currently In Service: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)portsNotEnabledException);
        }
        catch (PortsWithOrderwireException portsWithOrderwireException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught PortsWithOrderwireException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = portsWithOrderwireException.getBlsrNodes();
            String string = "The following nodes have ports which currently have orderwire specified: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)portsWithOrderwireException);
        }
        catch (NodeUnreachableException nodeUnreachableException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught SpanConnectedToUnreachableNodeException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = nodeUnreachableException.getBlsrNodes();
            String string = "The following nodes are currently unreachable: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)nodeUnreachableException);
        }
        catch (PortsInProtectionGroupException portsInProtectionGroupException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught PortsInProtectionGroupException in sanityCheck()");
            }
            BlsrNode[] blsrNodeArray = portsInProtectionGroupException.getBlsrNodes();
            String string = "The following nodes have ports which currently in protection groups specified: \n";
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                string = string + blsrNodeArray[i] + "\n";
            }
            throw new AnnotatedException(string, (Exception)portsInProtectionGroupException);
        }
        catch (TopoUpgradeNotSupportedException topoUpgradeNotSupportedException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught TopoUpgradeNotSupportedException in sanityCheck()");
            }
            INodeModel[] iNodeModelArray = topoUpgradeNotSupportedException.getUnsupportedNodes();
            StringBuffer stringBuffer = new StringBuffer("The following nodes do not support " + UPSR_TERM + " to " + BLSR_TERM + " conversion:\n");
            for (int i = 0; i < iNodeModelArray.length; ++i) {
                INodeModel iNodeModel = iNodeModelArray[i];
                stringBuffer.append(iNodeModel.getName());
                if (i + 2 < iNodeModelArray.length) {
                    stringBuffer.append(", ");
                    continue;
                }
                if (i + 1 < iNodeModelArray.length) {
                    stringBuffer.append(" and ");
                    continue;
                }
                stringBuffer.append(".");
            }
            throw new AnnotatedException(stringBuffer.toString(), (Exception)topoUpgradeNotSupportedException);
        }
        catch (IncompatibleBlsrNodesException incompatibleBlsrNodesException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught IncompatibleBlsrNodesException in sanityCheck()");
            }
            BlsrCompatBundle[] blsrCompatBundleArray = incompatibleBlsrNodesException.getBlsrCompatBundles();
            StringBuffer stringBuffer = new StringBuffer("The following nodes have " + BLSR_TERM + " implementations that are incompatible with one another:\n");
            for (int i = 0; i < blsrCompatBundleArray.length; ++i) {
                BlsrCompatBundle blsrCompatBundle = blsrCompatBundleArray[i];
                BlsrVersion blsrVersion = (BlsrVersion)blsrCompatBundle.getVersion();
                INodeModel[] iNodeModelArray = blsrCompatBundle.getNodes();
                stringBuffer.append("Software Version " + iNodeModelArray[0].getSwVersion() + ": ");
                for (int j = 0; j < iNodeModelArray.length; ++j) {
                    stringBuffer.append(iNodeModelArray[j].getName());
                    if (j + 2 < iNodeModelArray.length) {
                        stringBuffer.append(", ");
                        continue;
                    }
                    if (j + 1 < iNodeModelArray.length) {
                        stringBuffer.append(" and ");
                        continue;
                    }
                    stringBuffer.append(".");
                }
                stringBuffer.append("\n");
            }
            throw new AnnotatedException(stringBuffer.toString(), (Exception)incompatibleBlsrNodesException);
        }
        catch (OspfAreaException ospfAreaException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught OspfAreaException in sanityCheck()");
            }
            throw new AnnotatedException(ospfAreaException.getMessage(), (Exception)ospfAreaException);
        }
        catch (WigglingCircuitException wigglingCircuitException) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught WigglingCircuitException in sanityCheck()");
            }
            throw new AnnotatedException("", (Exception)wigglingCircuitException);
        }
        catch (Exception exception) {
            if (RingCreationDialog.db.on) {
                db.println("--- caught \"generic\" Exception in sanityCheck()");
            }
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("An unexpected exception occured during provisioning.  The ring failed to provision.", exception);
        }
    }

    @Override
    public void dispose() {
        if (RingCreationDialog.db.on) {
            db.println("dispose() called");
        }
        this.disposePane(this.rcdAttrsPane);
        this.rcdAttrsPane = null;
        this.disposePane(this.rcdCreationPane);
        this.rcdCreationPane = null;
        this.disposePane(this.rcdProtectPortPane);
        this.rcdProtectPortPane = null;
        if (null != this.rcdUpsr2BlsrForceTrafficPane) {
            this.rcdUpsr2BlsrForceTrafficPane.dispose();
            this.rcdUpsr2BlsrForceTrafficPane = null;
        }
        if (null != this.rcdUpsr2BlsrConversionPane) {
            this.rcdUpsr2BlsrConversionPane.dispose();
            this.rcdUpsr2BlsrConversionPane = null;
        }
        if (null != this.blsrRingModel) {
            try {
                this.blsrRingModel.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.blsrRingModel = null;
        }
        this.ringCreationDebug.dispose();
        super.dispose();
    }

    protected int getRingType() {
        return this.blsrRingInfo.getRingType();
    }

    protected void setRingType(int n) {
        this.blsrRingInfo.setRingType(n);
    }

    protected int getRingSpeed() {
        return this.blsrRingInfo.getRingSpeed();
    }

    protected void setRingSpeed(int n) {
        if (this.blsrRingInfo.getRingSpeed() != n) {
            this.blsrRingInfo.setRingSpeed(n);
            if (this.rcdCreationPane.blsrDesignMap != null) {
                this.rcdCreationPane.blsrDesignMap.reInitMap();
            }
            db.fine("setRingSpeed: setting ring speed to " + n);
        }
    }

    protected String getRingName() {
        return this.blsrRingInfo.getRingName();
    }

    protected void setRingName(String string) {
        if (string.length() > 0) {
            try {
                this.blsrRingInfo.setRingName(string);
            }
            catch (DuplicateRingId duplicateRingId) {
                ErrorMsg.displayError(null, (EID)NEMC.EID_BLSR_UNIQUE_RING_ID);
            }
            catch (BlsrSpanSwitched blsrSpanSwitched) {
                ErrorMsg.displayError(null, (EID)NEMC.EID_BLSR_SWITCH_ACTIVE_CAN_NOT_CHANGE_RING_NAME_PARAM_1, (Object)BLSR_TERM);
            }
        } else {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_BLSR_NO_RING_NAME);
        }
    }

    protected IRevertiveBehavior getRingReversion() {
        return this.blsrRingInfo.getRingReversion();
    }

    protected void setRingReversion(IRevertiveBehavior iRevertiveBehavior) {
        this.blsrRingInfo.setUnprovisionedRingReversion(iRevertiveBehavior);
    }

    protected IRevertiveBehavior getSpanReversion() {
        return this.blsrRingInfo.getSpanReversion();
    }

    protected void setSpanReversion(IRevertiveBehavior iRevertiveBehavior) {
        this.blsrRingInfo.setUnprovisionedSpanReversion(iRevertiveBehavior);
    }

    @Override
    protected BlsrRingModel getBlsrRingModel() {
        return this.blsrRingModel;
    }

    @Override
    public void showPage(String string, boolean bl) {
        if (RingCreationDialog.db.on) {
            db.println("showPage(pageName=" + string + ", refresh=" + bl + ") called");
        }
        if (string.equals(DESIGN_PANE)) {
            this.setDialogSize(this.tallWidth, this.tallHeight);
        } else {
            this.setDialogSize(750, 375);
        }
        super.showPage(string, bl);
    }

    public boolean isFourFiber() {
        return this.blsrRingInfo.isFourFiber();
    }

    public void setRevModified(boolean bl) {
        this.revModified = bl;
    }

    public void setInsaneMode(boolean bl) {
        this.insaneMode = bl;
    }

    public int getWizardMode() {
        return wizardMode;
    }

    static {
        uiToolkit = UiToolkit.instance();
        PREF_WIDTH = "twidth";
        PREF_TALL = "theight";
        db = new SDebug("RingCreationDialog");
    }

    public class RingCreationDebug
    extends SDebug {
        private RingCreationDialog _rcd;

        public RingCreationDebug(String string, RingCreationDialog ringCreationDialog2) {
            super(string);
            this._rcd = ringCreationDialog2;
        }

        public final void goInsane() {
            if (null != this._rcd) {
                this._rcd.setInsaneMode(true);
            }
        }

        public final void goSane() {
            if (null != this._rcd) {
                this._rcd.setInsaneMode(false);
            }
        }

        public final void printHasSelections() {
            if (null != this._rcd) {
                if (this._rcd.rcdCreationPane.hasSelectedSpans()) {
                    this.println("true");
                } else {
                    this.println("false");
                }
            }
        }

        public void dispose() {
            this._rcd = null;
            super.dispose();
        }
    }
}

