/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ui.WizardPane;
import cerent.cms.ui.circuits.BulkRollDialog;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BulkRollAttrsPane
extends WizardPane
implements ActionListener {
    private static SDebug db = new SDebug("BulkRollAttrsPane");
    UComboBox rollModeCB;
    UComboBox rollTypeCB;
    JCheckBox forceRollCompletionCB;
    ButtonGroup radioButtonGroup;
    BulkRollDialog parent;
    public static final String ROLL_TYPE_SINGLE = "Single";
    public static final String ROLL_TYPE_DUAL = "Dual";
    private static final String ROLL_MODE_AUTO = "Auto";
    private static final String ROLL_MODE_MANUAL = "Manual";
    private String lastRollType;

    public BulkRollAttrsPane(String string, BulkRollDialog bulkRollDialog) {
        super(string, bulkRollDialog);
        this.parent = bulkRollDialog;
        this.initializePane();
    }

    protected void initializePane() {
        this.setLayout(new GridLayout(1, 2));
        JPanel jPanel = BulkRollAttrsPane.createVerticalPanel("Roll");
        this.add(jPanel);
        JPanel jPanel2 = BulkRollAttrsPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Roll Mode: "));
        this.rollModeCB = new UComboBox();
        this.rollModeCB.addItem((Object)ROLL_MODE_MANUAL);
        this.rollModeCB.addItem((Object)ROLL_MODE_AUTO);
        jPanel2.add((Component)this.rollModeCB);
        this.rollModeCB.addActionListener((ActionListener)this);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = BulkRollAttrsPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Roll Type: "));
        this.rollTypeCB = new UComboBox();
        this.setRollTypeSelection();
        this.lastRollType = (String)this.rollTypeCB.getSelectedItem();
        jPanel2.add((Component)this.rollTypeCB);
        this.rollTypeCB.addActionListener((ActionListener)this);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = BulkRollAttrsPane.createVerticalPanel("Force parameters");
        this.add(jPanel3);
        jPanel2 = BulkRollAttrsPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Force Completion: "));
        this.forceRollCompletionCB = new JCheckBox();
        this.forceRollCompletionCB.addActionListener(this);
        jPanel2.add(this.forceRollCompletionCB);
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalStrut(5));
    }

    private void setRollTypeSelection() {
        this.rollTypeCB.addItem((Object)ROLL_TYPE_SINGLE);
        this.rollTypeCB.addItem((Object)ROLL_TYPE_DUAL);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void validatePage() throws Exception {
        boolean bl = false;
        String string = (String)this.rollTypeCB.getSelectedItem();
        if (!string.equals(this.lastRollType)) {
            bl = true;
            this.lastRollType = string;
        }
        this.parent.rollType = string;
        this.parent.guiRollMode = ((String)this.rollModeCB.getSelectedItem()).equals(ROLL_MODE_AUTO) ? 0 : 1;
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Circuit Roll Mode: ");
        stringBuffer.append(this.rollModeCB.getSelectedItem());
        stringBuffer.append("\nCircuit Roll Type: ");
        stringBuffer.append(this.parent.rollType);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rollModeCB || object == this.rollTypeCB) {
            if (((String)this.rollTypeCB.getSelectedItem()).equals(ROLL_TYPE_DUAL) && ((String)this.rollModeCB.getSelectedItem()).equals(ROLL_MODE_AUTO)) {
                ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_DUAL_AUTO_WARNING);
            }
        } else if (object == this.forceRollCompletionCB) {
            // empty if block
        }
    }
}

