/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CcdVcatRoutePane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.LabelUI;

public class CcdLoPane
extends WzCcdPane
implements ChangeListener {
    protected JRadioButton lotRB;
    protected JRadioButton lapRB;
    protected JLabel infoLbl;
    protected JRadioButton noneRB;
    protected ButtonGroup createOptionalBG;
    protected JRadioButton useSrcRB;
    protected JRadioButton useDstRB;
    protected ButtonGroup vapBG;
    private NetCircuitManager ncMgr = NetCircuitManager.instance();
    private boolean canUseSrc = false;
    private boolean canUseDst = false;
    protected static final String LOT_DESC_MSG = "Create " + CircuitMapUtil.LO_TERM + " tunnel on transit nodes";
    protected static final String LAP_DESC_MSG = "Create " + CircuitMapUtil.LO_TERM + " aggregation point";
    protected static final String NONE_MSG = "None";
    protected static final String NONE_BECAUSE_RC_MSG = "\n \nSelected routing constraints prevent " + CircuitMapUtil.LO_TERM + " matrix optimization.";
    INodeModel stsGroomingNode;
    INodeModel vtGroomingNode;
    protected ArrayList existingTunnelList = new ArrayList();
    private INetCircuit existingLap = null;

    public CcdLoPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
    }

    @Override
    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = CcdLoPane.createVerticalPanel("Select Optimization");
        this.add(jPanel);
        this.lotRB = new JRadioButton(LOT_DESC_MSG);
        jPanel.add(this.lotRB);
        this.lapRB = new JRadioButton(LAP_DESC_MSG);
        jPanel.add(this.lapRB);
        JPanel jPanel2 = CcdLoPane.createVerticalPanel(null);
        jPanel.add(jPanel2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.useSrcRB = new JRadioButton();
        jPanel2.add(this.useSrcRB);
        this.useDstRB = new JRadioButton();
        jPanel2.add(this.useDstRB);
        this.initUseSrcDstRBs();
        this.useSrcRB.setEnabled(false);
        this.useDstRB.setEnabled(false);
        this.noneRB = new JRadioButton(NONE_MSG, true);
        jPanel.add(this.noneRB);
        this.createOptionalBG = new ButtonGroup();
        this.createOptionalBG.add(this.lotRB);
        this.createOptionalBG.add(this.lapRB);
        this.createOptionalBG.add(this.noneRB);
        this.lapRB.addChangeListener(this);
        this.vapBG = new ButtonGroup();
        this.vapBG.add(this.useSrcRB);
        this.vapBG.add(this.useDstRB);
        this.infoLbl = new JLabel();
        jPanel.add(this.infoLbl);
        this.infoLbl.setUI((LabelUI)new MultiLineLabelUI());
    }

    private void initUseSrcDstRBs() {
        if (this.useSrcRB != null && this.useDstRB != null) {
            String string = "Circuit source";
            try {
                string = this.getAbstractCktDlg().getSourceNode().getName();
            }
            catch (Exception exception) {
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
            String string2 = "Circuit destination";
            try {
                string2 = this.getAbstractCktDlg().getDestNode().getName();
            }
            catch (Exception exception) {
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
            this.useSrcRB.setText(CircuitMapUtil.HO_TERM + " grooming node is " + string + ";  " + CircuitMapUtil.LO_TERM + " grooming node is " + string2);
            this.useDstRB.setText(CircuitMapUtil.HO_TERM + " grooming node is " + string2 + ";  " + CircuitMapUtil.LO_TERM + " grooming node is " + string);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.syncButtons();
    }

    private void destroyExistingLap() {
        if (this.existingLap != null) {
            try {
                this.existingLap.destroyCircuit();
                this.getAbstractCktDlg().removeRelatedCircuit(this.existingLap);
                this.existingLap = null;
            }
            catch (Exception exception) {
                this.db.println("cannot delete the existing LAP= ");
                if (this.existingLap != null) {
                    this.existingLap.prettyPrint(this.db);
                }
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void destroyExistingTunnels() {
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
        Iterator iterator = this.existingTunnelList.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = null;
            try {
                iNetCircuit = (INetCircuit)iterator.next();
                if (this.db.on()) {
                    this.db.println("destroying this tunnel: " + iNetCircuit);
                }
                iNetCircuit.destroyCircuit();
                this.getAbstractCktDlg().removeRelatedCircuit(iNetCircuit);
                arrayList.add(iNetCircuit);
            }
            catch (Exception exception) {
                this.db.println("Cannot destroy existing tunnel: ");
                if (iNetCircuit != null) {
                    iNetCircuit.prettyPrint(this.db);
                }
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        this.existingTunnelList.removeAll(arrayList);
    }

    @Override
    public void enteringPane() {
        if (this.getAbstractCktDlg().destinationAdded) {
            try {
                this.getAbstractCktDlg().deleteDestination();
            }
            catch (Exception exception) {
                this.db.println("enteringPane's deleteDestination failed.");
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        super.enteringPane();
        this.initUseSrcDstRBs();
        if (!this.goingForward) {
            this.destroyExistingTunnels();
            this.destroyExistingLap();
            this.revalidateData();
            this.syncButtons();
        }
    }

    protected void syncButtons() {
        if (this.lapRB.isSelected()) {
            this.useDstRB.setEnabled(this.canUseDst);
            this.useSrcRB.setEnabled(this.canUseSrc);
            if (this.useSrcRB.isEnabled()) {
                this.useSrcRB.setSelected(!this.useDstRB.isEnabled() || !this.useDstRB.isSelected());
            } else if (this.useDstRB.isEnabled()) {
                this.useDstRB.setSelected(!this.useSrcRB.isEnabled() || !this.useSrcRB.isSelected());
            }
        } else {
            this.useSrcRB.setEnabled(false);
            this.useDstRB.setEnabled(false);
        }
        boolean bl = this.getAbstractCktDlg().isRrbc() || !this.getAbstractCktDlg().isAutoRoute();
        this.getAbstractCktDlg().setNextEnabled(bl);
        this.getAbstractCktDlg().setFinishEnabled(!bl);
    }

    @Override
    protected String getNextPaneName() {
        if (!this.getAbstractCktDlg().isAutoRoute() || this.getAbstractCktDlg().isAutoRoute() && this.getAbstractCktDlg().isRrbc()) {
            return "Route Review/Edit";
        }
        return null;
    }

    @Override
    public void validatePage() throws Exception {
        if (!(this.parent instanceof UnprotectedToUpsrDialog)) {
            block20: {
                if (this.lotRB.isSelected()) {
                    try {
                        this.createLoTunnel(true);
                    }
                    catch (Exception exception) {
                        AnnotatedException annotatedException = new AnnotatedException("An LO tunnel cannot be created.", exception);
                        throw annotatedException;
                    }
                }
                if (this.lapRB.isSelected()) {
                    try {
                        if (this.useSrcRB.isSelected()) {
                            this.stsGroomingNode = this.getAbstractCktDlg().getSourceNode();
                            this.vtGroomingNode = this.getAbstractCktDlg().getDestNode();
                            this.createOrReuseLap(this.getAbstractCktDlg().getSource(), true);
                        }
                        this.stsGroomingNode = this.getAbstractCktDlg().getDestNode();
                        this.vtGroomingNode = this.getAbstractCktDlg().getSourceNode();
                        this.createOrReuseLap(this.getAbstractCktDlg().getDest(), false);
                    }
                    catch (Exception exception) {
                        WzDiagDebug.printStackTrace((Throwable)exception);
                        throw exception;
                    }
                } else if (this.noneRB.isSelected()) {
                    try {
                        if (this.getAbstractCktDlg().isAutoRoute()) {
                            if (!this.getAbstractCktDlg().isVcatType()) {
                                boolean bl;
                                if (this.getAbstractCktDlg().getCircuit().useLAP() == null && this.ncMgr.getLAPHo(this.getAbstractCktDlg().getDestNode(), this.getAbstractCktDlg().getDest().getEntityModel(), this.getAbstractCktDlg().getDest().getHoNum()) == null && (bl = this.ncMgr.isLoTunnelNeeded(this.getAbstractCktDlg().getCircuit(), this.getDestinations(), this.getAbstractCktDlg().getRoutePrefs()))) {
                                    this.createLoTunnel(true);
                                }
                            } else {
                                boolean bl = this.ncMgr.isLoTunnelNeeded(this.getAbstractCktDlg().getCircuit(), this.getDestinations(), this.getAbstractCktDlg().getRoutePrefs());
                                if (bl) {
                                    this.createLoTunnel(true);
                                }
                            }
                        } else if (this.db.on()) {
                            this.db.println("Circuit is manually routed; not doing LO tunnel check+create");
                        }
                    }
                    catch (ObjNotFound objNotFound) {
                        if (!this.db.on()) break block20;
                        WzDiagDebug.printStackTrace((Throwable)objNotFound);
                    }
                }
            }
            this.addOrRouteNewCircuit();
            if (this.getAbstractCktDlg().getRoutePrefs().getTsValidation()) {
                this.getTsSwitchWarnings();
            }
        }
    }

    @Override
    public boolean handleBack() {
        this.destroyExistingTunnels();
        this.destroyExistingLap();
        try {
            this.getAbstractCktDlg().addDestination(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.handleBack();
    }

    @Override
    protected void handlePostValidate() {
        AutorangeInfo autorangeInfo = this.getAutorangeInfo();
        if (autorangeInfo != null) {
            autorangeInfo.clearLO();
            if (this.lotRB.isSelected()) {
                autorangeInfo.requestTransitTunnels = true;
            } else if (this.lapRB.isSelected()) {
                autorangeInfo.lapStsGroomingNode = this.stsGroomingNode;
                autorangeInfo.lapVtGroomingNe = CcdLoPane.getNetElement(this.vtGroomingNode);
            }
        }
    }

    protected void createLoTunnel(boolean bl) throws Exception {
        List list = this.ncMgr.createLoTunnels(this.getAbstractCktDlg().getCircuit(), this.getDestinations(), this.getAbstractCktDlg().getRoutePrefs());
        if (this.db.on()) {
            this.db.info("createLoTunnel " + bl + " got " + list.size() + " tunnel");
        }
        for (LoTunnelInfo loTunnelInfo : list) {
            boolean bl2 = true;
            AnnotatedException annotatedException = null;
            if (!loTunnelInfo.required() && !bl) continue;
            try {
                if (this.db.on) {
                    this.db.info("createLoTunnel: provisioning required Lo tunnel");
                }
                loTunnelInfo.tunnel().provision();
                this.getAbstractCktDlg().addRelatedCircuit(loTunnelInfo.tunnel());
                this.existingTunnelList.add(loTunnelInfo.tunnel());
                bl2 = false;
            }
            catch (Exception exception) {
                annotatedException = new AnnotatedException("A required LO tunnel could not be created.", exception);
            }
            if (!bl2) continue;
            try {
                if (this.db.on) {
                    this.db.info("createLoTunnel: destroying LO tunnel");
                }
                this.destroyExistingTunnels();
            }
            catch (Exception exception) {
                throw new AnnotatedException("The LO tunnel cannot be destroyed.", exception);
            }
            if (annotatedException == null) continue;
            throw annotatedException;
        }
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = "Optimization Choice:";
        if (this.lotRB.isSelected()) {
            arrayList.add(new String[]{string, CircuitMapUtil.LO_TERM + " Tunnel"});
        } else if (this.lapRB.isSelected()) {
            String string2 = this.stsGroomingNode == null ? "Circuit Source" : this.stsGroomingNode.getName();
            String string3 = this.vtGroomingNode == null ? "Circuit Destination" : this.vtGroomingNode.getName();
            arrayList.add(new String[]{string, CircuitMapUtil.LAP_TERM});
            arrayList.add(new String[]{CircuitMapUtil.HO_TERM + " Grooming Node:", string2});
            arrayList.add(new String[]{CircuitMapUtil.LO_TERM + " Grooming Node:", string3});
        } else {
            arrayList.add(new String[]{string, "N/A"});
        }
        return CcdLoPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lotRB.isSelected()) {
            stringBuffer.append("\nCreated " + CircuitMapUtil.LO_TERM + " Tunnel");
        } else if (this.lapRB.isSelected()) {
            stringBuffer.append("\nCreating " + CircuitMapUtil.LAP_TERM);
        } else {
            stringBuffer.append("No tunnel or aggregation choice.");
        }
        return stringBuffer.toString();
    }

    protected boolean areThereRequiredOrExcluded() {
        int n = 0;
        int n2 = 0;
        try {
            RoutePrefs routePrefs = this.getAbstractCktDlg().getRoutePrefs();
            LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
            if (linkedList == null) {
                return false;
            }
            for (MemberGroupPrefs memberGroupPrefs : linkedList) {
                MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
                n += memberPrefs.getRequiredLinks().size();
                n += memberPrefs.getRequiredNodes().size();
                n2 += memberPrefs.getExcludeSpans().size();
                n2 += memberPrefs.getExcludeSrgs().size();
            }
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
        }
        if (this.db.on()) {
            this.db.println("required: " + n);
            this.db.println("excluded: " + n2);
        }
        return n + n2 > 0;
    }

    @Override
    public void revalidateData() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        block20: {
            bl4 = this.areThereRequiredOrExcluded();
            if (this.db.on) {
                this.db.info("revalidateData()");
            }
            if (this.getAbstractCktDlg().autoRange && this.getAbstractCktDlg().circuitNumber > 1) {
                boolean bl5 = this.getAbstractCktDlg().isRrbc() || !this.getAbstractCktDlg().isAutoRoute();
                this.getAbstractCktDlg().setNextEnabled(bl5);
                this.getAbstractCktDlg().setFinishEnabled(!bl5);
                return;
            }
            this.noneRB.setSelected(true);
            if (this.getAbstractCktDlg().isVcatType()) {
                boolean bl6;
                this.lapRB.setEnabled(false);
                this.useDstRB.setEnabled(false);
                this.useSrcRB.setEnabled(false);
                boolean bl7 = bl6 = ((CcdVcatRoutePane)((CircuitCreationDialog)this.getAbstractCktDlg()).getRoutePane()).driMemCount > 0;
                if (!bl6 && !bl4) {
                    if (this.getAbstractCktDlg().getRoutePrefs().getActiveDropPrefs().isCommonFiber()) {
                        int n = this.getAbstractCktDlg().getCircuitType();
                        int n2 = this.getAbstractCktDlg().getCircuitSize();
                        int n3 = NetCircuitManager.instance().calcFramingType(n, n2);
                        int n4 = HoLoFactory.getAllLoNums(n3, n2).size();
                        if (((CcdVcatRoutePane)((CircuitCreationDialog)this.getAbstractCktDlg()).getRoutePane()).memberCktList.size() <= n4) {
                            boolean bl8 = this.ncMgr.canHaveOptionalLot(this.getAbstractCktDlg().getCircuit(), this.getDestinations(), this.getAbstractCktDlg().getRoutePrefs());
                            this.lotRB.setEnabled(bl8);
                        } else {
                            this.lotRB.setEnabled(false);
                        }
                    } else {
                        boolean bl9 = this.ncMgr.canHaveOptionalLot(this.getAbstractCktDlg().getCircuit(), this.getDestinations(), this.getAbstractCktDlg().getRoutePrefs());
                        this.lotRB.setEnabled(bl9);
                    }
                } else {
                    this.lotRB.setEnabled(false);
                }
                this.syncButtons();
                return;
            }
            boolean bl10 = this.ncMgr.canHaveOptionalLot(this.getAbstractCktDlg().getCircuit(), this.getDestinations(), this.getAbstractCktDlg().getRoutePrefs());
            boolean bl11 = this.getAbstractCktDlg().getRoutePrefs().getDri();
            bl3 = bl10 && !bl11;
            this.lotRB.setEnabled(bl3 && !bl4);
            if (this.db.on()) {
                this.db.info("lot RB logic\nCan Have Optional:" + bl10 + "\nAre Route Prefs DRI?" + bl11);
            }
            bl2 = this.getAbstractCktDlg().getSourceNode() == this.getAbstractCktDlg().getDestNode();
            bl = false;
            if (this.getAbstractCktDlg().getSourceNode() != null && this.getAbstractCktDlg().getAltSourceNode() != null) {
                if (this.getAbstractCktDlg().getSourceNode() != this.getAbstractCktDlg().getAltSourceNode()) {
                    bl = true;
                }
            } else if (this.getAbstractCktDlg().getDestNode() != null && this.getAbstractCktDlg().getAltDestNode() != null && this.getAbstractCktDlg().getDestNode() != this.getAbstractCktDlg().getAltDestNode()) {
                bl = true;
            }
            try {
                this.canUseSrc = this.ncMgr.capableOfLAPHoConnection(this.getAbstractCktDlg().getSourceNode(), this.getAbstractCktDlg().getSource().getEntityModel(), this.getAbstractCktDlg().getSource().getHoNum()) && this.ncMgr.getLAPHo(this.getAbstractCktDlg().getDestNode(), this.getAbstractCktDlg().getDest().getEntityModel(), this.getAbstractCktDlg().getDest().getHoNum()) == null && !this.getAbstractCktDlg().getRoutePrefs().getDri();
                this.canUseDst = this.ncMgr.capableOfLAPHoConnection(this.getAbstractCktDlg().getDestNode(), this.getAbstractCktDlg().getDest().getEntityModel(), this.getAbstractCktDlg().getDest().getHoNum()) && this.ncMgr.getLAPHo(this.getAbstractCktDlg().getSourceNode(), this.getAbstractCktDlg().getSource().getEntityModel(), this.getAbstractCktDlg().getSource().getHoNum()) == null && !this.getAbstractCktDlg().getRoutePrefs().getDri();
            }
            catch (ObjNotFound objNotFound) {
                if (!this.db.on()) break block20;
                WzDiagDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        if (this.db.on()) {
            this.db.println("\tSummary for enabling VAP radio button: ");
            this.db.println("\tIs Open Ended (false for enabled): " + bl);
            if (bl) {
                this.db.println("\t\t(has two unique sources/destinations)");
            }
            this.db.println("\tSame SRC/DST  (false for enabled): " + bl2);
            this.db.println("\tCan Use SRC|DST (1 true needed)  : " + this.canUseSrc + " and " + this.canUseDst);
        }
        boolean bl12 = !bl && !bl2 && (this.canUseSrc || this.canUseDst);
        this.lapRB.setEnabled(bl12 && !bl4);
        if (bl4 && (bl12 || bl3)) {
            this.infoLbl.setText(NONE_BECAUSE_RC_MSG);
        } else {
            this.infoLbl.setText("");
        }
        this.syncButtons();
    }

    private List getDestinations() {
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(this.getAbstractCktDlg().getDest());
        if (this.getAbstractCktDlg().getAltDest() != null && this.getAbstractCktDlg().getDest().getNodeId() != this.getAbstractCktDlg().getAltDest().getNodeId()) {
            linkedList.add(this.getAbstractCktDlg().getAltDest());
        }
        return linkedList;
    }

    private void createOrReuseLap(INetCircuitEnd iNetCircuitEnd, boolean bl) throws Exception {
        if (!(this.parent instanceof UnprotectedToUpsrDialog)) {
            INetCircuit iNetCircuit = this.findLap(this.stsGroomingNode, iNetCircuitEnd);
            if (this.getAbstractCktDlg().autoRange && this.getAbstractCktDlg().circuitNumber > 1) {
                if (iNetCircuit == null) {
                    if (this.db.on()) {
                        this.db.info("Create more LAP using existing dest");
                    }
                    this.createLapCircuit(this.stsGroomingNode, iNetCircuitEnd, this.vtGroomingNode);
                }
            } else {
                if (this.db.on()) {
                    this.db.info("Create a new LAP");
                }
                this.createLapCircuit(this.stsGroomingNode, iNetCircuitEnd, this.vtGroomingNode);
            }
            if (bl) {
                this.getAbstractCktDlg().destroyCircuit();
                if (this.getAbstractCktDlg().getAltSource() != null) {
                    INetCircuit iNetCircuit2 = NetCircuitFactory.newCircuit(this.getAbstractCktDlg().getCircuitInfo(), this.getAbstractCktDlg().getSource(), this.getAbstractCktDlg().getAltSource());
                    this.getAbstractCktDlg().setCircuit(iNetCircuit2);
                } else {
                    INetCircuit iNetCircuit3 = NetCircuitFactory.newCircuit(this.getAbstractCktDlg().getCircuitInfo(), this.getAbstractCktDlg().getSource());
                    this.getAbstractCktDlg().setCircuit(iNetCircuit3);
                }
            }
        }
    }

    private INetCircuit findLap(INodeModel iNodeModel, INetCircuitEnd iNetCircuitEnd) {
        INetCircuit iNetCircuit;
        block2: {
            iNetCircuit = null;
            try {
                iNetCircuit = NetCircuitManager.instance().getLAPHo(iNodeModel, iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum());
            }
            catch (ObjNotFound objNotFound) {
                if (!this.db.on()) break block2;
                WzDiagDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        return iNetCircuit;
    }

    private static INetElement getNetElement(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return null;
        }
        return Network.instance().getNetElem(iNodeModel.getNodeId());
    }

    private void createLapCircuit(INodeModel iNodeModel, INetCircuitEnd iNetCircuitEnd, INodeModel iNodeModel2) throws Exception {
        INetElement iNetElement = CcdLoPane.getNetElement(iNodeModel2);
        if (iNetElement == null) {
            throw new Exception("The network element cannot be resolved.");
        }
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(CircuitMapUtil.useSonetTerminology() ? 7 : 8, CircuitMapUtil.useSonetTerminology() ? 1 : 12, 1, false, "", this.getAbstractCktDlg().getCircuitInfo().adminState(), this.getAbstractCktDlg().getCircuitInfo().tl1Compatible());
        INetCircuit iNetCircuit = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetCircuitEnd);
        if (this.db.on()) {
            this.db.info("createLapCircuit:  created lapCkt with source " + CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
        }
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setPathProt(this.getAbstractCktDlg().getRoutePrefs().getPathProt());
        routePrefs.setDiversityOption(2);
        routePrefs.setPcaPref(this.getAbstractCktDlg().getRoutePrefs().getPcaPref());
        iNetCircuit.routeNetElement(iNetElement, routePrefs);
        iNetCircuit.setUpsrSelectorAttributes(this.getAbstractCktDlg().getUpsrReversion(), (short)this.getAbstractCktDlg().getUpsrSfBerLevel().getIntValue(), (short)this.getAbstractCktDlg().getUpsrSdBerLevel().getIntValue(), this.getAbstractCktDlg().getUpsrSwitchOnPdip());
        this.db.info("createLapCircuit:  routed ne = " + iNetElement.prettyString());
        try {
            iNetCircuit.sanityCheck();
            iNetCircuit.provision();
            this.getAbstractCktDlg().addRelatedCircuit(iNetCircuit);
            this.existingLap = iNetCircuit;
            if (this.db.on()) {
                this.db.info("createLapCircuit:  provision succeeded");
            }
        }
        catch (Exception exception) {
            iNetCircuit.destroyCircuit();
            this.destroyExistingLap();
            if (this.db.on()) {
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
            if (exception instanceof SanityCheckFailed) {
                throw new SanityCheckException("", "nodes or spans are", exception);
            }
            throw exception;
        }
    }

    private void addNetLinkAsRequiredLink(RoutePrefs routePrefs, INetLink iNetLink) {
        if (routePrefs != null && iNetLink != null) {
            LinkedList linkedList;
            ArrayList<INetLink> arrayList = new ArrayList<INetLink>();
            arrayList.add(iNetLink);
            if (this.db.on()) {
                this.db.println("add " + iNetLink + " as required Link");
            }
            if ((linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs()) == null) {
                if (this.db.on()) {
                    this.db.println("could not get the member group prefs from routeprefs");
                }
                return;
            }
            for (MemberGroupPrefs memberGroupPrefs : linkedList) {
                MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
                try {
                    memberPrefs.setReqEntityList(arrayList);
                }
                catch (ObjDuplicate objDuplicate) {
                    WzDiagDebug.printStackTrace((Throwable)objDuplicate);
                }
            }
        }
    }

    protected void addOrRouteNewCircuit() throws Exception {
        Object object;
        if (this.getAbstractCktDlg().isAutoRoute()) {
            INetLink iNetLink = null;
            object = this.findLap(this.getAbstractCktDlg().getSourceNode(), this.getAbstractCktDlg().getSource());
            if (object != null) {
                iNetLink = object.getLapLink();
            } else {
                object = this.findLap(this.getAbstractCktDlg().getDestNode(), this.getAbstractCktDlg().getDest());
                if (object != null) {
                    iNetLink = object.getReverseLapLink();
                }
            }
            RoutePrefs routePrefs = null;
            if (iNetLink != null) {
                if (this.db.on()) {
                    this.db.println("When we provision, we will use " + iNetLink.prettyString() + " as a required " + "link (LAP).");
                }
                routePrefs = this.getAbstractCktDlg().getRoutePrefs();
                RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
                this.addNetLinkAsRequiredLink(routePrefs2, iNetLink);
                if (this.getAbstractCktDlg() instanceof CircuitCreationDialog) {
                    ((CircuitCreationDialog)this.getAbstractCktDlg()).setRoutePrefs(routePrefs2);
                }
            }
            this.getAbstractCktDlg().addDestination(true);
            if (routePrefs != null && this.getAbstractCktDlg() instanceof CircuitCreationDialog) {
                ((CircuitCreationDialog)this.getAbstractCktDlg()).setRoutePrefs(routePrefs);
            }
            if (this.db.on()) {
                this.db.info("validatePage: addDestination(true) worked");
            }
        } else {
            this.getAbstractCktDlg().addDestination(false);
        }
        if (this.getAbstractCktDlg().isUrn() && !this.getAbstractCktDlg().isRrbc()) {
            try {
                this.getAbstractCktDlg().getCircuit().sanityCheckManualRouting();
                if (this.db.on()) {
                    this.db.info("validatePage: sanityCheckManualRouting succeded");
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckException("", "nodes or spans are", sanityCheckFailed);
            }
            catch (Exception exception) {
                object = "The selected nodes or spans are invalid.";
                throw new AnnotatedException((String)object, exception);
            }
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdLoPane;
    }

    @Override
    public void removeListeners() {
        if (this.lapRB != null) {
            this.lapRB.removeChangeListener(this);
        }
        super.removeListeners();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Can use SRC: " + this.canUseSrc + "\n");
        stringBuffer.append("Can use DST: " + this.canUseDst + "\n");
        stringBuffer.append("Lap Src Node: " + this.stsGroomingNode + "\n");
        stringBuffer.append("Lap Dst Node: " + this.vtGroomingNode + "\n");
        return stringBuffer.toString();
    }

    public void getTsSwitchWarnings() {
        StringBuffer stringBuffer = new StringBuffer();
        INetCircuit iNetCircuit = this.getAbstractCktDlg().getCircuit();
        List list = iNetCircuit.getTimeSlotViolations();
        if (list != null && list.size() != 0) {
            stringBuffer.append("The Circuit Route Changes Time Slots On The Following Spans: ");
            stringBuffer.append("\n");
            for (int i = 0; i < list.size(); ++i) {
                if (list.size() > 1) {
                    stringBuffer.append("Warning #" + (i + 1) + " " + ": " + "\n");
                }
                String string = (String)list.get(i);
                stringBuffer.append(string);
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Is it OK to continue with the circuit creation?");
            this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)stringBuffer.toString(), (String)"Time Slot Change Warning");
        }
    }
}

