/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.ncp.SvlanCircuitEnd;
import cerent.cms.ui.Pane;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.util.BusEvent;
import cerent.util.EventBus;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class CcdQinQDialog
extends JDialog
implements Observer {
    private Frame frame;

    private CcdQinQDialog(Frame frame, String string, SvlanCircuitEnd svlanCircuitEnd, short s, QinQSettings qinQSettings, boolean bl) throws HeadlessException {
        super(frame, string, bl);
        this.frame = frame;
    }

    public static void display(Frame frame, String string, SvlanCircuitEnd svlanCircuitEnd, short s, QinQSettings qinQSettings, boolean bl) {
        CcdQinQDialog ccdQinQDialog = new CcdQinQDialog(frame, string, svlanCircuitEnd, s, qinQSettings, bl);
        INodeModel iNodeModel = svlanCircuitEnd.getNodeModel();
        if (iNodeModel.provides(Feature.CHANNEL_GROUP)) {
            try {
                IEntityModel iEntityModel = svlanCircuitEnd.getEntityModel();
                IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel.getModuleModel();
                IXPLLayer2LineModel iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iEntityModel.getNodeModel(), iEntityModel.getEntityIndex());
                JPanel jPanel = new JPanel(new BorderLayout());
                ccdQinQDialog.getContentPane().add(jPanel);
                Pane pane = iXPL2ModuleModel.getQinQPlugin(((AbstractCircuitDialog)ccdQinQDialog.frame).getTabbedView(), iXPLLayer2LineModel, s, qinQSettings);
                EventBus.instance().addObserver((Observer)ccdQinQDialog, (Object)pane);
                jPanel.add((Component)pane, "Center");
            }
            catch (ObjNotFound objNotFound) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            ccdQinQDialog.pack();
            ccdQinQDialog.setLocationRelativeTo(ccdQinQDialog.frame);
            ccdQinQDialog.setVisible(true);
        } else {
            try {
                IEntityModel iEntityModel = svlanCircuitEnd.getEntityModel();
                IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel.getModuleModel();
                JPanel jPanel = new JPanel(new BorderLayout());
                ccdQinQDialog.getContentPane().add(jPanel);
                int n = ((IPortModel)iEntityModel).getParent().getParent().getPositionInParent();
                Pane pane = iXPL2ModuleModel.getQinQPlugin(((AbstractCircuitDialog)ccdQinQDialog.frame).getTabbedView(), (short)n, s, qinQSettings);
                EventBus.instance().addObserver((Observer)ccdQinQDialog, (Object)pane);
                jPanel.add((Component)pane, "Center");
            }
            catch (ObjNotFound objNotFound) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            ccdQinQDialog.pack();
            ccdQinQDialog.setLocationRelativeTo(ccdQinQDialog.frame);
            ccdQinQDialog.setVisible(true);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string;
        BusEvent busEvent;
        if (object instanceof BusEvent && (busEvent = (BusEvent)object).getEvent() instanceof String && (string = (String)busEvent.getEvent()).equals("Apply")) {
            EventBus.instance().deleteObserver((Observer)this);
            this.setVisible(false);
            this.dispose();
        }
    }
}

