/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.SvlanCircuitEnd;
import cerent.cms.ui.circuits.AbstractCcdEndpointPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CcdQinQDialog;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.ILoNum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.SortedMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CcdSvlanEndpointPanel
extends AbstractCcdEndpointPanel {
    protected JButton svlanQinQB;
    protected QinQSettings qinq;

    public CcdSvlanEndpointPanel(String string, AbstractCircuitDialog abstractCircuitDialog, CcdEndpointsPane ccdEndpointsPane) {
        super(string, abstractCircuitDialog, ccdEndpointsPane);
    }

    @Override
    protected void addComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridwidth = 0;
        this.svlanQinQB = new JButton("QinQ Setting...");
        this.svlanQinQB.setPreferredSize(new Dimension(100, 25));
        this.add((Component)this.svlanQinQB, gridBagConstraints);
        this.svlanQinQB.setVisible(true);
        this.svlanQinQB.setEnabled(false);
        this.svlanQinQB.addActionListener(this);
        this.portCB.setRenderer(new ComboBoxRenderer());
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.endpoint.getNodeModel() != null) {
            boolean bl = true;
            if (this.parent.isDestPane() && this.cktDialog.getCircuitInfo().isProtected()) {
                bl = false;
            }
            this.shelfCB.setEnabled(bl);
            this.slotCB.setEnabled(bl);
            this.portCB.setEnabled(bl);
        } else {
            this.svlanQinQB.setEnabled(false);
        }
    }

    @Override
    protected void reset() {
        if (db.on()) {
            db.println("CcdSvlanEndPointPane reset");
        }
        this.endpoint = new SvlanCircuitEnd();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.svlanQinQB) {
            CcdQinQDialog.display(this.cktDialog, "QinQ Setting", (SvlanCircuitEnd)this.endpoint, this.getCircuitInfo().svlan(), this.qinq, true);
        } else if (object == this.shelfCB) {
            String string = (String)this.shelfCB.getSelectedItem();
            if (this.isNull(string, "newShelf")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: shelf " + this.shelf + " -> " + string);
            }
            this.shelf = string;
            this.entityMap = (SortedMap)this.shelfMap.get(this.shelf);
            if (this.isNull(this.entityMap, "entityMap")) {
                this.setCBList(this.slotCB, null);
                return;
            }
            if (this.entityMap.size() == 0) {
                if (db.on()) {
                    db.println(this.title + " entityMap is empty");
                }
                return;
            }
            this.setCBList(this.slotCB, this.entityMap.keySet());
            if (this.entityMap.size() == 1) {
                String string2 = (String)this.entityMap.firstKey();
                this.slotCB.setSelectedItem(string2);
            }
        } else if (object == this.slotCB) {
            String string = (String)this.slotCB.getSelectedItem();
            if (this.isNull(string, "newSlot")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: slot " + this.slot + " -> " + string);
            }
            this.slot = string;
            this.portMap = (SortedMap)this.entityMap.get(this.slot);
            if (this.isNull(this.portMap, "portMap")) {
                this.setCBList(this.portCB, null);
                return;
            }
            if (this.portMap.size() == 0) {
                if (db.on()) {
                    db.println(this.title + " portMap is empty");
                }
                return;
            }
            this.setCBList(this.portCB, this.portMap.keySet());
            if (this.portMap.size() == 1) {
                SortablePortString sortablePortString = (SortablePortString)this.portMap.firstKey();
                if (!sortablePortString.isEmpty()) {
                    this.portCB.setSelectedItem(sortablePortString);
                } else {
                    this.port = null;
                    try {
                        this.setEntity((IEntityModel)this.portMap.get(sortablePortString));
                    }
                    catch (AnnotatedException annotatedException) {
                        if (db.on()) {
                            db.println(this.title + " actionPerformed(slotCB): exception in setEntity");
                        }
                        this.clearEntity(annotatedException, true);
                    }
                }
                this.portCB.setEnabled(false);
            }
        } else if (object == this.portCB) {
            SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
            if (this.isNull(sortablePortString, "newPort")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: port " + this.port + " -> " + sortablePortString);
            }
            this.port = sortablePortString;
            try {
                this.setEntity((IEntityModel)this.portMap.get(this.port));
            }
            catch (AnnotatedException annotatedException) {
                if (db.on()) {
                    db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                }
                this.clearEntity(annotatedException, false);
            }
            if (this.portCB.getSelectedItem() != null) {
                if (SvlanCircuitHelper.isNNI(this.node, this.endpoint.getEntityIndex())) {
                    this.svlanQinQB.setEnabled(false);
                } else {
                    this.svlanQinQB.setEnabled(true);
                }
            } else {
                this.svlanQinQB.setEnabled(false);
            }
        }
    }

    @Override
    protected void setEntity(IEntityModel iEntityModel) throws AnnotatedException {
        if (db.on()) {
            db.println(this.title + " setEntity: slot = " + this.slot + ", port = " + this.port);
        }
        if (!iEntityModel.equals(this.getEntityModel())) {
            if (this.getCircuitInfo().isProtected() && this.parent.isDestPane()) {
                this.qinq = this.getCircuitInfo().getSrcQinQInfo();
            } else {
                this.qinq = new QinQSettings(this.getCircuitInfo().svlan());
                if (this.parent.isDestPane()) {
                    this.getCircuitInfo().setDstQinQInfo(this.qinq);
                } else {
                    this.getCircuitInfo().setSrcQinQInfo(this.qinq);
                }
            }
            this.endpoint.setNodeModel(iEntityModel.getNodeModel());
            this.endpoint.setEntityIndex(iEntityModel.getEntityIndex());
        }
    }

    @Override
    protected boolean fullySelected() {
        if (this.slot == null) {
            return false;
        }
        if (this.slotCB.isEnabled() && this.slotCB.getSelectedIndex() < 0) {
            return false;
        }
        return !this.portCB.isEnabled() || this.portCB.getSelectedIndex() >= 0;
    }

    @Override
    public void validatePage() throws Exception {
        super.validatePage();
        if (!SvlanCircuitHelper.isNNI(this.node, this.endpoint.getEntityIndex()) && (this.qinq.getQinQMode() == -1 || this.qinq.getQinQMode() == 0 && !this.qinq.getQinQTable().hasSvlanEntryFromNet())) {
            throw new Exception(this.getName() + " QinQ setting is not specified.");
        }
    }

    @Override
    protected void selectLoComponentsFromEndpoint() {
    }

    @Override
    protected List getLoParts() {
        return this.loParts;
    }

    @Override
    protected void setLoComponentsFromEndpoint() {
    }

    @Override
    protected void localRefresh(ICircuitType iCircuitType, int n) {
    }

    @Override
    protected void setLoComponents(ILoNum iLoNum) {
    }

    @Override
    protected SortedMap createNewLoMap() {
        return null;
    }

    @Override
    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
    }

    @Override
    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        return false;
    }

    @Override
    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        return null;
    }

    @Override
    protected JComboBox getHoCB() {
        return null;
    }

    private class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof SortablePortString) {
                SortablePortString sortablePortString = (SortablePortString)object;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(sortablePortString.toString());
                IEntityModel iEntityModel = sortablePortString.getEntityModel();
                if (iEntityModel instanceof IPortModel) {
                    if (SvlanCircuitHelper.isNNI(iEntityModel.getNodeModel(), iEntityModel.getEntityIndex())) {
                        stringBuilder.append(" - NNI");
                    } else {
                        stringBuilder.append(" - UNI");
                    }
                    this.setText(stringBuilder.toString());
                }
            }
            return this;
        }
    }
}

