/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.NetVlanInfoCellRenderer;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.VlanInfoCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.ColorUtil;
import cerent.util.ComparisonUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class CircuitColumnRenderer
extends AbstractColumnRenderer {
    public static final int NAME = 0;
    public static final int TYPE = 1;
    public static final int SIZE = 2;
    public static final int CHANNEL_ID = 3;
    public static final int DIR = 4;
    public static final int PROT = 5;
    public static final int STATUS = 6;
    public static final int SOURCE = 7;
    public static final int DEST = 8;
    public static final int VLANS = 9;
    public static final int SPANS = 10;
    public static final int STATE = 11;
    public static final int LOOPBACK = 12;
    public static final int VCATSTATE = 13;
    public static final int BY_NAME = 0;
    static final int VCAT_MEM_TABLE = 1;
    static final int[][] columns = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, {0, 1, 2, 4, 5, 6, 7, 8, 10, 11, 12, 13}};
    public static Color ACTIVE_BG = Color.green;
    public static Color ACTIVE_FG = Color.black;
    public static Color STANDBY_BG = new Color(128, 0, 192);
    public static Color STANDBY_FG = Color.white;
    public static String PREFS_CIRCUITS = "ctc.circuits";
    public static String PREFS_ACTIVE_SPAN = "activespan";
    public static String PREFS_STANDBY_SPAN = "standbyspan";
    static final String SPAN_TITLE = "# of Spans";
    static final String DET_SPAN_TITLE = "Spans";
    static final int SPAN_WIDTH = 80;
    static final int DET_SPAN_WIDTH = 400;
    private static boolean spanDetailsOn = false;
    private JLabel label;
    private JTextArea textArea;
    private int mode;
    private static int EBW;
    private static EmptyBorder emptyBorder;
    private static final SDebug db;

    public static String getStateStringFromColor(Color color) {
        String string = "";
        if (color != null) {
            if (color == ACTIVE_BG) {
                string = "ACT";
            } else if (color == STANDBY_BG) {
                string = "SBY";
            }
        }
        return string;
    }

    public static void loadColors() {
        ACTIVE_BG = CircuitColumnRenderer.getColorPreference(PREFS_ACTIVE_SPAN, ACTIVE_BG);
        STANDBY_BG = CircuitColumnRenderer.getColorPreference(PREFS_STANDBY_SPAN, STANDBY_BG);
        ACTIVE_FG = ACTIVE_BG.getGreen() >= 127 ? Color.black : Color.white;
        STANDBY_FG = STANDBY_BG.getGreen() >= 127 ? Color.black : Color.white;
    }

    public void setWidth(int n) {
        if (n > 1) {
            this.width = n;
        }
    }

    private static void preferenceCleanup() {
        String string = "activespan.fg";
        String string2 = "activespan.bg";
        String string3 = "standbyspan.fg";
        String string4 = "standbyspan.bg";
        Preferences preferences = Preferences.instance();
        preferences.removeProperty(PREFS_CIRCUITS, string);
        preferences.removeProperty(PREFS_CIRCUITS, string3);
        String string5 = preferences.getProperty(PREFS_CIRCUITS, string2, null);
        String string6 = preferences.getProperty(PREFS_CIRCUITS, PREFS_ACTIVE_SPAN, null);
        if (string5 != null) {
            if (string6 == null) {
                preferences.setProperty(PREFS_CIRCUITS, PREFS_ACTIVE_SPAN, string5);
            }
            preferences.removeProperty(PREFS_CIRCUITS, string2);
        }
        string5 = preferences.getProperty(PREFS_CIRCUITS, string4, null);
        string6 = preferences.getProperty(PREFS_CIRCUITS, PREFS_STANDBY_SPAN, null);
        if (string5 != null) {
            if (string6 == null) {
                preferences.setProperty(PREFS_CIRCUITS, PREFS_STANDBY_SPAN, string5);
            }
            preferences.removeProperty(PREFS_CIRCUITS, string4);
        }
    }

    private static Color getColorPreference(String string, Color color) {
        String string2 = Preferences.instance().getProperty(PREFS_CIRCUITS, string, null);
        Color color2 = ColorUtil.getColor(string2);
        if (color2 == null) {
            color2 = color;
            String string3 = ColorUtil.getRGBString(color2);
            Preferences.instance().setProperty(PREFS_CIRCUITS, string, string3);
        }
        return color2;
    }

    public CircuitColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.textArea = new JTextArea();
        this.textArea.setOpaque(true);
        this.textArea.setForeground(Color.black);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
        this.textArea.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.label;
        this.label.setText("");
        INetCircuit iNetCircuit = (INetCircuit)object;
        TDMTerminology tDMTerminology = this.getTerminology(iNetCircuit);
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (this.mode) {
            case 0: {
                this.label.setText(iNetCircuit.getCircuitName());
                break;
            }
            case 1: {
                if (tDMTerminology != null) {
                    if ((iNetCircuit.getCircuitTypeObj().isOchncType() || iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) && ((OchncCircuit)iNetCircuit).isDCNCircuit()) {
                        String string = tDMTerminology.getCircuitTypeShortString(iNetCircuit.getCircuitTypeObj());
                        this.label.setText(string + " DCN");
                        break;
                    }
                    this.label.setText(tDMTerminology.getCircuitTypeShortString(iNetCircuit.getCircuitTypeObj()));
                    break;
                }
                this.label.setText("");
                break;
            }
            case 2: {
                String string = null;
                try {
                    string = !iNetCircuit.getCircuitTypeObj().isOchccCircuitType() ? iNetCircuit.getCircuitSizeObj().getCircuitSizeString() : OchTrailHelper.getCircuitSizeString((OchccCircuit)iNetCircuit);
                }
                catch (Throwable throwable) {
                    string = "Unknown size " + iNetCircuit.getCircuitSize();
                }
                if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                    int n3 = iNetCircuit.getConfiguredForwardMemberSize();
                    string = string + "-" + n3 + "v";
                }
                this.label.setText(string);
                break;
            }
            case 3: {
                this.label.setText(this.getChannelText(iNetCircuit));
                break;
            }
            case 5: {
                if (tDMTerminology != null) {
                    this.label.setText(NetworkDefaults.circuitProtTypeToString(iNetCircuit.getProtType(), tDMTerminology));
                    if (iNetCircuit.getProtType() != 15) break;
                    color = Color.red;
                    break;
                }
                this.label.setText("");
                break;
            }
            case 4: {
                this.label.setText(NetworkDefaults.circuitDirectionToString(iNetCircuit.getCircuitDir()));
                break;
            }
            case 6: {
                this.label.setText(NetworkDefaults.circuitStateToString(iNetCircuit.getState()));
                break;
            }
            case 7: {
                List list = iNetCircuit.getSources();
                INetCircuitEnd[] iNetCircuitEndArray = list.toArray(new INetCircuitEnd[0]);
                if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType() && iNetCircuit.isOpenEndedVcatCircuit() && ((NetVcatCircuit)iNetCircuit).getPrimarySource() == null) {
                    this.textArea.setText("Open-ended VCAT ...");
                } else {
                    this.textArea.setText(CircuitColumnRenderer.getEndpoints(iNetCircuit, iNetCircuitEndArray));
                    if (iNetCircuit.isDiag()) {
                        this.textArea.append("/PRBS Generator");
                    }
                }
                jComponent = this.textArea;
                if (!CircuitColumnRenderer.db.on) break;
                db.println("Source: " + this.textArea.getText());
                break;
            }
            case 8: {
                INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{};
                if (iNetCircuit.getCircuitTypeObj().isEthernetCircuitType() && iNetCircuit.getDrops().size() == 0) {
                    iNetCircuitEndArray = new INetCircuitEnd[]{iNetCircuit.getPrimarySource()};
                    this.textArea.setText(CircuitColumnRenderer.getEndpoints(iNetCircuit, iNetCircuitEndArray));
                } else if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType() && iNetCircuit.isOpenEndedVcatCircuit() && ((NetVcatCircuit)iNetCircuit).getPrimaryDrop() == null) {
                    this.textArea.setText("Open-ended VCAT ...");
                } else {
                    List list = iNetCircuit.getDrops();
                    iNetCircuitEndArray = new INetCircuitEnd[list.size()];
                    Iterator iterator = list.iterator();
                    for (int i = 0; i < list.size(); ++i) {
                        iNetCircuitEndArray[i] = (INetCircuitEnd)iterator.next();
                    }
                    this.textArea.setText(CircuitColumnRenderer.getEndpoints(iNetCircuit, iNetCircuitEndArray));
                }
                jComponent = this.textArea;
                if (!CircuitColumnRenderer.db.on) break;
                db.println("Destination: " + this.textArea.getText());
                break;
            }
            case 9: {
                int n4 = iNetCircuit.getNetVlans().length;
                if (n4 > 0) {
                    this.label.setToolTipText(CircuitColumnRenderer.getVlanList(iNetCircuit.getNetVlans(), 10, false));
                } else {
                    this.label.setToolTipText(null);
                }
                this.label.setText(n4 > 0 ? String.valueOf(n4) : "");
                if (!CircuitColumnRenderer.db.on) break;
                db.println("VLANs: " + this.label.getText());
                break;
            }
            case 10: {
                if (spanDetailsOn) {
                    List list = iNetCircuit.getCircuitSpans();
                    INetCircuitSpan[] iNetCircuitSpanArray = new INetCircuitSpan[list.size()];
                    Iterator iterator = list.iterator();
                    for (int i = 0; i < list.size(); ++i) {
                        iNetCircuitSpanArray[i] = (INetCircuitSpan)iterator.next();
                    }
                    jComponent = this.textArea;
                    this.textArea.setText(CircuitColumnRenderer.getSpans(iNetCircuitSpanArray));
                    if (!CircuitColumnRenderer.db.on) break;
                    db.println("Span " + iNetCircuitSpanArray + ": " + this.textArea.getText());
                    break;
                }
                int n5 = iNetCircuit.getCircuitSpanNum();
                if (n5 == -1) {
                    this.label.setText("N/A");
                } else {
                    if ((iNetCircuit.getCircuitTypeObj().isOchncType() || iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) && iNetCircuit.isBidirectional()) {
                        n5 = n5 % 2 != 0 ? n5 / 2 + 1 : (n5 /= 2);
                    }
                    this.label.setText(Integer.toString(n5));
                }
                if (!CircuitColumnRenderer.db.on) break;
                db.println("Spans: " + this.label.getText());
                break;
            }
            case 11: {
                this.label.setText(NetworkDefaults.circuitServiceStateToString(CircuitColumnRenderer.getServiceState(iNetCircuit)));
                if (!CircuitColumnRenderer.db.on) break;
                db.println("Circuit Service State: " + this.label.getText());
                break;
            }
            case 12: {
                String string = "";
                if (iNetCircuit.getState() != 0 && iNetCircuit.getState() != 2) {
                    try {
                        if (iNetCircuit.hasLoopback() || iNetCircuit.hasXcLoopback()) {
                            string = "LPBK";
                        }
                    }
                    catch (Exception exception) {
                        db.severe("Unable to get loopback status on " + iNetCircuit.getCircuitName());
                    }
                }
                this.label.setText(string);
                if (!CircuitColumnRenderer.db.on) break;
                db.println("Loopback: " + this.label.getText());
                break;
            }
            case 13: {
                String string = "";
                if (iNetCircuit.isMemberOfVcat()) {
                    string = iNetCircuit.isMemberInGroup() ? "In Group" : "Out Of Group";
                }
                this.label.setText(string);
            }
        }
        ((Component)jComponent).setForeground(color);
        ((Component)jComponent).setBackground(color2);
        return jComponent;
    }

    protected TDMTerminology getTerminology(INetCircuit iNetCircuit) {
        TDMTerminology tDMTerminology = null;
        INodeModel iNodeModel = null;
        if (iNetCircuit.getPrimarySource() != null) {
            iNodeModel = iNetCircuit.getPrimarySource().getNodeModel();
        } else {
            List list = iNetCircuit.getCircuitNodes();
            if (list.size() != 0) {
                iNodeModel = ((INetCircuitNode)list.get(0)).getNodeModel();
            }
        }
        if (iNodeModel != null) {
            tDMTerminology = iNodeModel.getTDMTerminology();
        }
        return tDMTerminology;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        INetCircuit iNetCircuit = (INetCircuit)object;
        INetCircuit iNetCircuit2 = (INetCircuit)object2;
        int n2 = 0;
        switch (this.mode) {
            case 0: {
                n2 = iNetCircuit.getCircuitName().compareTo(iNetCircuit2.getCircuitName());
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getCircuitType(), (int)iNetCircuit2.getCircuitType());
                break;
            }
            case 2: {
                n2 = CircuitColumnRenderer.compareCircuitSize((CircuitSize)iNetCircuit.getCircuitSizeObj(), (CircuitSize)iNetCircuit2.getCircuitSizeObj());
                if (n2 != 0) break;
                int n3 = 0;
                int n4 = 0;
                n3 = iNetCircuit.getCircuitTypeObj().isVcatCircuitType() ? iNetCircuit.getConfiguredForwardMemberSize() : 1;
                n4 = iNetCircuit2.getCircuitTypeObj().isVcatCircuitType() ? iNetCircuit2.getConfiguredForwardMemberSize() : 1;
                n2 = ComparisonUtil.compare((int)n3, (int)n4);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getProtType(), (int)iNetCircuit2.getProtType());
                break;
            }
            case 3: {
                n2 = this.getChannelText(iNetCircuit).compareTo(this.getChannelText(iNetCircuit2));
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getCircuitDir(), (int)iNetCircuit2.getCircuitDir());
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getState(), (int)iNetCircuit2.getState());
                break;
            }
            case 7: {
                n2 = CircuitColumnRenderer.getEndpoints(iNetCircuit, new INetCircuitEnd[]{iNetCircuit.getPrimarySource()}).compareTo(CircuitColumnRenderer.getEndpoints(iNetCircuit2, new INetCircuitEnd[]{iNetCircuit2.getPrimarySource()}));
                break;
            }
            case 8: {
                if (iNetCircuit.getDrops().size() == 0 || iNetCircuit2.getDrops().size() == 0) {
                    n2 = ComparisonUtil.compare((int)iNetCircuit.getDrops().size(), (int)iNetCircuit2.getDrops().size());
                    break;
                }
                n2 = CircuitColumnRenderer.getEndpoints(iNetCircuit, new INetCircuitEnd[]{(INetCircuitEnd)iNetCircuit.getDrops().iterator().next()}).compareTo(CircuitColumnRenderer.getEndpoints(iNetCircuit2, new INetCircuitEnd[]{(INetCircuitEnd)iNetCircuit2.getDrops().iterator().next()}));
                break;
            }
            case 9: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getVlans().length, (int)iNetCircuit2.getVlans().length);
                break;
            }
            case 10: {
                List list = iNetCircuit.getCircuitSpans();
                List list2 = iNetCircuit2.getCircuitSpans();
                if (spanDetailsOn && list.size() == list2.size() && list.size() > 0) {
                    n2 = CircuitColumnRenderer.getSpan((INetCircuitSpan)list.iterator().next()).compareTo(CircuitColumnRenderer.getSpan((INetCircuitSpan)list2.iterator().next()));
                    break;
                }
                n2 = ComparisonUtil.compare((int)list.size(), (int)list2.size());
                break;
            }
            case 11: {
                n2 = ComparisonUtil.compare((int)CircuitColumnRenderer.getServiceState(iNetCircuit), (int)CircuitColumnRenderer.getServiceState(iNetCircuit2));
                break;
            }
            case 13: {
                n2 = ComparisonUtil.compare((boolean)iNetCircuit.isMemberInGroup(), (boolean)iNetCircuit2.isMemberInGroup());
                break;
            }
            case 12: {
                n2 = ComparisonUtil.compare((iNetCircuit.hasLoopback() || iNetCircuit.hasXcLoopback() ? 1 : 0) != 0, (iNetCircuit2.hasLoopback() || iNetCircuit2.hasXcLoopback() ? 1 : 0) != 0);
            }
        }
        return n2;
    }

    public static String getEndpoints(INetCircuit iNetCircuit, INetCircuitEnd[] iNetCircuitEndArray) {
        if (iNetCircuitEndArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        Network network = Network.instance();
        for (int i = 0; i < iNetCircuitEndArray.length; ++i) {
            INetCircuitEnd iNetCircuitEnd;
            INetCircuitEnd iNetCircuitEnd2 = iNetCircuitEndArray[i];
            if (iNetCircuitEnd2 == null || iNetCircuitEnd2.getNodeId() == 0) continue;
            if (i > 0) {
                stringBuilder.append("\n");
            }
            INetElement iNetElement = network.findNetElem(iNetCircuitEnd2.getNodeId());
            if (iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                if (i > 0 && iNetCircuit.getCircuitSpanNum() == 0) break;
                iNetCircuitEnd = ((OchncCircuit)iNetCircuit).getEndPointForOchTrail(iNetElement);
                if (iNetCircuitEnd != null) {
                    iNetCircuitEnd2 = iNetCircuitEnd;
                }
            } else if (iNetCircuit.getCircuitTypeObj().isOchccCircuitType() && iNetCircuitEnd2.getEntityIndex() == 0 && (iNetCircuitEnd = ((OchccCircuit)iNetCircuit).getEndPointForItuOchcc(iNetElement)) != null) {
                iNetCircuitEnd2 = iNetCircuitEnd;
            }
            stringBuilder.append(CircuitColumnRenderer.getEndpoint(iNetElement, iNetCircuitEnd2, iNetCircuit.getCircuitTypeObj().isEthernetCircuitType(), iNetCircuit.getCircuitSizeObj()));
        }
        return stringBuilder.toString();
    }

    public static String getEndpoint(INetElement iNetElement, INetCircuitEnd iNetCircuitEnd, boolean bl, ICircuitSize iCircuitSize) {
        return CircuitColumnRenderer.getEndpoint(iNetElement, iNetCircuitEnd, bl, iCircuitSize, false);
    }

    private static String getEndPointStr(INetElement iNetElement, INetCircuitEnd iNetCircuitEnd, boolean bl, ICircuitSize iCircuitSize, boolean bl2, boolean bl3) {
        String string = iNetElement != null ? iNetElement.getName() : "<unknown>";
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string);
        int n = iNetCircuitEnd.getEntityIndex();
        if (bl) {
            stringBuilder.append("/Ethergroup");
            return stringBuilder.toString();
        }
        if (n == 0) {
            return string;
        }
        stringBuilder.append("/");
        stringBuilder.append(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, iCircuitSize, bl2, bl3));
        return stringBuilder.toString();
    }

    public static String getEndpoint(INetElement iNetElement, INetCircuitEnd iNetCircuitEnd, boolean bl, ICircuitSize iCircuitSize, boolean bl2, boolean bl3) {
        return CircuitColumnRenderer.getEndPointStr(iNetElement, iNetCircuitEnd, bl, iCircuitSize, bl2, bl3);
    }

    public static String getEndpoint(INetElement iNetElement, INetCircuitEnd iNetCircuitEnd, boolean bl, ICircuitSize iCircuitSize, boolean bl2) {
        return CircuitColumnRenderer.getEndPointStr(iNetElement, iNetCircuitEnd, bl, iCircuitSize, bl2, true);
    }

    public static String getVlanList(IVlanModel[] iVlanModelArray) {
        return CircuitColumnRenderer.getVlanList(iVlanModelArray, iVlanModelArray.length);
    }

    private static String getVlanList(IVlanModel[] iVlanModelArray, int n) {
        if (iVlanModelArray.length < n) {
            n = iVlanModelArray.length;
        }
        StringBuilder stringBuilder = new StringBuilder(16 * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(VlanInfoCellRenderer.getString(iVlanModelArray[i]));
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        return iVlanModelArray.length > n ? stringBuilder.append(", ...").toString() : stringBuilder.toString();
    }

    public static String getVlanList(NetVlanInfo[] netVlanInfoArray, boolean bl) {
        return CircuitColumnRenderer.getVlanList(netVlanInfoArray, netVlanInfoArray.length, bl);
    }

    public static String getVlanList(NetVlanInfo[] netVlanInfoArray) {
        return CircuitColumnRenderer.getVlanList(netVlanInfoArray, netVlanInfoArray.length, false);
    }

    private static String getVlanList(NetVlanInfo[] netVlanInfoArray, int n, boolean bl) {
        if (netVlanInfoArray.length < n) {
            n = netVlanInfoArray.length;
        }
        StringBuilder stringBuilder = new StringBuilder(16 * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(NetVlanInfoCellRenderer.getString(netVlanInfoArray[i], bl));
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        return netVlanInfoArray.length > n ? stringBuilder.append(", ...").toString() : stringBuilder.toString();
    }

    public static INetCircuitSpan[] sortSpans(INetCircuitSpan[] iNetCircuitSpanArray) {
        int n;
        Object object;
        int n2 = iNetCircuitSpanArray.length;
        INetCircuitSpan[] iNetCircuitSpanArray2 = new INetCircuitSpan[n2];
        INetLink iNetLink = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        List list = null;
        if (iNetCircuitSpanArray.length == 0) {
            return iNetCircuitSpanArray;
        }
        if (iNetCircuitSpanArray[0].getCircuit().getSources() == null) {
            return iNetCircuitSpanArray;
        }
        list = iNetCircuitSpanArray[0].getCircuit().getSources();
        Iterator iterator = list.iterator();
        if (list.size() != 1) {
            return iNetCircuitSpanArray;
        }
        while (iterator.hasNext()) {
            object = (INetCircuitEnd)iterator.next();
            n5 = object.getNodeId();
        }
        object = new ArrayList(iNetCircuitSpanArray.length);
        for (n = 0; n < iNetCircuitSpanArray.length; ++n) {
            object.add(iNetCircuitSpanArray[n]);
        }
        block2: for (n = 0; n < iNetCircuitSpanArray.length; ++n) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator2.next();
                iNetLink = iNetCircuitSpan.getLink();
                n3 = iNetLink.getSrc().getNodeId();
                n4 = iNetLink.getDst().getNodeId();
                if (n5 == n3) {
                    iNetCircuitSpanArray2[n] = iNetCircuitSpan;
                    n5 = n4;
                    iterator2.remove();
                    continue block2;
                }
                if (n5 != n4) continue;
                iNetCircuitSpanArray2[n] = iNetCircuitSpan;
                n5 = n3;
                iterator2.remove();
                continue block2;
            }
        }
        if (object.isEmpty() && iNetCircuitSpanArray2.length == iNetCircuitSpanArray.length) {
            return iNetCircuitSpanArray2;
        }
        return iNetCircuitSpanArray;
    }

    public static String getSpans(INetCircuitSpan[] iNetCircuitSpanArray) {
        INetCircuitSpan[] iNetCircuitSpanArray2 = CircuitColumnRenderer.sortSpans(iNetCircuitSpanArray);
        StringBuilder stringBuilder = new StringBuilder(64);
        for (int i = 0; i < iNetCircuitSpanArray2.length; ++i) {
            INetCircuitSpan iNetCircuitSpan = iNetCircuitSpanArray2[i];
            if (iNetCircuitSpan == null) continue;
            if (i > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(CircuitColumnRenderer.getSpan(iNetCircuitSpan));
        }
        return stringBuilder.toString();
    }

    public static String getSpan(INetCircuitSpan iNetCircuitSpan) {
        Object object;
        String string;
        Object object2;
        Object object3;
        INetLink iNetLink = iNetCircuitSpan.getLink();
        StringBuilder stringBuilder = new StringBuilder(64);
        int n = 1;
        StringBuilder stringBuilder2 = new StringBuilder(32);
        StringBuilder stringBuilder3 = new StringBuilder(32);
        try {
            object3 = iNetLink.getSrc().getNodeModel();
            object2 = new NetCircuitEnd((INodeModel)object3, object3 != null ? object3.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()) : null, iNetCircuitSpan.getSrcHoNum(), iNetCircuitSpan.getLoNum(), false);
            string = CircuitColumnRenderer.getEndpoint(iNetLink.getSrc(), (INetCircuitEnd)object2, false, iNetCircuitSpan.getCircuit().getCircuitSizeObj(), true, !iNetCircuitSpan.isSrcFabricated());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            string = "unavailable";
        }
        stringBuilder2.append(string);
        try {
            object2 = iNetLink.getDst().getNodeModel();
            object = new NetCircuitEnd((INodeModel)object2, object2 != null ? object2.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex()) : null, iNetCircuitSpan.getDstHoNum(), iNetCircuitSpan.getLoNum(), false);
            object3 = CircuitColumnRenderer.getEndpoint(iNetLink.getDst(), (INetCircuitEnd)object, false, iNetCircuitSpan.getCircuit().getCircuitSizeObj(), true, !iNetCircuitSpan.isDstFabricated());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            object3 = "unavailable";
        }
        stringBuilder3.append((String)object3);
        if (iNetCircuitSpan != null) {
            int n2 = n = iNetCircuitSpan.active() ? 4 : 5;
        }
        if (db.on()) {
            db.println("getSpan= " + iNetCircuitSpan + " state = " + n);
        }
        object2 = iNetCircuitSpan.getLink().getSrc();
        object = iNetCircuitSpan.getLink().getDst();
        List list = iNetCircuitSpan.getCircuit().getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            INetElement iNetElement = netCircuitNode.getNetElement();
            if (iNetElement.getNodeId() == object2.getNodeId()) {
                if (netCircuitNode.getWorkingSpans().contains(iNetCircuitSpan)) {
                    stringBuilder2.append(" (W)");
                    continue;
                }
                if (!netCircuitNode.getProtectSpans().contains(iNetCircuitSpan)) continue;
                stringBuilder2.append(" (P)");
                continue;
            }
            if (iNetElement.getNodeId() != object.getNodeId()) continue;
            if (netCircuitNode.getWorkingSpans().contains(iNetCircuitSpan)) {
                stringBuilder3.append(" (W)");
                continue;
            }
            if (!netCircuitNode.getProtectSpans().contains(iNetCircuitSpan)) continue;
            stringBuilder3.append(" (P)");
        }
        if (db.isFineEnabled()) {
            db.println("getSpan(): srcFab = " + iNetCircuitSpan.isSrcFabricated() + ", dstFab = " + iNetCircuitSpan.isDstFabricated() + ", src = " + stringBuilder2.toString() + ", dst = " + stringBuilder3.toString());
        }
        if (string.compareTo((String)object3) < 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(" - ");
            stringBuilder.append((CharSequence)stringBuilder3);
        } else {
            stringBuilder.append((CharSequence)stringBuilder3);
            stringBuilder.append(" - ");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static ColumnRenderer[] createTableRenderers(int n) {
        if (n < 0 || n >= columns.length) {
            return null;
        }
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columns[n].length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = CircuitColumnRenderer.createCircuitColumnRenderer(columns[n][i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createCircuitColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Circuit Name";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Type";
                n3 = 60;
                bl = true;
                n2 = 0;
                break;
            }
            case 2: {
                string = "Size";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            case 5: {
                string = "Protection";
                n3 = 80;
                bl = true;
                n2 = 0;
                break;
            }
            case 4: {
                string = "Dir";
                n3 = 60;
                bl = true;
                n2 = 0;
                break;
            }
            case 6: {
                string = "Status";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            case 3: {
                string = "OCHNC Wlen";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            case 7: {
                string = "Source";
                n3 = 140;
                bl = true;
                n2 = 2;
                break;
            }
            case 8: {
                string = "Destination";
                n3 = 140;
                bl = true;
                n2 = 2;
                break;
            }
            case 9: {
                string = "# of VLANs";
                n3 = 80;
                bl = true;
                n2 = 0;
                break;
            }
            case 10: {
                string = SPAN_TITLE;
                n3 = 80;
                bl = true;
                n2 = 0;
                break;
            }
            case 11: {
                string = "State";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            case 12: {
                string = "Loopback";
                n3 = 70;
                bl = true;
                n2 = 0;
                break;
            }
            case 13: {
                string = "VCAT State";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = true;
                n2 = 2;
            }
        }
        return new CircuitColumnRenderer(n, string, n3, bl, n2);
    }

    public static int compareCircuitSize(CircuitSize circuitSize, CircuitSize circuitSize2) {
        return circuitSize.compareTo((Object)circuitSize2);
    }

    public static int getServiceState(INetCircuit iNetCircuit) {
        int n;
        block2: {
            n = -1;
            try {
                n = iNetCircuit.getServiceState();
            }
            catch (Exception exception) {
                if (!CircuitColumnRenderer.db.on) break block2;
                db.println("getServiceState: error in getting service state.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }

    public void setSpanDetailsOn(boolean bl) {
        spanDetailsOn = bl;
        if (spanDetailsOn && this.name.equals(SPAN_TITLE)) {
            this.name = DET_SPAN_TITLE;
            this.width = 400;
        } else if (this.name.equals(DET_SPAN_TITLE)) {
            this.name = SPAN_TITLE;
            this.width = 80;
        }
    }

    public boolean isSpanDetailsOn() {
        return spanDetailsOn;
    }

    private String getChannelText(INetCircuit iNetCircuit) {
        if (iNetCircuit.getCircuitType() == 9 || iNetCircuit.getCircuitType() == 15 || iNetCircuit.getCircuitType() == 14) {
            return Wavelength.getWavelengthStringFromWavelength(iNetCircuit.getCircuitOptChannel());
        }
        return "N/A";
    }

    static {
        CircuitColumnRenderer.preferenceCleanup();
        EBW = 2;
        emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
        db = new SDebug("CircuitColumnRenderer");
    }
}

