/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.IModel;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.circuits.CircuitFilterCriteria;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OscNetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.circuits.AbstractCircuitFilterPane;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyDialogSheet;
import cerent.util.gui.CheckableList;
import cerent.util.gui.StringChoicePropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CircuitFilterAdvancedPane
extends AbstractCircuitFilterPane {
    private StringChoicePropertyEditor ringBox;
    private CheckableList netElemList;
    private StringChoicePropertyEditor linkBox;
    private StringChoicePropertyEditor endBox;
    protected static final int LABEL_PREFERRED_WIDTH = 85;
    protected static final int EDITOR_PREFERRED_WIDTH = 450;
    private static final SDebug db = new SDebug("CircuitFilterAdvancedPane");

    public CircuitFilterAdvancedPane(String string, CircuitsPane circuitsPane, AbstractPropertyDialogSheet abstractPropertyDialogSheet, CircuitFilterCriteria circuitFilterCriteria) {
        super(string, abstractPropertyDialogSheet, circuitFilterCriteria, 85, 450);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout(0, 1, 5, 5));
        this.add(this.createLeftPane());
        this.load();
        IModel iModel = circuitsPane.getCurrentCircuitScope();
        this.notifyAllPropertyEditors(this);
    }

    private JPanel createLeftPane() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
        Dimension dimension = new Dimension(500, 320);
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), null, 1, 2));
        this.ringBox = new StringChoicePropertyEditor("Ring:", this.getAllRings());
        jPanel.add(this.ringBox);
        this.ringBox.setEditorRenderer(new RingListCellRenderer());
        this.regularizePropertyEditor(this.ringBox);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Node:");
        this.regularizePropertyEditor(jPanel2, jLabel, 151);
        jPanel3.add((Component)jLabel, "North");
        jPanel2.add((Component)jPanel3, "West");
        this.netElemList = new CheckableList();
        this.netElemList.setData(this.getAllNetElems());
        this.netElemList.selectAll();
        this.regularizeCheckableList(this.netElemList, 4);
        jPanel2.add((Component)new JScrollPane(this.netElemList), "Center");
        jPanel.add(jPanel2);
        this.linkBox = new StringChoicePropertyEditor("Link:", this.getAllLinks());
        jPanel.add(this.linkBox);
        this.linkBox.setEditorRenderer(new LinkListCellRenderer());
        this.regularizePropertyEditor(this.linkBox);
        this.endBox = new StringChoicePropertyEditor("Source/Drop:", this.getSrcDropTypes());
        jPanel.add(this.endBox);
        this.regularizePropertyEditor(this.endBox);
        return jPanel;
    }

    @Override
    public void restoreDefaults() {
        this.ringBox.setValue(new Integer(-1));
        this.netElemList.selectAll();
        this.linkBox.setValue(new Integer(-1));
        this.endBox.setValue(new Integer(-1));
        super.restoreDefaults();
    }

    @Override
    public void load() {
        if (this.ringBox.containsChoice(this.filterCriteria.getRing())) {
            this.ringBox.setValue(this.filterCriteria.getRing());
        } else {
            this.ringBox.setValue(new Integer(-1));
        }
        if (this.filterCriteria.getNetElements() == null) {
            this.netElemList.selectAll();
        } else {
            INetElement[] iNetElementArray = this.filterCriteria.getNetElements();
            ArrayList<NetElementDisplayer> arrayList = new ArrayList<NetElementDisplayer>();
            for (int i = 0; i < iNetElementArray.length; ++i) {
                arrayList.add(new NetElementDisplayer(iNetElementArray[i]));
            }
            this.netElemList.setSelectedObjects(arrayList);
        }
        if (this.linkBox.containsChoice(this.filterCriteria.getLink())) {
            this.linkBox.setValue(this.filterCriteria.getLink());
        } else {
            this.linkBox.setValue(new Integer(-1));
        }
        this.endBox.setValue(new Integer(this.filterCriteria.getSrcDropType()));
    }

    @Override
    public void store() {
        if (this.ringBox.getValue() instanceof Attribute) {
            this.filterCriteria.setRing(null);
        } else {
            this.filterCriteria.setRing((BlsrRingModel)this.ringBox.getValue());
        }
        List list = this.netElemList.getSelectedObjects();
        INetElement[] iNetElementArray = null;
        if (list.size() < this.netElemList.getModel().getSize()) {
            iNetElementArray = new INetElement[list.size()];
            for (int i = 0; i < iNetElementArray.length; ++i) {
                iNetElementArray[i] = ((NetElementDisplayer)list.get((int)i)).ne;
            }
        }
        this.filterCriteria.setNetElements(iNetElementArray);
        if (this.linkBox.getValue() instanceof Attribute) {
            this.filterCriteria.setLink(null);
        } else {
            this.filterCriteria.setLink((INetLink)this.linkBox.getValue());
        }
        this.filterCriteria.setSrcDropType(((Attribute)this.endBox.getValue()).getIntValue());
    }

    public void dispose() {
        this.ringBox = null;
        this.netElemList = null;
        this.linkBox = null;
        this.endBox = null;
        this.removeAll();
    }

    private List getAllRings() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(BlsrRingManager.instance().getBlsrRingModels());
        this.sortCollection(arrayList, new RingComparator());
        arrayList.add(0, new Attribute("Any", -1));
        return arrayList;
    }

    private Collection getAllNetElems() {
        ArrayList<NetElementDisplayer> arrayList = new ArrayList<NetElementDisplayer>();
        for (INetElement iNetElement : Network.instance().getAllElements()) {
            if (!iNetElement.getNodeModel().isInited()) continue;
            arrayList.add(new NetElementDisplayer(iNetElement));
        }
        this.sortCollection(arrayList, new NetElementDisplayerComparator());
        return arrayList;
    }

    private List getAllLinks() {
        TreeSet<INetLink> treeSet = new TreeSet<INetLink>(new LinkComparator());
        for (INetLink iNetLink : Network.instance().getNetLinks()) {
            if (iNetLink.isDeleted() || iNetLink.isPhantom() || iNetLink instanceof OscNetLink || !iNetLink.isVirtual() && !iNetLink.isRoutable()) continue;
            treeSet.add(iNetLink);
        }
        ArrayList arrayList = new ArrayList(treeSet);
        arrayList.add(0, new Attribute("Any", -1));
        return arrayList;
    }

    private Attribute[] getSrcDropTypes() {
        return new Attribute[]{new Attribute("Any", -1), new Attribute("1 Source and 1 Drop Only", 1), new Attribute("Multiple Sources or Multiple Drops", 2)};
    }

    private String getLinkPrettyString(INetLink iNetLink) {
        return MapLinkRenderer.getLinkLabel(iNetLink);
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CircuitFilterAdvancedPane;
    }

    public boolean onValidate() {
        return true;
    }

    private class LinkComparator
    implements Comparator {
        private LinkComparator() {
        }

        public int compare(Object object, Object object2) {
            INetLink iNetLink = (INetLink)object;
            INetLink iNetLink2 = (INetLink)object2;
            return CircuitFilterAdvancedPane.this.getLinkPrettyString(iNetLink).compareTo(CircuitFilterAdvancedPane.this.getLinkPrettyString(iNetLink2));
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    private class LinkListCellRenderer
    extends DefaultListCellRenderer {
        private LinkListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Attribute) {
                string = object.toString();
            } else {
                INetLink iNetLink = (INetLink)object;
                string = CircuitFilterAdvancedPane.this.getLinkPrettyString(iNetLink);
            }
            this.setText(string);
            this.setToolTipText(string);
            return this;
        }
    }

    private class NetElementDisplayer {
        INetElement ne;

        NetElementDisplayer(INetElement iNetElement) {
            this.ne = iNetElement;
        }

        public String toString() {
            return this.ne.getName();
        }

        public boolean equals(Object object) {
            return this.ne.equals(((NetElementDisplayer)object).ne);
        }
    }

    private class NetElementDisplayerComparator
    implements Comparator {
        private NetElementDisplayerComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((NetElementDisplayer)object).toString();
            String string2 = ((NetElementDisplayer)object2).toString();
            return string.compareTo(string2);
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    private class RingComparator
    implements Comparator {
        private RingComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((BlsrRingModel)object).getRingName();
            String string2 = ((BlsrRingModel)object2).getRingName();
            return string.compareTo(string2);
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    private class RingListCellRenderer
    extends DefaultListCellRenderer {
        private RingListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Attribute) {
                string = object.toString();
            } else {
                BlsrRingModel blsrRingModel = (BlsrRingModel)object;
                string = blsrRingModel.getRingName();
            }
            this.setText(string);
            return this;
        }
    }
}

