/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ui.circuits.AbstractCircuitMap;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.circuits.OchccProtectedCircuitMapNode;
import cerent.cms.ui.circuits.OchncProtectedCircuitMapNode;
import cerent.cms.ui.network.CircuitExternalMapLink;
import cerent.cms.ui.network.CircuitExternalMapLinkCookie;
import cerent.cms.ui.network.CircuitExternalMapNode;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.NetMapFactory;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.ExternalMapKey;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;

public class CircuitMapFactory
implements IMapFactory {
    private static final SDebug db = new SDebug("CircuitMapFactory");
    private static final CircuitMapFactory instance = new CircuitMapFactory();

    private CircuitMapFactory() {
    }

    public static CircuitMapFactory instance() {
        return instance;
    }

    @Override
    public MapLink createLink(MapToolkit mapToolkit, Object object) {
        return NetMapFactory.instance().createLink(mapToolkit, object);
    }

    @Override
    public MapLink createLink(MapToolkit mapToolkit, boolean bl, Object object) {
        return NetMapFactory.instance().createLink(mapToolkit, bl, object);
    }

    @Override
    public MapLink createLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string, Object object) {
        if (mapToolkit instanceof AbstractCircuitMap) {
            if (object instanceof CircuitExternalMapLinkCookie) {
                return new CircuitExternalMapLink(mapToolkit, mapNode, mapNode2, string);
            }
            return new CircuitMapLink(mapToolkit, mapNode, mapNode2, string);
        }
        return NetMapFactory.instance().createLink(mapToolkit, mapNode, mapNode2, string, object);
    }

    @Override
    public MapNode createNode(MapToolkit mapToolkit, Object object) {
        return this.createNode(mapToolkit, false, object);
    }

    @Override
    public MapNode createNode(MapToolkit mapToolkit, boolean bl, Object object) {
        if (mapToolkit instanceof AbstractCircuitMap) {
            if (object instanceof ExternalMapKey) {
                return new CircuitExternalMapNode(mapToolkit);
            }
            if (this.needsOchccProtectedCircuitNode(mapToolkit)) {
                return new OchccProtectedCircuitMapNode(mapToolkit);
            }
            if (this.needsOchncProtectedCircuitNode(mapToolkit)) {
                return new OchncProtectedCircuitMapNode(mapToolkit);
            }
            return new CircuitMapNode(mapToolkit);
        }
        return NetMapFactory.instance().createNode(mapToolkit, bl, object);
    }

    private boolean needsOchccProtectedCircuitNode(MapToolkit mapToolkit) {
        CircuitMap circuitMap;
        INetCircuit iNetCircuit;
        if (mapToolkit instanceof CircuitMap && (iNetCircuit = (circuitMap = (CircuitMap)mapToolkit).getNetCircuit()) instanceof OchccCircuit) {
            return ((OchccCircuit)iNetCircuit).isCircuitProtected();
        }
        return false;
    }

    private boolean needsOchncProtectedCircuitNode(MapToolkit mapToolkit) {
        CircuitMap circuitMap;
        INetCircuit iNetCircuit;
        if (mapToolkit instanceof CircuitMap && (iNetCircuit = (circuitMap = (CircuitMap)mapToolkit).getNetCircuit()) instanceof OchncCircuit) {
            return ((OchncCircuit)iNetCircuit).isSplitterProtectedCircuit();
        }
        return false;
    }
}

