/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDs123LineModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFcmrLineModel;
import cerent.cms.model.IGfpLineModel;
import cerent.cms.model.IHdGeLineModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IL2scLineModel;
import cerent.cms.model.ILexLineModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.IML2PosLineModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.ucp.IUcpCircuitOriginModel;
import cerent.cms.model.ucp.IUcpCircuitTerminationModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CircuitMapUtil {
    private static SDebug db = new SDebug("CircuitMapUtil");
    public static final int ACTIVE_IS_UNKNOWN = 0;
    public static final int ACTIVE_IS_WORKING = 1;
    public static final int ACTIVE_IS_PROTECT = 2;
    public static final String LO_TERM = CircuitMapUtil.getTDMTerminology().getGeneralTerms(1);
    public static final String HO_TERM = CircuitMapUtil.getTDMTerminology().getGeneralTerms(0);
    public static final String LAP_TERM = CircuitMapUtil.getTDMTerminology().getGeneralTerms(6);
    public static final String BLSR_TERM = CircuitMapUtil.getTDMTerminology().getRingTerms(1);
    public static final String BLSRDRI_TERM = BLSR_TERM + "-DRI";
    public static final String BLSRDRI2_TERM = BLSR_TERM + "-" + BLSRDRI_TERM;
    public static final String UPSR_TERM = CircuitMapUtil.getTDMTerminology().getRingTerms(0);
    public static final String UPSRDRI_TERM = UPSR_TERM + "-DRI";
    public static final String TUNNEL_TERM = CircuitMapUtil.getTDMTerminology().getGeneralTerms(5);
    public static final String PDIP_TERM = CircuitMapUtil.getTDMTerminology().getGeneralTerms(9);
    public static final int CKT_ACTIVE_ONLY = 0;
    public static final int CKT_ACTIVE_OR_UPGRADABLE = 1;

    private CircuitMapUtil() {
    }

    public static IInterfaceModel getInterfaceModel(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd) {
        block23: {
            try {
                ILoNum iLoNum;
                IPortModel iPortModel;
                IInterfaceModel iInterfaceModel;
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                IHoNum iHoNum = iNetCircuitEnd.getHoNum();
                IPortModel iPortModel2 = iEntityModel instanceof IPortModel ? (IPortModel)iEntityModel : null;
                boolean bl = iPortModel2 != null && iPortModel2.getEqType() == 34;
                boolean bl2 = iPortModel2 != null && iPortModel2.getEqType() == 31;
                boolean bl3 = iPortModel2 != null && iPortModel2.getEqType() == 68;
                boolean bl4 = iPortModel2 != null && iPortModel2.getEqType() == 69;
                boolean bl5 = false;
                if (iPortModel2 != null && Feature.provides((INodeModel)iPortModel2.getNodeModel(), (Feature)Feature.SDH_AU3)) {
                    boolean bl6 = bl5 = iPortModel2 != null && iPortModel2.getEqType() == 32 && iPortModel2.getNodeModel().getTdmProtocolTypeObj().isSdh();
                }
                if (db.on()) {
                    db.println("getInterfaceModel(): isDs1Port=" + bl + ", isEc1Port= " + bl2 + ", isE1Port= " + bl3 + ", isE3Port= " + bl4 + ", isDS3PortOnSdh= " + bl5);
                }
                if (iPortModel2 != null && (bl2 || bl3 || bl4 || bl5) && (iPortModel2.getModuleModel().getEqType() == 233 || iPortModel2.getModuleModel().getEqType() == 234) && iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                    if (db.on()) {
                        db.println("getInterfaceModel(): processing Ec1/E1/E3/DS3OnSDH port isLoCircuitType= " + iNetCircuit.getCircuitTypeObj().isLoCircuitType() + " eEqType= " + iEntityModel.getEqType());
                    }
                    ITdmLoModel iTdmLoModel = null;
                    ILoNum iLoNum2 = iNetCircuitEnd.getLoNum();
                    if (bl3 || bl4 || bl5) {
                        IModuleModel iModuleModel = iPortModel2.getModuleModel();
                        IPortModel iPortModel3 = iModuleModel.getPortModelForPath((IEntityModel)iPortModel2, iLoNum2, iHoNum);
                        iTdmLoModel = iPortModel3.getTdmLoModel(iLoNum2);
                    } else {
                        iTdmLoModel = iPortModel2.getTdmLoModel(iLoNum2);
                    }
                    if (db.on()) {
                        if (iTdmLoModel == null) {
                            db.println("getInterfaceModel(): Ec1 port/E1 port/E3 port/DS3 port, LO model= null!");
                        } else {
                            db.println("getInterfaceModel(): Ec1 port/E1 port/E3 port/DS3 port, LO model= " + iTdmLoModel.toString());
                        }
                    }
                    return iTdmLoModel;
                }
                if (iPortModel2 != null && !bl) {
                    iInterfaceModel = iPortModel2.getInterfaceModel();
                    if (db.on()) {
                        db.println("getInterfaceModel: -------> " + iPortModel2 + " port type " + CircuitMapUtil.getSpanLabel(iNetCircuitEnd) + " Interface: " + iInterfaceModel.toString());
                    }
                    if (iInterfaceModel instanceof IDwdmTrkLineModel) {
                        return iInterfaceModel;
                    }
                    if (iInterfaceModel instanceof IDs123LineModel && iNetCircuit.getCircuitTypeObj().isLoCircuitType() && iEntityModel.getEqType() == 33 && (iPortModel = iPortModel2.getTdmLoModel(iLoNum = iNetCircuitEnd.getLoNum())) != null) {
                        return iPortModel;
                    }
                    if (db.on()) {
                        db.println("getInterfaceModel: ----------> " + iPortModel2 + " port type " + CircuitMapUtil.getSpanLabel(iNetCircuitEnd) + " hoNum: " + iHoNum);
                    }
                    if ((iLoNum = iPortModel2.getTdmHoModel(iHoNum)) != null) {
                        return iLoNum;
                    }
                    if (CircuitMapUtil.isDataCardLineInterface(iInterfaceModel)) {
                        return CircuitMapUtil.getDataCardPathInterface(iNetCircuit, iInterfaceModel, iHoNum);
                    }
                }
                if (bl || iEntityModel instanceof IModuleModel) {
                    iInterfaceModel = iNetCircuit.getCircuitTypeObj();
                    iLoNum = iNetCircuitEnd.getLoNum();
                    iPortModel = CircuitEndCellRenderer.getDs1(iEntityModel, iLoNum, iHoNum);
                    if (db.on()) {
                        db.println("Module Model: poking vt " + iLoNum);
                    }
                    if (iInterfaceModel.isLoCircuitType()) {
                        if (iPortModel.getNodeModel().provides(Feature.J2_COMMON)) {
                            return iPortModel.getTdmLoModel(iLoNum);
                        }
                        return iPortModel.getTdmHoModel(iHoNum);
                    }
                    return iPortModel.getTdmHoModel(iHoNum);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block23;
                db.println("getInterfaceModel encountered exception:");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on() && iNetCircuitEnd != null) {
            db.println("getInterfaceModel:no interface found for " + CircuitMapUtil.getSpanLabel(iNetCircuitEnd));
        }
        return null;
    }

    private static IInterfaceModel getDataCardPathInterface(INetCircuit iNetCircuit, IInterfaceModel iInterfaceModel, IHoNum iHoNum) {
        block8: {
            try {
                short s = 0;
                if (iHoNum != null) {
                    s = iHoNum.getIdlHoNum();
                }
                if (iNetCircuit.isMemberOfVcat()) {
                    s = (short)iNetCircuit.getMemberNumber();
                }
                if (iNetCircuit.getCircuitTypeObj().isHoCircuitType()) {
                    return iInterfaceModel.getHoIfModelFromMemberId(s);
                }
                if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                    return iInterfaceModel.getLoIfModelFromMemberId(s);
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractMethodError);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return iInterfaceModel;
    }

    private static boolean isDataCardLineInterface(IInterfaceModel iInterfaceModel) {
        return iInterfaceModel instanceof IHdGeLineModel || iInterfaceModel instanceof IL2scLineModel || iInterfaceModel instanceof IFcmrLineModel || iInterfaceModel instanceof IML2PosLineModel || iInterfaceModel instanceof IGfpLineModel || iInterfaceModel instanceof ILexLineModel;
    }

    public static IInterfaceModel getLineModel(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd) {
        IInterfaceModel iInterfaceModel;
        block6: {
            iInterfaceModel = null;
            try {
                IPortModel iPortModel;
                boolean bl;
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                IPortModel iPortModel2 = iEntityModel instanceof IPortModel ? (IPortModel)iEntityModel : null;
                boolean bl2 = bl = iPortModel2 != null && iPortModel2.getEqType() == 34;
                if (iPortModel2 != null && !bl) {
                    iInterfaceModel = iPortModel2.getInterfaceModel();
                } else if ((bl || iEntityModel instanceof IModuleModel) && (iPortModel = CircuitEndCellRenderer.getDs1(iEntityModel, iNetCircuitEnd.getLoNum(), iNetCircuitEnd.getHoNum())) != null) {
                    iInterfaceModel = iPortModel.getInterfaceModel();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                db.println("getLineModel encountered exception:");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on() && iNetCircuitEnd != null) {
            db.println("getLineModel:no interface found for " + CircuitMapUtil.getSpanLabel(iNetCircuitEnd));
        }
        return iInterfaceModel;
    }

    public static IDwdmPortModel getClientPortModelForAdm(IPortModel iPortModel) {
        int n = 0;
        IEntityModel iEntityModel = null;
        List list = null;
        if (iPortModel != null && (iEntityModel = iPortModel.getParent().getParent()) != null) {
            n = iEntityModel.getPositionInParent();
            if ((iEntityModel = iEntityModel.getParent()) != null) {
                list = iEntityModel.getDescendantsOfEqType(122);
            }
            for (int i = 0; i < list.size() && (iEntityModel = (IEntityModel)list.get(i)).getPositionInParent() != n; ++i) {
            }
            if (db.on()) {
                db.println("Returning PortModel : " + (iEntityModel != null ? iEntityModel.toString() : null));
            }
        }
        return iEntityModel instanceof IDwdmPortModel ? (IDwdmPortModel)iEntityModel : null;
    }

    public static NetCircuitEnd getCircuitEnd(INodeModel iNodeModel, int n, IHoNum iHoNum, ILoNum iLoNum) {
        try {
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNodeModel, iNodeModel != null ? iNodeModel.getEntityTable().getEntityModelByIndex(n) : null, iHoNum, iLoNum, false);
            return netCircuitEnd;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSpanLabel(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, iHoNum, iLoNum, 0);
    }

    public static String getSpanLabel(INetCircuitEnd iNetCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    public static String dumpSpanInfo(INetCircuitSpan iNetCircuitSpan) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            INetLink iNetLink = iNetCircuitSpan.getLink();
            ILinkModel iLinkModel = iNetLink.getLinkModel();
            INodeModel iNodeModel = iLinkModel.dst();
            INodeModel iNodeModel2 = iLinkModel.src();
            NetCircuitEnd netCircuitEnd = CircuitMapUtil.getCircuitEnd(iNodeModel2, iLinkModel.srcEntityIndex(), iNetCircuitSpan.getSrcHoNum(), iNetCircuitSpan.getLoNum());
            NetCircuitEnd netCircuitEnd2 = CircuitMapUtil.getCircuitEnd(iNodeModel, iLinkModel.dstEntityIndex(), iNetCircuitSpan.getDstHoNum(), iNetCircuitSpan.getLoNum());
            stringBuffer.append("Information in addSpan() " + iNetCircuitSpan);
            stringBuffer.append("\tSrc: " + CircuitMapUtil.getSpanLabel(netCircuitEnd) + " [" + iNetCircuitSpan.getLink().getLinkModel().src().getName() + ", STS: " + iNetCircuitSpan.getSrcHoNum() + "]");
            stringBuffer.append("\tSpan State on " + iNodeModel.getName() + ": " + iNetCircuitSpan.getSpanState(iNodeModel));
            stringBuffer.append("\tDst: " + CircuitMapUtil.getSpanLabel(netCircuitEnd2) + " [" + iNetCircuitSpan.getLink().getLinkModel().dst().getName() + ", STS: " + iNetCircuitSpan.getDstHoNum() + "]");
            stringBuffer.append("\tSpan State on " + iNodeModel2.getName() + ": " + iNetCircuitSpan.getSpanState(iNodeModel2));
        }
        catch (Exception exception) {
            stringBuffer.append(exception.toString());
            SDebug.printStackTrace((Throwable)exception);
        }
        return stringBuffer.toString();
    }

    public static TDMTerminology getTDMTerminology() {
        return CircuitMapUtil.getTDMTerminology(null);
    }

    public static boolean useSonetTerminology() {
        return CircuitMapUtil.getTDMTerminology() instanceof SONETTDMTerminology;
    }

    public static TDMTerminology getTDMTerminology(INetCircuit iNetCircuit) {
        INetCircuitNode iNetCircuitNode;
        Collection collection;
        TDMTerminology tDMTerminology = null;
        if (iNetCircuit != null) {
            collection = null;
            List list = iNetCircuit.getCircuitNodes();
            if (db.on()) {
                db.fine("TDMTerm: circuitnodes size is " + list.size());
            }
            Object object = list.iterator();
            while (object.hasNext()) {
                iNetCircuitNode = (INetCircuitNode)object.next();
                if (iNetCircuitNode == null) continue;
                collection = iNetCircuitNode.getNodeModel();
                if (collection != null) {
                    if (db.on()) {
                        db.fine("OK for TDMTerm! - " + collection.getName());
                    }
                    tDMTerminology = collection.getTDMTerminology();
                    break;
                }
                if (!db.on()) continue;
                db.fine("Not OK for TDMTerm: cktnode is null!");
            }
        }
        if (tDMTerminology == null && (tDMTerminology = NetworkModel.instance().getCmsHostModel().getNodeModel().getTDMTerminology()) == null) {
            collection = Network.instance().getAllElements();
            for (Object object : collection) {
                if (object == null || (iNetCircuitNode = object.getNodeModel()) == null || !iNetCircuitNode.isInited()) continue;
                tDMTerminology = iNetCircuitNode.getTDMTerminology();
                break;
            }
        }
        return tDMTerminology;
    }

    public static List getPortDrops(INetCircuit iNetCircuit) {
        ArrayList<INetCircuitDropInfo> arrayList = new ArrayList<INetCircuitDropInfo>();
        for (INetCircuitDropInfo iNetCircuitDropInfo : iNetCircuit.getDrops()) {
            if (iNetCircuitDropInfo == null) {
                if (!db.on()) continue;
                db.println("getPortDrops: info is null");
                continue;
            }
            if (iNetCircuitDropInfo.getEntityIndex() == 0) {
                if (!db.on()) continue;
                db.println("getPortDrops: info.getEntityIndex() is null");
                continue;
            }
            if (db.on()) {
                db.println("getPortDrops: adding drop");
            }
            arrayList.add(iNetCircuitDropInfo);
        }
        return arrayList;
    }

    public static boolean dropOpAllowed(int n, INetCircuit iNetCircuit, INetCircuitNode iNetCircuitNode) {
        ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
        if (iCircuitType.isSVLANType()) {
            return true;
        }
        if (iCircuitType.isEthernetCircuitType()) {
            if (n == -1) {
                return true;
            }
            return iNetCircuitNode != null && iNetCircuitNode.eligibleForEtherHoDropAdd();
        }
        if ((iCircuitType.isLoCircuitType() || iCircuitType.isHoCircuitType()) && iNetCircuit.getCircuitDir() == 0) {
            int n2 = CircuitMapUtil.getPortDrops(iNetCircuit).size() + n;
            return n2 > 0;
        }
        return false;
    }

    public static boolean circuitValidState(INetCircuit iNetCircuit, int n) {
        if (iNetCircuit != null) {
            int n2 = iNetCircuit.getState();
            if (n2 == 1) {
                return true;
            }
            if (n2 == 5 && n == 1) {
                return true;
            }
        }
        return false;
    }

    public static String generalInterest(INetCircuit iNetCircuit) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            Object object2;
            stringBuffer.append("\n\tcircuit name: " + iNetCircuit.getCircuitName());
            stringBuffer.append("\n\tcircuit type: " + iNetCircuit.getCircuitType());
            stringBuffer.append("\n\tcircuit size: " + iNetCircuit.getCircuitSize());
            stringBuffer.append("\n\tcircuit active? " + CircuitMapUtil.circuitValidState(iNetCircuit, 1));
            stringBuffer.append("\n\tSPANS:");
            for (Object object2 : iNetCircuit.getCircuitSpans()) {
                stringBuffer.append("\n\tSpan: " + object2);
            }
            stringBuffer.append("\n\tNODES:");
            object2 = iNetCircuit.getCircuitNodes();
            TDMTerminology tDMTerminology = CircuitMapUtil.getTDMTerminology(iNetCircuit);
            if (tDMTerminology != null) {
                string = tDMTerminology.getRingTerms(0);
            } else {
                stringBuffer.append("(trouble getting Tdm Terminology for UPSR_TERM!");
                string = "UPSR";
            }
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                INetCircuitNode iNetCircuitNode = (INetCircuitNode)object3.next();
                stringBuffer.append("\n\tNode: " + iNetCircuitNode.getNodeModel().getName() + string + " selector? " + iNetCircuitNode.isUpsrSelector());
            }
            stringBuffer.append("\n\tSOURCES:");
            object3 = iNetCircuit.getSources();
            if (object3 != null) {
                int n = 0;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                    stringBuffer.append("\n\tCircuit Src #" + ++n + " " + iNetCircuitEnd);
                }
            } else {
                stringBuffer.append("\n\tSources are null.");
            }
            stringBuffer.append("\n\tDROPS:");
            List list = iNetCircuit.getDrops();
            int n = 0;
            for (INetCircuitEnd iNetCircuitEnd : list) {
                stringBuffer.append("\n\tCircuit Drop #" + ++n + " " + iNetCircuitEnd);
            }
        }
        catch (Exception exception) {
            stringBuffer.append(exception.toString());
            SDebug.printStackTrace((Throwable)exception);
        }
        return stringBuffer.toString();
    }

    public static String circuitSuffix(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static boolean connectionHasSecondSelector(IConnectionModel iConnectionModel) {
        ILoConnectionModel iLoConnectionModel;
        int n;
        boolean bl = false;
        if (iConnectionModel instanceof IHoConnectionModel) {
            IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)iConnectionModel;
            int n2 = iHoConnectionModel.getConnectionType();
            if (n2 == 3 || n2 == 11 || n2 == 13) {
                bl = true;
            }
        } else if (iConnectionModel instanceof ILoConnectionModel && ((n = (iLoConnectionModel = (ILoConnectionModel)iConnectionModel).getConnectionType()) == 3 || n == 11 || n == 13)) {
            bl = true;
        }
        return bl;
    }

    public static String getSelectorString(IConnectionModel iConnectionModel, boolean bl, SDebug sDebug) {
        int n;
        Object object;
        if (iConnectionModel instanceof IHoConnectionModel) {
            object = (IHoConnectionModel)iConnectionModel;
            n = object.getConnectionType();
        } else if (iConnectionModel instanceof ILoConnectionModel) {
            object = (ILoConnectionModel)iConnectionModel;
            n = object.getConnectionType();
        } else {
            return "";
        }
        String string = object = bl ? "First Selector" : "Second Selector";
        if (sDebug.on()) {
            String string2 = "A-B";
            if (n == 3 || n == 11) {
                string2 = bl ? "A-B" : "C-D";
            } else if (n == 13) {
                string2 = bl ? "A-D" : "C-B";
            } else if (n == 15 || n == 16 || n == 14) {
                string2 = "A-D";
            }
            object = (String)object + ", " + string2;
        }
        return object;
    }

    public static int getActivePathCode(INetCircuitNode iNetCircuitNode, int n) {
        if (iNetCircuitNode == null) {
            if (db.on()) {
                db.println("CktNode is null!");
            }
            return 0;
        }
        int n2 = iNetCircuitNode.getConnectionType();
        List list = iNetCircuitNode.getPathList();
        List list2 = iNetCircuitNode.getActivePathList();
        if (n > list2.size()) {
            if (db.on()) {
                db.println("psIndex " + n + " exceeds num of selectors");
            }
            return 0;
        }
        try {
            int n3;
            int n4;
            if (n == 0) {
                n4 = 0;
                n3 = 1;
                if (n2 == 13 || n2 == 15 || n2 == 14 || n2 == 16) {
                    n4 = 0;
                    n3 = 3;
                }
            } else if (n == 1) {
                n4 = 2;
                n3 = 3;
                if (n2 == 13) {
                    n4 = 2;
                    n3 = 1;
                }
            } else {
                if (db.on()) {
                    db.println("Invalid PS# " + n);
                }
                return 0;
            }
            Object e = list.get(n4);
            Object e2 = list.get(n3);
            Object e3 = list2.get(n);
            if (e3 != null) {
                if (e3.equals(e)) {
                    return 1;
                }
                if (e3.equals(e2)) {
                    return 2;
                }
                if (db.on()) {
                    db.println("Active path: " + e3 + " did not " + "match either working path: " + e + " nor protect path: " + e2);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return 0;
    }

    public static ICircuitId getConnCircuitId(Object object) {
        if (object instanceof IConnectionModel) {
            return ((IConnectionModel)object).getCircuitId();
        }
        if (object instanceof IUcpCircuitOriginModel) {
            return ((IUcpCircuitOriginModel)object).getCircuitId();
        }
        if (object instanceof IUcpCircuitTerminationModel) {
            return ((IUcpCircuitTerminationModel)object).getCircuitId();
        }
        return null;
    }

    public static boolean interfaceHasDriConnection(IInterfaceModel iInterfaceModel, INetCircuit iNetCircuit) {
        ICircuitId iCircuitId = iNetCircuit.getCircuitId();
        if (db.on()) {
            db.println("Checking if interface supports DRI Connection ");
            db.println("Interface: " + iInterfaceModel);
            db.println("on this circuit: " + iNetCircuit + "\tId=" + iCircuitId);
        }
        List list = iInterfaceModel.getConnectionsList();
        for (int i = 0; i < list.size(); ++i) {
            ICircuitId iCircuitId2;
            int n;
            Object e = list.get(i);
            if (db.on()) {
                db.fine("\tFound connection " + i + "/" + list.size() + ": " + e);
            }
            if (!(e instanceof IHoConnectionModel) && !(e instanceof ILoConnectionModel)) continue;
            IHoConnectionModel iHoConnectionModel = null;
            ILoConnectionModel iLoConnectionModel = null;
            if (e instanceof IHoConnectionModel) {
                iHoConnectionModel = (IHoConnectionModel)e;
                if (db.on()) {
                    db.fine("\t\t(It is an IHoConnectionModel)");
                }
            } else {
                iLoConnectionModel = (ILoConnectionModel)e;
                if (db.on()) {
                    db.fine("\t\t(It is an ILoConnectionModel)");
                }
            }
            int n2 = n = iHoConnectionModel != null ? iHoConnectionModel.getDriNodeType() : iLoConnectionModel.getDriNodeType();
            if (n == 0) continue;
            if (db.on()) {
                db.println("\tValid, DRI Type is " + n);
            }
            ICircuitId iCircuitId3 = iCircuitId2 = iHoConnectionModel != null ? CircuitMapUtil.getConnCircuitId(iHoConnectionModel) : CircuitMapUtil.getConnCircuitId(iLoConnectionModel);
            if (!iCircuitId.equals(iCircuitId2)) continue;
            return true;
        }
        return false;
    }

    public static boolean interfaceHasDriConnection(INetCircuitEnd iNetCircuitEnd, INetCircuit iNetCircuit) {
        IInterfaceModel iInterfaceModel = CircuitMapUtil.getInterfaceModel(iNetCircuit, iNetCircuitEnd);
        return CircuitMapUtil.interfaceHasDriConnection(iInterfaceModel, iNetCircuit);
    }

    public static boolean isBlsrDriNode(INetCircuitNode iNetCircuitNode) {
        return iNetCircuitNode.getDriNodeType() != 0;
    }
}

