/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPptData;
import cerent.cms.model.IPptListener;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.circuits.PptPane;
import cerent.util.KDebug;
import cerent.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.naming.OperationNotSupportedException;

final class CircuitPpt {
    private KDebug db;
    private PptPane owner;
    private INetCircuit ckt;
    private boolean canceled = false;
    private boolean started = false;
    private Object masterLock = new Object();
    private PptListener fwdListener = new PptListener();
    private PptListener revListener = new PptListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.masterLock;
        synchronized (object) {
            this.canceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfComplete() {
        Object object = this.masterLock;
        synchronized (object) {
            if (this.canceled) {
                return;
            }
            if (this.fwdListener.isComplete() && this.revListener.isComplete()) {
                this.owner.updateData(this.fwdListener.getResult(), this.revListener.getResult());
                this.fwdListener.reset();
                this.revListener.reset();
            }
        }
    }

    public CircuitPpt(PptPane pptPane, KDebug kDebug) {
        this.db = new KDebug(kDebug, "CircuitPpt");
        this.owner = pptPane;
        this.ckt = pptPane.getCircuit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OperationNotSupportedException {
        List<Pair<IIpAddr, Integer>> list;
        Object object = this.masterLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        object = (OchncCircuit)this.ckt;
        boolean bl = ((NetCircuit)object).isBidirectional();
        List list2 = ((NetCcatCircuit)object).getCircuitNodeFromNE(((NetCircuit)object).getSourceNE());
        if (list2 == null) {
            if (this.db.on()) {
                this.db.warning("CircuitPpt: srcList==null");
            }
            return;
        }
        List list3 = ((NetCcatCircuit)object).getCircuitNodeFromNE(((OchncCircuit)object).getDstNetElementForOCHNC());
        if (list3 == null) {
            if (this.db.on()) {
                this.db.warning("CircuitPpt: dstList==null");
            }
            return;
        }
        OchncCircuitNode ochncCircuitNode = null;
        OchncCircuitNode ochncCircuitNode2 = null;
        NetCircuitNode netCircuitNode = (NetCircuitNode)list2.get(0);
        if (netCircuitNode instanceof OchncCircuitNode) {
            ochncCircuitNode = (OchncCircuitNode)netCircuitNode;
        } else {
            list = netCircuitNode.getAllSpansList();
            for (Object e : list) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)e;
                INetCircuitNode iNetCircuitNode = netCircuitSpan.getDstNCN();
                if (!(iNetCircuitNode instanceof OchncCircuitNode)) continue;
                ochncCircuitNode = (OchncCircuitNode)iNetCircuitNode;
            }
        }
        if (ochncCircuitNode == null) {
            if (this.db.on()) {
                this.db.warning("CircuitPpt: src==null");
            }
            return;
        }
        for (Object object2 : list3) {
            if (!(object2 instanceof OchncCircuitNode)) continue;
            ochncCircuitNode2 = (OchncCircuitNode)object2;
            break;
        }
        if (ochncCircuitNode2 == null) {
            if (this.db.on()) {
                this.db.warning("CircuitPpt: dst==null");
            }
            return;
        }
        try {
            list = this.createPathList(ochncCircuitNode, ochncCircuitNode2);
            if (!ochncCircuitNode.getNodeModel().getINodeOpticsTopologyModel().startPpt(this.ckt.getCircuitOptChannel(), list, (IPptListener)this.fwdListener)) {
                this.fwdListener.fail();
            }
            if (bl) {
                Object object2;
                object2 = this.createPathList(ochncCircuitNode2, ochncCircuitNode);
                if (!ochncCircuitNode2.getNodeModel().getINodeOpticsTopologyModel().startPpt(this.ckt.getCircuitOptChannel(), (List)object2, (IPptListener)this.revListener)) {
                    this.revListener.fail();
                }
            } else {
                this.revListener.fail();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
    }

    private List<Pair<IIpAddr, Integer>> createPathList(OchncCircuitNode ochncCircuitNode, OchncCircuitNode ochncCircuitNode2) throws AbstractCmsNoSuchEntityException, NoSuchInterface, AbstractCmsIOException {
        List list;
        Object object2;
        ArrayList<Pair<IIpAddr, Integer>> arrayList = new ArrayList<Pair<IIpAddr, Integer>>();
        List list2 = ochncCircuitNode.getPathList();
        for (Object object2 : list2) {
            IOchncPathDefModel iOchncPathDefModel = (IOchncPathDefModel)object2;
            list = (IPortModel)ochncCircuitNode.getNodeModel().getEntityTable().getEntityModelByIndex(iOchncPathDefModel.getPortEntityIdx());
            IOpticsModel iOpticsModel = (IOpticsModel)list.getInterfaceModel();
            if (!iOpticsModel.isPortTypeRX()) continue;
            arrayList.add((Pair<IIpAddr, Integer>)new Pair((Object)ochncCircuitNode.getNodeModel().getIpConfig().getIpAddress(), (Object)iOchncPathDefModel.getPortEntityIdx()));
            break;
        }
        Object object3 = ochncCircuitNode;
        object2 = null;
        boolean bl = false;
        block1: do {
            list = ((NetCircuitNode)object3).getAllSpansList();
            bl = false;
            for (Object e : list) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)e;
                INetLink iNetLink = netCircuitSpan.getLink();
                if (iNetLink instanceof InternalNetLink || !iNetLink.getSrc().equals(((NetCircuitNode)object3).getNetElement()) || object2 != null && iNetLink.getDst().equals(((NetCircuitNode)object2).getNetElement())) continue;
                List list3 = this.ckt.getCircuitNodeFromNE(iNetLink.getDst());
                for (Object e2 : list3) {
                    if (!(e2 instanceof OchncCircuitNode)) continue;
                    object2 = object3;
                    object3 = (OchncCircuitNode)e2;
                    IIpAddr iIpAddr = ((NetCircuitNode)object3).getNodeModel().getIpConfig().getIpAddress();
                    int n = iNetLink.getDstEntityIndex();
                    arrayList.add((Pair<IIpAddr, Integer>)new Pair((Object)iIpAddr, (Object)n));
                    bl = true;
                    break;
                }
                if (!bl) continue;
                continue block1;
            }
        } while (!object3.equals(ochncCircuitNode2) && bl);
        return arrayList;
    }

    private class PptListener
    implements IPptListener {
        private List<IPptData> result = null;
        private boolean complete = false;
        private Object innerLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isComplete() {
            Object object = this.innerLock;
            synchronized (object) {
                return this.complete;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.innerLock;
            synchronized (object) {
                this.complete = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fail() {
            Object object = this.innerLock;
            synchronized (object) {
                this.complete = true;
            }
            CircuitPpt.this.notifyIfComplete();
        }

        public List<IPptData> getResult() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPptResult(List<IPptData> list) {
            this.result = list;
            Object object = this.innerLock;
            synchronized (object) {
                this.complete = true;
            }
            CircuitPpt.this.notifyIfComplete();
        }
    }
}

