/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitRepairManager;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.Feature;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NodeSelector;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.WizardPane;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MacAddrDocument;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Observer;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;

public class CircuitRepairDialog
extends WizardDialog
implements ProgressDialogControl {
    static final String TITLE = "Circuit Repair";
    static final String PREAMBLE = "Background";
    static final String GATHER = "Node MAC Addresses";
    static final String PROCESS = "Repair Circuits";
    private GatherPane gatherPane;
    private NodeModel node;
    private long oldMacAddr;
    private long newMacAddr;
    private int oldNodeId;
    private int newNodeId;
    private static final SDebug db = new SDebug("CircuitRepairDialog");

    public CircuitRepairDialog(Frame frame) {
        super(frame, TITLE, false);
        this.reset(true);
        this.createPages();
        this.setLocationRelativeTo(frame);
    }

    private void createPages() {
        this.addPage(new PreamblePane());
        this.gatherPane = new GatherPane();
        this.addPage(this.gatherPane);
        this.addPage(new ProcessPane());
    }

    private void reset(boolean bl) {
        this.setSize(new Dimension(550, 350));
        this.invalidate();
        this.setFinishEnabled(false);
    }

    @Override
    public void apply() throws Exception {
        if (CircuitRepairManager.instance().allCktsRepairable(this.oldNodeId, this.newNodeId) || CerentDialog.yesNoDialog((Component)this, (String)"Note that circuits with Multi-card Ethernet Switch Group endpoints\nwill not be repaired; they must be deleted and re-created in order\nto become active. This is due to the presence of older network\nelements with circuits in the network.\n\nWould you like to proceed with circuit repair?", (String)"Confirmation Dialog")) {
            ProgressDialog.start(this, TITLE, "Circuits are being repaired.  Please wait...", this, 2000, 20, false);
        }
    }

    @Override
    public void handleCancel() {
        this.reset();
    }

    @Override
    public void handleFinish() {
        this.reset();
        super.handleFinish();
    }

    @Override
    public void reset() {
        this.showPage(PREAMBLE, false);
        if (this.gatherPane != null) {
            this.gatherPane.reset();
        }
    }

    public void setNode(NodeModel nodeModel) {
        this.node = nodeModel;
    }

    public void setOldMacAddr(long l) {
        this.oldMacAddr = l;
        this.oldNodeId = (int)l;
    }

    public void setNewMacAddr(long l) {
        this.newMacAddr = l;
        this.newNodeId = (int)l;
    }

    public void executeTask(Observer observer) throws Exception {
        observer.update(null, "Circuits are being repaired.  Please wait...");
        CircuitRepairManager.instance().repairCircuits(this.oldNodeId, this.newNodeId);
    }

    @Override
    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        String string = exception == null ? "Refer to CKT annunciator in the status bar for progress." : "Circuit repair failed:\n" + exception.getMessage();
        return new ProgressDialogResult(string);
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return false;
    }

    class GatherPane
    extends WizardPane
    implements ActionListener {
        private NodeSelector nodeCB;
        private JTextField oldMacTF;
        private JTextField newMacTF;

        GatherPane() {
            super(CircuitRepairDialog.GATHER, CircuitRepairDialog.this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 2, 5, 5));
            this.createNodePanel(jPanel, "Node");
            this.oldMacTF = this.createMacPanel(jPanel, "Old MAC Address", false);
            try {
                this.oldMacTF.getDocument().insertString(0, MacAddrDocument.INIT_STRING, null);
            }
            catch (BadLocationException badLocationException) {
                db;
                SDebug.printStackTrace((Throwable)badLocationException);
            }
            this.newMacTF = this.createMacPanel(jPanel, "New MAC Address", true);
            this.add(jPanel);
        }

        void reset() {
            this.nodeCB.setSelectedItem(null);
            this.oldMacTF.setText("");
            this.newMacTF.setText("");
        }

        private void createNodePanel(JPanel jPanel, String string) {
            jPanel.add(new JLabel(string + ": ", 4));
            this.nodeCB = new NodeSelector();
            jPanel.add((Component)((Object)this.nodeCB));
            this.nodeCB.setSelectedItem(null);
            this.nodeCB.addActionListener(this);
        }

        private JTextField createMacPanel(JPanel jPanel, String string, boolean bl) {
            JTextField jTextField = new JTextField();
            if (bl) {
                jTextField.setEditable(false);
            }
            MacAddrDocument macAddrDocument = new MacAddrDocument(jTextField);
            jTextField.setDocument(macAddrDocument);
            jPanel.add(new JLabel(string + ": ", 4));
            jPanel.add(jTextField);
            return jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CircuitRepairDialog.this.setNode((NodeModel)this.nodeCB.getSelectedItem());
            if (CircuitRepairDialog.this.node != null) {
                IEtherMacAddr iEtherMacAddr = CircuitRepairDialog.this.node.provides(Feature.TCC2P_SECURITY_MODE) && CircuitRepairDialog.this.node.isSecureMode() ? CircuitRepairDialog.this.node.getSecureEtherMACAddress() : CircuitRepairDialog.this.node.getNodeEtherMACAddress();
                try {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(MacAddrDocument.MAC_STRING, MacAddrDocument.NEW_STRING);
                    this.newMacTF.getDocument().insertString(0, MacAddrFormat.format(iEtherMacAddr.getAddr()), simpleAttributeSet);
                }
                catch (BadLocationException badLocationException) {
                    db;
                    SDebug.printStackTrace((Throwable)badLocationException);
                }
            }
        }

        @Override
        public void validatePage() throws Exception {
            if (CircuitRepairDialog.this.node == null) {
                throw new Exception("No node was selected.");
            }
            try {
                CircuitRepairDialog.this.setOldMacAddr(MacAddrFormat.parseMacAddr(this.oldMacTF.getText()));
            }
            catch (ParseException parseException) {
                if (db.on()) {
                    db.println("Unable to parse Old MAC Addr: " + parseException);
                    db;
                    SDebug.printStackTrace((Throwable)parseException);
                }
                throw new Exception("The old MAC address \"" + this.oldMacTF.getText() + "\" is invalid.");
            }
            if (CircuitRepairDialog.this.oldMacAddr == 0L) {
                throw new Exception("The old MAC address \"" + MacAddrFormat.formatMacAddr(CircuitRepairDialog.this.oldMacAddr) + "\" is invalid.");
            }
            NetElement netElement = (NetElement)Network.instance().findNetElem(CircuitRepairDialog.this.oldNodeId);
            if (netElement != null) {
                throw new Exception("The node with the old MAC address \"" + netElement.getNodeModel().getName() + "\" is still in the network.");
            }
            try {
                CircuitRepairDialog.this.setNewMacAddr(MacAddrFormat.parseMacAddr(this.newMacTF.getText()));
            }
            catch (ParseException parseException) {
                if (db.on()) {
                    db.println("Unable to parse New MAC Addr: " + parseException);
                    db;
                    SDebug.printStackTrace((Throwable)parseException);
                }
                CircuitRepairDialog.this.setNewMacAddr(0L);
            }
            long l = CircuitRepairDialog.this.node.provides(Feature.TCC2P_SECURITY_MODE) && CircuitRepairDialog.this.node.isSecureMode() ? MacAddrFormat.toLong(CircuitRepairDialog.this.node.getSecureEtherMACAddress().getAddr()) : MacAddrFormat.toLong(CircuitRepairDialog.this.node.getNodeEtherMACAddress().getAddr());
            if (CircuitRepairDialog.this.newMacAddr == 0L || l != CircuitRepairDialog.this.newMacAddr) {
                throw new Exception("The new MAC address \"" + MacAddrFormat.formatMacAddr(CircuitRepairDialog.this.newMacAddr) + "\" does not match the node's MAC address \"" + MacAddrFormat.formatMacAddr(l) + "\".");
            }
        }

        @Override
        public void refresh() {
        }
    }

    class PreamblePane
    extends WizardPane {
        private final String preamble = "<html><body><p>The Circuit Repair wizard fixes circuits stuck in the <b>PARTIAL</b> state after a change occurs to the node MAC address.  This type of change usually occurs when hardware that stores the node's MAC address is replaced.</p><p>Before you continue, verify the following:<ol><li>You have the old MAC address for the node.</li><li>The hardware replacement is complete.</li><li>You restarted CTC and circuits remain in the PARTIAL state.</li></ol></p><p>Refer to your user documentation for circuit repair procedures and information.</p></body></html>";

        PreamblePane() {
            super(CircuitRepairDialog.PREAMBLE, CircuitRepairDialog.this);
            this.preamble = "<html><body><p>The Circuit Repair wizard fixes circuits stuck in the <b>PARTIAL</b> state after a change occurs to the node MAC address.  This type of change usually occurs when hardware that stores the node's MAC address is replaced.</p><p>Before you continue, verify the following:<ol><li>You have the old MAC address for the node.</li><li>The hardware replacement is complete.</li><li>You restarted CTC and circuits remain in the PARTIAL state.</li></ol></p><p>Refer to your user documentation for circuit repair procedures and information.</p></body></html>";
            this.setLayout(new BorderLayout(5, 5));
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body><p>The Circuit Repair wizard fixes circuits stuck in the <b>PARTIAL</b> state after a change occurs to the node MAC address.  This type of change usually occurs when hardware that stores the node's MAC address is replaced.</p><p>Before you continue, verify the following:<ol><li>You have the old MAC address for the node.</li><li>The hardware replacement is complete.</li><li>You restarted CTC and circuits remain in the PARTIAL state.</li></ol></p><p>Refer to your user documentation for circuit repair procedures and information.</p></body></html>");
            jEditorPane.setEditable(false);
            this.add((Component)new UScrollPane((Component)jEditorPane), "Center");
        }

        @Override
        public void validatePage() throws Exception {
        }

        @Override
        public void refresh() {
        }
    }

    class ProcessPane
    extends WizardPane {
        JTextArea confirmText;

        ProcessPane() {
            super(CircuitRepairDialog.PROCESS, CircuitRepairDialog.this);
            this.setLayout(new BorderLayout(5, 5));
            this.confirmText = new JTextArea("");
            this.add(this.confirmText, "Center");
        }

        @Override
        public void validatePage() throws Exception {
        }

        @Override
        public void refresh() {
            String string = "CTC is ready to repair circuits due to the change of " + CircuitRepairDialog.this.node.getName() + "'s MAC address\n" + "from " + MacAddrFormat.formatMacAddr(CircuitRepairDialog.this.oldMacAddr) + " to " + MacAddrFormat.formatMacAddr(CircuitRepairDialog.this.newMacAddr) + ".\n" + "\nOnce the repair is complete, you will be able to find any remaining partial" + "\ncircuits in the circuit table if you sort it by circuit state.";
            this.confirmText.setText(string);
        }

        @Override
        public void leavingPage() throws Exception {
            CircuitRepairDialog.this.setFinishEnabled(false);
        }

        @Override
        public void enteringPage() {
            CircuitRepairDialog.this.setNextEnabled(false);
            CircuitRepairDialog.this.setFinishEnabled(true);
        }
    }
}

