/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IModel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.circuits.CircuitsTabbedView;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import com.cisco.ctc.CtcApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CircuitsDisabledPane
extends CircuitsPane {
    private JButton enablePB;
    private TabbedView parentView;
    private static final SDebug db = new SDebug("CircuitsDisabledPane");

    public CircuitsDisabledPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.parentView = tabbedView;
        if (db.on()) {
            db.println("ParentView: " + this.parentView);
        }
        this.enablePB = new JButton("Enable Circuit Management");
        this.enablePB.addActionListener(this);
        this.enablePB.setToolTipText("Circuit Management is not enabled.");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(this.enablePB);
        this.setLayout(new BorderLayout());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.CircuitsDisabledPane);
        this.add(jPanel, "North");
        this.add(cSHelpButtonPane, "South");
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void enteringPage() {
    }

    @Override
    public void refresh() {
    }

    @Override
    protected void removeActionListeners() {
        this.enablePB.removeActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.enablePB) {
            this.removeActionListeners();
            CircuitsTabbedView circuitsTabbedView = (CircuitsTabbedView)this.parentView.getCurrentPane();
            try {
                if (db.on()) {
                    db.println("Current pane : " + (Object)((Object)circuitsTabbedView));
                }
                CtcApplication.instance().setCktMgtMode(true);
                circuitsTabbedView.setShowing(false);
                circuitsTabbedView.enteringPage();
                circuitsTabbedView.setShowing(true);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Exception " + exception + " entering pane " + (Object)((Object)circuitsTabbedView));
                }
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NAV_ENTER_PAGE_ERROR_PARAM_1, (Object)((Object)circuitsTabbedView));
            }
        }
    }
}

