/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.circuits.AbstractProtectedCircuitMapNode;
import cerent.cms.ui.circuits.OchncProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;

public class OchncProtectedCircuitMapNode
extends AbstractProtectedCircuitMapNode {
    private MapPort unprotectedPgPort;

    public OchncProtectedCircuitMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    @Override
    protected CircuitMapPort doCreateCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, INetCircuitEnd iNetCircuitEnd) {
        Object object = this.getUserObject();
        if (object != null && object instanceof INodeModel) {
            INodeModel iNodeModel = (INodeModel)object;
            int n = ((CircuitMapNode)detailedMapNode).getNetCircuit().getCircuitOptChannel();
            if (iNetCircuitEnd != null && OchncHelper.isSplitterPGLinePort(iNodeModel, iNetCircuitEnd.getEntityIndex(), n)) {
                return new OchncProtectedCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd.getEntityIndex(), n);
            }
        }
        return super.doCreateCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd);
    }

    @Override
    public int getEntityIndex(MapPort mapPort) {
        if (mapPort instanceof OchncProtectedCircuitMapPort) {
            return ((OchncProtectedCircuitMapPort)mapPort).getOtsPgIndex();
        }
        return super.getEntityIndex(mapPort);
    }

    @Override
    protected IEntityModel[] getPgPorts(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        return OchncHelper.getSplitterPGLinePorts(iNodeModel, n);
    }

    @Override
    protected MapPort getUnprotectedPgPort() {
        if (this.unprotectedPgPort == null) {
            MapPort[] mapPortArray = this.getPorts(true);
            INodeModel iNodeModel = (INodeModel)this.getUserObject();
            for (int i = 0; i < mapPortArray.length; ++i) {
                int n;
                MapPort mapPort = mapPortArray[i];
                if (mapPort instanceof OchncProtectedCircuitMapPort || !OchncHelper.isSplitterPGUnprotectedPort(iNodeModel, n = this.getEntityIndex(mapPort))) continue;
                this.unprotectedPgPort = mapPort;
                break;
            }
        }
        return this.unprotectedPgPort;
    }

    @Override
    protected int getUnprotectedSelectorSide() {
        MapPort mapPort = this.getUnprotectedPgPort();
        int n = 0;
        if (mapPort != null) {
            int n2 = mapPort.getSide();
            n = n2 == 2 ? 2 : (n2 == 1 ? 3 : (n2 == -2 ? 1 : 4));
        }
        return n;
    }
}

