/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.circuits.OchncSpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class OchncSpanColumnRenderer
extends AbstractColumnRenderer {
    public static final int TYPE = 1;
    public static final int NAME = 2;
    public static final int SIZE = 3;
    public static final int DIR = 4;
    public static final int OCH = 5;
    static final int PER_SPAN = 0;
    int[][] columns = null;
    private JLabel label;
    private int mode;
    private static int EBW = 2;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
    private static final SDebug db = new SDebug("OchncSpanColumnRenderer");
    private static final int[] OchncColumns = new int[]{1, 3, 5, 4, 2};

    protected OchncSpanColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
    }

    protected TDMTerminology getTerminology(INetCircuit iNetCircuit) {
        TDMTerminology tDMTerminology = null;
        INodeModel iNodeModel = null;
        if (iNetCircuit.getPrimarySource() != null) {
            iNodeModel = iNetCircuit.getPrimarySource().getNodeModel();
        } else {
            List list = iNetCircuit.getCircuitNodes();
            if (list.size() != 0) {
                iNodeModel = ((INetCircuitNode)list.get(0)).getNodeModel();
            }
        }
        if (iNodeModel != null) {
            tDMTerminology = iNodeModel.getTDMTerminology();
        }
        return tDMTerminology;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        OchncSpanRow ochncSpanRow = (OchncSpanRow)object;
        INetCircuit iNetCircuit = ochncSpanRow.getCircuit();
        TDMTerminology tDMTerminology = this.getTerminology(iNetCircuit);
        JLabel jLabel = this.label;
        this.label.setText("");
        if (ochncSpanRow == null) {
            return jLabel;
        }
        Color color = jTable.getForeground();
        Color color2 = jTable.getBackground();
        switch (this.mode) {
            case 1: {
                if (ochncSpanRow.getCircuit() != null) {
                    if (tDMTerminology != null) {
                        this.label.setText(tDMTerminology.getCircuitTypeShortString(iNetCircuit.getCircuitTypeObj()));
                    } else {
                        this.label.setText("");
                    }
                    if (ochncSpanRow.getSpan() == null) break;
                    if (ochncSpanRow.getSpan().active()) {
                        color2 = CircuitColumnRenderer.ACTIVE_BG;
                        color = CircuitColumnRenderer.ACTIVE_FG;
                        break;
                    }
                    color2 = CircuitColumnRenderer.STANDBY_BG;
                    color = CircuitColumnRenderer.STANDBY_FG;
                    break;
                }
                this.label.setText("--unused--");
                break;
            }
            case 3: {
                String string = null;
                try {
                    string = !iNetCircuit.getCircuitTypeObj().isOchccCircuitType() ? iNetCircuit.getCircuitSizeObj().getCircuitSizeString() : OchTrailHelper.getCircuitSizeString((OchccCircuit)iNetCircuit);
                }
                catch (Throwable throwable) {
                    string = "Unknown size " + iNetCircuit.getCircuitSize();
                }
                this.label.setText(string);
                break;
            }
            case 2: {
                if (ochncSpanRow.getCircuit() != null) {
                    this.label.setText(ochncSpanRow.getCircuit().getCircuitName());
                    break;
                }
                this.label.setText("--unused--");
                break;
            }
            case 4: {
                if (ochncSpanRow.getCircuit() == null) break;
                this.label.setText(NetworkDefaults.circuitDirectionToString(ochncSpanRow.getCircuit().getCircuitDir()));
                break;
            }
            case 5: {
                if (ochncSpanRow.getCircuit() == null) break;
                this.label.setText(Wavelength.getWavelengthStringFromWavelength(ochncSpanRow.getCircuit().getCircuitOptChannel()));
            }
        }
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    static ColumnRenderer[] createTableRenderers(int n) {
        if (n < 0 || n >= OchncColumns.length) {
            return null;
        }
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[OchncColumns.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = OchncSpanColumnRenderer.createSpanColumnRenderer(OchncColumns[i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createSpanColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 1: {
                string = "Type";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Circuit";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Size";
                n3 = 80;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Dir";
                n3 = 80;
                bl = true;
                n2 = 0;
                break;
            }
            case 5: {
                string = "OCHNC Wavelength";
                n3 = 130;
                bl = true;
                n2 = 0;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new OchncSpanColumnRenderer(n, string, n3, bl, n2);
    }
}

