/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.RollValidator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.cms.ui.circuits.RollDesignMap;
import cerent.cms.ui.circuits.RollFromSelectionDialog;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RollPointPane
extends WzPane {
    private RollValidator rollValidator = RollValidator.getInstance();
    JPanel topPanel;
    JPanel bottomPanel;
    JTextField bNrTF;
    RollCreationDialog parent;
    RollDesignMap circuitMap;
    INetCircuitEnd selectedPort;
    String title;

    public RollPointPane(RollCreationDialog rollCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(rollCreationDialog, wzDiagDebug, string);
        this.parent = rollCreationDialog;
        this.title = string;
    }

    @Override
    protected void initPane() {
        this.setLayout(new BorderLayout());
        if (this.circuitMap == null) {
            this.circuitMap = new RollDesignMap();
            this.circuitMap.getGraphWindow().setBorder(BorderFactory.createLoweredBevelBorder());
            this.circuitMap.init(this);
        }
        JComponent jComponent = this.circuitMap.getGraphWindow();
        jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
        this.topPanel = RollPointPane.createHorizontalPanel(null);
        this.add((Component)this.topPanel, "Center");
        this.topPanel.add(jComponent);
        this.bottomPanel = RollPointPane.createHorizontalPanel(null);
        this.add((Component)this.bottomPanel, "South");
        this.bNrTF = new JTextField();
        this.bNrTF.setEditable(false);
        this.bottomPanel.add(this.bNrTF);
    }

    @Override
    public void validatePage() throws Exception {
        if (this.selectedPort == null) {
            throw new Exception("Pivot/Fixed Point is not selected.");
        }
        if (this == this.parent.bNr1Pane && this.parent.bNr1 != this.selectedPort) {
            this.parent.bNr1 = null;
            this.parent.bNr2 = null;
            this.parent.rollFrom1 = null;
            this.parent.rollFrom2 = null;
            this.parent.rollTo1 = null;
            this.parent.rollTo2 = null;
            this.parent.bNr2Pane.reset();
            this.parent.endpointPane.reset();
        } else if (this == this.parent.bNr2Pane && this.parent.bNr2 != this.selectedPort) {
            this.parent.bNr2 = null;
            this.parent.rollFrom2 = null;
            this.parent.rollTo2 = null;
        } else {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        INetCircuitEnd iNetCircuitEnd = null;
        INetCircuitEnd iNetCircuitEnd2 = null;
        if (this.parent.rollType.equals("Single")) {
            List list = this.rollValidator.getRollFromPathList(RollValidator.SINGLE_ROLL, this.selectedPort, this.parent.rollFromCkt, stringBuffer);
            if (stringBuffer.length() > 0) {
                throw new Exception(stringBuffer.toString());
            }
            iNetCircuitEnd = this.getRollFromCktEnd(list, stringBuffer);
            if (stringBuffer.length() > 0) {
                throw new Exception(stringBuffer.toString());
            }
            iNetCircuitEnd2 = this.rollValidator.validateSingleRollBNR(this.parent.guiRollMode, this.parent.rollFromCkt, this.parent.rollToCkt, this.selectedPort, iNetCircuitEnd, stringBuffer);
            if (stringBuffer.length() != 0) {
                throw new Exception(stringBuffer.toString());
            }
            this.parent.bNr1 = this.selectedPort;
            this.parent.rollFrom1 = iNetCircuitEnd;
            this.parent.rollTo1 = iNetCircuitEnd2;
            if (this.parent.rollToCkt != null) {
                this.rollValidator.checkRollToOnLink(this.parent.rollFromCkt, this.parent.rollToCkt, this.parent.rollTo1, stringBuffer);
                if (stringBuffer.length() != 0) {
                    throw new Exception(stringBuffer.toString());
                }
            }
        } else if (this.parent.rollType.equals("Dual")) {
            if (this == this.parent.bNr1Pane) {
                List list = this.rollValidator.getRollFromPathList(RollValidator.DUAL_ROLL_1, this.selectedPort, this.parent.rollFromCkt, stringBuffer);
                if (stringBuffer.toString().length() > 0) {
                    throw new Exception(stringBuffer.toString());
                }
                iNetCircuitEnd = this.getRollFromCktEnd(list, stringBuffer);
                if (stringBuffer.toString().length() > 0) {
                    throw new Exception(stringBuffer.toString());
                }
                iNetCircuitEnd2 = this.rollValidator.validateDualRollBNR1(this.parent.rollFromCkt, this.parent.rollToCkt, this.selectedPort, iNetCircuitEnd, stringBuffer);
                if (stringBuffer.length() > 0) {
                    throw new Exception(stringBuffer.toString());
                }
                this.parent.bNr1 = this.selectedPort;
                this.parent.rollFrom1 = iNetCircuitEnd;
                this.parent.rollTo1 = iNetCircuitEnd2;
            } else if (this == this.parent.bNr2Pane) {
                List list = this.rollValidator.getRollFromPathList(RollValidator.DUAL_ROLL_2, this.selectedPort, this.parent.rollFromCkt, stringBuffer);
                if (stringBuffer.length() > 0) {
                    throw new Exception(stringBuffer.toString());
                }
                iNetCircuitEnd = this.getRollFromCktEnd(list, stringBuffer);
                if (stringBuffer.length() > 0) {
                    throw new Exception(stringBuffer.toString());
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                iNetCircuitEnd2 = this.rollValidator.validateDualRollBNR2(this.parent.rollFromCkt, this.parent.rollToCkt, this.parent.bNr1, this.parent.rollFrom1, this.parent.rollTo1, this.parent.changedNodeList, this.parent.changedSpanList, this.selectedPort, iNetCircuitEnd, stringBuffer, stringBuffer2);
                if (stringBuffer.length() != 0) {
                    throw new Exception(stringBuffer.toString());
                }
                if (stringBuffer2.length() > 0) {
                    this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)stringBuffer2.toString(), (String)"Change protection?");
                    if (!this.isOkToPostValidate()) {
                        return;
                    }
                }
                this.parent.bNr2 = this.selectedPort;
                this.parent.rollFrom2 = iNetCircuitEnd;
                this.parent.rollTo2 = iNetCircuitEnd2;
                this.parent.oldRoute = this.parent.changedSpanList;
                this.parent.oldRouteProtType = ((NetCcatCircuit)this.parent.rollFromCkt).getProtType(this.parent.oldRoute, new LinkedList());
                this.parent.isOldRouteUPSR = ((NetCcatCircuit)this.parent.rollFromCkt).isOldRouteUPSR(this.parent.oldRoute);
            }
        }
    }

    private INetCircuitEnd getRollFromCktEnd(List list, StringBuffer stringBuffer) {
        INetCircuitEnd iNetCircuitEnd = null;
        try {
            if (list.size() == 1) {
                if (this == this.parent.bNr1Pane) {
                    iNetCircuitEnd = (INetCircuitEnd)list.get(0);
                } else {
                    INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)list.get(0);
                    LinkedList linkedList = new LinkedList();
                    LinkedList linkedList2 = new LinkedList();
                    ((NetCcatCircuit)this.parent.rollFromCkt).getNodeAndSpanListWithCktEnd(this.parent.rollFrom1, iNetCircuitEnd2, linkedList, linkedList2);
                    if (!linkedList.isEmpty() && !linkedList2.isEmpty()) {
                        this.parent.changedNodeList = new LinkedList();
                        this.parent.changedSpanList = new LinkedList();
                        this.parent.changedNodeList.addAll(linkedList);
                        this.parent.changedSpanList.addAll(linkedList2);
                        iNetCircuitEnd = iNetCircuitEnd2;
                    }
                }
            } else {
                if (this == this.parent.bNr1Pane) {
                    RollFromSelectionDialog rollFromSelectionDialog = new RollFromSelectionDialog(UiToolkit.instance().getApplicationFrame(), list);
                    rollFromSelectionDialog.show();
                    iNetCircuitEnd = rollFromSelectionDialog.getChoice();
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        INetCircuitEnd iNetCircuitEnd3 = (INetCircuitEnd)list.get(i);
                        LinkedList linkedList = new LinkedList();
                        LinkedList linkedList3 = new LinkedList();
                        ((NetCcatCircuit)this.parent.rollFromCkt).getNodeAndSpanListWithCktEnd(this.parent.rollFrom1, iNetCircuitEnd3, linkedList, linkedList3);
                        if (linkedList.isEmpty() || linkedList3.isEmpty()) continue;
                        this.parent.changedNodeList = new LinkedList();
                        this.parent.changedSpanList = new LinkedList();
                        this.parent.changedNodeList.addAll(linkedList);
                        this.parent.changedSpanList.addAll(linkedList3);
                        iNetCircuitEnd = iNetCircuitEnd3;
                        break;
                    }
                }
                if (iNetCircuitEnd != null) {
                    StringBuffer stringBuffer2 = new StringBuffer(this.bNrTF.getText());
                    stringBuffer2.append("(");
                    stringBuffer2.append(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
                    stringBuffer2.append(")");
                    this.bNrTF.setText(stringBuffer2.toString());
                }
            }
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
        }
        if (iNetCircuitEnd == null) {
            if (this == this.parent.bNr2Pane && !((NetCcatCircuit)this.parent.rollFromCkt).isBidirectional() && ((NetCcatCircuit)this.parent.rollFromCkt).getDrops().size() > 1 && ((NetCcatCircuit)this.parent.rollFromCkt).isUpsrCircuit()) {
                stringBuffer.append("Drops were found between two pivot/fixed points. \nPlease delete these drops before rolling.");
            } else {
                stringBuffer.append("The roll-from path cannot be determined based on the selected pivot/fixed point.");
            }
            return null;
        }
        return iNetCircuitEnd;
    }

    @Override
    public void revalidateData() {
        INetCircuit iNetCircuit = null;
        iNetCircuit = this.parent.rollFromCkt;
        this.circuitMap.traceDetailedCircuit(iNetCircuit, true, false);
        this.bottomPanel.setBorder(BorderFactory.createTitledBorder("Select " + this.title + " from Circuit " + iNetCircuit.getCircuitName()));
        if (this.parent.rollType.equals("Single") && this == this.parent.bNr1Pane && this.parent.rollToCkt != null || this.parent.rollType.equals("Dual") && this == this.parent.bNr2Pane && this.parent.rollToCkt != null) {
            this.parent.setNextEnabled(false);
            this.parent.setFinishEnabled(true);
        }
    }

    public void reset() {
        if (!this.isInited()) {
            return;
        }
        this.bNrTF.setText("");
        this.selectedPort = null;
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = " ";
        if (this == this.parent.bNr1Pane) {
            string = "Pivot/Fixed 1:";
        } else if (this == this.parent.bNr2Pane) {
            string = "Pivot/Fixed 2:";
        }
        arrayList.add(new String[]{string, this.bNrTF.getText()});
        return RollPointPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this == this.parent.bNr1Pane) {
            stringBuffer.append("\nPivot/Fixed 1: ");
        } else if (this == this.parent.bNr2Pane) {
            stringBuffer.append("\nPivot/Fixed 2: ");
        }
        stringBuffer.append(this.bNrTF.getText());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (mapNode == null) {
            return;
        }
        if (mapNode.isDomain()) {
            mapNode.setSelected(false);
            return;
        }
    }

    public void clicked(MapPort mapPort) {
        INetCircuitEnd iNetCircuitEnd = ((CircuitMapPort)mapPort).getCircuitEnd();
        this.selectedPort = CircuitMapUtil.getCircuitEnd(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
        this.selectedPort.setPathIdentifier(iNetCircuitEnd.getPathIdentifier());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.selectedPort.getNodeModel().getName());
        stringBuffer.append("/");
        stringBuffer.append(CircuitEndCellRenderer.asSlashSeparatedString(this.selectedPort));
        stringBuffer.append(" ");
        this.bNrTF.setText(stringBuffer.toString());
    }

    protected boolean inRollPoint1() {
        return this.getName().equals("Pivot/Fixed Point 1");
    }

    @Override
    protected String getNextPaneName() {
        if (this.inRollPoint1()) {
            this.parent.setCircuit(null);
            if (this.parent.rollToCkt == null && this.parent.rollType.equals("Single")) {
                this.parent.maybeInitEndpointPane();
                return "Select New Endpoint";
            }
            return "Pivot/Fixed Point 2";
        }
        if (this.parent.rollToCkt == null) {
            this.parent.setCircuit(this.parent.rollFromCkt);
        }
        return "Circuit Routing Preferences";
    }

    @Override
    public CSHelpID getHelpID() {
        if (this.inRollPoint1()) {
            return NetCSHelpConst.RollPointPane1;
        }
        return NetCSHelpConst.RollPointPane2;
    }

    @Override
    public void dispose() {
        if (this.circuitMap != null) {
            this.circuitMap.dispose();
            this.circuitMap = null;
        }
        this.parent = null;
        this.selectedPort = null;
        super.dispose();
    }
}

