/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.LinkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SrgViolation;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdReviewEditPane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc.util.map.MapNode;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

public class RollReviewEditPane
extends CcdReviewEditPane {
    public RollReviewEditPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.circuitMap != null) {
            this.circuitMap.clearNodeMarkers();
            this.circuitMap.addGenericMarker(this.srcNodeModel, "Pivot/Fixed Point1", this.circuitMap.getPoint(((RollCreationDialog)this.parent).bNr1));
            this.circuitMap.addGenericMarker(this.dstNodeModel, "Pivot/Fixed Point2", this.circuitMap.getPoint(((RollCreationDialog)this.parent).bNr2));
            this.circuitMap.updateView();
        }
    }

    @Override
    protected void initialization() {
        if (!((RollCreationDialog)this.parent).isAutoRoute()) {
            this.mapExistingSpans(new LinkedList());
        } else {
            this.mapExistingSpans(((RollCreationDialog)this.parent).newRoute);
        }
    }

    @Override
    public void validatePage() throws Exception {
        ((RollCreationDialog)this.parent).newRoute = new LinkedList();
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).ckt;
        for (int i = 0; i < this.olm.getContent().size(); ++i) {
            if (!(this.olm.getContent().get(i) instanceof NetLinkSpan)) continue;
            NetLinkSpan netLinkSpan = (NetLinkSpan)this.olm.getContent().get(i);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, null, null);
            if (((RollCreationDialog)this.parent).isOldRouteUPSR && netCircuitSpan.getLink().getProtectionType() == 3) {
                netCircuitSpan.setUpsrLink(true);
            }
            ((RollCreationDialog)this.parent).newRoute.add(netCircuitSpan);
        }
        if (((RollCreationDialog)this.parent).checkNewRouteForUPSR()) {
            throw new Exception("A(n) " + CircuitMapUtil.UPSR_TERM + " ring was detected between pivot/fixed point 1 and pivot/fixed point 2.");
        }
        super.validatePage();
        if (this.isOkToPostValidate()) {
            ((RollCreationDialog)this.parent).getNewCircuitInfo();
        }
    }

    @Override
    protected void performSanityChecks() throws SanityCheckException {
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).ckt;
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        netCcatCircuit.getNewSpanAndNodeList(((RollCreationDialog)this.parent).newRoute, ((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2);
        String string = "performSanityChecks(): ";
        if (this.db.on()) {
            this.db.println(string + "checking SRGs");
        }
        try {
            LinkedList linkedList3 = netCcatCircuit.sanityCheckBridgeRollSRGs(linkedList);
            if (linkedList3 != null && linkedList3.size() > 0) {
                if (this.db.on()) {
                    this.db.println(string + " SRG list is size " + linkedList3.size());
                }
                String string2 = linkedList3.size() == 1 ? "violation" : "violations";
                String string3 = linkedList3.size() == 1 ? "Violation" : "Violations";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getThisRouteString() + "the following Shared Risk" + " Group " + string2 + ":\n\n");
                for (int i = 0; i < linkedList3.size(); ++i) {
                    if (linkedList3.size() > 1) {
                        stringBuffer.append("Violation #" + (i + 1) + ": ");
                    }
                    SrgViolation srgViolation = (SrgViolation)linkedList3.get(i);
                    stringBuffer.append(this.makeFriendlyViolation(srgViolation) + "\n\n");
                }
                stringBuffer.append("Is it OK to continue the circuit creation?");
                this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)stringBuffer.toString(), (String)("Shared Risk Group " + string3));
                if (!this.isOkToPostValidate()) {
                    return;
                }
            }
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            WzDiagDebug.printStackTrace((Throwable)sanityCheckFailed);
            throw new SanityCheckException("A failure occurred during the shared risk group check.", "spans are", sanityCheckFailed);
        }
        if (this.db.on()) {
            this.db.println(string + "checking manual routing");
        }
        ((RollCreationDialog)this.parent).addBlsrDriRoutePrefs();
        try {
            netCcatCircuit.sanityCheckBridgeRollRouting(((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2, this.getAbstractCktDlg().getRoutePrefs());
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw new SanityCheckException("", "spans are", sanityCheckFailed);
        }
        ((RollCreationDialog)this.parent).savePostRollCktSpansAndNodes(linkedList, linkedList2);
        if (this.newRoutesGoingThroughUnchangedNodes()) {
            throw new SanityCheckException("", "spans are", new SanityCheckFailed("The span selections are invalid."));
        }
        if (this.db.on()) {
            this.db.println("all sanity checks succeeded.");
        }
    }

    private boolean newRoutesGoingThroughUnchangedNodes() {
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).ckt;
        List list = netCcatCircuit.getCircuitNodes();
        list.removeAll(((RollCreationDialog)this.parent).changedNodeList);
        for (NetCircuitSpan netCircuitSpan : ((RollCreationDialog)this.parent).newRoute) {
            INetCircuitNode iNetCircuitNode = netCircuitSpan.getSrcNCN();
            INetCircuitNode iNetCircuitNode2 = netCircuitSpan.getDstNCN();
            if (!list.contains(iNetCircuitNode) && !list.contains(iNetCircuitNode2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isNodeSelectable(MapNode mapNode) {
        NodeModel nodeModel = (NodeModel)mapNode.getUserObject();
        if (nodeModel == this.srcNodeModel) {
            return true;
        }
        if (this.olm.getContent() != null) {
            NetLinkSpan netLinkSpan = null;
            for (int i = 0; i < this.olm.getContent().size(); ++i) {
                LinkModel linkModel;
                if (!(this.olm.getContent().get(i) instanceof NetLinkSpan) || (NodeModel)(linkModel = (LinkModel)this.getNetLink(netLinkSpan = (NetLinkSpan)this.olm.getContent().get(i)).getLinkModel()).src() != nodeModel && (NodeModel)linkModel.dst() != nodeModel) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
    }

    @Override
    protected void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
    }

    @Override
    protected List getActiveCircuitSpans() {
        return new LinkedList();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollReviewEditPane;
    }
}

