/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.IHoSfSdSupport;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IL2scLineModel;
import cerent.cms.model.ILoSfSdSupport;
import cerent.cms.model.IML2PosLineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SfSdDialog
extends JDialog
implements ActionListener {
    private static final SDebug db = new SDebug("SfSdDialog");
    private static final String DEFAULT = "Default";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final String SF_BER = "SF BER:";
    private static final String SD_BER = "SD BER:";
    private static int SFBER_3 = 3;
    private static int SFBER_4 = 4;
    private static int SFBER_5 = 5;
    private static int SDBER_5 = 5;
    private static int SDBER_6 = 6;
    private static int SDBER_7 = 7;
    private static int SDBER_8 = 8;
    private static int SDBER_9 = 9;
    private JButton okButton;
    private JButton cancelButton;
    private JButton defaultButton;
    private Integer oldSfBer = new Integer(0);
    private Integer oldSdBer = new Integer(0);
    private IInterfaceModel ifModel = null;
    private JComboBox sfBox;
    private JComboBox sdBox;
    private TreeMap sfMap;
    private TreeMap sdMap;
    private boolean isHoCircuit;
    private int circuitSize;
    private boolean sfSdCleanup = false;

    public SfSdDialog(Frame frame, CircuitMapPort circuitMapPort) {
        super(frame, "", false);
        try {
            INetCircuit iNetCircuit = circuitMapPort.getCircuit();
            this.isHoCircuit = iNetCircuit.getCircuitTypeObj().isHoCircuitType();
            this.circuitSize = iNetCircuit.getCircuitSize();
            INetCircuitEnd iNetCircuitEnd = circuitMapPort.getCircuitEnd();
            this.ifModel = circuitMapPort.getIfModel();
            this.setTitle(this.ifModel.getNodeModel().getName() + ": " + circuitMapPort.getInfoString());
            this.sfSdCleanup = this.isSfSdCleanup(this.ifModel);
            this.initContentPane(this.circuitSize);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private boolean isSfSdCleanup(IInterfaceModel iInterfaceModel) {
        if (iInterfaceModel != null) {
            INodeModel iNodeModel = iInterfaceModel.getNodeModel();
            return iNodeModel.provides(Feature.SF_SD_CLEANUP);
        }
        return false;
    }

    public void initContentPane(int n) {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(new JLabel(SF_BER));
        this.sfBox = new JComboBox<Attribute>(this.getSfChoices(n));
        this.sfBox.addActionListener(this);
        jPanel.add(this.sfBox);
        jPanel.add(new JLabel(SD_BER));
        this.sdBox = new JComboBox<Attribute>(this.getSdChoices());
        this.sdBox.addActionListener(this);
        jPanel.add(this.sdBox);
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPane(), "South");
        this.refreshFromModel();
    }

    private JPanel getButtonPane() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.defaultButton = new JButton(DEFAULT);
        this.okButton = new JButton(OK);
        this.cancelButton = new JButton(CANCEL);
        this.defaultButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        jPanel.add(this.defaultButton);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.defaultButton) {
            this.setDefaults();
        } else if (object == this.okButton) {
            this.applyChangesToModel();
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public void applyChangesToModel() {
        block10: {
            Integer n;
            block9: {
                if (this.sfBox.getSelectedIndex() == -1 || this.sdBox.getSelectedIndex() == -1) {
                    return;
                }
                Integer n2 = ((Attribute)this.sfBox.getSelectedItem()).getValue();
                n = ((Attribute)this.sdBox.getSelectedItem()).getValue();
                if (n2 != this.oldSfBer) {
                    try {
                        this.setSfBerLevel(this.ifModel, this.sfSdCleanup, n2);
                        if (db.on()) {
                            db.println("SF BER changed from " + this.oldSfBer + " to " + n2);
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block9;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            if (n != this.oldSdBer) {
                try {
                    this.setSdBerLevel(this.ifModel, this.sfSdCleanup, n);
                    if (db.on()) {
                        db.println("SD BER changed from " + this.oldSdBer + " to " + n);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block10;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public void refreshFromModel() {
        block2: {
            try {
                this.oldSfBer = this.getSfBerLevel(this.ifModel, this.sfSdCleanup);
                this.oldSdBer = this.getSdBerLevel(this.ifModel, this.sfSdCleanup);
                this.sfBox.setSelectedItem(this.sfMap.get(this.oldSfBer));
                this.sdBox.setSelectedItem(this.sdMap.get(this.oldSdBer));
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private Integer getSfBerLevel(IInterfaceModel iInterfaceModel, boolean bl) throws NoSuchInterface, WrongInterfaceType {
        short s;
        short s2 = s = this.isHoCircuit ? (short)SFBER_4 : (short)SFBER_3;
        if (bl) {
            if (this.isHoCircuit && iInterfaceModel instanceof IHoSfSdSupport) {
                s = ((IHoSfSdSupport)iInterfaceModel).getHoSfSdModel().getSfBerLevel();
            } else if (!this.isHoCircuit && iInterfaceModel instanceof ILoSfSdSupport) {
                s = ((ILoSfSdSupport)iInterfaceModel).getLoSfSdModel().getSfBerLevel();
            } else if (db.on()) {
                db.println("getSfBerLevel() hits exception");
            }
        } else if (iInterfaceModel instanceof IL2scLineModel) {
            s = this.isHoCircuit ? ((IL2scLineModel)iInterfaceModel).getSfBerLevel() : ((IL2scLineModel)iInterfaceModel).getLoSfBerLevel();
        } else if (iInterfaceModel instanceof ITdmHoModel) {
            s = ((ITdmHoModel)iInterfaceModel).getSfBerLevel();
        } else if (iInterfaceModel instanceof ITdmLoModel) {
            s = ((ITdmLoModel)iInterfaceModel).getSfBerLevel();
        }
        return new Integer(s);
    }

    private void setSfBerLevel(IInterfaceModel iInterfaceModel, boolean bl, Integer n) throws NoSuchInterface, WrongInterfaceType {
        if (bl) {
            if (this.isHoCircuit && iInterfaceModel instanceof IHoSfSdSupport) {
                ((IHoSfSdSupport)iInterfaceModel).getHoSfSdModel().setSfBerLevel(n.shortValue());
            } else if (!this.isHoCircuit && iInterfaceModel instanceof ILoSfSdSupport) {
                ((ILoSfSdSupport)iInterfaceModel).getLoSfSdModel().setSfBerLevel(n.shortValue());
            } else if (db.on()) {
                db.println("setSfBerLevel() hits exception");
            }
        } else if (iInterfaceModel instanceof IL2scLineModel) {
            if (this.isHoCircuit) {
                ((IL2scLineModel)iInterfaceModel).setSfBerLevel(n.shortValue());
            } else {
                ((IL2scLineModel)iInterfaceModel).setLoSfBerLevel(n.shortValue());
            }
        } else if (iInterfaceModel instanceof ITdmHoModel) {
            ((ITdmHoModel)iInterfaceModel).setSfBerLevel(n.shortValue());
        } else if (iInterfaceModel instanceof ITdmLoModel) {
            ((ITdmLoModel)iInterfaceModel).setSfBerLevel(n.shortValue());
        }
    }

    private Integer getSdBerLevel(IInterfaceModel iInterfaceModel, boolean bl) throws NoSuchInterface, WrongInterfaceType {
        short s;
        short s2 = s = this.isHoCircuit ? (short)SDBER_7 : (short)SDBER_5;
        if (bl) {
            if (this.isHoCircuit && iInterfaceModel instanceof IHoSfSdSupport) {
                s = ((IHoSfSdSupport)iInterfaceModel).getHoSfSdModel().getSdBerLevel();
            } else if (!this.isHoCircuit && iInterfaceModel instanceof ILoSfSdSupport) {
                s = ((ILoSfSdSupport)iInterfaceModel).getLoSfSdModel().getSdBerLevel();
            } else if (db.on()) {
                db.println("getSdBerLevel() hits exception");
            }
        } else if (iInterfaceModel instanceof IL2scLineModel) {
            s = this.isHoCircuit ? ((IL2scLineModel)iInterfaceModel).getSdBerLevel() : ((IL2scLineModel)iInterfaceModel).getLoSdBerLevel();
        } else if (iInterfaceModel instanceof ITdmHoModel) {
            s = ((ITdmHoModel)iInterfaceModel).getSdBerLevel();
        } else if (iInterfaceModel instanceof ITdmLoModel) {
            s = ((ITdmLoModel)iInterfaceModel).getSdBerLevel();
        }
        return new Integer(s);
    }

    private void setSdBerLevel(IInterfaceModel iInterfaceModel, boolean bl, Integer n) throws NoSuchInterface, WrongInterfaceType {
        if (bl) {
            if (this.isHoCircuit && iInterfaceModel instanceof IHoSfSdSupport) {
                ((IHoSfSdSupport)iInterfaceModel).getHoSfSdModel().setSdBerLevel(n.shortValue());
            } else if (!this.isHoCircuit && iInterfaceModel instanceof ILoSfSdSupport) {
                ((ILoSfSdSupport)iInterfaceModel).getLoSfSdModel().setSdBerLevel(n.shortValue());
            } else if (db.on()) {
                db.println("setSdBerLevel() hits exception");
            }
        } else if (iInterfaceModel instanceof IL2scLineModel) {
            if (this.isHoCircuit) {
                ((IL2scLineModel)iInterfaceModel).setSdBerLevel(n.shortValue());
            } else {
                ((IL2scLineModel)iInterfaceModel).setLoSdBerLevel(n.shortValue());
            }
        } else if (iInterfaceModel instanceof ITdmHoModel) {
            ((ITdmHoModel)iInterfaceModel).setSdBerLevel(n.shortValue());
        } else if (iInterfaceModel instanceof ITdmLoModel) {
            ((ITdmLoModel)iInterfaceModel).setSdBerLevel(n.shortValue());
        }
    }

    private Attribute[] getSdChoices() {
        this.sdMap = SfSdBerLevel.getSdChoices();
        return this.sdMap.values().toArray(new Attribute[0]);
    }

    private Attribute[] getSfChoices(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 10: 
            case 11: {
                this.sfMap = SfSdBerLevel.getSfChoice1();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.sfMap = SfSdBerLevel.getSfChoice2();
                break;
            }
            case 8: 
            case 16: {
                this.sfMap = SfSdBerLevel.getSfChoice3();
                break;
            }
            default: {
                this.sfMap = SfSdBerLevel.getSfChoice3();
            }
        }
        return this.sfMap.values().toArray(new Attribute[0]);
    }

    public void setDefaults() {
        if (this.isHoCircuit) {
            if (this.ifModel instanceof IML2PosLineModel) {
                this.sfBox.setSelectedItem(this.sfMap.get(new Integer(SFBER_4)));
            } else if (this.sfBox.getItemCount() == 1) {
                this.sfBox.setSelectedItem(this.sfMap.get(new Integer(SFBER_5)));
            } else {
                this.sfBox.setSelectedItem(this.sfMap.get(new Integer(SFBER_4)));
            }
            this.sdBox.setSelectedItem(this.sdMap.get(new Integer(SDBER_7)));
        } else {
            this.sfBox.setSelectedItem(this.sfMap.get(new Integer(SFBER_3)));
            this.sdBox.setSelectedItem(this.sdMap.get(new Integer(SDBER_5)));
        }
    }

    static class SfSdBerLevel {
        SfSdBerLevel() {
        }

        public static TreeMap getSfChoice1() {
            TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
            treeMap.put(new Integer(SFBER_3), new Attribute("1E-3", new Integer(SFBER_3)));
            treeMap.put(new Integer(SFBER_4), new Attribute("1E-4", new Integer(SFBER_4)));
            treeMap.put(new Integer(SFBER_5), new Attribute("1E-5", new Integer(SFBER_5)));
            return treeMap;
        }

        public static TreeMap getSfChoice2() {
            TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
            treeMap.put(new Integer(SFBER_4), new Attribute("1E-4", new Integer(SFBER_4)));
            treeMap.put(new Integer(SFBER_5), new Attribute("1E-5", new Integer(SFBER_5)));
            return treeMap;
        }

        public static TreeMap getSfChoice3() {
            TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
            treeMap.put(new Integer(SFBER_5), new Attribute("1E-5", new Integer(SFBER_5)));
            return treeMap;
        }

        public static TreeMap getSdChoices() {
            TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
            treeMap.put(new Integer(SDBER_5), new Attribute("1E-5", new Integer(SDBER_5)));
            treeMap.put(new Integer(SDBER_6), new Attribute("1E-6", new Integer(SDBER_6)));
            treeMap.put(new Integer(SDBER_7), new Attribute("1E-7", new Integer(SDBER_7)));
            treeMap.put(new Integer(SDBER_8), new Attribute("1E-8", new Integer(SDBER_8)));
            treeMap.put(new Integer(SDBER_9), new Attribute("1E-9", new Integer(SDBER_9)));
            return treeMap;
        }
    }
}

