/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.circuits.AbstractCcdEndpointPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.AnnotatedException;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.HoLoIndustryMappedComparator;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.gui.LoListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class SonetCcdEndpointPanel
extends AbstractCcdEndpointPanel {
    private JComboBox stsCB;
    private JComboBox vtCB;
    private SortedMap vtMap;
    protected JLabel stsLB;
    protected JLabel vtLB;
    protected boolean hasDs1Endpoints = false;

    public SonetCcdEndpointPanel(String string, AbstractCircuitDialog abstractCircuitDialog, CcdEndpointsPane ccdEndpointsPane) {
        super(string, abstractCircuitDialog, ccdEndpointsPane);
    }

    @Override
    protected void addComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridheight = 1;
        this.stsLB = new JLabel("STS:", 4);
        this.stsCB = this.addCB(this.stsLB, "stsCB", gridBagConstraints);
        this.vtLB = new JLabel("VT:", 4);
        this.vtCB = this.addCB(this.vtLB, "vtCB", gridBagConstraints);
        this.vtCB.setRenderer(new VtListCellRenderer());
        this.hoParts.add(this.stsCB);
        this.hoParts.add(this.stsLB);
        this.loParts.add(this.vtCB);
        this.loParts.add(this.vtLB);
    }

    @Override
    protected List getLoParts() {
        if (this.loParts.size() == 0) {
            this.loParts.add(this.vtLB);
            this.loParts.add(this.vtCB);
        }
        return this.loParts;
    }

    @Override
    protected void setLoComponentsFromEndpoint() {
        this.setCBList(this.vtCB, this.loNum != null ? Collections.singleton(this.loNum) : null);
        this.vtCB.setSelectedItem(this.loNum);
    }

    @Override
    protected JComboBox getHoCB() {
        return this.stsCB;
    }

    @Override
    protected SortedMap createNewLoMap() {
        IEntityModel iEntityModel = this.getEntityModel();
        if (iEntityModel != null && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.DS1_E1_56) && iEntityModel instanceof IModuleModel && ((IModuleModel)iEntityModel).isIndustryMapped(this.hoNum)) {
            return new TreeMap(HoLoIndustryMappedComparator.instance());
        }
        return new TreeMap(HoLoComparator.instance());
    }

    @Override
    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
        INetCircuitEnd iNetCircuitEnd2 = sortedMap.put(iNetCircuitEnd.getLoNum(), iNetCircuitEnd);
        if (iNetCircuitEnd2 != null && db.on()) {
            db.println(this.title + " getDropPoints: multiple endpoints with " + "STS = " + iNetCircuitEnd.getHoNum() + ", VT = " + iNetCircuitEnd.getLoNum());
        }
    }

    @Override
    protected void selectLoComponentsFromEndpoint() {
        this.vtCB.setSelectedItem(this.loNum);
    }

    @Override
    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        if (sortedMap == null) {
            return false;
        }
        return sortedMap.containsKey(iLoNum);
    }

    @Override
    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        return (ILoNum)sortedMap.firstKey();
    }

    @Override
    protected boolean useDs1EndpointAsPort(IModuleModel iModuleModel) {
        if (super.useDs1EndpointAsPort(iModuleModel)) {
            return true;
        }
        int n = this.getCircuitInfoSize();
        return n == 0 && iModuleModel != null && iModuleModel.getEqType() == 218;
    }

    @Override
    protected void localRefresh(ICircuitType iCircuitType, int n) {
        this.localRefresh(iCircuitType, n, false);
    }

    protected void localRefresh(ICircuitType iCircuitType, int n, boolean bl) {
        if (bl && iCircuitType.isVcatCircuitType()) {
            if (this.memberList.getModel().getSize() <= 0) {
                this.retrieveMemberListData();
            }
            this.holoRowPanel.setVisible(true);
            this.stsLB.setVisible(false);
            this.stsCB.setVisible(false);
            this.vtLB.setVisible(false);
            this.vtCB.setVisible(false);
        } else {
            if (!iCircuitType.isLoCircuitType() && !iCircuitType.isLoVcatCircuitType()) {
                this.endpoint.setLoNum(null);
                this.loNum = null;
                this.vtLB.setVisible(false);
                this.vtCB.setVisible(false);
            } else {
                this.vtLB.setVisible(true);
                this.vtCB.setVisible(true);
            }
            this.stsLB.setVisible(true);
            this.stsCB.setVisible(true);
            if (this.holoRowPanel != null) {
                this.holoRowPanel.setVisible(false);
            }
        }
    }

    private boolean hasDs1Endpoints(String string, SortablePortString sortablePortString) {
        this.hasDs1Endpoints = string.indexOf("DS1") >= 0 && string.indexOf("EC1") >= 0 ? (sortablePortString != null ? sortablePortString.toSortableString().indexOf("DS1") >= 0 : false) : (string.indexOf("DS1") >= 0 || string.indexOf("DS3XM") >= 0 || string.indexOf("XTC") >= 0 ? string.indexOf("DS1_E1") < 0 : (string.indexOf("CTX") >= 0 && sortablePortString != null ? sortablePortString.toSortableString().indexOf("DS1") >= 0 : false));
        return this.hasDs1Endpoints;
    }

    protected void resetHoLoNums() {
        this.hoNum = null;
        this.loNum = null;
    }

    @Override
    protected void setLoComponents(ILoNum iLoNum) {
        this.vtCB.setSelectedItem(iLoNum);
    }

    @Override
    protected void setEntity(IEntityModel iEntityModel) throws AnnotatedException {
        super.setEntity(iEntityModel);
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfoType());
        boolean bl = this.isEntityMaunualModeCe2Card();
        this.localRefresh(iCircuitType, this.getCircuitInfoSize(), bl);
    }

    private boolean isConversionCircuit(int n) {
        int n2 = 0;
        try {
            if (!this.parent.isDestPane()) {
                return false;
            }
            n2 = this.parent.getAbstractCktDlg().getSource().getEntityModel().getEqType();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return n == 32 && n2 == 33 || n == 33 && n2 == 32;
    }

    private boolean slotIsPRBSGenerator() {
        return this.slot == "PRBS Generator";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block38: {
            Object object;
            block40: {
                Object object2;
                block41: {
                    block39: {
                        block37: {
                            SortablePortString sortablePortString;
                            IEntityModel iEntityModel;
                            object = actionEvent.getSource();
                            if (object != this.slotCB) break block37;
                            String string = (String)this.slotCB.getSelectedItem();
                            if (this.isNull(string, "newSlot")) {
                                return;
                            }
                            if (db.on()) {
                                db.println(this.title + " actionPerformed: slot " + this.slot + " -> " + string);
                            }
                            this.slot = string;
                            boolean bl = this.isEther = this.slot == "Ethergroup";
                            if (this.hasDs1Endpoints(this.slot, null)) {
                                this.vtLB.setText("DS1:");
                            } else {
                                this.vtLB.setText("VT:");
                            }
                            this.portMap = (SortedMap)this.entityMap.get(this.slot);
                            if (this.isNull(this.portMap, "portMap")) {
                                if (db.on()) {
                                    db.println(this.title + " assuming Ethergroup");
                                }
                                this.parent.setAltPanelEnabled(false);
                                this.hoNum = null;
                                this.loNum = null;
                                this.setCBList(this.portCB, null);
                                this.setCBList(this.hoParts, null);
                                this.setCBList(this.loParts, null);
                                return;
                            }
                            this.parent.setAltPanelEnabled(!this.getMonitor());
                            if (this.portMap.size() == 0) {
                                if (db.on()) {
                                    db.println(this.title + " portMap is empty");
                                }
                                return;
                            }
                            this.setCBList(this.portCB, this.portMap.keySet());
                            if (this.parent != null && ((iEntityModel = (IEntityModel)this.portMap.get(sortablePortString = (SortablePortString)this.portMap.firstKey())).getEqType() == 14 || iEntityModel.getEqType() == 15 || iEntityModel.getEqType() == 63 || iEntityModel.getEqType() == 105 || iEntityModel.getEqType() == 165 || this.isConversionCircuit(iEntityModel.getEqType()))) {
                                this.parent.setFinishedEnabled(false);
                            }
                            if (this.portMap.size() == 1) {
                                sortablePortString = (SortablePortString)this.portMap.firstKey();
                                if (!sortablePortString.isEmpty()) {
                                    this.portCB.setSelectedItem(sortablePortString);
                                } else {
                                    this.port = null;
                                    try {
                                        this.setEntity((IEntityModel)this.portMap.get(sortablePortString));
                                    }
                                    catch (AnnotatedException annotatedException) {
                                        if (db.on()) {
                                            db.println(this.title + " actionPerformed(slotCB): exception in setEntity");
                                        }
                                        this.clearEntity(annotatedException, true);
                                    }
                                }
                                this.portCB.setEnabled(false);
                                break block38;
                            } else {
                                this.setCBList(this.hoParts, null);
                                this.setCBList(this.loParts, null);
                            }
                            break block38;
                        }
                        if (object != this.portCB) break block39;
                        if (this.slotIsPRBSGenerator()) {
                            this.endpoint.setHoNum(null);
                            this.endpoint.setLoNum(null);
                            return;
                        }
                        SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
                        if (this.isNull(sortablePortString, "newPort")) {
                            return;
                        }
                        if (db.on()) {
                            db.println(this.title + " actionPerformed: port " + this.port + " -> " + sortablePortString);
                        }
                        this.port = sortablePortString;
                        if (this.hasDs1Endpoints(this.slot, this.port)) {
                            this.vtLB.setText("DS1:");
                        } else {
                            this.vtLB.setText("VT:");
                        }
                        try {
                            this.setEntity((IEntityModel)this.portMap.get(this.port));
                        }
                        catch (AnnotatedException annotatedException) {
                            if (db.on()) {
                                db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                            }
                            this.clearEntity(annotatedException, false);
                        }
                        break block38;
                    }
                    if (object != this.stsCB) break block40;
                    IHoNum iHoNum = (IHoNum)this.stsCB.getSelectedItem();
                    if (this.isNull(iHoNum, "newSts")) {
                        return;
                    }
                    IEntityModel iEntityModel = this.getEntityModel();
                    if (iEntityModel != null && ((object2 = iEntityModel.getModuleModel()).getEqType() == 234 || object2.getEqType() == 233) && iEntityModel.getEqType() == 34) {
                        iHoNum = HoLoFactory.idlSts2HoNum(iHoNum.getFramingType(), 1);
                    }
                    if (db.on()) {
                        db.println(this.title + " actionPerformed: sts " + this.hoNum + " -> " + iHoNum);
                    }
                    this.hoNum = iHoNum;
                    if (this.port != null) {
                        object2 = CircuitEndCellRenderer.convertFromExternalHoNumber((IEntityModel)this.portMap.get(this.port), this.hoNum);
                        this.endpoint.setHoNum((IHoNum)object2);
                    } else {
                        this.endpoint.setHoNum(this.hoNum);
                    }
                    object2 = this.endpointMap.get(this.hoNum);
                    if (this.isNull(object2, "endpointMap value for STS " + this.hoNum.toString())) {
                        return;
                    }
                    if (!(object2 instanceof INetCircuitEnd)) break block41;
                    this.setCBList(this.vtCB, null);
                    break block38;
                }
                if (object2 instanceof SortedMap) {
                    this.vtMap = (SortedMap)object2;
                    this.setCBList(this.vtCB, this.vtMap.keySet());
                    if (this.vtMap.size() == 1) {
                        this.vtCB.setSelectedItem(this.vtMap.firstKey());
                        this.vtCB.setEnabled(false);
                    }
                    break block38;
                } else {
                    if (db.on()) {
                        db.println(this.title + " actionPerformed: endpointMap value has wrong class: " + object2.getClass().toString());
                    }
                    return;
                }
            }
            if (object == this.vtCB) {
                ILoNum iLoNum = (ILoNum)this.vtCB.getSelectedItem();
                if (this.isNull(iLoNum, "newVt")) {
                    return;
                }
                if (db.on()) {
                    db.println(this.title + " actionPerformed: vt " + (this.loNum == null ? "null" : this.loNum.prettyString()) + " -> " + iLoNum.prettyString());
                }
                this.loNum = iLoNum;
                this.endpoint.setLoNum(iLoNum);
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.vtMap != null) {
            this.vtMap.clear();
        }
        if (this.stsCB != null) {
            this.stsCB.removeActionListener(this);
        }
        if (this.vtCB != null) {
            this.vtCB.removeActionListener(this);
        }
    }

    @Override
    protected boolean fullySelected() {
        this.setMemberHoLoNums();
        if (!super.fullySelected()) {
            return false;
        }
        if (db.on()) {
            db.println("Performing fullySelected() check on circuit type " + this.getCircuitInfoType());
        }
        if (this.getCircuitInfoType() == 11 && !this.parent.inSourcePane() && this.parent.isOpenVcat() && this.vtCB.getSelectedItem() == null) {
            return false;
        }
        return this.getCircuitInfoType() != 2 || this.slotIsPRBSGenerator() || this.loNum != null;
    }

    @Override
    protected void debugEndpoint(String string) {
        super.debugEndpoint(string);
        if (db.on()) {
            if (this.hoNum != null) {
                db.println(string + "sts = " + this.hoNum.toString());
            }
            if (this.loNum != null) {
                db.println(string + "vt = " + (this.loNum != null ? this.loNum.toString() : ""));
            }
        }
    }

    @Override
    protected IHoLoNum getNextHoLoNum(IHoLoNum iHoLoNum, IEntityModel iEntityModel) {
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        return HoLoFactory.addGroupOffset(iHoLoNum2, 1);
    }

    private class VtListCellRenderer
    extends LoListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = null;
            if (object != null && object instanceof ILoNum && SonetCcdEndpointPanel.this.hasDs1Endpoints) {
                StringBuffer stringBuffer = new StringBuffer();
                ILoNum iLoNum = (ILoNum)object;
                IEntityModel iEntityModel = SonetCcdEndpointPanel.this.getEntityModel();
                if (iEntityModel != null) {
                    int n2 = SonetCcdEndpointPanel.this.getPortForPath(iEntityModel.getModuleModel(), iEntityModel, iLoNum, SonetCcdEndpointPanel.this.hoNum);
                    if (n2 > 0) {
                        stringBuffer.append(n2);
                    } else {
                        stringBuffer.append(iLoNum.toString());
                    }
                    IPortModel iPortModel = CircuitEndCellRenderer.getDs1(iEntityModel, iLoNum, SonetCcdEndpointPanel.this.hoNum);
                    if (iPortModel != null) {
                        stringBuffer.append(PortHelper.getFormattedPortAlias((IPortModel)iPortModel));
                    }
                    stringBuffer.append(" (VT");
                    stringBuffer.append(iLoNum.groupString());
                    stringBuffer.append(')');
                }
                this.setText(stringBuffer.toString());
                this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                component = this;
            } else {
                component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
            return component;
        }
    }
}

